/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.nested.NestedDataColumnV3;
import org.apache.druid.segment.nested.NestedDataColumnV4;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedFieldDictionaryEncodedColumn;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.utils.CompressionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NestedDataColumnSupplierV4Test
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    private static final String NO_MATCH = "no";
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory((BitmapFactory)new RoaringBitmapFactory());
    List<Map<String, Object>> data = ImmutableList.of(TestHelper.makeMap("x", 1L, "y", 1.0, "z", "a", "v", "100", "nullish", "notnull"), TestHelper.makeMap("y", 3.0, "z", "d", "v", 1000L, "nullish", null), TestHelper.makeMap("x", 5L, "y", 5.0, "z", "b", "nullish", ""), TestHelper.makeMap("x", 3L, "y", 4.0, "z", "c", "v", 3000.333, "nullish", "null"), TestHelper.makeMap("x", 2L, "v", "40000"), TestHelper.makeMap("x", 4L, "y", 2.0, "z", "e", "v", 11111L, "nullish", null));
    List<Map<String, Object>> arrayTestData = ImmutableList.of(TestHelper.makeMap("s", new Object[]{"a", "b", "c"}, "l", new Object[]{1L, 2L, 3L}, "d", new Object[]{1.1, 2.2}), TestHelper.makeMap("s", new Object[]{null, "b", "c"}, "l", new Object[]{1L, null, 3L}, "d", new Object[]{2.2, 2.2}), TestHelper.makeMap("s", new Object[]{"b", "c"}, "l", new Object[]{null, null}, "d", new Object[]{1.1, null, 2.2}), TestHelper.makeMap("s", new Object[]{"a", "b", "c", "d"}, "l", new Object[]{4L, 2L, 3L}), TestHelper.makeMap("s", new Object[]{"d", "b", "c", "a"}, "d", new Object[]{1.1, 2.2}), TestHelper.makeMap("l", new Object[]{1L, 2L, 3L}, "d", new Object[]{3.1, 2.2, 1.9}));
    Closer closer = Closer.create();
    SmooshedFileMapper fileMapper;
    ByteBuffer baseBuffer;
    SmooshedFileMapper arrayFileMapper;
    ByteBuffer arrayBaseBuffer;

    @BeforeClass
    public static void staticSetup() {
        BuiltInTypesModule.registerHandlersAndSerde();
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testLegacyV3ReaderFormat() throws IOException {
        String columnName = "shipTo";
        String firstValue = "Cole";
        File tmpLocation = this.tempFolder.newFolder();
        CompressionUtils.unzip((InputStream)NestedDataColumnSupplierV4Test.class.getClassLoader().getResourceAsStream("nested_segment_v3/index.zip"), (File)tmpLocation);
        try (Closer closer = Closer.create();){
            QueryableIndex theIndex = (QueryableIndex)closer.register((Closeable)TestHelper.getTestIndexIO().loadIndex(tmpLocation));
            BaseColumnHolder holder = theIndex.getColumnHolder(columnName);
            Assert.assertNotNull((Object)holder);
            Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)holder.getCapabilities().toColumnType());
            NestedDataColumnV3 v3 = (NestedDataColumnV3)closer.register((Closeable)((NestedDataColumnV3)holder.getColumn()));
            Assert.assertNotNull((Object)v3);
            ImmutableList path = ImmutableList.of((Object)new NestedPathField("lastName"));
            ColumnHolder nestedColumnHolder = v3.getColumnHolder((List)path);
            Assert.assertNotNull((Object)nestedColumnHolder);
            Assert.assertEquals((Object)ColumnType.STRING, (Object)nestedColumnHolder.getCapabilities().toColumnType());
            NestedFieldDictionaryEncodedColumn nestedColumn = (NestedFieldDictionaryEncodedColumn)nestedColumnHolder.getColumn();
            Assert.assertNotNull((Object)nestedColumn);
            ColumnValueSelector selector = nestedColumn.makeColumnValueSelector((ReadableOffset)new SimpleAscendingOffset(theIndex.getNumRows()));
            ColumnIndexSupplier indexSupplier = v3.getColumnIndexSupplier((List)path);
            Assert.assertNotNull((Object)indexSupplier);
            StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
            Assert.assertNotNull((Object)valueSetIndex);
            BitmapColumnIndex indexForValue = valueSetIndex.forValue(firstValue);
            Assert.assertEquals((Object)firstValue, (Object)selector.getObject());
            Assert.assertTrue((boolean)((ImmutableBitmap)indexForValue.computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(0));
        }
    }

    @Test
    public void testLegacyV4ReaderFormat() throws IOException {
        String columnName = "shipTo";
        String firstValue = "Beatty";
        File tmpLocation = this.tempFolder.newFolder();
        CompressionUtils.unzip((InputStream)NestedDataColumnSupplierV4Test.class.getClassLoader().getResourceAsStream("nested_segment_v4/index.zip"), (File)tmpLocation);
        try (Closer closer = Closer.create();){
            QueryableIndex theIndex = (QueryableIndex)closer.register((Closeable)TestHelper.getTestIndexIO().loadIndex(tmpLocation));
            BaseColumnHolder holder = theIndex.getColumnHolder(columnName);
            Assert.assertNotNull((Object)holder);
            Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)holder.getCapabilities().toColumnType());
            NestedDataColumnV4 v4 = (NestedDataColumnV4)closer.register((Closeable)((NestedDataColumnV4)holder.getColumn()));
            Assert.assertNotNull((Object)v4);
            ImmutableList path = ImmutableList.of((Object)new NestedPathField("lastName"));
            ColumnHolder nestedColumnHolder = v4.getColumnHolder((List)path);
            Assert.assertNotNull((Object)nestedColumnHolder);
            Assert.assertEquals((Object)ColumnType.STRING, (Object)nestedColumnHolder.getCapabilities().toColumnType());
            NestedFieldDictionaryEncodedColumn nestedColumn = (NestedFieldDictionaryEncodedColumn)nestedColumnHolder.getColumn();
            Assert.assertNotNull((Object)nestedColumn);
            ColumnValueSelector selector = nestedColumn.makeColumnValueSelector((ReadableOffset)new SimpleAscendingOffset(theIndex.getNumRows()));
            ColumnIndexSupplier indexSupplier = v4.getColumnIndexSupplier((List)path);
            Assert.assertNotNull((Object)indexSupplier);
            StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
            Assert.assertNotNull((Object)valueSetIndex);
            BitmapColumnIndex indexForValue = valueSetIndex.forValue(firstValue);
            Assert.assertEquals((Object)firstValue, (Object)selector.getObject());
            Assert.assertTrue((boolean)((ImmutableBitmap)indexForValue.computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(0));
        }
    }

    private void smokeTest(NestedDataComplexColumn column) throws IOException {
        SimpleAscendingOffset offset = new SimpleAscendingOffset(this.data.size());
        ColumnValueSelector rawSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        List xPath = NestedPathFinder.parseJsonPath((String)"$.x");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.LONG), (Object)column.getFieldTypes(xPath));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)column.getColumnHolder(xPath).getCapabilities().toColumnType());
        ColumnValueSelector xSelector = column.makeColumnValueSelector(xPath, null, (ReadableOffset)offset);
        DimensionSelector xDimSelector = column.makeDimensionSelector(xPath, null, null, (ReadableOffset)offset);
        ColumnIndexSupplier xIndexSupplier = column.getColumnIndexSupplier(xPath);
        Assert.assertNotNull((Object)xIndexSupplier);
        StringValueSetIndexes xValueIndex = (StringValueSetIndexes)xIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes xPredicateIndex = (DruidPredicateIndexes)xIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex xNulls = (NullValueIndex)xIndexSupplier.as(NullValueIndex.class);
        List yPath = NestedPathFinder.parseJsonPath((String)"$.y");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.DOUBLE), (Object)column.getFieldTypes(yPath));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)column.getColumnHolder(yPath).getCapabilities().toColumnType());
        ColumnValueSelector ySelector = column.makeColumnValueSelector(yPath, null, (ReadableOffset)offset);
        DimensionSelector yDimSelector = column.makeDimensionSelector(yPath, null, null, (ReadableOffset)offset);
        ColumnIndexSupplier yIndexSupplier = column.getColumnIndexSupplier(yPath);
        Assert.assertNotNull((Object)yIndexSupplier);
        StringValueSetIndexes yValueIndex = (StringValueSetIndexes)yIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes yPredicateIndex = (DruidPredicateIndexes)yIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex yNulls = (NullValueIndex)yIndexSupplier.as(NullValueIndex.class);
        List zPath = NestedPathFinder.parseJsonPath((String)"$.z");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING), (Object)column.getFieldTypes(zPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(zPath).getCapabilities().toColumnType());
        ColumnValueSelector zSelector = column.makeColumnValueSelector(zPath, null, (ReadableOffset)offset);
        DimensionSelector zDimSelector = column.makeDimensionSelector(zPath, null, null, (ReadableOffset)offset);
        ColumnIndexSupplier zIndexSupplier = column.getColumnIndexSupplier(zPath);
        Assert.assertNotNull((Object)zIndexSupplier);
        StringValueSetIndexes zValueIndex = (StringValueSetIndexes)zIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes zPredicateIndex = (DruidPredicateIndexes)zIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex zNulls = (NullValueIndex)zIndexSupplier.as(NullValueIndex.class);
        List vPath = NestedPathFinder.parseJsonPath((String)"$.v");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING, (Object)ColumnType.LONG, (Object)ColumnType.DOUBLE), (Object)column.getFieldTypes(vPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(vPath).getCapabilities().toColumnType());
        ColumnValueSelector vSelector = column.makeColumnValueSelector(vPath, null, (ReadableOffset)offset);
        DimensionSelector vDimSelector = column.makeDimensionSelector(vPath, null, null, (ReadableOffset)offset);
        ColumnIndexSupplier vIndexSupplier = column.getColumnIndexSupplier(vPath);
        Assert.assertNotNull((Object)vIndexSupplier);
        StringValueSetIndexes vValueIndex = (StringValueSetIndexes)vIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes vPredicateIndex = (DruidPredicateIndexes)vIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex vNulls = (NullValueIndex)vIndexSupplier.as(NullValueIndex.class);
        List nullishPath = NestedPathFinder.parseJsonPath((String)"$.nullish");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING), (Object)column.getFieldTypes(nullishPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(nullishPath).getCapabilities().toColumnType());
        ColumnValueSelector nullishSelector = column.makeColumnValueSelector(nullishPath, null, (ReadableOffset)offset);
        DimensionSelector nullishDimSelector = column.makeDimensionSelector(nullishPath, null, null, (ReadableOffset)offset);
        ColumnIndexSupplier nullishIndexSupplier = column.getColumnIndexSupplier(nullishPath);
        Assert.assertNotNull((Object)nullishIndexSupplier);
        StringValueSetIndexes nullishValueIndex = (StringValueSetIndexes)nullishIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes nullishPredicateIndex = (DruidPredicateIndexes)nullishIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex nullishNulls = (NullValueIndex)nullishIndexSupplier.as(NullValueIndex.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)nullishPath, (Object)vPath, (Object)xPath, (Object)yPath, (Object)zPath), (Object)column.getNestedFields());
        for (int i = 0; i < this.data.size(); ++i) {
            Map<String, Object> row = this.data.get(i);
            Assert.assertEquals((Object)JSON_MAPPER.writeValueAsString(row), (Object)JSON_MAPPER.writeValueAsString(StructuredData.unwrap((Object)rawSelector.getObject())));
            this.testPath(row, i, "v", vSelector, vDimSelector, vValueIndex, vPredicateIndex, vNulls, null);
            this.testPath(row, i, "x", xSelector, xDimSelector, xValueIndex, xPredicateIndex, xNulls, ColumnType.LONG);
            this.testPath(row, i, "y", ySelector, yDimSelector, yValueIndex, yPredicateIndex, yNulls, ColumnType.DOUBLE);
            this.testPath(row, i, "z", zSelector, zDimSelector, zValueIndex, zPredicateIndex, zNulls, ColumnType.STRING);
            this.testPath(row, i, "nullish", nullishSelector, nullishDimSelector, nullishValueIndex, nullishPredicateIndex, nullishNulls, ColumnType.STRING);
            offset.increment();
        }
    }

    private void testPath(Map row, int rowNumber, String path, ColumnValueSelector<?> valueSelector, DimensionSelector dimSelector, StringValueSetIndexes valueSetIndex, DruidPredicateIndexes predicateIndex, NullValueIndex nullValueIndex, @Nullable ColumnType singleType) {
        Object inputValue = row.get(path);
        if (row.containsKey(path) && inputValue != null) {
            Assert.assertEquals(inputValue, (Object)valueSelector.getObject());
            if (ColumnType.LONG.equals((Object)singleType)) {
                Assert.assertEquals(inputValue, (Object)valueSelector.getLong());
                Assert.assertFalse((String)(path + " is not null"), (boolean)valueSelector.isNull());
            } else if (ColumnType.DOUBLE.equals((Object)singleType)) {
                Assert.assertEquals((double)((Double)inputValue), (double)valueSelector.getDouble(), (double)0.0);
                Assert.assertFalse((String)(path + " is not null"), (boolean)valueSelector.isNull());
            }
            String theString = String.valueOf(inputValue);
            Assert.assertEquals((Object)theString, (Object)dimSelector.getObject());
            String dimSelectorLookupVal = dimSelector.lookupName(dimSelector.getRow().get(0));
            Assert.assertEquals((Object)theString, (Object)dimSelectorLookupVal);
            Assert.assertEquals((long)dimSelector.idLookup().lookupId(dimSelectorLookupVal), (long)dimSelector.getRow().get(0));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(theString).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)theString))).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(theString)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)NO_MATCH))).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)nullValueIndex.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher(theString).matches(false));
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher(NO_MATCH).matches(false));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)theString)).matches(false));
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)NO_MATCH)).matches(false));
        } else {
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((String)path, (boolean)valueSelector.isNull());
            Assert.assertEquals((long)0L, (long)dimSelector.getRow().get(0));
            Assert.assertNull((Object)dimSelector.getObject());
            Assert.assertNull((Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)nullValueIndex.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(null)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher((String)null).matches(false));
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher(NO_MATCH).matches(false));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo(null)).matches(false));
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)NO_MATCH)).matches(false));
        }
    }

    private static class SettableSelector
    extends ObjectColumnSelector<StructuredData> {
        private StructuredData data;

        private SettableSelector() {
        }

        public void setObject(StructuredData o) {
            this.data = o;
        }

        @Nullable
        public StructuredData getObject() {
            return this.data;
        }

        public Class classOfObject() {
            return StructuredData.class;
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

