/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.core.JsonProcessingException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.nested.ObjectStorageEncoding;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class NestedCommonFormatColumnFormatSpecTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        NestedCommonFormatColumnFormatSpec spec = NestedCommonFormatColumnFormatSpec.builder().setObjectFieldsDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1))).setObjectStorageCompression(CompressionStrategy.ZSTD).setStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(16), Byte.valueOf((byte)1))).build();
        Assert.assertEquals((Object)spec, (Object)TestHelper.JSON_MAPPER.readValue(TestHelper.JSON_MAPPER.writeValueAsString((Object)spec), NestedCommonFormatColumnFormatSpec.class));
    }

    @Test
    public void testGetEffectiveSpecDefaults() {
        NestedCommonFormatColumnFormatSpec defaults = NestedCommonFormatColumnFormatSpec.getEffectiveFormatSpec(null, (IndexSpec)IndexSpec.getDefault().getEffectiveSpec());
        Assert.assertEquals((Object)StringEncodingStrategy.UTF8_STRATEGY, (Object)defaults.getObjectFieldsDictionaryEncoding());
        Assert.assertEquals((Object)ObjectStorageEncoding.SMILE, (Object)defaults.getObjectStorageEncoding());
        Assert.assertEquals((Object)CompressionStrategy.LZ4, (Object)defaults.getObjectStorageCompression());
        Assert.assertEquals((Object)IndexSpec.getDefault().getEffectiveSpec().getDimensionCompression(), (Object)defaults.getDictionaryEncodedColumnCompression());
        Assert.assertEquals((Object)IndexSpec.getDefault().getEffectiveSpec().getStringDictionaryEncoding(), (Object)defaults.getStringDictionaryEncoding());
        Assert.assertEquals((Object)IndexSpec.getDefault().getEffectiveSpec().getMetricCompression(), (Object)defaults.getLongColumnCompression());
        Assert.assertEquals((Object)IndexSpec.getDefault().getEffectiveSpec().getMetricCompression(), (Object)defaults.getDoubleColumnCompression());
    }

    @Test
    public void testEffectiveSpecIndexSpecOverrides() {
        StringEncodingStrategy.FrontCoded frontcoded = new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1));
        NestedCommonFormatColumnFormatSpec defaults = NestedCommonFormatColumnFormatSpec.getEffectiveFormatSpec(null, (IndexSpec)IndexSpec.builder().withAutoColumnFormatSpec(NestedCommonFormatColumnFormatSpec.builder().setObjectFieldsDictionaryEncoding((StringEncodingStrategy)frontcoded).build()).withMetricCompression(CompressionStrategy.LZF).build().getEffectiveSpec());
        Assert.assertEquals((Object)frontcoded, (Object)defaults.getObjectFieldsDictionaryEncoding());
        Assert.assertEquals((Object)CompressionStrategy.LZ4, (Object)defaults.getObjectStorageCompression());
        Assert.assertEquals((Object)IndexSpec.getDefault().getEffectiveSpec().getDimensionCompression(), (Object)defaults.getDictionaryEncodedColumnCompression());
        Assert.assertEquals((Object)IndexSpec.getDefault().getEffectiveSpec().getStringDictionaryEncoding(), (Object)defaults.getStringDictionaryEncoding());
        Assert.assertEquals((Object)CompressionStrategy.LZF, (Object)defaults.getLongColumnCompression());
        Assert.assertEquals((Object)CompressionStrategy.LZF, (Object)defaults.getDoubleColumnCompression());
    }

    @Test
    public void testGetEffectiveSpecMerge() {
        NestedCommonFormatColumnFormatSpec merged = NestedCommonFormatColumnFormatSpec.getEffectiveFormatSpec((NestedCommonFormatColumnFormatSpec)NestedCommonFormatColumnFormatSpec.builder().setObjectFieldsDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1))).setObjectStorageCompression(CompressionStrategy.ZSTD).setStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1))).setDoubleColumnCompression(CompressionStrategy.ZSTD).build(), (IndexSpec)IndexSpec.getDefault().getEffectiveSpec());
        Assert.assertEquals((Object)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1)), (Object)merged.getObjectFieldsDictionaryEncoding());
        Assert.assertEquals((Object)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1)), (Object)merged.getStringDictionaryEncoding());
        Assert.assertEquals((Object)ObjectStorageEncoding.SMILE, (Object)merged.getObjectStorageEncoding());
        Assert.assertEquals((Object)IndexSpec.getDefault().getEffectiveSpec().getDimensionCompression(), (Object)merged.getDictionaryEncodedColumnCompression());
        Assert.assertEquals((Object)CompressionStrategy.ZSTD, (Object)merged.getObjectStorageCompression());
        Assert.assertEquals((Object)IndexSpec.getDefault().getEffectiveSpec().getMetricCompression(), (Object)merged.getLongColumnCompression());
        Assert.assertEquals((Object)CompressionStrategy.ZSTD, (Object)merged.getDoubleColumnCompression());
    }

    @Test
    public void testGetEffectiveSpecInvalid() {
        Throwable t = Assert.assertThrows(ISE.class, () -> NestedCommonFormatColumnFormatSpec.getEffectiveFormatSpec((NestedCommonFormatColumnFormatSpec)NestedCommonFormatColumnFormatSpec.builder().setBitmapEncoding((BitmapSerdeFactory)new ConciseBitmapSerdeFactory()).build(), (IndexSpec)IndexSpec.builder().withBitmapSerdeFactory((BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance()).build().getEffectiveSpec()));
        Assert.assertEquals((Object)"bitmapEncoding[ConciseBitmapSerdeFactory{}] does not match indexSpec.bitmap[RoaringBitmapSerdeFactory{}]", (Object)t.getMessage());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(NestedCommonFormatColumnFormatSpec.class).usingGetClass().verify();
    }
}

