/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.jackson.SegmentizerModule;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.join.table.BroadcastSegmentIndexedTable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class BroadcastSegmentIndexedTableTest
extends InitializedNullHandlingTest {
    private static final String STRING_COL_1 = "market";
    private static final String LONG_COL_1 = "longNumericNull";
    private static final String DOUBLE_COL_1 = "doubleNumericNull";
    private static final String FLOAT_COL_1 = "floatNumericNull";
    private static final String STRING_COL_2 = "partial_null_column";
    private static final String MULTI_VALUE_COLUMN = "placementish";
    private static final String DIM_NOT_EXISTS = "DIM_NOT_EXISTS";
    private static final String DATASOURCE = "DATASOURCE";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private QueryableIndexSegment backingSegment;
    private BroadcastSegmentIndexedTable broadcastTable;
    private List<String> columnNames;
    private final Set<String> keyColumns = ImmutableSet.builder().add((Object)"market").add((Object)"partial_null_column").add((Object)"longNumericNull").add((Object)"doubleNumericNull").add((Object)"floatNumericNull").add((Object)"placementish").add((Object)"DIM_NOT_EXISTS").build();

    @Before
    public void setup() throws IOException, SegmentLoadingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerModule((Module)new SegmentizerModule());
        IndexIO indexIO = new IndexIO((ObjectMapper)mapper, ColumnConfig.DEFAULT);
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)mapper).addValue(IndexIO.class, (Object)indexIO).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));
        IndexMergerV9 indexMerger = new IndexMergerV9((ObjectMapper)mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        Interval testInterval = Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z");
        IncrementalIndex data = TestIndex.makeSampleNumericIncrementalIndex();
        File segment = new File(this.temporaryFolder.newFolder(), "segment");
        File persisted = indexMerger.persist(data, testInterval, segment, IndexSpec.getDefault(), null);
        File factoryJson = new File(persisted, "factory.json");
        Assert.assertTrue((boolean)factoryJson.exists());
        SegmentizerFactory factory = (SegmentizerFactory)mapper.readValue(factoryJson, SegmentizerFactory.class);
        Assert.assertTrue((boolean)(factory instanceof MMappedQueryableSegmentizerFactory));
        DataSegment dataSegment = new DataSegment(DATASOURCE, testInterval, DateTimes.nowUtc().toString(), (Map)ImmutableMap.of(), this.columnNames, (List)ImmutableList.of(), null, null, segment.getTotalSpace());
        this.backingSegment = (QueryableIndexSegment)factory.factorize(dataSegment, segment, false, SegmentLazyLoadFailCallback.NOOP);
        this.columnNames = new QueryableIndexCursorFactory((QueryableIndex)this.backingSegment.as(QueryableIndex.class)).getRowSignature().getColumnNames();
        this.broadcastTable = new BroadcastSegmentIndexedTable(this.backingSegment, this.keyColumns, dataSegment.getVersion());
    }

    @Test
    public void testInitShouldGenerateCorrectTable() {
        Assert.assertEquals((long)1209L, (long)this.broadcastTable.numRows());
    }

    @Test
    public void testStringKeyColumn() {
        Object[] vals = new String[]{"spot", "total_market", "upfront"};
        this.checkIndexAndReader(STRING_COL_1, vals);
    }

    @Test
    public void testNullableStringKeyColumn() {
        Object[] vals = new String[]{null, "value"};
        this.checkIndexAndReader(STRING_COL_2, vals);
    }

    @Test
    public void testMultiValueStringKeyColumn() {
        Object[] nonMatchingVals = new Object[]{ImmutableList.of((Object)"a", (Object)"preferred")};
        this.checkIndexAndReader(MULTI_VALUE_COLUMN, new Object[0], nonMatchingVals);
    }

    @Test
    public void testLongKeyColumn() {
        Object[] vals = new Long[]{null, 10L, 20L};
        this.checkIndexAndReader(LONG_COL_1, vals);
    }

    @Test
    public void testFloatKeyColumn() {
        Object[] vals = new Float[]{null, Float.valueOf(10.0f), Float.valueOf(20.0f)};
        this.checkIndexAndReader(FLOAT_COL_1, vals);
    }

    @Test
    public void testDoubleKeyColumn() {
        Object[] vals = new Double[]{null, 10.0, 20.0};
        this.checkIndexAndReader(DOUBLE_COL_1, vals);
    }

    @Test
    public void testTimestampColumn() {
        this.checkNonIndexedReader("__time");
    }

    @Test
    public void testStringNonKeyColumn() {
        this.checkNonIndexedReader("qualityNumericString");
    }

    @Test
    public void testLongNonKeyColumn() {
        this.checkNonIndexedReader("qualityLong");
    }

    @Test
    public void testFloatNonKeyColumn() {
        this.checkNonIndexedReader("qualityFloat");
    }

    @Test
    public void testDoubleNonKeyColumn() {
        this.checkNonIndexedReader("qualityDouble");
    }

    @Test
    public void testIsCacheable() {
        Assert.assertTrue((boolean)this.broadcastTable.isCacheable());
    }

    @Test
    public void testNonexistentColumn() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Column[-1] is not a valid column");
        this.broadcastTable.columnReader(this.columnNames.indexOf(DIM_NOT_EXISTS));
    }

    @Test
    public void testNonexistentColumnOutOfRange() {
        int non = this.columnNames.size();
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Column[%s] is not a valid column", (Object[])new Object[]{non}));
        this.broadcastTable.columnReader(non);
    }

    private void checkIndexAndReader(String columnName, Object[] vals) {
        this.checkIndexAndReader(columnName, vals, new Object[0]);
    }

    private void checkIndexAndReader(String columnName, Object[] vals, Object[] nonmatchingVals) {
        this.checkColumnSelectorFactory(columnName);
        try (Closer closer = Closer.create();){
            IntSortedSet valIndex;
            int columnIndex = this.columnNames.indexOf(columnName);
            IndexedTable.Reader reader = this.broadcastTable.columnReader(columnIndex);
            closer.register((Closeable)reader);
            IndexedTable.Index valueIndex = this.broadcastTable.columnIndex(columnIndex);
            for (Object val : vals) {
                valIndex = valueIndex.find(val);
                Assert.assertTrue((valIndex.size() > 0 ? 1 : 0) != 0);
                IntBidirectionalIterator rowIterator = valIndex.iterator();
                while (rowIterator.hasNext()) {
                    Assert.assertEquals((Object)val, (Object)reader.read(rowIterator.nextInt()));
                }
            }
            for (Object val : nonmatchingVals) {
                valIndex = valueIndex.find(val);
                Assert.assertEquals((long)0L, (long)valIndex.size());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkNonIndexedReader(String columnName) {
        this.checkColumnSelectorFactory(columnName);
        try (Closer closer = Closer.create();){
            int columnIndex = this.columnNames.indexOf(columnName);
            int numRows = ((PhysicalSegmentInspector)this.backingSegment.as(PhysicalSegmentInspector.class)).getNumRows();
            IndexedTable.Reader reader = this.broadcastTable.columnReader(columnIndex);
            closer.register((Closeable)reader);
            SimpleAscendingOffset offset = new SimpleAscendingOffset(numRows);
            BaseColumn theColumn = ((QueryableIndex)this.backingSegment.as(QueryableIndex.class)).getColumnHolder(columnName).getColumn();
            closer.register((Closeable)theColumn);
            ColumnValueSelector selector = theColumn.makeColumnValueSelector((ReadableOffset)offset);
            for (int row = 0; row < numRows; ++row) {
                offset.setCurrentOffset(row);
                Assert.assertEquals((Object)selector.getObject(), (Object)reader.read(row));
            }
            try {
                Assert.assertEquals(null, (Object)this.broadcastTable.columnIndex(columnIndex));
            }
            catch (IAE iae) {
                Assert.assertEquals((Object)StringUtils.format((String)"Column[%d] is not a key column", (Object[])new Object[]{columnIndex}), (Object)iae.getMessage());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkColumnSelectorFactory(String columnName) {
        try (Closer closer = Closer.create();){
            int numRows = ((PhysicalSegmentInspector)this.backingSegment.as(PhysicalSegmentInspector.class)).getNumRows();
            SimpleAscendingOffset offset = new SimpleAscendingOffset(numRows);
            BaseColumn theColumn = ((QueryableIndex)this.backingSegment.as(QueryableIndex.class)).getColumnHolder(columnName).getColumn();
            closer.register((Closeable)theColumn);
            ColumnValueSelector selector = theColumn.makeColumnValueSelector((ReadableOffset)offset);
            ColumnSelectorFactory tableFactory = this.broadcastTable.makeColumnSelectorFactory((ReadableOffset)offset, closer);
            ColumnValueSelector tableSelector = tableFactory.makeColumnValueSelector(columnName);
            for (int row = 0; row < numRows; ++row) {
                offset.setCurrentOffset(row);
                Assert.assertEquals((Object)selector.getObject(), (Object)tableSelector.getObject());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

