/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.join.BaseHashJoinSegmentCursorFactoryTest;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.HashJoinSegmentCursorFactory;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.lookup.LookupJoinable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.junit.Assert;
import org.junit.Test;

public class HashJoinSegmentCursorFactoryTest
extends BaseHashJoinSegmentCursorFactoryTest {
    @Test
    public void test_getInterval_factToCountry() {
        Assert.assertEquals((Object)Intervals.of((String)"2015-09-12/2015-09-12T05:21:00.060Z"), (Object)this.makeFactToCountrySegment().getDataInterval());
    }

    @Test
    public void test_getRowSignature_factToCountry() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"channel", (Object)"regionIsoCode", (Object)"countryNumber", (Object)"countryIsoCode", (Object)"user", (Object)"isRobot", (Object)"isAnonymous", (Object)"namespace", (Object)"page", (Object)"delta", (Object)"channel_uniques", (Object[])new String[]{"c1.countryNumber", "c1.countryIsoCode", "c1.countryName"}), (Object)Lists.newArrayList((Iterable)((CursorFactory)this.makeFactToCountrySegment().as(CursorFactory.class)).getRowSignature().getColumnNames()));
    }

    @Test
    public void test_getColumnCapabilities_factToCountryFactColumn() {
        ColumnCapabilities capabilities = ((CursorFactory)this.makeFactToCountrySegment().as(CursorFactory.class)).getColumnCapabilities("countryIsoCode");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.hasBitmapIndexes());
        Assert.assertTrue((boolean)capabilities.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)capabilities.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)capabilities.areDictionaryValuesUnique().isTrue());
    }

    @Test
    public void test_getColumnCapabilities_factToCountryJoinColumn() {
        ColumnCapabilities capabilities = ((CursorFactory)this.makeFactToCountrySegment().as(CursorFactory.class)).getColumnCapabilities("c1.countryIsoCode");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertFalse((boolean)capabilities.hasBitmapIndexes());
        Assert.assertFalse((boolean)capabilities.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)capabilities.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)capabilities.isDictionaryEncoded().isTrue());
    }

    @Test
    public void test_getColumnCapabilities_factToCountryNonexistentFactColumn() {
        ColumnCapabilities capabilities = ((CursorFactory)this.makeFactToCountrySegment().as(CursorFactory.class)).getColumnCapabilities("nonexistent");
        Assert.assertNull((Object)capabilities);
    }

    @Test
    public void test_getColumnCapabilities_factToCountryNonexistentJoinColumn() {
        ColumnCapabilities capabilities = ((CursorFactory)this.makeFactToCountrySegment().as(CursorFactory.class)).getColumnCapabilities("c1.nonexistent");
        Assert.assertNull((Object)capabilities);
    }

    @Test
    public void test_getColumnCapabilities_complexTypeName_factToCountryFactColumn() {
        Assert.assertEquals((Object)"hyperUnique", (Object)((CursorFactory)this.makeFactToCountrySegment().as(CursorFactory.class)).getColumnCapabilities("channel_uniques").getComplexTypeName());
    }

    @Test
    public void test_getColumnCapabilities_typeString_factToCountryFactColumn() {
        Assert.assertEquals((Object)"COMPLEX<hyperUnique>", (Object)((CursorFactory)this.makeFactToCountrySegment().as(CursorFactory.class)).getColumnCapabilities("channel_uniques").asTypeString());
    }

    @Test
    public void test_getColumnCapabilities_typeString_factToCountryJoinColumn() {
        Assert.assertEquals((Object)"STRING", (Object)((CursorFactory)this.makeFactToCountrySegment().as(CursorFactory.class)).getColumnCapabilities("c1.countryName").asTypeString());
    }

    @Test
    public void test_makeCursor_factToCountryLeft() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", null, null, null, NULL_COUNTRY}, (Object)new Object[]{"Rallicula", null, null, null, NULL_COUNTRY}, (Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia", 0L}, (Object)new Object[]{"Apamea abruzzorum", null, null, null, NULL_COUNTRY}, (Object)new Object[]{"Atractus flammigerus", null, null, null, NULL_COUNTRY}, (Object)new Object[]{"Agama mossambica", null, null, null, NULL_COUNTRY}, (Object)new Object[]{"Mathis Bolly", "MX", "MX", "Mexico", 10L}, (Object)new Object[]{"\uc720\ud76c\uc655 GX", "KR", "KR", "Republic of Korea", 9L}, (Object)new Object[]{"\u9752\u91ce\u6b66", "JP", "JP", "Japan", 8L}, (Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "Chile", 2L}, (Object)new Object[]{"President of India", "US", "US", "United States", 13L}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany", 3L}, (Object[])new Object[][]{{"Saison 9 de Secret Story", "FR", "FR", "France", 5L}, {"Glasgow", "GB", "GB", "United Kingdom", 6L}, {"Didier Leclair", "CA", "CA", "Canada", 1L}, {"Les Argonautes", "CA", "CA", "Canada", 1L}, {"Otjiwarongo Airport", "US", "US", "United States", 13L}, {"Sarah Michelle Gellar", "CA", "CA", "Canada", 1L}, {"DirecTV", "US", "US", "United States", 13L}, {"Carlo Curti", "US", "US", "United States", 13L}, {"Giusy Ferreri discography", "IT", "IT", "Italy", 7L}, {"Roma-Bangkok", "IT", "IT", "Italy", 7L}, {"Wendigo", "SV", "SV", "El Salvador", 12L}, {"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "NO", "NO", "Norway", 11L}, {"Gabinete Ministerial de Rafael Correa", "EC", "EC", "Ecuador", 4L}, {"Old Anatolian Turkish", "US", "US", "United States", 13L}, {"Cream Soda", "SU", "SU", "States United", 15L}, {"Orange Soda", "MatchNothing", null, null, NULL_COUNTRY}, {"History of Fourems", "MMMM", "MMMM", "Fourems", 205L}}));
    }

    @Test
    public void test_makeCursor_factToCountryLeftUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", null, null, null}, (Object)new Object[]{"Rallicula", null, null, null}, (Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia"}, (Object)new Object[]{"Apamea abruzzorum", null, null, null}, (Object)new Object[]{"Atractus flammigerus", null, null, null}, (Object)new Object[]{"Agama mossambica", null, null, null}, (Object)new Object[]{"Mathis Bolly", "MX", "MX", "Mexico"}, (Object)new Object[]{"\uc720\ud76c\uc655 GX", "KR", "KR", "Republic of Korea"}, (Object)new Object[]{"\u9752\u91ce\u6b66", "JP", "JP", "Japan"}, (Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "Chile"}, (Object)new Object[]{"President of India", "US", "US", "United States"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany"}, (Object[])new Object[][]{{"Saison 9 de Secret Story", "FR", "FR", "France"}, {"Glasgow", "GB", "GB", "United Kingdom"}, {"Didier Leclair", "CA", "CA", "Canada"}, {"Les Argonautes", "CA", "CA", "Canada"}, {"Otjiwarongo Airport", "US", "US", "United States"}, {"Sarah Michelle Gellar", "CA", "CA", "Canada"}, {"DirecTV", "US", "US", "United States"}, {"Carlo Curti", "US", "US", "United States"}, {"Giusy Ferreri discography", "IT", "IT", "Italy"}, {"Roma-Bangkok", "IT", "IT", "Italy"}, {"Wendigo", "SV", "SV", "El Salvador"}, {"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "NO", "NO", "Norway"}, {"Gabinete Ministerial de Rafael Correa", "EC", "EC", "Ecuador"}, {"Old Anatolian Turkish", "US", "US", "United States"}, {"Cream Soda", "SU", "SU", "States United"}, {"Orange Soda", "MatchNothing", null, null}, {"History of Fourems", "MMMM", "MMMM", "Fourems"}}));
    }

    @Test
    public void test_makeCursor_factToCountryInner() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.INNER));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia", 0L}, (Object)new Object[]{"Mathis Bolly", "MX", "MX", "Mexico", 10L}, (Object)new Object[]{"\uc720\ud76c\uc655 GX", "KR", "KR", "Republic of Korea", 9L}, (Object)new Object[]{"\u9752\u91ce\u6b66", "JP", "JP", "Japan", 8L}, (Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "Chile", 2L}, (Object)new Object[]{"President of India", "US", "US", "United States", 13L}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany", 3L}, (Object)new Object[]{"Saison 9 de Secret Story", "FR", "FR", "France", 5L}, (Object)new Object[]{"Glasgow", "GB", "GB", "United Kingdom", 6L}, (Object)new Object[]{"Didier Leclair", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Les Argonautes", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Otjiwarongo Airport", "US", "US", "United States", 13L}, (Object[])new Object[][]{{"Sarah Michelle Gellar", "CA", "CA", "Canada", 1L}, {"DirecTV", "US", "US", "United States", 13L}, {"Carlo Curti", "US", "US", "United States", 13L}, {"Giusy Ferreri discography", "IT", "IT", "Italy", 7L}, {"Roma-Bangkok", "IT", "IT", "Italy", 7L}, {"Wendigo", "SV", "SV", "El Salvador", 12L}, {"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "NO", "NO", "Norway", 11L}, {"Gabinete Ministerial de Rafael Correa", "EC", "EC", "Ecuador", 4L}, {"Old Anatolian Turkish", "US", "US", "United States", 13L}, {"Cream Soda", "SU", "SU", "States United", 15L}, {"History of Fourems", "MMMM", "MMMM", "Fourems", 205L}}));
    }

    @Test
    public void test_makeCursor_factToCountryInnerUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.INNER));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia"}, (Object)new Object[]{"Mathis Bolly", "MX", "MX", "Mexico"}, (Object)new Object[]{"\uc720\ud76c\uc655 GX", "KR", "KR", "Republic of Korea"}, (Object)new Object[]{"\u9752\u91ce\u6b66", "JP", "JP", "Japan"}, (Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "Chile"}, (Object)new Object[]{"President of India", "US", "US", "United States"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany"}, (Object)new Object[]{"Saison 9 de Secret Story", "FR", "FR", "France"}, (Object)new Object[]{"Glasgow", "GB", "GB", "United Kingdom"}, (Object)new Object[]{"Didier Leclair", "CA", "CA", "Canada"}, (Object)new Object[]{"Les Argonautes", "CA", "CA", "Canada"}, (Object)new Object[]{"Otjiwarongo Airport", "US", "US", "United States"}, (Object[])new Object[][]{{"Sarah Michelle Gellar", "CA", "CA", "Canada"}, {"DirecTV", "US", "US", "United States"}, {"Carlo Curti", "US", "US", "United States"}, {"Giusy Ferreri discography", "IT", "IT", "Italy"}, {"Roma-Bangkok", "IT", "IT", "Italy"}, {"Wendigo", "SV", "SV", "El Salvador"}, {"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "NO", "NO", "Norway"}, {"Gabinete Ministerial de Rafael Correa", "EC", "EC", "Ecuador"}, {"Old Anatolian Turkish", "US", "US", "United States"}, {"Cream Soda", "SU", "SU", "States United"}, {"History of Fourems", "MMMM", "MMMM", "Fourems"}}));
    }

    @Test
    public void test_makeCursor_factToCountryInnerUsingCountryNumber() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnNumber(JoinType.INNER));
        Filter filter = new SelectorDimFilter("channel", "#en.wikipedia", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c2.countryIsoCode", (Object)"c2.countryName", (Object)"c2.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia", 0L}, (Object)new Object[]{"President of India", "US", "US", "United States", 13L}, (Object)new Object[]{"Glasgow", "GB", "GB", "United Kingdom", 6L}, (Object)new Object[]{"Otjiwarongo Airport", "US", "US", "United States", 13L}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"DirecTV", "US", "US", "United States", 13L}, (Object)new Object[]{"Carlo Curti", "US", "US", "United States", 13L}, (Object)new Object[]{"Giusy Ferreri discography", "IT", "IT", "Italy", 7L}, (Object)new Object[]{"Roma-Bangkok", "IT", "IT", "Italy", 7L}, (Object)new Object[]{"Old Anatolian Turkish", "US", "US", "United States", 13L}, (Object)new Object[]{"Cream Soda", "SU", "SU", "States United", 15L}, (Object)new Object[]{"History of Fourems", "MMMM", "MMMM", "Fourems", 205L}, (Object[])new Object[0][]));
    }

    @Test
    public void test_makeCursor_factToCountryInnerUsingCountryNumberUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingNumberLookup(JoinType.INNER));
        Filter filter = new SelectorDimFilter("channel", "#en.wikipedia", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c2.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Peremptory norm", "AU", "Australia"}, (Object)new Object[]{"President of India", "US", "United States"}, (Object)new Object[]{"Glasgow", "GB", "United Kingdom"}, (Object)new Object[]{"Otjiwarongo Airport", "US", "United States"}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "Canada"}, (Object)new Object[]{"DirecTV", "US", "United States"}, (Object)new Object[]{"Carlo Curti", "US", "United States"}, (Object)new Object[]{"Giusy Ferreri discography", "IT", "Italy"}, (Object)new Object[]{"Roma-Bangkok", "IT", "Italy"}, (Object)new Object[]{"Old Anatolian Turkish", "US", "United States"}, (Object)new Object[]{"Cream Soda", "SU", "States United"}, (Object)new Object[]{"History of Fourems", "MMMM", "Fourems"}, (Object[])new Object[0][]));
    }

    @Test
    public void test_makeCursor_factToCountryLeftWithFilterOnFacts() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.LEFT));
        Filter filter = new SelectorDimFilter("channel", "#de.wikipedia", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany", 3L}));
    }

    @Test
    public void test_makeCursor_factToCountryLeftWithFilterOnFactsUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.LEFT));
        Filter filter = new SelectorDimFilter("channel", "#de.wikipedia", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany"}));
    }

    @Test
    public void test_makeCursor_factToCountryRightWithFilterOnLeftIsNull() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.RIGHT));
        Filter filter = new SelectorDimFilter("channel", null, null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber");
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(filter).build();
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(buildSpec), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, null, "AX", "Atlantis", 14L}, (Object)new Object[]{null, null, null, "USCA", "Usca", 16L}));
    }

    @Test
    public void test_makeCursor_factToCountryRightWithFilterOnLeftIsNullUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.RIGHT));
        Filter filter = new SelectorDimFilter("channel", null, null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.k", (Object)"c1.v");
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(filter).build();
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(buildSpec), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, null, "AX", "Atlantis"}, (Object)new Object[]{null, null, null, "USCA", "Usca"}));
    }

    @Test
    public void test_makeCursor_factToCountryFullWithFilterOnLeftIsNull() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.FULL));
        Filter filter = new SelectorDimFilter("channel", null, null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber");
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(filter).build();
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(buildSpec), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, null, "AX", "Atlantis", 14L}, (Object)new Object[]{null, null, null, "USCA", "Usca", 16L}));
    }

    @Test
    public void test_makeCursor_factToCountryFullWithFilterOnLeftIsNullUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.FULL));
        Filter filter = new SelectorDimFilter("channel", null, null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.k", (Object)"c1.v");
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(filter).build();
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(buildSpec), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, null, "AX", "Atlantis"}, (Object)new Object[]{null, null, null, "USCA", "Usca"}));
    }

    @Test
    public void test_makeCursor_factToCountryRightWithFilterOnJoinable() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.RIGHT));
        Filter filter = new SelectorDimFilter("c1.countryName", "Germany", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", 3L, "DE", "Germany", 3L}));
    }

    @Test
    public void test_makeCursor_factToCountryRightWithFilterOnJoinableUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.RIGHT));
        Filter filter = new SelectorDimFilter("c1.v", "Germany", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", 3L, "DE", "Germany"}));
    }

    @Test
    public void test_makeCursor_factToCountryLeftWithFilterOnJoinable() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.LEFT));
        Filter filter = new OrDimFilter(new DimFilter[]{new SelectorDimFilter("c1.countryIsoCode", "DE", null), new SelectorDimFilter("c1.countryName", "Norway", null), new SelectorDimFilter("c1.countryNumber", "10", null)}).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Mathis Bolly", "MX", "MX", "Mexico", 10L}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany", 3L}, (Object)new Object[]{"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "NO", "NO", "Norway", 11L}));
    }

    @Test
    public void test_makeCursor_factToCountryLeftWithFilterOnJoinableUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.LEFT));
        Filter filter = new OrDimFilter(new DimFilter[]{new SelectorDimFilter("c1.k", "DE", null), new SelectorDimFilter("c1.v", "Norway", null)}).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany"}, (Object)new Object[]{"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "NO", "NO", "Norway"}));
    }

    @Test
    public void test_makeCursor_factToCountryInnerWithFilterInsteadOfRealJoinCondition() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"1", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        Filter filter = new ExpressionDimFilter(StringUtils.format((String)"\"%scountryIsoCode\" == countryIsoCode", (Object[])new Object[]{"c1."}), ExprMacroTable.nil()).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia", 0L}, (Object)new Object[]{"Mathis Bolly", "MX", "MX", "Mexico", 10L}, (Object)new Object[]{"\uc720\ud76c\uc655 GX", "KR", "KR", "Republic of Korea", 9L}, (Object)new Object[]{"\u9752\u91ce\u6b66", "JP", "JP", "Japan", 8L}, (Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "Chile", 2L}, (Object)new Object[]{"President of India", "US", "US", "United States", 13L}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany", 3L}, (Object)new Object[]{"Saison 9 de Secret Story", "FR", "FR", "France", 5L}, (Object)new Object[]{"Glasgow", "GB", "GB", "United Kingdom", 6L}, (Object)new Object[]{"Didier Leclair", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Les Argonautes", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Otjiwarongo Airport", "US", "US", "United States", 13L}, (Object[])new Object[][]{{"Sarah Michelle Gellar", "CA", "CA", "Canada", 1L}, {"DirecTV", "US", "US", "United States", 13L}, {"Carlo Curti", "US", "US", "United States", 13L}, {"Giusy Ferreri discography", "IT", "IT", "Italy", 7L}, {"Roma-Bangkok", "IT", "IT", "Italy", 7L}, {"Wendigo", "SV", "SV", "El Salvador", 12L}, {"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "NO", "NO", "Norway", 11L}, {"Gabinete Ministerial de Rafael Correa", "EC", "EC", "Ecuador", 4L}, {"Old Anatolian Turkish", "US", "US", "United States", 13L}, {"Cream Soda", "SU", "SU", "States United", 15L}, {"History of Fourems", "MMMM", "MMMM", "Fourems", 205L}}));
    }

    @Test
    public void test_makeCursor_factToCountryInnerWithFilterInsteadOfRealJoinConditionUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"1", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        Filter filter = new ExpressionDimFilter(StringUtils.format((String)"\"%sk\" == countryIsoCode", (Object[])new Object[]{"c1."}), ExprMacroTable.nil()).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia"}, (Object)new Object[]{"Mathis Bolly", "MX", "MX", "Mexico"}, (Object)new Object[]{"\uc720\ud76c\uc655 GX", "KR", "KR", "Republic of Korea"}, (Object)new Object[]{"\u9752\u91ce\u6b66", "JP", "JP", "Japan"}, (Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "Chile"}, (Object)new Object[]{"President of India", "US", "US", "United States"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", "DE", "Germany"}, (Object)new Object[]{"Saison 9 de Secret Story", "FR", "FR", "France"}, (Object)new Object[]{"Glasgow", "GB", "GB", "United Kingdom"}, (Object)new Object[]{"Didier Leclair", "CA", "CA", "Canada"}, (Object)new Object[]{"Les Argonautes", "CA", "CA", "Canada"}, (Object)new Object[]{"Otjiwarongo Airport", "US", "US", "United States"}, (Object[])new Object[][]{{"Sarah Michelle Gellar", "CA", "CA", "Canada"}, {"DirecTV", "US", "US", "United States"}, {"Carlo Curti", "US", "US", "United States"}, {"Giusy Ferreri discography", "IT", "IT", "Italy"}, {"Roma-Bangkok", "IT", "IT", "Italy"}, {"Wendigo", "SV", "SV", "El Salvador"}, {"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "NO", "NO", "Norway"}, {"Gabinete Ministerial de Rafael Correa", "EC", "EC", "Ecuador"}, {"Old Anatolian Turkish", "US", "US", "United States"}, {"Cream Soda", "SU", "SU", "States United"}, {"History of Fourems", "MMMM", "MMMM", "Fourems"}}));
    }

    @Test
    public void test_makeCursor_factToRegionToCountryLeft() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", null, null}, (Object)new Object[]{"Rallicula", null, null}, (Object)new Object[]{"Peremptory norm", "New South Wales", "Australia"}, (Object)new Object[]{"Apamea abruzzorum", null, null}, (Object)new Object[]{"Atractus flammigerus", null, null}, (Object)new Object[]{"Agama mossambica", null, null}, (Object)new Object[]{"Mathis Bolly", "Mexico City", "Mexico"}, (Object)new Object[]{"\uc720\ud76c\uc655 GX", "Seoul", "Republic of Korea"}, (Object)new Object[]{"\u9752\u91ce\u6b66", "T\u014dky\u014d", "Japan"}, (Object)new Object[]{"Golpe de Estado en Chile de 1973", "Santiago Metropolitan", "Chile"}, (Object)new Object[]{"President of India", "California", "United States"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Hesse", "Germany"}, (Object[])new Object[][]{{"Saison 9 de Secret Story", "Val d'Oise", "France"}, {"Glasgow", "Kingston upon Hull", "United Kingdom"}, {"Didier Leclair", "Ontario", "Canada"}, {"Les Argonautes", "Quebec", "Canada"}, {"Otjiwarongo Airport", "California", "United States"}, {"Sarah Michelle Gellar", "Ontario", "Canada"}, {"DirecTV", "North Carolina", "United States"}, {"Carlo Curti", "California", "United States"}, {"Giusy Ferreri discography", "Provincia di Varese", "Italy"}, {"Roma-Bangkok", "Provincia di Varese", "Italy"}, {"Wendigo", "Departamento de San Salvador", "El Salvador"}, {"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "Finnmark Fylke", "Norway"}, {"Gabinete Ministerial de Rafael Correa", "Provincia del Guayas", "Ecuador"}, {"Old Anatolian Turkish", "Virginia", "United States"}, {"Cream Soda", "Ainigriv", "States United"}, {"Orange Soda", null, null}, {"History of Fourems", "Fourems Province", "Fourems"}}));
    }

    @Test
    public void test_makeCursor_factToRegionToCountryInnerIncludeNull() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegionIncludeNull(JoinType.INNER), (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", "Nulland", null}, (Object)new Object[]{"Rallicula", "Nulland", null}, (Object)new Object[]{"Peremptory norm", "New South Wales", "Australia"}, (Object)new Object[]{"Apamea abruzzorum", "Nulland", null}, (Object)new Object[]{"Atractus flammigerus", "Nulland", null}, (Object)new Object[]{"Agama mossambica", "Nulland", null}, (Object)new Object[]{"Mathis Bolly", "Mexico City", "Mexico"}, (Object)new Object[]{"\uc720\ud76c\uc655 GX", "Seoul", "Republic of Korea"}, (Object)new Object[]{"\u9752\u91ce\u6b66", "T\u014dky\u014d", "Japan"}, (Object)new Object[]{"Golpe de Estado en Chile de 1973", "Santiago Metropolitan", "Chile"}, (Object)new Object[]{"President of India", "California", "United States"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Hesse", "Germany"}, (Object[])new Object[][]{{"Saison 9 de Secret Story", "Val d'Oise", "France"}, {"Glasgow", "Kingston upon Hull", "United Kingdom"}, {"Didier Leclair", "Ontario", "Canada"}, {"Les Argonautes", "Quebec", "Canada"}, {"Otjiwarongo Airport", "California", "United States"}, {"Sarah Michelle Gellar", "Ontario", "Canada"}, {"DirecTV", "North Carolina", "United States"}, {"Carlo Curti", "California", "United States"}, {"Giusy Ferreri discography", "Provincia di Varese", "Italy"}, {"Roma-Bangkok", "Provincia di Varese", "Italy"}, {"Wendigo", "Departamento de San Salvador", "El Salvador"}, {"\u0410\u043b\u0438\u0441\u0430 \u0432 \u0417\u0430\u0437\u0435\u0440\u043a\u0430\u043b\u044c\u0435", "Finnmark Fylke", "Norway"}, {"Gabinete Ministerial de Rafael Correa", "Provincia del Guayas", "Ecuador"}, {"Old Anatolian Turkish", "Virginia", "United States"}, {"Cream Soda", "Ainigriv", "States United"}, {"History of Fourems", "Fourems Province", "Fourems"}}));
    }

    @Test
    public void test_makeCursor_factToCountryAlwaysTrue() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"1", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        Filter filter = new SelectorDimFilter("channel", "#de.wikipedia", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"c1.countryName");
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(filter).build();
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(buildSpec), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "Australia"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Canada"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Chile"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Germany"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Ecuador"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "France"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "United Kingdom"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Italy"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Japan"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Republic of Korea"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Mexico"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Norway"}, (Object[])new Object[][]{{"Diskussion:Sebastian Schulz", "El Salvador"}, {"Diskussion:Sebastian Schulz", "United States"}, {"Diskussion:Sebastian Schulz", "Atlantis"}, {"Diskussion:Sebastian Schulz", "States United"}, {"Diskussion:Sebastian Schulz", "Usca"}, {"Diskussion:Sebastian Schulz", "Fourems"}}));
    }

    @Test
    public void test_makeCursor_factToCountryAlwaysFalse() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"0", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        Filter filter = new SelectorDimFilter("channel", "#de.wikipedia", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"c1.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", null}));
    }

    @Test
    public void test_makeCursor_factToCountryAlwaysTrueUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"1", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        Filter filter = new SelectorDimFilter("channel", "#de.wikipedia", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"c1.v");
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(filter).build();
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(buildSpec), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "Australia"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Canada"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Chile"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Germany"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Ecuador"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "France"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "United Kingdom"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Italy"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Japan"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Republic of Korea"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Mexico"}, (Object)new Object[]{"Diskussion:Sebastian Schulz", "Norway"}, (Object[])new Object[][]{{"Diskussion:Sebastian Schulz", "El Salvador"}, {"Diskussion:Sebastian Schulz", "United States"}, {"Diskussion:Sebastian Schulz", "Atlantis"}, {"Diskussion:Sebastian Schulz", "States United"}, {"Diskussion:Sebastian Schulz", "Usca"}, {"Diskussion:Sebastian Schulz", "Fourems"}}));
    }

    @Test
    public void test_makeCursor_factToCountryAlwaysFalseUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"0", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        Filter filter = new SelectorDimFilter("channel", "#de.wikipedia", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter(filter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", null}));
    }

    @Test
    public void test_makeCursor_factToCountryUsingVirtualColumn() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.INNER, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%scountryIsoCode\" == virtual", (Object[])new Object[]{"c1."}), (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        VirtualColumns virtualColumns = VirtualColumns.create(Collections.singletonList(this.makeExpressionVirtualColumn("concat(substring(countryIsoCode, 0, 1),'L')")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, virtualColumns);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setVirtualColumns(virtualColumns).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"virtual", (Object)"c1.countryIsoCode", (Object)"c1.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "CL", "Chile"}, (Object)new Object[]{"Didier Leclair", "CA", "CL", "CL", "Chile"}, (Object)new Object[]{"Les Argonautes", "CA", "CL", "CL", "Chile"}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CL", "CL", "Chile"}));
    }

    @Test
    public void test_makeCursor_factToCountryUsingVirtualColumnUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), JoinType.INNER, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sk\" == virtual", (Object[])new Object[]{"c1."}), (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        VirtualColumns virtualColumns = VirtualColumns.create(Collections.singletonList(this.makeExpressionVirtualColumn("concat(substring(countryIsoCode, 0, 1),'L')")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, virtualColumns);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setVirtualColumns(virtualColumns).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"virtual", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "CL", "Chile"}, (Object)new Object[]{"Didier Leclair", "CA", "CL", "CL", "Chile"}, (Object)new Object[]{"Les Argonautes", "CA", "CL", "CL", "Chile"}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CL", "CL", "Chile"}));
    }

    @Test
    public void test_makeCursor_factToCountryUsingExpression() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.INNER, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%scountryIsoCode\" == concat(substring(countryIsoCode, 0, 1),'L')", (Object[])new Object[]{"c1."}), (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "Chile"}, (Object)new Object[]{"Didier Leclair", "CA", "CL", "Chile"}, (Object)new Object[]{"Les Argonautes", "CA", "CL", "Chile"}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CL", "Chile"}));
    }

    @Test
    public void test_makeCursor_factToCountryUsingExpressionUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), JoinType.INNER, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sk\" == concat(substring(countryIsoCode, 0, 1),'L')", (Object[])new Object[]{"c1."}), (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Golpe de Estado en Chile de 1973", "CL", "CL", "Chile"}, (Object)new Object[]{"Didier Leclair", "CA", "CL", "Chile"}, (Object)new Object[]{"Les Argonautes", "CA", "CL", "Chile"}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CL", "Chile"}));
    }

    @Test
    public void test_makeCursor_factToRegionTheWrongWay() {
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("r1.", (Joinable)new IndexedTableJoinable(this.regionsTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sregionIsoCode\" == regionIsoCode", (Object[])new Object[]{"r1."}), (String)"r1.", (ExprMacroTable)ExprMacroTable.nil())));
        Filter filter = new SelectorDimFilter("regionIsoCode", "VA", null).toFilter();
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"regionIsoCode", (Object)"countryIsoCode", (Object)"r1.regionName", (Object)"r1.countryIsoCode");
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(filter).build();
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(buildSpec), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{"Giusy Ferreri discography", "VA", "IT", "Provincia di Varese", "IT"}, (Object)new Object[]{"Giusy Ferreri discography", "VA", "IT", "Virginia", "US"}, (Object)new Object[]{"Roma-Bangkok", "VA", "IT", "Provincia di Varese", "IT"}, (Object)new Object[]{"Roma-Bangkok", "VA", "IT", "Virginia", "US"}, (Object)new Object[]{"Old Anatolian Turkish", "VA", "US", "Provincia di Varese", "IT"}, (Object)new Object[]{"Old Anatolian Turkish", "VA", "US", "Virginia", "US"}));
    }

    @Test
    public void test_makeCursor_errorOnNonEquiJoin() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot build hash-join matcher on non-equi-join condition: x == y");
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == y", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.readCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of());
    }

    @Test
    public void test_makeCursor_errorOnNonEquiJoinUsingLookup() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot join lookup with non-equi condition: x == y");
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == y", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.readCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of());
    }

    @Test
    public void test_makeCursor_errorOnNonKeyBasedJoin() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot build hash-join matcher on non-key-based condition: Equality{leftExpr=x, rightColumn='countryName', includeNull=false}");
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"x == \"%scountryName\"", (Object[])new Object[]{"c1."}), (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.readCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of());
    }

    @Test
    public void test_makeCursor_errorOnNonKeyBasedJoinUsingLookup() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot join lookup with condition referring to non-key column: x == \"c1.countryName");
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"x == \"%scountryName\"", (Object[])new Object[]{"c1."}), (String)"c1.", (ExprMacroTable)ExprMacroTable.nil())));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.readCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of());
    }

    @Test
    public void test_makeCursor_factToCountryLeft_filterExcludesAllLeftRows() {
        SelectorFilter originalFilter = new SelectorFilter("page", "this matches nothing");
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter((Filter)originalFilter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void test_makeCursor_factToCountryLeft_filterExcludesAllLeftRowsUsingLookup() {
        SelectorFilter originalFilter = new SelectorFilter("page", "this matches nothing");
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter((Filter)originalFilter).build()), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void test_makeCursor_originalFilterDoesNotMatchPreAnalysis_shouldThrowISE() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.LEFT));
        SelectorFilter filter = new SelectorFilter("page", "this matches nothing");
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis((Filter)filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), null, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.builder().setFilter((Filter)filter).build());
    }

    @Test
    public void test_makeCursor_factToCountryLeftWithBaseFilter() {
        Filter baseFilter = Filters.or(Arrays.asList(new SelectorDimFilter("countryIsoCode", "CA", null).toFilter(), new SelectorDimFilter("countryIsoCode", "MatchNothing", null).toFilter()));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(baseFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), baseFilter, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Didier Leclair", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Les Argonautes", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Orange Soda", "MatchNothing", null, null, NULL_COUNTRY}));
    }

    @Test
    public void test_makeCursor_factToCountryInnerWithBaseFilter() {
        Filter baseFilter = Filters.or(Arrays.asList(new SelectorDimFilter("countryIsoCode", "CA", null).toFilter(), new SelectorDimFilter("countryIsoCode", "MatchNothing", null).toFilter()));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.INNER));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(baseFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinTestHelper.verifyCursor(new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), baseFilter, (List)joinableClauses, joinFilterPreAnalysis).makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Didier Leclair", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Les Argonautes", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CA", "Canada", 1L}));
    }

    @Test
    public void test_makeCursor_factToCountryRightWithBaseFilter() {
        Filter baseFilter = Filters.or(Arrays.asList(new SelectorDimFilter("countryIsoCode", "CA", null).toFilter(), new SelectorDimFilter("countryIsoCode", "MatchNothing", null).toFilter()));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.RIGHT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(baseFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), baseFilter, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber");
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{"Didier Leclair", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Les Argonautes", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CA", "Canada", 1L}, (Object)new Object[]{null, null, "AU", "Australia", 0L}, (Object)new Object[]{null, null, "CL", "Chile", 2L}, (Object)new Object[]{null, null, "DE", "Germany", 3L}, (Object)new Object[]{null, null, "EC", "Ecuador", 4L}, (Object)new Object[]{null, null, "FR", "France", 5L}, (Object)new Object[]{null, null, "GB", "United Kingdom", 6L}, (Object)new Object[]{null, null, "IT", "Italy", 7L}, (Object)new Object[]{null, null, "JP", "Japan", 8L}, (Object)new Object[]{null, null, "KR", "Republic of Korea", 9L}, (Object[])new Object[][]{{null, null, "MX", "Mexico", 10L}, {null, null, "NO", "Norway", 11L}, {null, null, "SV", "El Salvador", 12L}, {null, null, "US", "United States", 13L}, {null, null, "AX", "Atlantis", 14L}, {null, null, "SU", "States United", 15L}, {null, null, "USCA", "Usca", 16L}, {null, null, "MMMM", "Fourems", 205L}}));
    }

    @Test
    public void test_makeCursor_factToCountryFullWithBaseFilter() {
        Filter baseFilter = Filters.or(Arrays.asList(new SelectorDimFilter("countryIsoCode", "CA", null).toFilter(), new SelectorDimFilter("countryIsoCode", "MatchNothing", null).toFilter()));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.FULL));
        JoinFilterPreAnalysis joinFilterPreAnalysis = HashJoinSegmentCursorFactoryTest.makeDefaultConfigPreAnalysis(baseFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentCursorFactory cursorFactory = new HashJoinSegmentCursorFactory((CursorFactory)this.factSegment.as(CursorFactory.class), baseFilter, (List)joinableClauses, joinFilterPreAnalysis);
        ImmutableList columns = ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber");
        JoinTestHelper.verifyCursor(cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN), (List<String>)columns, (List<Object[]>)ImmutableList.of((Object)new Object[]{"Didier Leclair", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Les Argonautes", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Sarah Michelle Gellar", "CA", "CA", "Canada", 1L}, (Object)new Object[]{"Orange Soda", "MatchNothing", null, null, null}, (Object)new Object[]{null, null, "AU", "Australia", 0L}, (Object)new Object[]{null, null, "CL", "Chile", 2L}, (Object)new Object[]{null, null, "DE", "Germany", 3L}, (Object)new Object[]{null, null, "EC", "Ecuador", 4L}, (Object)new Object[]{null, null, "FR", "France", 5L}, (Object)new Object[]{null, null, "GB", "United Kingdom", 6L}, (Object)new Object[]{null, null, "IT", "Italy", 7L}, (Object)new Object[]{null, null, "JP", "Japan", 8L}, (Object[])new Object[][]{{null, null, "KR", "Republic of Korea", 9L}, {null, null, "MX", "Mexico", 10L}, {null, null, "NO", "Norway", 11L}, {null, null, "SV", "El Salvador", 12L}, {null, null, "US", "United States", 13L}, {null, null, "AX", "Atlantis", 14L}, {null, null, "SU", "States United", 15L}, {null, null, "USCA", "Usca", 16L}, {null, null, "MMMM", "Fourems", 205L}}));
    }

    @Test
    public void test_hasBuiltInFiltersForSingleJoinableClauseWithVariousJoinTypes() {
        Assert.assertFalse((boolean)((TopNOptimizationInspector)this.makeFactToCountrySegment(JoinType.INNER).as(TopNOptimizationInspector.class)).areAllDictionaryIdsPresent());
        Assert.assertTrue((boolean)((TopNOptimizationInspector)this.makeFactToCountrySegment(JoinType.LEFT).as(TopNOptimizationInspector.class)).areAllDictionaryIdsPresent());
        Assert.assertFalse((boolean)((TopNOptimizationInspector)this.makeFactToCountrySegment(JoinType.RIGHT).as(TopNOptimizationInspector.class)).areAllDictionaryIdsPresent());
        Assert.assertTrue((boolean)((TopNOptimizationInspector)this.makeFactToCountrySegment(JoinType.FULL).as(TopNOptimizationInspector.class)).areAllDictionaryIdsPresent());
        HashJoinSegment segment = new HashJoinSegment((Segment)ReferenceCountedSegmentProvider.unmanaged((Segment)this.factSegment).orElseThrow(), null, (List)ImmutableList.of((Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"'true'", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil()))), null, () -> {});
        TopNOptimizationInspector inspector = (TopNOptimizationInspector)segment.as(TopNOptimizationInspector.class);
        Assert.assertTrue((boolean)inspector.areAllDictionaryIdsPresent());
    }

    @Test
    public void test_hasBuiltInFiltersForConvertedJoin() {
        HashJoinSegment segment = new HashJoinSegment((Segment)ReferenceCountedSegmentProvider.unmanaged((Segment)this.factSegment).orElseThrow(), (Filter)new InDimFilter("dim", (Set)ImmutableSet.of((Object)"foo", (Object)"bar")), (List)ImmutableList.of(), null, () -> {});
        TopNOptimizationInspector inspector = (TopNOptimizationInspector)segment.as(TopNOptimizationInspector.class);
        Assert.assertFalse((boolean)inspector.areAllDictionaryIdsPresent());
    }

    @Test
    public void test_hasBuiltInFiltersForMultipleJoinableClausesWithVariousJoinTypes() {
        HashJoinSegment segment = new HashJoinSegment((Segment)ReferenceCountedSegmentProvider.unmanaged((Segment)this.factSegment).orElseThrow(), null, (List)ImmutableList.of((Object)this.factToRegion(JoinType.INNER), (Object)this.regionToCountry(JoinType.LEFT)), null, () -> {});
        Assert.assertFalse((boolean)((TopNOptimizationInspector)segment.as(TopNOptimizationInspector.class)).areAllDictionaryIdsPresent());
        HashJoinSegment segment2 = new HashJoinSegment((Segment)ReferenceCountedSegmentProvider.unmanaged((Segment)this.factSegment).orElseThrow(), null, (List)ImmutableList.of((Object)this.factToRegion(JoinType.RIGHT), (Object)this.regionToCountry(JoinType.INNER), (Object)this.factToCountryOnNumber(JoinType.FULL)), null, () -> {});
        Assert.assertFalse((boolean)((TopNOptimizationInspector)segment2.as(TopNOptimizationInspector.class)).areAllDictionaryIdsPresent());
        HashJoinSegment segment3 = new HashJoinSegment((Segment)ReferenceCountedSegmentProvider.unmanaged((Segment)this.factSegment).orElseThrow(), null, (List)ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT)), null, () -> {});
        Assert.assertTrue((boolean)((TopNOptimizationInspector)segment3.as(TopNOptimizationInspector.class)).areAllDictionaryIdsPresent());
        HashJoinSegment segment4 = new HashJoinSegment((Segment)ReferenceCountedSegmentProvider.unmanaged((Segment)this.factSegment).orElseThrow(), null, (List)ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"'true'", (String)"c1.", (ExprMacroTable)ExprMacroTable.nil()))), null, () -> {});
        Assert.assertTrue((boolean)((TopNOptimizationInspector)segment4.as(TopNOptimizationInspector.class)).areAllDictionaryIdsPresent());
    }
}

