/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.druid.segment.filter.PredicateValueMatcherFactory;
import org.apache.druid.segment.selector.TestColumnValueSelector;
import org.apache.druid.segment.serde.StringUtf8DictionaryEncodedColumnSupplier;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class PredicateValueMatcherFactoryTest
extends InitializedNullHandlingTest {
    @Test
    public void testDefaultType() {
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)PredicateValueMatcherFactoryTest.forSelector(null).defaultType());
    }

    @Test
    public void testDimensionProcessorSingleValuedDimensionMatchingValue() {
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("0").makeDimensionProcessor(DimensionSelector.constant((String)"0"), false);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testDimensionProcessorSingleValuedDimensionNotMatchingValue() {
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("1").makeDimensionProcessor(DimensionSelector.constant((String)"0"), false);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testDimensionProcessorMultiValuedDimensionMatchingValue() {
        StringUtf8DictionaryEncodedColumnSupplier columnSupplier = new StringUtf8DictionaryEncodedColumnSupplier(() -> ((GenericIndexed)GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v1")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v2")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v3"))), (ObjectStrategy)GenericIndexed.UTF8_STRATEGY)).singleThreaded(), null, () -> VSizeColumnarMultiInts.fromIterable((Iterable)ImmutableList.of((Object)VSizeColumnarInts.fromArray((int[])new int[]{1}))), (BitmapFactory)new RoaringBitmapFactory());
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("v2").makeDimensionProcessor(columnSupplier.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), true);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testDimensionProcessorMultiValuedDimensionNotMatchingValue() {
        StringUtf8DictionaryEncodedColumnSupplier columnSupplier = new StringUtf8DictionaryEncodedColumnSupplier(() -> ((GenericIndexed)GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v1")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v2")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v3"))), (ObjectStrategy)GenericIndexed.UTF8_STRATEGY)).singleThreaded(), null, () -> VSizeColumnarMultiInts.fromIterable((Iterable)ImmutableList.of((Object)VSizeColumnarInts.fromArray((int[])new int[]{1}))), (BitmapFactory)new RoaringBitmapFactory());
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("v3").makeDimensionProcessor(columnSupplier.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), true);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testFloatProcessorMatchingValue() {
        TestColumnValueSelector<Float> columnValueSelector = TestColumnValueSelector.of(Float.class, (Collection<Object>)ImmutableList.of((Object)Float.valueOf(2.0f)));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("2.f").makeFloatProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testFloatProcessorNotMatchingValue() {
        TestColumnValueSelector<Float> columnValueSelector = TestColumnValueSelector.of(Float.class, (Collection<Object>)ImmutableList.of((Object)Float.valueOf(2.0f)));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("5.f").makeFloatProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testDoubleProcessorMatchingValue() {
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)2.0));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("2.").makeDoubleProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testDoubleProcessorNotMatchingValue() {
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)2.0));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("5.").makeDoubleProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testNumberProcessorMatchingValue() {
        final Double num = 2.0;
        TestColumnValueSelector<Number> columnValueSelector = TestColumnValueSelector.of(Number.class, (Collection<Object>)ImmutableList.of((Object)new Number(){

            @Override
            public int intValue() {
                return num.intValue();
            }

            @Override
            public long longValue() {
                return num.longValue();
            }

            @Override
            public float floatValue() {
                return num.floatValue();
            }

            @Override
            public double doubleValue() {
                return num;
            }
        }));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("2").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testNumberProcessorNotMatchingValue() {
        final Double num = 2.0;
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)new Number(){

            @Override
            public int intValue() {
                return num.intValue();
            }

            @Override
            public long longValue() {
                return num.longValue();
            }

            @Override
            public float floatValue() {
                return num.floatValue();
            }

            @Override
            public double doubleValue() {
                return num;
            }
        }));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("5").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testLongProcessorMatchingValue() {
        TestColumnValueSelector<Long> columnValueSelector = TestColumnValueSelector.of(Long.class, (Collection<Object>)ImmutableList.of((Object)2L));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("2").makeLongProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testLongProcessorNotMatchingValue() {
        TestColumnValueSelector<Long> columnValueSelector = TestColumnValueSelector.of(Long.class, (Collection<Object>)ImmutableList.of((Object)2L));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("5").makeLongProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingNull() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, Arrays.asList(null, "v"));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector(null).makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorEmptyString() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, Arrays.asList("", "v"));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector(null).makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingInteger() {
        TestColumnValueSelector<Integer> columnValueSelector = TestColumnValueSelector.of(Integer.class, (Collection<Object>)ImmutableList.of((Object)11));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorNotMatchingInteger() {
        TestColumnValueSelector<Integer> columnValueSelector = TestColumnValueSelector.of(Integer.class, (Collection<Object>)ImmutableList.of((Object)15));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingLong() {
        TestColumnValueSelector<Long> columnValueSelector = TestColumnValueSelector.of(Long.class, (Collection<Object>)ImmutableList.of((Object)11L));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorNotMatchingLong() {
        TestColumnValueSelector<Long> columnValueSelector = TestColumnValueSelector.of(Long.class, (Collection<Object>)ImmutableList.of((Object)15L));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingFloat() {
        TestColumnValueSelector<Float> columnValueSelector = TestColumnValueSelector.of(Float.class, (Collection<Object>)ImmutableList.of((Object)Float.valueOf(11.0f)));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11.f").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorNotMatchingFloat() {
        TestColumnValueSelector<Float> columnValueSelector = TestColumnValueSelector.of(Float.class, (Collection<Object>)ImmutableList.of((Object)Float.valueOf(15.0f)));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11.f").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingDouble() {
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)11.0));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11.d").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorNotMatchingDouble() {
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)15.0));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11.d").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingString() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)"val"));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorNotMatchingString() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)"bar"));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingStringList() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)ImmutableList.of((Object)"val")));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorNotMatchingStringList() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)ImmutableList.of((Object)"bar")));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingEmptyList() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)ImmutableList.of()));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector(null).makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingBoolean() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)false));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("false").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorNotMatchingBoolean() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)true));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("false").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorMatchingByteArray() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)StringUtils.toUtf8((String)"var")));
        columnValueSelector.advance();
        String base64Encoded = StringUtils.encodeBase64String((byte[])StringUtils.toUtf8((String)"var"));
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector(base64Encoded).makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches(false));
    }

    @Test
    public void testComplexProcessorNotMatchingByteArray() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)StringUtils.toUtf8((String)"var")));
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    private static PredicateValueMatcherFactory forSelector(@Nullable String value) {
        return new PredicateValueMatcherFactory((DruidPredicateFactory)new SelectorPredicateFactory(value));
    }
}

