/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.segment.columnar.ColumnarFrameCursorFactory;
import org.apache.druid.frame.segment.row.RowFrameCursorFactory;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.RowBasedCursorFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.cnf.CNFFilterExplosionException;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public abstract class BaseFilterTest
extends InitializedNullHandlingTest {
    static final String TIMESTAMP_COLUMN = "timestamp";
    static final VirtualColumns VIRTUAL_COLUMNS = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "1.0 + 0.1", ColumnType.FLOAT, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("exprDouble", "1.0 + 1.1", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("exprLong", "1 + 2", ColumnType.LONG, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vdim0", "dim0", ColumnType.STRING, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vdim1", "dim1", ColumnType.STRING, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vs0", "s0", ColumnType.STRING, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vd0", "d0", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vf0", "f0", ColumnType.FLOAT, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vl0", "l0", ColumnType.LONG, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vd0-nvl-2", "nvl(vd0, 2.0)", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vd0-add-sub", "d0 + (d0 - d0)", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("vf0-add-sub", "f0 + (f0 - f0)", ColumnType.FLOAT, TestExprMacroTable.INSTANCE), (Object[])new VirtualColumn[]{new ExpressionVirtualColumn("vl0-add-sub", "l0 + (l0 - l0)", ColumnType.LONG, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("double-vd0-add-sub", "vd0 + (vd0 - vd0)", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("double-vf0-add-sub", "vf0 + (vf0 - vf0)", ColumnType.FLOAT, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("double-vl0-add-sub", "vl0 + (vl0 - vl0)", ColumnType.LONG, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("vdim3-concat", "dim3 + dim3", ColumnType.LONG, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("vdim2-offset", "array_offset(dim2, 1)", ColumnType.STRING, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("nestedArrayLong", "array(arrayLong)", ColumnType.ofArray((ColumnType)ColumnType.LONG_ARRAY), TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("fake-nvl", "nvl(fake, 'hello')", ColumnType.STRING, TestExprMacroTable.INSTANCE), new ListFilteredVirtualColumn("allow-dim0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim0"), (Set)ImmutableSet.of((Object)"3", (Object)"4"), Boolean.valueOf(true)), new ListFilteredVirtualColumn("deny-dim0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim0"), (Set)ImmutableSet.of((Object)"3", (Object)"4"), Boolean.valueOf(false)), new ListFilteredVirtualColumn("allow-dim2", (DimensionSpec)DefaultDimensionSpec.of((String)"dim2"), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true)), new ListFilteredVirtualColumn("deny-dim2", (DimensionSpec)DefaultDimensionSpec.of((String)"dim2"), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(false)), new NestedFieldVirtualColumn("nested", "$.s0", "nested.s0", ColumnType.STRING), new NestedFieldVirtualColumn("nested", "$.d0", "nested.d0", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nested", "$.l0", "nested.l0", ColumnType.LONG), new NestedFieldVirtualColumn("nested", "$.arrayLong", "nested.arrayLong", ColumnType.LONG_ARRAY), new NestedFieldVirtualColumn("nested", "$.arrayDouble", "nested.arrayDouble", ColumnType.DOUBLE_ARRAY), new NestedFieldVirtualColumn("nested", "$.arrayString", "nested.arrayString", ColumnType.STRING_ARRAY), new ExpressionVirtualColumn("arrayLongAsMvd", "array_to_mv(arrayLong)", ColumnType.STRING, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("arrayDoubleAsMvd", "array_to_mv(arrayDouble)", ColumnType.STRING, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("arrayStringAsMvd", "array_to_mv(arrayString)", ColumnType.STRING, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("arrayConstantAsMvd", "array_to_mv(array(1,2,3))", ColumnType.STRING, TestExprMacroTable.INSTANCE)}));
    static final TimestampSpec DEFAULT_TIMESTAMP_SPEC = new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000"));
    static final DimensionsSpec DEFAULT_DIM_SPEC = new DimensionsSpec((List)ImmutableList.builder().addAll((Iterable)DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3", (Object)"timeDim", (Object)"s0"))).add((Object)new DoubleDimensionSchema("d0")).add((Object)new FloatDimensionSchema("f0")).add((Object)new LongDimensionSchema("l0")).add((Object)new AutoTypeColumnSchema("arrayString", ColumnType.STRING_ARRAY, null)).add((Object)new AutoTypeColumnSchema("arrayLong", ColumnType.LONG_ARRAY, null)).add((Object)new AutoTypeColumnSchema("arrayDouble", ColumnType.DOUBLE_ARRAY, null)).add((Object)AutoTypeColumnSchema.of((String)"variant")).add((Object)AutoTypeColumnSchema.of((String)"nested")).build());
    static final InputRowParser<Map<String, Object>> DEFAULT_PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(DEFAULT_TIMESTAMP_SPEC, DEFAULT_DIM_SPEC));
    static final RowSignature DEFAULT_ROW_SIGNATURE = RowSignature.builder().add("dim0", ColumnType.STRING).add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("timeDim", ColumnType.STRING).add("s0", ColumnType.STRING).add("d0", ColumnType.DOUBLE).add("f0", ColumnType.FLOAT).add("l0", ColumnType.LONG).add("arrayString", ColumnType.STRING_ARRAY).add("arrayLong", ColumnType.LONG_ARRAY).add("arrayDouble", ColumnType.DOUBLE_ARRAY).add("variant", ColumnType.STRING_ARRAY).add("nested", ColumnType.NESTED_DATA).build();
    static final List<InputRow> DEFAULT_ROWS = ImmutableList.of((Object)BaseFilterTest.makeDefaultSchemaRow("0", "", ImmutableList.of((Object)"a", (Object)"b"), "2017-07-25", "", 0.0, Float.valueOf(0.0f), 0L, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), ImmutableList.of((Object)1L, (Object)2L, (Object)3L), ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), "abc", TestHelper.makeMapWithExplicitNull("s0", "", "d0", 0.0, "f0", Float.valueOf(0.0f), "l0", 0L, "arrayString", ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), "arrayLong", ImmutableList.of((Object)1L, (Object)2L, (Object)3L), "arrayDouble", ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), "variant", "abc")), (Object)BaseFilterTest.makeDefaultSchemaRow("1", "10", ImmutableList.of(), "2017-07-25", "a", 10.1, Float.valueOf(10.1f), 100L, ImmutableList.of(), ImmutableList.of(), new Object[]{1.1, 2.2, 3.3}, 100L, TestHelper.makeMapWithExplicitNull("s0", "a", "d0", 10.1, "f0", Float.valueOf(10.1f), "l0", 100L, "arrayString", ImmutableList.of(), "arrayLong", ImmutableList.of(), "arrayDouble", new Object[]{1.1, 2.2, 3.3}, "variant", 100L)), (Object)BaseFilterTest.makeDefaultSchemaRow("2", "2", ImmutableList.of((Object)""), "2017-05-25", "b", null, Float.valueOf(5.5f), 40L, null, new Object[]{1L, 2L, 3L}, Collections.singletonList(null), "100", TestHelper.makeMapWithExplicitNull("s0", "b", "d0", null, "f0", Float.valueOf(5.5f), "l0", 40L, "arrayString", null, "arrayLong", new Object[]{1L, 2L, 3L}, "arrayDouble", Collections.singletonList(null), "variant", "100")), (Object)BaseFilterTest.makeDefaultSchemaRow("3", "1", ImmutableList.of((Object)"a"), "2020-01-25", null, 120.0245, Float.valueOf(110.0f), null, new Object[]{"a", "b", "c"}, null, ImmutableList.of(), Arrays.asList(1.1, 2.2, 3.3), TestHelper.makeMapWithExplicitNull("s0", null, "d0", 120.0245, "f0", Float.valueOf(110.0f), "l0", null, "arrayString", new Object[]{"a", "b", "c"}, "arrayLong", null, "arrayDouble", ImmutableList.of(), "variant", Arrays.asList(1.1, 2.2, 3.3))), (Object)BaseFilterTest.makeDefaultSchemaRow("4", "abdef", ImmutableList.of((Object)"c"), null, "c", 60.0, null, 9001L, ImmutableList.of((Object)"c", (Object)"d"), Collections.singletonList(null), new Object[]{-1.1, -333.3}, 12.34, TestHelper.makeMapWithExplicitNull("s0", "c", "d0", 60.0, "f0", null, "l0", 9001L, "arrayString", ImmutableList.of((Object)"c", (Object)"d"), "arrayLong", Collections.singletonList(null), "arrayDouble", new Object[]{-1.1, -333.3}, "variant", 12.34)), (Object)BaseFilterTest.makeDefaultSchemaRow("5", "abc", null, "2020-01-25", "a", 765.432, Float.valueOf(123.45f), 12345L, Collections.singletonList(null), new Object[]{123L, 345L}, null, Arrays.asList(100, 200, 300), TestHelper.makeMapWithExplicitNull("s0", "a", "d0", 765.432, "f0", Float.valueOf(123.45f), "l0", 12345L, "arrayString", Collections.singletonList(null), "arrayLong", new Object[]{123L, 345L}, "arrayDouble", null, "variant", Arrays.asList(100, 200, 300))));
    static final IncrementalIndexSchema DEFAULT_INDEX_SCHEMA = new IncrementalIndexSchema.Builder().withDimensionsSpec(DEFAULT_DIM_SPEC).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final List<InputRow> rows;
    protected final IndexBuilder indexBuilder;
    protected final Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher;
    protected final boolean cnf;
    protected final boolean optimize;
    protected final String testName;
    protected CursorFactory cursorFactory;
    protected VirtualColumns virtualColumns;
    private static ThreadLocal<Map<String, Map<String, CursorStuff>>> adapterCache = ThreadLocal.withInitial(HashMap::new);

    static InputRow makeDefaultSchemaRow(Object ... elements) {
        return BaseFilterTest.makeSchemaRow(DEFAULT_PARSER, DEFAULT_ROW_SIGNATURE, elements);
    }

    public static InputRow makeSchemaRow(InputRowParser<Map<String, Object>> parser, RowSignature signature, Object ... elements) {
        HashMap mapRow = Maps.newHashMapWithExpectedSize((int)signature.size());
        for (int i = 0; i < signature.size(); ++i) {
            String columnName = signature.getColumnName(i);
            if (elements != null && i < elements.length) {
                Object value = elements[i];
                mapRow.put(columnName, value);
                continue;
            }
            mapRow.put(columnName, null);
        }
        return (InputRow)parser.parseBatch((Object)mapRow).get(0);
    }

    public BaseFilterTest(String testName, List<InputRow> rows, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
        this.testName = testName;
        this.rows = rows;
        this.indexBuilder = indexBuilder;
        this.finisher = finisher;
        this.cnf = cnf;
        this.optimize = optimize;
    }

    @Before
    public void setUp() throws Exception {
        CursorStuff cursorStuff;
        BuiltInTypesModule.registerHandlersAndSerde();
        String className = this.getClass().getName();
        Map<String, CursorStuff> adaptersForClass = adapterCache.get().get(className);
        if (adaptersForClass == null) {
            adaptersForClass = new HashMap<String, CursorStuff>();
            adapterCache.get().put(className, adaptersForClass);
        }
        if ((cursorStuff = adaptersForClass.get(this.testName)) == null) {
            Pair pair = (Pair)this.finisher.apply((Object)this.indexBuilder.tmpDir(this.temporaryFolder.newFolder()).rows(this.rows));
            cursorStuff = new CursorStuff((CursorFactory)pair.lhs, VirtualColumns.create(Arrays.stream(VIRTUAL_COLUMNS.getVirtualColumns()).filter(x -> x.canVectorize(VIRTUAL_COLUMNS.wrapInspector((ColumnInspector)pair.lhs))).collect(Collectors.toList())), (Closeable)pair.rhs);
            adaptersForClass.put(this.testName, cursorStuff);
        }
        this.cursorFactory = cursorStuff.cursorFactory;
        this.virtualColumns = cursorStuff.virtualColumns;
    }

    public static void tearDown(String className) throws Exception {
        Map<String, CursorStuff> adaptersForClass = adapterCache.get().get(className);
        if (adaptersForClass != null) {
            for (Map.Entry<String, CursorStuff> entry : adaptersForClass.entrySet()) {
                entry.getValue().closeable.close();
            }
            adapterCache.get().put(className, null);
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        return BaseFilterTest.makeConstructors();
    }

    public static Collection<Object[]> makeConstructors() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        ImmutableMap bitmapSerdeFactories = ImmutableMap.of((Object)"concise", (Object)new ConciseBitmapSerdeFactory(), (Object)"roaring", (Object)RoaringBitmapSerdeFactory.getInstance());
        ImmutableMap segmentWriteOutMediumFactories = ImmutableMap.of((Object)"tmpFile segment write-out medium", (Object)TmpFileSegmentWriteOutMediumFactory.instance(), (Object)"off-heap memory segment write-out medium", (Object)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        ImmutableMap finishers = ImmutableMap.builder().put((Object)"incremental", input -> {
            IncrementalIndex index = input.buildIncrementalIndex();
            return Pair.of((Object)new IncrementalIndexCursorFactory(index), (Object)index);
        }).put((Object)"incrementalAutoTypes", input -> {
            input.mapSchema(schema -> new IncrementalIndexSchema(schema.getMinTimestamp(), schema.getTimestampSpec(), schema.getQueryGranularity(), schema.getVirtualColumns(), schema.getDimensionsSpec().withDimensions(schema.getDimensionsSpec().getDimensions().stream().map(dimensionSchema -> AutoTypeColumnSchema.of((String)dimensionSchema.getName())).collect(Collectors.toList())), schema.getMetrics(), schema.isRollup(), schema.getProjections()));
            IncrementalIndex index = input.buildIncrementalIndex();
            return Pair.of((Object)new IncrementalIndexCursorFactory(index), (Object)index);
        }).put((Object)"mmappedAutoTypes", input -> {
            input.mapSchema(schema -> new IncrementalIndexSchema(schema.getMinTimestamp(), schema.getTimestampSpec(), schema.getQueryGranularity(), schema.getVirtualColumns(), schema.getDimensionsSpec().withDimensions(schema.getDimensionsSpec().getDimensions().stream().map(dimensionSchema -> AutoTypeColumnSchema.of((String)dimensionSchema.getName())).collect(Collectors.toList())), schema.getMetrics(), schema.isRollup(), schema.getProjections()));
            QueryableIndex index = input.buildMMappedIndex();
            return Pair.of((Object)new QueryableIndexCursorFactory(index), (Object)index);
        }).put((Object)"mmappedAutoTypesMerged", input -> {
            QueryableIndex index = input.mapSchema(schema -> new IncrementalIndexSchema(schema.getMinTimestamp(), schema.getTimestampSpec(), schema.getQueryGranularity(), schema.getVirtualColumns(), schema.getDimensionsSpec().withDimensions(schema.getDimensionsSpec().getDimensions().stream().map(dimensionSchema -> new AutoTypeColumnSchema(dimensionSchema.getName(), null, null)).collect(Collectors.toList())), schema.getMetrics(), schema.isRollup(), schema.getProjections())).intermediaryPersistSize(3).buildMMappedIndex();
            return Pair.of((Object)new QueryableIndexCursorFactory(index), (Object)index);
        }).put((Object)"mmapped", input -> {
            QueryableIndex index = input.buildMMappedIndex();
            return Pair.of((Object)new QueryableIndexCursorFactory(index), (Object)index);
        }).put((Object)"mmappedMerged", input -> {
            QueryableIndex index = input.buildMMappedMergedIndex();
            return Pair.of((Object)new QueryableIndexCursorFactory(index), (Object)index);
        }).put((Object)"rowBasedWithoutTypeSignature", input -> Pair.of((Object)((CursorFactory)input.buildRowBasedSegmentWithoutTypeSignature().as(CursorFactory.class)), () -> {})).put((Object)"rowBasedWithTypeSignature", input -> Pair.of((Object)((CursorFactory)input.buildRowBasedSegmentWithTypeSignature().as(CursorFactory.class)), () -> {})).put((Object)"frame (row-based)", input -> {
            input.mapSchema(schema -> new IncrementalIndexSchema(schema.getMinTimestamp(), schema.getTimestampSpec(), schema.getQueryGranularity(), schema.getVirtualColumns(), schema.getDimensionsSpec().withDimensions(schema.getDimensionsSpec().getDimensions().stream().filter(dimensionSchema -> !dimensionSchema.getName().equals("variant")).collect(Collectors.toList())), schema.getMetrics(), schema.isRollup(), schema.getProjections()));
            FrameSegment segment = input.buildFrameSegment(FrameType.latestRowBased());
            return Pair.of((Object)((CursorFactory)segment.as(CursorFactory.class)), (Object)segment);
        }).put((Object)"frame (columnar)", input -> {
            input.mapSchema(schema -> new IncrementalIndexSchema(schema.getMinTimestamp(), schema.getTimestampSpec(), schema.getQueryGranularity(), schema.getVirtualColumns(), schema.getDimensionsSpec().withDimensions(schema.getDimensionsSpec().getDimensions().stream().filter(dimensionSchema -> !(dimensionSchema instanceof AutoTypeColumnSchema)).collect(Collectors.toList())), schema.getMetrics(), schema.isRollup(), schema.getProjections()));
            FrameSegment segment = input.buildFrameSegment(FrameType.latestColumnar());
            return Pair.of((Object)((CursorFactory)segment.as(CursorFactory.class)), (Object)segment);
        }).build();
        StringEncodingStrategy[] stringEncoding = new StringEncodingStrategy[]{new StringEncodingStrategy.Utf8(), new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)0)), new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1))};
        for (Map.Entry bitmapSerdeFactoryEntry : bitmapSerdeFactories.entrySet()) {
            for (Map.Entry segmentWriteOutMediumFactoryEntry : segmentWriteOutMediumFactories.entrySet()) {
                for (Map.Entry finisherEntry : finishers.entrySet()) {
                    UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
                    while (unmodifiableIterator.hasNext()) {
                        boolean cnf = (Boolean)unmodifiableIterator.next();
                        UnmodifiableIterator unmodifiableIterator2 = ImmutableList.of((Object)false, (Object)true).iterator();
                        while (unmodifiableIterator2.hasNext()) {
                            boolean optimize = (Boolean)unmodifiableIterator2.next();
                            UnmodifiableIterator unmodifiableIterator3 = ImmutableList.of((Object)false, (Object)true).iterator();
                            while (unmodifiableIterator3.hasNext()) {
                                boolean storeNullColumns = (Boolean)unmodifiableIterator3.next();
                                for (StringEncodingStrategy encodingStrategy : stringEncoding) {
                                    String testName = StringUtils.format((String)"bitmaps[%s], indexMerger[%s], finisher[%s], cnf[%s], optimize[%s], stringDictionaryEncoding[%s], storeNullColumns[%s]", (Object[])new Object[]{bitmapSerdeFactoryEntry.getKey(), segmentWriteOutMediumFactoryEntry.getKey(), finisherEntry.getKey(), cnf, optimize, encodingStrategy.getType(), storeNullColumns});
                                    IndexBuilder indexBuilder = IndexBuilder.create().schema(DEFAULT_INDEX_SCHEMA).writeNullColumns(storeNullColumns).indexSpec(IndexSpec.builder().withBitmapSerdeFactory((BitmapSerdeFactory)bitmapSerdeFactoryEntry.getValue()).withStringDictionaryEncoding(encodingStrategy).build()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)segmentWriteOutMediumFactoryEntry.getValue());
                                    constructors.add(new Object[]{testName, indexBuilder, finisherEntry.getValue(), cnf, optimize});
                                }
                            }
                        }
                    }
                }
            }
        }
        return constructors;
    }

    protected boolean isAutoSchema() {
        return this.testName.contains("AutoTypes");
    }

    protected boolean hasTypeInformation() {
        return !this.testName.contains("rowBasedWithoutTypeSignature");
    }

    protected boolean canTestArrayColumns() {
        return !this.testName.contains("frame (columnar)") && !this.testName.contains("rowBasedWithoutTypeSignature");
    }

    private Filter makeFilter(DimFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        DimFilter maybeOptimized = this.maybeOptimize(dimFilter);
        Filter filter = maybeOptimized.toFilter();
        try {
            return this.cnf ? Filters.toCnf((Filter)filter) : filter;
        }
        catch (CNFFilterExplosionException cnfFilterExplosionException) {
            throw new RuntimeException(cnfFilterExplosionException);
        }
    }

    private DimFilter maybeOptimize(DimFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        return this.optimize ? dimFilter.optimize(false) : dimFilter;
    }

    private CursorBuildSpec makeCursorBuildSpec(@Nullable Filter filter) {
        return CursorBuildSpec.builder().setFilter(filter).setVirtualColumns(VIRTUAL_COLUMNS).build();
    }

    private CursorBuildSpec makeVectorCursorBuildSpec(@Nullable Filter filter) {
        return CursorBuildSpec.builder().setFilter(filter).setVirtualColumns(this.virtualColumns).setQueryContext(QueryContext.of((Map)ImmutableMap.of((Object)"vectorSize", (Object)3))).build();
    }

    private VectorCursor makeVectorCursor(Filter filter) {
        CursorBuildSpec buildSpec = this.makeVectorCursorBuildSpec(filter);
        return this.cursorFactory.makeCursorHolder(buildSpec).asVectorCursor();
    }

    private List<String> selectColumnValuesMatchingFilter(DimFilter filter, String selectColumn) {
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(this.makeCursorBuildSpec(this.makeFilter(filter)));){
            IndexedInts row;
            Cursor cursor = cursorHolder.asCursor();
            DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
            ArrayList<String> values = new ArrayList<String>();
            while (!cursor.isDone()) {
                row = selector.getRow();
                Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                cursor.advance();
            }
            cursor.reset();
            while (!cursor.isDone()) {
                row = selector.getRow();
                Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                values.add(selector.lookupName(row.get(0)));
                cursor.advance();
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    private long selectCountUsingFilteredAggregator(DimFilter filter) {
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(this.makeCursorBuildSpec(null));){
            Cursor cursor = cursorHolder.asCursor();
            Aggregator agg = new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count"), this.maybeOptimize(filter)).factorize(cursor.getColumnSelectorFactory());
            while (!cursor.isDone()) {
                agg.aggregate();
                cursor.advance();
            }
            long l = agg.getLong();
            return l;
        }
    }

    private long selectCountUsingVectorizedFilteredAggregator(DimFilter dimFilter) {
        Preconditions.checkState((boolean)this.makeFilter(dimFilter).canVectorizeMatcher((ColumnInspector)this.cursorFactory), (String)"Cannot vectorize filter: %s", (Object)dimFilter);
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(this.makeVectorCursorBuildSpec(null));){
            long val2;
            VectorCursor cursor = cursorHolder.asVectorCursor();
            FilteredAggregatorFactory aggregatorFactory = new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count"), this.maybeOptimize(dimFilter));
            VectorAggregator aggregator = aggregatorFactory.factorizeVector(cursor.getColumnSelectorFactory());
            ByteBuffer buf = ByteBuffer.allocate(aggregatorFactory.getMaxIntermediateSizeWithNulls() * 2);
            aggregator.init(buf, 0);
            aggregator.init(buf, aggregatorFactory.getMaxIntermediateSizeWithNulls());
            while (!cursor.isDone()) {
                aggregator.aggregate(buf, 0, 0, cursor.getCurrentVectorSize());
                int[] positions = new int[cursor.getCurrentVectorSize()];
                Arrays.fill(positions, aggregatorFactory.getMaxIntermediateSizeWithNulls());
                int[] allRows = new int[cursor.getCurrentVectorSize()];
                for (int i = 0; i < allRows.length; ++i) {
                    allRows[i] = i;
                }
                aggregator.aggregate(buf, cursor.getCurrentVectorSize(), positions, allRows, 0);
                cursor.advance();
            }
            long val1 = (Long)aggregator.get(buf, 0);
            if (val1 != (val2 = ((Long)aggregator.get(buf, aggregatorFactory.getMaxIntermediateSizeWithNulls())).longValue())) {
                throw new ISE("Oh no, val1[%d] != val2[%d]", new Object[]{val1, val2});
            }
            long l = val1;
            return l;
        }
    }

    private List<String> selectColumnValuesMatchingFilterUsingPostFiltering(DimFilter filter, String selectColumn) {
        final Filter theFilter = this.makeFilter(filter);
        Filter postFilteringFilter = new Filter(){

            public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
                return theFilter.makeMatcher(factory);
            }

            public Set<String> getRequiredColumns() {
                return Collections.emptySet();
            }

            @Nullable
            public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
                return null;
            }
        };
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(this.makeCursorBuildSpec(postFilteringFilter));){
            IndexedInts row;
            Cursor cursor = cursorHolder.asCursor();
            DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
            ArrayList<String> values = new ArrayList<String>();
            while (!cursor.isDone()) {
                row = selector.getRow();
                Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                cursor.advance();
            }
            cursor.reset();
            while (!cursor.isDone()) {
                row = selector.getRow();
                Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                values.add(selector.lookupName(row.get(0)));
                cursor.advance();
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    private List<String> selectColumnValuesMatchingFilterUsingVectorizedPostFiltering(DimFilter filter, String selectColumn) {
        final Filter theFilter = this.makeFilter(filter);
        Filter postFilteringFilter = new Filter(){

            public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
                return theFilter.makeMatcher(factory);
            }

            public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
                return theFilter.makeVectorMatcher(factory);
            }

            public boolean canVectorizeMatcher(ColumnInspector inspector) {
                return theFilter.canVectorizeMatcher(inspector);
            }

            public Set<String> getRequiredColumns() {
                return null;
            }

            @Nullable
            public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
                return null;
            }
        };
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(this.makeVectorCursorBuildSpec(postFilteringFilter));){
            VectorCursor cursor = cursorHolder.asVectorCursor();
            SingleValueDimensionVectorSelector selector = cursor.getColumnSelectorFactory().makeSingleValueDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
            ArrayList<String> values = new ArrayList<String>();
            while (!cursor.isDone()) {
                cursor.advance();
            }
            cursor.reset();
            while (!cursor.isDone()) {
                int[] rowVector = selector.getRowVector();
                for (int i = 0; i < cursor.getCurrentVectorSize(); ++i) {
                    values.add(selector.lookupName(rowVector[i]));
                }
                cursor.advance();
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    private List<String> selectColumnValuesMatchingFilterUsingVectorCursor(DimFilter filter, String selectColumn) {
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(this.makeVectorCursorBuildSpec(this.makeFilter(filter)));){
            VectorCursor cursor = cursorHolder.asVectorCursor();
            SingleValueDimensionVectorSelector selector = cursor.getColumnSelectorFactory().makeSingleValueDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
            ArrayList<String> values = new ArrayList<String>();
            while (!cursor.isDone()) {
                cursor.advance();
            }
            cursor.reset();
            while (!cursor.isDone()) {
                int[] rowVector = selector.getRowVector();
                for (int i = 0; i < cursor.getCurrentVectorSize(); ++i) {
                    values.add(selector.lookupName(rowVector[i]));
                }
                cursor.advance();
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    private List<String> selectColumnValuesMatchingFilterUsingVectorVirtualColumnCursor(DimFilter filter, String virtualColumn, String selectColumn) {
        Expr parsedIdentifier = Parser.parse((String)selectColumn, (ExprMacroTable)TestExprMacroTable.INSTANCE);
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(this.makeVectorCursorBuildSpec(this.makeFilter(filter)));){
            VectorCursor cursor = cursorHolder.asVectorCursor();
            ExpressionType outputType = parsedIdentifier.getOutputType((Expr.InputBindingInspector)cursor.getColumnSelectorFactory());
            ArrayList<String> values = new ArrayList<String>();
            if (outputType.is((TypeDescriptor)ExprType.STRING)) {
                VectorObjectSelector objectSelector = cursor.getColumnSelectorFactory().makeObjectSelector(virtualColumn);
                while (!cursor.isDone()) {
                    Object[] rowVector = objectSelector.getObjectVector();
                    for (int i = 0; i < cursor.getCurrentVectorSize(); ++i) {
                        values.add((String)rowVector[i]);
                    }
                    cursor.advance();
                }
            } else {
                VectorValueSelector valueSelector = cursor.getColumnSelectorFactory().makeValueSelector(virtualColumn);
                while (!cursor.isDone()) {
                    int i;
                    boolean[] nulls = valueSelector.getNullVector();
                    if (outputType.is((TypeDescriptor)ExprType.DOUBLE)) {
                        double[] doubles = valueSelector.getDoubleVector();
                        for (i = 0; i < cursor.getCurrentVectorSize(); ++i) {
                            if (nulls != null && nulls[i]) {
                                values.add(null);
                                continue;
                            }
                            values.add(String.valueOf(doubles[i]));
                        }
                    } else {
                        long[] longs = valueSelector.getLongVector();
                        for (i = 0; i < cursor.getCurrentVectorSize(); ++i) {
                            if (nulls != null && nulls[i]) {
                                values.add(null);
                                continue;
                            }
                            values.add(String.valueOf(longs[i]));
                        }
                    }
                    cursor.advance();
                }
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    private List<String> selectColumnValuesMatchingFilterUsingRowBasedColumnSelectorFactory(DimFilter filter, String selectColumn) {
        SettableSupplier rowSupplier = new SettableSupplier();
        ValueMatcher matcher = this.makeFilter(filter).makeMatcher(VIRTUAL_COLUMNS.wrap((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create((RowAdapter)RowAdapters.standardRow(), () -> ((SettableSupplier)rowSupplier).get(), (ColumnInspector)this.cursorFactory.getRowSignature(), (boolean)false, (boolean)false)));
        ArrayList<String> values = new ArrayList<String>();
        for (InputRow row : this.rows) {
            rowSupplier.set((Object)row);
            if (!matcher.matches(false)) continue;
            values.add((String)row.getRaw(selectColumn));
        }
        return values;
    }

    protected void assertFilterMatches(DimFilter filter, List<String> expectedRows) {
        boolean testVectorized = !(this.cursorFactory instanceof IncrementalIndexCursorFactory) && !(this.cursorFactory instanceof RowBasedCursorFactory) && !(this.cursorFactory instanceof RowFrameCursorFactory) && !(this.cursorFactory instanceof ColumnarFrameCursorFactory);
        this.assertFilterMatches(filter, expectedRows, testVectorized);
        if (!StringUtils.toLowerCase((String)this.testName).contains("concise")) {
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NotDimFilter.of((DimFilter)filter)), expectedRows, testVectorized);
        }
    }

    protected void assertFilterMatchesSkipArrays(DimFilter filter, List<String> expectedRows) {
        boolean testVectorized;
        boolean bl = testVectorized = !(this.cursorFactory instanceof IncrementalIndexCursorFactory) && !(this.cursorFactory instanceof RowBasedCursorFactory) && !(this.cursorFactory instanceof RowFrameCursorFactory) && !(this.cursorFactory instanceof ColumnarFrameCursorFactory);
        if (this.isAutoSchema()) {
            Throwable t = Assert.assertThrows(Throwable.class, () -> this.assertFilterMatches(filter, expectedRows, testVectorized));
            Assert.assertTrue((boolean)t.getMessage().contains("ARRAY"));
        } else {
            this.assertFilterMatches(filter, expectedRows, testVectorized);
            if (!StringUtils.toLowerCase((String)this.testName).contains("concise")) {
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NotDimFilter.of((DimFilter)filter)), expectedRows, testVectorized);
            }
        }
    }

    protected void assertFilterMatchesSkipVectorize(DimFilter filter, List<String> expectedRows) {
        this.assertFilterMatches(filter, expectedRows, false);
        if (!StringUtils.toLowerCase((String)this.testName).contains("concise")) {
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NotDimFilter.of((DimFilter)filter)), expectedRows, false);
        }
    }

    protected void assertFilterMatchesSkipVectorizeUnlessFallback(DimFilter filter, List<String> expectedRows) {
        if (ExpressionProcessing.allowVectorizeFallback()) {
            this.assertFilterMatches(filter, expectedRows);
        } else {
            this.assertFilterMatches(filter, expectedRows, false);
            if (!StringUtils.toLowerCase((String)this.testName).contains("concise")) {
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NotDimFilter.of((DimFilter)filter)), expectedRows, false);
            }
        }
    }

    private void assertFilterMatches(DimFilter filter, List<String> expectedRows, boolean testVectorized) {
        Assert.assertEquals((String)("Cursor: " + filter), expectedRows, this.selectColumnValuesMatchingFilter(filter, "dim0"));
        Assert.assertEquals((String)("Cursor with postFiltering: " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingPostFiltering(filter, "dim0"));
        Assert.assertEquals((String)("Filtered aggregator: " + filter), (long)expectedRows.size(), (long)this.selectCountUsingFilteredAggregator(filter));
        Assert.assertEquals((String)("RowBasedColumnSelectorFactory: " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingRowBasedColumnSelectorFactory(filter, "dim0"));
        if (testVectorized) {
            Assert.assertEquals((String)("Cursor (vectorized): " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingVectorCursor(filter, "dim0"));
            Assert.assertEquals((String)("Cursor Virtual Column (vectorized): " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingVectorVirtualColumnCursor(filter, "vdim0", "dim0"));
            Assert.assertEquals((String)("Cursor with postFiltering (vectorized): " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingVectorizedPostFiltering(filter, "dim0"));
            Assert.assertEquals((String)("Filtered aggregator (vectorized): " + filter), (long)expectedRows.size(), (long)this.selectCountUsingVectorizedFilteredAggregator(filter));
        }
    }

    private static class CursorStuff {
        private final CursorFactory cursorFactory;
        private final VirtualColumns virtualColumns;
        private final Closeable closeable;

        private CursorStuff(CursorFactory cursorFactory, VirtualColumns virtualColumns, Closeable closeable) {
            this.cursorFactory = cursorFactory;
            this.virtualColumns = virtualColumns;
            this.closeable = closeable;
        }
    }
}

