/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import junitparams.converters.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FrontCodedIntArrayIndexedTest {
    private final ByteOrder order;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{ByteOrder.LITTLE_ENDIAN}, (Object)new Object[]{ByteOrder.BIG_ENDIAN});
    }

    public FrontCodedIntArrayIndexedTest(ByteOrder byteOrder) {
        this.order = byteOrder;
    }

    @Test
    public void testFrontCodedIntArrayIndexed() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        TreeSet<int[]> values = new TreeSet<int[]>(FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR);
        values.add(new int[]{1, 2, 3});
        values.add(new int[]{1, 2});
        values.add(new int[]{1, 3});
        values.add(new int[]{1, 2, 4});
        values.add(new int[]{1, 3, 4});
        values.add(new int[]{1, 2, 1});
        values.add(new int[]{2, 1});
        values.add(new int[]{2, 2, 1});
        FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, values, 4);
        buffer.position(0);
        FrontCodedIntArrayIndexed codedIndexed = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Iterator indexedIterator = codedIndexed.iterator();
        Iterator<int[]> expectedIterator = values.iterator();
        int ctr = 0;
        while (expectedIterator.hasNext() && indexedIterator.hasNext()) {
            int[] expectedNext = expectedIterator.next();
            int[] next = (int[])indexedIterator.next();
            FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, next);
            FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, codedIndexed.get(ctr));
            Assert.assertEquals((String)("row " + ctr), (long)ctr, (long)codedIndexed.indexOf(next));
            ++ctr;
        }
        Assert.assertEquals((Object)expectedIterator.hasNext(), (Object)indexedIterator.hasNext());
    }

    @Test
    public void testFrontCodedIntArrayIndexedSingleBucket() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        TreeSet<int[]> values = new TreeSet<int[]>(FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR);
        values.add(new int[]{1, 2, 3});
        values.add(new int[]{1, 2});
        values.add(new int[]{1, 3});
        values.add(new int[]{1, 2, 4});
        values.add(new int[]{1, 3, 4});
        values.add(new int[]{1, 2, 1});
        FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, values, 16);
        FrontCodedIntArrayIndexed codedIndexed = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Iterator<int[]> expectedIterator = values.iterator();
        Iterator indexedIterator = codedIndexed.iterator();
        int ctr = 0;
        while (indexedIterator.hasNext() && expectedIterator.hasNext()) {
            int[] expectedNext = expectedIterator.next();
            int[] next = (int[])indexedIterator.next();
            FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, next);
            FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, codedIndexed.get(ctr));
            Assert.assertEquals((long)ctr, (long)codedIndexed.indexOf(next));
            ++ctr;
        }
        Assert.assertEquals((Object)expectedIterator.hasNext(), (Object)indexedIterator.hasNext());
    }

    @Test
    public void testFrontCodedIntArrayIndexedBigger() throws IOException {
        int sizeBase = 10000;
        int bucketSize = 16;
        ByteBuffer buffer = ByteBuffer.allocate(0x1000000).order(this.order);
        for (int sizeAdjust = 0; sizeAdjust < 16; ++sizeAdjust) {
            TreeSet<int[]> values = new TreeSet<int[]>(FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR);
            while (values.size() < 10000 + sizeAdjust) {
                int length = ThreadLocalRandom.current().nextInt(10);
                int[] val = new int[length];
                for (int j = 0; j < length; ++j) {
                    val[j] = ThreadLocalRandom.current().nextInt(0, 10000);
                }
                values.add(val);
            }
            FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, values, 16);
            FrontCodedIntArrayIndexed codedIndexed = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
            Iterator<int[]> expectedIterator = values.iterator();
            Iterator indexedIterator = codedIndexed.iterator();
            int ctr = 0;
            while (indexedIterator.hasNext() && expectedIterator.hasNext()) {
                int[] expectedNext = expectedIterator.next();
                int[] next = (int[])indexedIterator.next();
                FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, next);
                FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, codedIndexed.get(ctr));
                Assert.assertEquals((long)ctr, (long)codedIndexed.indexOf(next));
                ++ctr;
            }
            Assert.assertEquals((Object)expectedIterator.hasNext(), (Object)indexedIterator.hasNext());
            Assert.assertEquals((long)ctr, (long)(10000 + sizeAdjust));
        }
    }

    @Test
    public void testFrontCodedIntArrayIndexedBiggerWithNulls() throws IOException {
        int sizeBase = 10000;
        int bucketSize = 16;
        ByteBuffer buffer = ByteBuffer.allocate(0x2000000).order(this.order);
        for (int sizeAdjust = 0; sizeAdjust < 16; ++sizeAdjust) {
            TreeSet<int[]> values = new TreeSet<int[]>(FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR);
            values.add(null);
            while (values.size() < 10000 + sizeAdjust + 1) {
                int length = ThreadLocalRandom.current().nextInt(10);
                int[] val = new int[length];
                for (int j = 0; j < length; ++j) {
                    val[j] = ThreadLocalRandom.current().nextInt(0, 10000);
                }
                values.add(val);
            }
            FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, values, 16);
            FrontCodedIntArrayIndexed codedIndexed = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
            Iterator<int[]> expectedIterator = values.iterator();
            Iterator indexedIterator = codedIndexed.iterator();
            int ctr = 0;
            while (indexedIterator.hasNext() && expectedIterator.hasNext()) {
                int[] expectedNext = expectedIterator.next();
                int[] next = (int[])indexedIterator.next();
                FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, next);
                FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, codedIndexed.get(ctr));
                Assert.assertEquals((long)ctr, (long)codedIndexed.indexOf(next));
                ++ctr;
            }
            Assert.assertEquals((Object)expectedIterator.hasNext(), (Object)indexedIterator.hasNext());
            Assert.assertEquals((long)ctr, (long)(10000 + sizeAdjust + 1));
        }
    }

    @Test
    public void testFrontCodedIntArrayIndexedIndexOf() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        TreeSet<int[]> values = new TreeSet<int[]>(FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR);
        values.add(new int[]{1, 2});
        values.add(new int[]{1, 2, 1});
        values.add(new int[]{1, 2, 3});
        values.add(new int[]{1, 2, 4});
        values.add(new int[]{1, 3});
        values.add(new int[]{1, 3, 4});
        FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, values, 4);
        FrontCodedIntArrayIndexed codedIndexed = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertEquals((long)-1L, (long)codedIndexed.indexOf(new int[]{1}));
        Assert.assertEquals((long)0L, (long)codedIndexed.indexOf(new int[]{1, 2}));
        Assert.assertEquals((long)1L, (long)codedIndexed.indexOf(new int[]{1, 2, 1}));
        Assert.assertEquals((long)-3L, (long)codedIndexed.indexOf(new int[]{1, 2, 2}));
        Assert.assertEquals((long)4L, (long)codedIndexed.indexOf(new int[]{1, 3}));
        Assert.assertEquals((long)-7L, (long)codedIndexed.indexOf(new int[]{1, 4, 4}));
        Assert.assertEquals((long)-7L, (long)codedIndexed.indexOf(new int[]{9, 1, 1}));
    }

    @Test
    public void testFrontCodedIntArrayIndexedIndexOfWithNull() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        TreeSet<int[]> values = new TreeSet<int[]>(FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR);
        values.add(null);
        values.add(new int[]{1, 2});
        values.add(new int[]{1, 2, 1});
        values.add(new int[]{1, 2, 3});
        values.add(new int[]{1, 2, 4});
        values.add(new int[]{1, 3});
        values.add(new int[]{1, 3, 4});
        FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, values, 4);
        FrontCodedIntArrayIndexed codedIndexed = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertEquals((long)0L, (long)codedIndexed.indexOf(null));
        Assert.assertEquals((long)-2L, (long)codedIndexed.indexOf(new int[]{1}));
        Assert.assertEquals((long)1L, (long)codedIndexed.indexOf(new int[]{1, 2}));
        Assert.assertEquals((long)2L, (long)codedIndexed.indexOf(new int[]{1, 2, 1}));
        Assert.assertEquals((long)-4L, (long)codedIndexed.indexOf(new int[]{1, 2, 2}));
        Assert.assertEquals((long)5L, (long)codedIndexed.indexOf(new int[]{1, 3}));
        Assert.assertEquals((long)-8L, (long)codedIndexed.indexOf(new int[]{1, 4, 4}));
        Assert.assertEquals((long)-8L, (long)codedIndexed.indexOf(new int[]{9, 1, 1}));
    }

    @Test
    public void testFrontCodedOnlyNull() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        List<Object> theList = Collections.singletonList(null);
        FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, theList, 4);
        buffer.position(0);
        FrontCodedIntArrayIndexed codedIndexed = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertNull((Object)codedIndexed.get(0));
        Assert.assertThrows(IllegalArgumentException.class, () -> codedIndexed.get(-1));
        Assert.assertThrows(IllegalArgumentException.class, () -> codedIndexed.get(theList.size()));
        Assert.assertEquals((long)0L, (long)codedIndexed.indexOf(null));
        Assert.assertEquals((long)-2L, (long)codedIndexed.indexOf(new int[]{1, 2, 3, 4}));
        Iterator iterator = codedIndexed.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNull(iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testFrontCodedEmpty() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(64).order(this.order);
        List<int[]> theList = Collections.emptyList();
        FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, theList, 4);
        buffer.position(0);
        FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertEquals((long)0L, (long)codedUtf8Indexed.size());
        Throwable t = Assert.assertThrows(IAE.class, () -> codedUtf8Indexed.get(0));
        Assert.assertEquals((Object)"Index[0] >= size[0]", (Object)t.getMessage());
        Assert.assertThrows(IllegalArgumentException.class, () -> codedUtf8Indexed.get(-1));
        Assert.assertThrows(IllegalArgumentException.class, () -> codedUtf8Indexed.get(theList.size()));
        Assert.assertEquals((long)-1L, (long)codedUtf8Indexed.indexOf(null));
        Assert.assertEquals((long)-1L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"hello")));
        Iterator utf8Iterator = codedUtf8Indexed.iterator();
        Assert.assertFalse((boolean)utf8Iterator.hasNext());
    }

    @Test
    public void testBucketSizes() throws IOException {
        int numValues = 10000;
        ByteBuffer buffer = ByteBuffer.allocate(0x2000000).order(this.order);
        int[] bucketSizes = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        TreeSet<int[]> values = new TreeSet<int[]>(FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR);
        values.add(null);
        while (values.size() < 10001) {
            int length = ThreadLocalRandom.current().nextInt(10);
            int[] val = new int[length];
            for (int j = 0; j < length; ++j) {
                val[j] = ThreadLocalRandom.current().nextInt(0, 10000);
            }
            values.add(val);
        }
        for (int bucketSize : bucketSizes) {
            FrontCodedIntArrayIndexedTest.persistToBuffer(buffer, values, bucketSize);
            FrontCodedIntArrayIndexed codedIndexed = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
            Iterator<int[]> expectedIterator = values.iterator();
            Iterator iterator = codedIndexed.iterator();
            int ctr = 0;
            while (iterator.hasNext() && expectedIterator.hasNext()) {
                int[] expectedNext = expectedIterator.next();
                int[] next = (int[])iterator.next();
                FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, next);
                FrontCodedIntArrayIndexedTest.assertSame(ctr, expectedNext, codedIndexed.get(ctr));
                Assert.assertEquals((long)ctr, (long)codedIndexed.indexOf(next));
                ++ctr;
            }
            Assert.assertEquals((Object)expectedIterator.hasNext(), (Object)iterator.hasNext());
            Assert.assertEquals((long)ctr, (long)10001L);
        }
    }

    @Test
    public void testBadBucketSize() {
        OnHeapMemorySegmentWriteOutMedium medium = new OnHeapMemorySegmentWriteOutMedium();
        Assert.assertThrows(IAE.class, () -> new FrontCodedIntArrayIndexedWriter((SegmentWriteOutMedium)medium, ByteOrder.nativeOrder(), 0));
        Assert.assertThrows(IAE.class, () -> new FrontCodedIntArrayIndexedWriter((SegmentWriteOutMedium)medium, ByteOrder.nativeOrder(), 15));
        Assert.assertThrows(IAE.class, () -> new FrontCodedIntArrayIndexedWriter((SegmentWriteOutMedium)medium, ByteOrder.nativeOrder(), 256));
    }

    private static long persistToBuffer(final ByteBuffer buffer, Iterable<int[]> sortedIterable, int bucketSize) throws IOException {
        Iterator<int[]> sortedInts = sortedIterable.iterator();
        buffer.position(0);
        OnHeapMemorySegmentWriteOutMedium medium = new OnHeapMemorySegmentWriteOutMedium();
        FrontCodedIntArrayIndexedWriter writer = new FrontCodedIntArrayIndexedWriter((SegmentWriteOutMedium)medium, buffer.order(), bucketSize);
        writer.open();
        int index = 0;
        while (sortedInts.hasNext()) {
            int[] next = sortedInts.next();
            writer.write(next);
            FrontCodedIntArrayIndexedTest.assertSame(index, next, writer.get(index));
            ++index;
        }
        Assert.assertEquals((long)index, (long)writer.getCardinality());
        index = 0;
        sortedInts = sortedIterable.iterator();
        while (sortedInts.hasNext()) {
            FrontCodedIntArrayIndexedTest.assertSame(index, sortedInts.next(), writer.get(index));
            ++index;
        }
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int size = src.remaining();
                buffer.put(src);
                return size;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        long size = writer.getSerializedSize();
        buffer.position(0);
        writer.writeTo(channel, null);
        Assert.assertEquals((long)size, (long)buffer.position());
        buffer.position(0);
        return size;
    }

    private static void assertSame(int index, @Nullable int[] expected, @Nullable int[] actual) {
        if (expected == null) {
            Assert.assertNull((String)("row " + index), (Object)actual);
        } else {
            Assert.assertArrayEquals((String)("row " + index + " expected: " + Arrays.toString(expected) + " actual: " + Arrays.toString(actual)), (int[])expected, (int[])actual);
        }
    }
}

