/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.OrderBy;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.NoopQueryableIndex;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;

public class TestSegmentUtils {
    private static final QueryableIndex INDEX = new NoopQueryableIndex(){

        public List<OrderBy> getOrdering() {
            return Cursors.ascendingTimeOrder();
        }
    };

    public static DataSegment makeTombstoneSegment(String dataSource, String version, Interval interval) {
        return new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"interval", (Object)interval, (Object)"type", (Object)"tombstone"), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)TombstoneShardSpec.INSTANCE, Integer.valueOf(9), 1L);
    }

    public static DataSegment makeSegment(String dataSource, String version, Interval interval) {
        return new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"type", (Object)"test", (Object)"version", (Object)version, (Object)"interval", (Object)interval), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
    }

    public static DataSegment makeSegment(String dataSource, String version, long size) {
        return new DataSegment(dataSource, Intervals.ETERNITY, version, (Map)ImmutableMap.of((Object)"type", (Object)"test", (Object)"version", (Object)version, (Object)"interval", (Object)Intervals.ETERNITY), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), size);
    }

    public static class InMemoryTestSegment<RowType>
    extends QueryableIndexSegment {
        private final RowBasedSegment<RowType> segment;

        public InMemoryTestSegment(SegmentId segmentId, Sequence<RowType> rowSequence, RowAdapter<RowType> rowAdapter, RowSignature rowSignature) {
            super(INDEX, segmentId);
            this.segment = new RowBasedSegment(rowSequence, rowAdapter, rowSignature);
        }

        @Nullable
        public <T> T as(@Nonnull Class<T> clazz) {
            if (CursorFactory.class.isAssignableFrom(clazz)) {
                return (T)this.segment.as(CursorFactory.class);
            }
            return null;
        }
    }

    public static class SegmentForTesting
    extends QueryableIndexSegment {
        private final String datasource;
        private final String version;
        private final Interval interval;
        private final Object lock = new Object();
        private volatile boolean closed = false;

        public SegmentForTesting(String datasource, Interval interval, String version) {
            super(INDEX, SegmentId.of((String)datasource, (Interval)interval, (String)version, (int)0));
            this.datasource = datasource;
            this.interval = interval;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public SegmentId getId() {
            return SegmentId.of((String)this.datasource, (Interval)this.interval, (String)this.version, (int)0);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public Interval getDataInterval() {
            return this.interval;
        }

        public <T> T as(@Nonnull Class<T> clazz) {
            if (clazz.equals(QueryableIndex.class)) {
                return (T)INDEX;
            }
            if (clazz.equals(CursorFactory.class)) {
                return (T)new QueryableIndexCursorFactory(INDEX);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.closed = true;
            }
        }
    }

    @JsonTypeName(value="testSegmentFactory")
    public static class TestSegmentizerFactory
    implements SegmentizerFactory {
        public Segment factorize(DataSegment segment, File parentDir, boolean lazy, SegmentLazyLoadFailCallback loadFailed) {
            return new SegmentForTesting(segment.getDataSource(), segment.getInterval(), segment.getVersion());
        }
    }

    @JsonTypeName(value="test")
    public static class TestLoadSpec
    implements LoadSpec {
        private final int size;
        private final String name;

        @JsonCreator
        public TestLoadSpec(@JsonProperty(value="size") int size, @JsonProperty(value="name") String name) {
            this.size = size;
            this.name = name;
        }

        public LoadSpec.LoadSpecResult loadSegment(File destDir) throws SegmentLoadingException {
            File segmentFile = new File(destDir, "segment");
            File factoryJson = new File(destDir, "factory.json");
            try {
                FileUtils.mkdirp((File)destDir);
                Assert.assertTrue((boolean)segmentFile.createNewFile());
                Assert.assertTrue((boolean)factoryJson.createNewFile());
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Failed to create files in directory[%s]", new Object[]{destDir.getAbsolutePath()});
            }
            try {
                byte[] bytes = new byte[this.size];
                ThreadLocalRandom.current().nextBytes(bytes);
                Files.write((byte[])bytes, (File)segmentFile);
                Files.write((byte[])"{\"type\":\"testSegmentFactory\"}".getBytes(StandardCharsets.UTF_8), (File)factoryJson);
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Failed to write data in directory[%s]", new Object[]{destDir.getAbsolutePath()});
            }
            return new LoadSpec.LoadSpecResult((long)this.size);
        }
    }
}

