/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedDataColumnSchema;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.junit.Assert;
import org.junit.Test;

public class NestedDataColumnSchemaTest {
    private static final DefaultColumnFormatConfig DEFAULT_CONFIG = new DefaultColumnFormatConfig(null, null, null);
    private static final NestedCommonFormatColumnFormatSpec DEFAULT_NESTED_SPEC = NestedCommonFormatColumnFormatSpec.builder().setObjectFieldsDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(8), Byte.valueOf((byte)1))).setObjectStorageCompression(CompressionStrategy.ZSTD).build();
    private static final DefaultColumnFormatConfig DEFAULT_NESTED_SPEC_CONFIG = new DefaultColumnFormatConfig(null, null, IndexSpec.builder().withAutoColumnFormatSpec(DEFAULT_NESTED_SPEC).build());
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final ObjectMapper DEFAULT_NESTED_SPEC_MAPPER;

    @Test
    public void testSerdeRoundTrip() throws JsonProcessingException {
        NestedDataColumnSchema v5 = new NestedDataColumnSchema("test", Integer.valueOf(5), DEFAULT_NESTED_SPEC, DEFAULT_CONFIG);
        Assert.assertEquals((Object)v5, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)v5), NestedDataColumnSchema.class));
    }

    @Test
    public void testSerdeDefault() throws JsonProcessingException {
        String there = "{\"type\":\"json\", \"name\":\"test\"}";
        NestedDataColumnSchema andBack = (NestedDataColumnSchema)MAPPER.readValue("{\"type\":\"json\", \"name\":\"test\"}", NestedDataColumnSchema.class);
        Assert.assertEquals((Object)new NestedDataColumnSchema("test", 5), (Object)andBack);
    }

    @Test
    public void testSerdeDefaultNestedSpec() throws JsonProcessingException {
        String there = "{\"type\":\"json\", \"name\":\"test\"}";
        NestedDataColumnSchema andBack = (NestedDataColumnSchema)DEFAULT_NESTED_SPEC_MAPPER.readValue("{\"type\":\"json\", \"name\":\"test\"}", NestedDataColumnSchema.class);
        Assert.assertEquals((Object)new NestedDataColumnSchema("test", Integer.valueOf(5), DEFAULT_NESTED_SPEC, DEFAULT_NESTED_SPEC_CONFIG), (Object)andBack);
    }

    static {
        MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DefaultColumnFormatConfig.class, (Object)DEFAULT_CONFIG));
        DEFAULT_NESTED_SPEC_MAPPER = new DefaultObjectMapper();
        DEFAULT_NESTED_SPEC_MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DefaultColumnFormatConfig.class, (Object)DEFAULT_NESTED_SPEC_CONFIG));
    }
}

