/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest
extends InitializedNullHandlingTest {
    @Test
    public void testSerde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        AggregatorFactory[] aggregators = new AggregatorFactory[]{new LongSumAggregatorFactory("out", "in")};
        Metadata metadata = new Metadata(Collections.singletonMap("k", "v"), aggregators, null, Granularities.ALL, Boolean.FALSE, null, null);
        Metadata metadataWithEmptyProjection = new Metadata(Collections.singletonMap("k", "v"), aggregators, null, Granularities.ALL, Boolean.FALSE, null, (List)ImmutableList.of());
        Metadata other = (Metadata)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)metadataWithEmptyProjection), Metadata.class);
        Assert.assertEquals((Object)metadata, (Object)other);
    }

    @Test
    public void testMerge() {
        Assert.assertNull((Object)Metadata.merge(null, null));
        Assert.assertNull((Object)Metadata.merge((List)ImmutableList.of(), null));
        ArrayList<Metadata> metadataToBeMerged = new ArrayList<Metadata>();
        metadataToBeMerged.add(null);
        Assert.assertNull((Object)Metadata.merge(metadataToBeMerged, null));
        AggregatorFactory[] aggs = new AggregatorFactory[]{new LongMaxAggregatorFactory("n", "f")};
        List<AggregateProjectionMetadata> projectionSpecs = List.of(new AggregateProjectionMetadata(AggregateProjectionMetadata.schemaBuilder((String)"some_projection").timeColumnName("__gran").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupAndOrder(new String[]{"a", "b", "__gran"}).aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("atLongLast", "d", null)}).ordering(new String[]{"a", "b", "__gran"}).build(), 1234));
        Metadata m1 = new Metadata(Collections.singletonMap("k", "v"), aggs, new TimestampSpec("ds", "auto", null), Granularities.ALL, Boolean.FALSE, null, projectionSpecs);
        Metadata m2 = new Metadata(Collections.singletonMap("k", "v"), aggs, new TimestampSpec("ds", "auto", null), Granularities.ALL, Boolean.FALSE, null, projectionSpecs);
        Metadata m3 = new Metadata(Collections.singletonMap("k", "v"), aggs, new TimestampSpec("ds", "auto", null), Granularities.ALL, Boolean.TRUE, null, projectionSpecs);
        Metadata merged = new Metadata(Collections.singletonMap("k", "v"), new AggregatorFactory[]{new LongMaxAggregatorFactory("n", "n")}, new TimestampSpec("ds", "auto", null), Granularities.ALL, Boolean.FALSE, Cursors.ascendingTimeOrder(), projectionSpecs);
        Assert.assertEquals((Object)merged, (Object)Metadata.merge((List)ImmutableList.of((Object)m1, (Object)m2), null));
        metadataToBeMerged.clear();
        metadataToBeMerged.add(m1);
        metadataToBeMerged.add(m2);
        metadataToBeMerged.add(null);
        Metadata merged2 = new Metadata(Collections.singletonMap("k", "v"), null, null, null, null, Cursors.ascendingTimeOrder(), projectionSpecs);
        Assert.assertEquals((Object)merged2, (Object)Metadata.merge(metadataToBeMerged, null));
        AggregatorFactory[] explicitAggs = new AggregatorFactory[]{new DoubleMaxAggregatorFactory("x", "y")};
        Metadata merged3 = new Metadata(Collections.singletonMap("k", "v"), explicitAggs, null, null, null, Cursors.ascendingTimeOrder(), projectionSpecs);
        Assert.assertEquals((Object)merged3, (Object)Metadata.merge(metadataToBeMerged, (AggregatorFactory[])explicitAggs));
        Metadata merged4 = new Metadata(Collections.singletonMap("k", "v"), explicitAggs, new TimestampSpec("ds", "auto", null), Granularities.ALL, null, Cursors.ascendingTimeOrder(), projectionSpecs);
        Assert.assertEquals((Object)merged4, (Object)Metadata.merge((List)ImmutableList.of((Object)m3, (Object)m2), (AggregatorFactory[])explicitAggs));
    }

    @Test
    public void testMergeOrderings() {
        Assert.assertThrows(IllegalArgumentException.class, () -> Metadata.mergeOrderings(Collections.emptyList()));
        Assert.assertEquals((Object)Cursors.ascendingTimeOrder(), (Object)Metadata.mergeOrderings(Collections.singletonList(null)));
        Assert.assertEquals(Collections.emptyList(), (Object)Metadata.mergeOrderings(Arrays.asList(null, MetadataTest.makeOrderBy("foo", "bar"))));
        Assert.assertEquals(Collections.emptyList(), (Object)Metadata.mergeOrderings(Arrays.asList(MetadataTest.makeOrderBy("foo", "bar"), null)));
        Assert.assertEquals((Object)Cursors.ascendingTimeOrder(), (Object)Metadata.mergeOrderings(Arrays.asList(MetadataTest.makeOrderBy("__time", "foo", "bar"), null)));
        Assert.assertEquals(Collections.emptyList(), (Object)Metadata.mergeOrderings(Arrays.asList(MetadataTest.makeOrderBy("foo", "bar"), MetadataTest.makeOrderBy("bar", "foo"))));
        Assert.assertEquals(Collections.singletonList(OrderBy.ascending((String)"bar")), (Object)Metadata.mergeOrderings(Arrays.asList(MetadataTest.makeOrderBy("bar", "baz"), MetadataTest.makeOrderBy("bar", "foo"))));
        Assert.assertEquals((Object)ImmutableList.of((Object)OrderBy.ascending((String)"bar"), (Object)OrderBy.ascending((String)"foo")), (Object)Metadata.mergeOrderings(Arrays.asList(MetadataTest.makeOrderBy("bar", "foo"), MetadataTest.makeOrderBy("bar", "foo"))));
    }

    @Test
    public void testMergeProjectionsUnexpectedMismatch() {
        ImmutableList p1 = ImmutableList.of((Object)new AggregateProjectionMetadata(AggregateProjectionMetadata.schemaBuilder((String)"some_projection").timeColumnName("__gran").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupAndOrder(new String[]{"a", "b", "__gran"}).aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("atLongLast", "d", null)}).ordering(new String[]{"a", "b", "__gran"}).build(), 654321));
        ImmutableList p2 = ImmutableList.of((Object)new AggregateProjectionMetadata(AggregateProjectionMetadata.schemaBuilder((String)"some_projection").timeColumnName("__gran").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupAndOrder(new String[]{"a", "b", "_gran"}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("longSum", "d")}).ordering(new String[]{"a", "b", "_gran"}).build(), 1234));
        ImmutableList p3 = ImmutableList.of((Object)new AggregateProjectionMetadata(AggregateProjectionMetadata.schemaBuilder((String)"some_projection").timeColumnName("__gran").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupAndOrder(new String[]{"a", "b", "__gran"}).aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("atLongLast", "d", null)}).ordering(new String[]{"a", "b", "__gran"}).build(), 12121), (Object)new AggregateProjectionMetadata(AggregateProjectionMetadata.schemaBuilder((String)"some_projection2").timeColumnName("__gran").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"__gran")}).groupAndOrder(new String[]{"__gran", "a"}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("longSum", "d")}).ordering(new String[]{"__gran", "a"}).build(), 555));
        Throwable t = Assert.assertThrows(DruidException.class, () -> MetadataTest.lambda$testMergeProjectionsUnexpectedMismatch$1((List)p1, (List)p2));
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unable to merge projections: mismatched projections"));
        t = Assert.assertThrows(DruidException.class, () -> MetadataTest.lambda$testMergeProjectionsUnexpectedMismatch$2((List)p1, (List)p3));
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unable to merge projections: mismatched projections count"));
        t = Assert.assertThrows(DruidException.class, () -> MetadataTest.lambda$testMergeProjectionsUnexpectedMismatch$3((List)p1));
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unable to merge projections: some projections were null"));
    }

    private static List<OrderBy> makeOrderBy(String ... columnNames) {
        return Arrays.stream(columnNames).map(OrderBy::ascending).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$testMergeProjectionsUnexpectedMismatch$3(List p1) throws Throwable {
        Metadata.validateProjections(Arrays.asList(p1, null));
    }

    private static /* synthetic */ void lambda$testMergeProjectionsUnexpectedMismatch$2(List p1, List p3) throws Throwable {
        Metadata.validateProjections(Arrays.asList(p1, p3));
    }

    private static /* synthetic */ void lambda$testMergeProjectionsUnexpectedMismatch$1(List p1, List p2) throws Throwable {
        Metadata.validateProjections(Arrays.asList(p1, p2));
    }
}

