/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.CloseableDefaultBlockingPool;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DefaultQueryMetrics;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryResourceId;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.TypedInFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryMetrics;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.IncrementalIndexTimeBoundaryInspector;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexTimeBoundaryInspector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CursorFactoryProjectionTest
extends InitializedNullHandlingTest {
    private static final Closer CLOSER = Closer.create();
    static final DateTime UTC_MIDNIGHT = Granularities.DAY.bucket(DateTimes.of((String)"2025-08-13")).getStart();
    static final DateTime UTC_01H = UTC_MIDNIGHT.plusHours(1);
    static final DateTime UTC_01H31M = UTC_MIDNIGHT.plusHours(1).plusMinutes(31);
    static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.DOUBLE).add("e", ColumnType.FLOAT).add("f", ColumnType.NESTED_DATA).build();
    private static final Set<String> PROJECTION_TIME_COLUMNS = Set.of("__time", "__virtualGranularity", "__gran");
    static final List<InputRow> ROWS = CursorFactoryProjectionTest.makeRows(ROW_SIGNATURE.getColumnNames());
    static final List<InputRow> ROLLUP_ROWS = CursorFactoryProjectionTest.makeRows((List<String>)ImmutableList.of((Object)"a", (Object)"b"));
    private static final List<AggregateProjectionSpec> PROJECTIONS = Arrays.asList(AggregateProjectionSpec.builder((String)"ab_hourly_cd_sum").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("a"), new StringDimensionSchema("b"), new LongDimensionSchema("__gran")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c"), new DoubleSumAggregatorFactory("d", "d")}).build(), AggregateProjectionSpec.builder((String)"a_hourly_c_sum_with_count_latest").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__gran"), new StringDimensionSchema("a")}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula"), new LongSumAggregatorFactory("_c_sum", "c"), new LongLastAggregatorFactory("_c_last", "c", null)}).build(), AggregateProjectionSpec.builder((String)"b_hourly_c_sum_non_time_ordered").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("b"), new LongDimensionSchema("__gran")}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula"), new LongSumAggregatorFactory("_c_sum", "c"), new LongLastAggregatorFactory("_c_last", "c", null)}).build(), AggregateProjectionSpec.builder((String)"bf_daily_c_sum").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"__gran")}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__gran"), new StringDimensionSchema("b"), new FloatDimensionSchema("e")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}).build(), AggregateProjectionSpec.builder((String)"b_c_sum").groupingColumns(new DimensionSchema[]{new StringDimensionSchema("b")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}).build(), AggregateProjectionSpec.builder((String)"ab").groupingColumns(new DimensionSchema[]{new StringDimensionSchema("a"), new StringDimensionSchema("b")}).build(), AggregateProjectionSpec.builder((String)"abfoo").virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("bfoo", "concat(b, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("a"), new StringDimensionSchema("bfoo")}).build(), AggregateProjectionSpec.builder((String)"c_sum_daily").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"__gran")}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__gran")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}).build(), AggregateProjectionSpec.builder((String)"c_sum").aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}).build(), AggregateProjectionSpec.builder((String)"missing_column").groupingColumns(new DimensionSchema[]{new StringDimensionSchema("missing")}).aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("dsum", "d")}).build(), AggregateProjectionSpec.builder((String)"json").groupingColumns(new DimensionSchema[]{AutoTypeColumnSchema.of((String)"f")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}).build(), AggregateProjectionSpec.builder((String)"a_filter_b_aaonly_hourly_cd_sum").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).filter((DimFilter)new EqualityFilter("b", ColumnType.STRING, (Object)"aa", null)).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("a"), new LongDimensionSchema("__gran")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c"), new DoubleSumAggregatorFactory("d", "d")}).build(), AggregateProjectionSpec.builder((String)"a_concat_b_d_plus_f_sum_c").virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("__vc2", "d + e", ColumnType.LONG, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("__vc3", "concat(a, b)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__vc2"), new StringDimensionSchema("__vc3")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_c", "c")}).build(), AggregateProjectionSpec.builder((String)"a_hourly_c_sum_filter_a_to_a").filter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"a", null)).virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("a"), new LongDimensionSchema("__gran")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}).build(), AggregateProjectionSpec.builder((String)"a_hourly_c_sum_filter_a_to_empty").filter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"nomatch", null)).virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("a"), new LongDimensionSchema("__gran")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c")}).build(), AggregateProjectionSpec.builder((String)"time_and_a").groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__time"), new StringDimensionSchema("a")}).build(), AggregateProjectionSpec.builder((String)"filtered_c_plus_d").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran"), new ExpressionVirtualColumn("__c_plus_d", "c + d", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE)}).filter((DimFilter)new TypedInFilter("__c_plus_d", ColumnType.DOUBLE, List.of(Double.valueOf(2.1), Double.valueOf(4.2)), null, null)).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__gran")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_c", "c")}).build());
    private static final List<AggregateProjectionSpec> ROLLUP_PROJECTIONS = Arrays.asList(AggregateProjectionSpec.builder((String)"a_hourly_c_sum_with_count").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__gran"), new StringDimensionSchema("a")}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula"), new LongSumAggregatorFactory("sum_c", "sum_c")}).build(), AggregateProjectionSpec.builder((String)"afoo").virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("afoo", "concat(a, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("afoo")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_c", "sum_c"), new LongMaxAggregatorFactory("max_c", "max_c")}).build());
    private static final List<AggregateProjectionSpec> AUTO_PROJECTIONS = PROJECTIONS.stream().map(projection -> AggregateProjectionSpec.builder((AggregateProjectionSpec)projection).groupingColumns(projection.getGroupingColumns().stream().map(CursorFactoryProjectionTest::toAutoColumn).collect(Collectors.toList())).build()).collect(Collectors.toList());
    private static final List<AggregateProjectionSpec> AUTO_ROLLUP_PROJECTIONS = ROLLUP_PROJECTIONS.stream().map(projection -> AggregateProjectionSpec.builder((AggregateProjectionSpec)projection).groupingColumns(projection.getGroupingColumns().stream().map(CursorFactoryProjectionTest::toAutoColumn).collect(Collectors.toList())).build()).collect(Collectors.toList());
    public final CursorFactory projectionsCursorFactory;
    public final TimeBoundaryInspector projectionsTimeBoundaryInspector;
    public final CursorFactory rollupProjectionsCursorFactory;
    public final TimeBoundaryInspector rollupProjectionsTimeBoundaryInspector;
    private final GroupingEngine groupingEngine;
    private final GroupByResourcesReservationPool resourcesReservationPool;
    private final TimeseriesQueryEngine timeseriesEngine;
    private final NonBlockingPool<ByteBuffer> nonBlockingPool;
    public final boolean segmentSortedByTime;
    public final boolean autoSchema;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public static List<InputRow> makeRows(List<String> dimensions) {
        return Arrays.asList(new ListBasedInputRow(ROW_SIGNATURE, UTC_MIDNIGHT, dimensions, Arrays.asList("a", "aa", 1L, 1.0, null, Map.of("x", "a", "y", 1L, "z", 1.0))), new ListBasedInputRow(ROW_SIGNATURE, UTC_MIDNIGHT.plusMinutes(2), dimensions, Arrays.asList("a", "bb", 1L, 1.1, Float.valueOf(1.1f), Map.of("x", "a", "y", 1L, "z", 1.1))), new ListBasedInputRow(ROW_SIGNATURE, UTC_MIDNIGHT.plusMinutes(4), dimensions, Arrays.asList("a", "cc", 2L, 2.2, Float.valueOf(2.2f), Map.of("x", "a", "y", 2L, "z", 2.2))), new ListBasedInputRow(ROW_SIGNATURE, UTC_MIDNIGHT.plusMinutes(6), dimensions, Arrays.asList("b", "aa", 3L, 3.3, Float.valueOf(3.3f), Map.of("x", "b", "y", 3L, "z", 3.3))), new ListBasedInputRow(ROW_SIGNATURE, UTC_MIDNIGHT.plusMinutes(8), dimensions, Arrays.asList("b", "aa", 4L, 4.4, Float.valueOf(4.4f), Map.of("x", "b", "y", 4L, "z", 4.4))), new ListBasedInputRow(ROW_SIGNATURE, UTC_MIDNIGHT.plusMinutes(10), dimensions, Arrays.asList("b", "bb", 5L, 5.5, Float.valueOf(5.5f), Map.of("x", "b", "y", 5L, "z", 5.5))), new ListBasedInputRow(ROW_SIGNATURE, UTC_01H, dimensions, Arrays.asList("a", "aa", 1L, 1.1, Float.valueOf(1.1f), Map.of("x", "a", "y", 1L, "z", 1.1))), new ListBasedInputRow(ROW_SIGNATURE, UTC_01H31M, dimensions, Arrays.asList("a", "dd", 2L, 2.2, Float.valueOf(2.2f), Map.of("x", "a", "y", 2L, "z", 2.2))));
    }

    @Parameterized.Parameters(name="name: {0}, segmentTimeOrdered: {5}, autoSchema: {6}, writeNullColumns: {7}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        DimensionsSpec.Builder dimensionsBuilder = DimensionsSpec.builder().setDimensions(Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("b"), new LongDimensionSchema("c"), new DoubleDimensionSchema("d"), new FloatDimensionSchema("e"), AutoTypeColumnSchema.of((String)"f"), new StringDimensionSchema("missing")));
        DimensionsSpec.Builder rollupDimensionsBuilder = DimensionsSpec.builder().setDimensions(Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("b")));
        AggregatorFactory[] rollupAggs = new AggregatorFactory[]{new LongMaxAggregatorFactory("max_c", "c"), new LongSumAggregatorFactory("sum_c", "c"), new DoubleSumAggregatorFactory("sum_d", "d"), new FloatSumAggregatorFactory("sum_e", "e")};
        DimensionsSpec dimsTimeOrdered = dimensionsBuilder.build();
        DimensionsSpec dimsOrdered = dimensionsBuilder.setForceSegmentSortByTime(Boolean.valueOf(false)).build();
        DimensionsSpec rollupDimsTimeOrdered = rollupDimensionsBuilder.build();
        DimensionsSpec rollupDimsOrdered = rollupDimensionsBuilder.setForceSegmentSortByTime(Boolean.valueOf(false)).build();
        List autoDims = dimsOrdered.getDimensions().stream().map(CursorFactoryProjectionTest::toAutoColumn).collect(Collectors.toList());
        List rollupAutoDims = rollupDimsOrdered.getDimensions().stream().map(CursorFactoryProjectionTest::toAutoColumn).collect(Collectors.toList());
        for (boolean incremental : new boolean[]{true, false}) {
            for (boolean sortByDim : new boolean[]{true, false}) {
                for (boolean autoSchema : new boolean[]{false, true}) {
                    for (boolean writeNullColumns : new boolean[]{true, false}) {
                        IncrementalIndex rollupIndex;
                        IncrementalIndex index;
                        DimensionsSpec rollupDims;
                        DimensionsSpec dims;
                        if (sortByDim) {
                            if (autoSchema) {
                                dims = dimsOrdered.withDimensions(autoDims);
                                rollupDims = rollupDimsOrdered.withDimensions(rollupAutoDims);
                            } else {
                                dims = dimsOrdered;
                                rollupDims = rollupDimsOrdered;
                            }
                        } else if (autoSchema) {
                            dims = dimsTimeOrdered.withDimensions(autoDims);
                            rollupDims = rollupDimsTimeOrdered.withDimensions(autoDims);
                        } else {
                            dims = dimsTimeOrdered;
                            rollupDims = rollupDimsTimeOrdered;
                        }
                        if (incremental) {
                            index = (IncrementalIndex)CLOSER.register((Closeable)CursorFactoryProjectionTest.makeBuilder(dims, autoSchema, writeNullColumns).buildIncrementalIndex());
                            rollupIndex = (IncrementalIndex)CLOSER.register((Closeable)CursorFactoryProjectionTest.makeRollupBuilder(rollupDims, rollupAggs, autoSchema).buildIncrementalIndex());
                            constructors.add(new Object[]{"incrementalIndex", new IncrementalIndexCursorFactory(index), new IncrementalIndexTimeBoundaryInspector(index), new IncrementalIndexCursorFactory(rollupIndex), new IncrementalIndexTimeBoundaryInspector(rollupIndex), !sortByDim, autoSchema, writeNullColumns});
                            continue;
                        }
                        index = (QueryableIndex)CLOSER.register((Closeable)CursorFactoryProjectionTest.makeBuilder(dims, autoSchema, writeNullColumns).buildMMappedIndex());
                        rollupIndex = (QueryableIndex)CLOSER.register((Closeable)CursorFactoryProjectionTest.makeRollupBuilder(rollupDims, rollupAggs, autoSchema).buildMMappedIndex());
                        constructors.add(new Object[]{"queryableIndex", new QueryableIndexCursorFactory((QueryableIndex)index), QueryableIndexTimeBoundaryInspector.create((QueryableIndex)index), new QueryableIndexCursorFactory((QueryableIndex)rollupIndex), QueryableIndexTimeBoundaryInspector.create((QueryableIndex)rollupIndex), !sortByDim, autoSchema, writeNullColumns});
                    }
                }
            }
        }
        return constructors;
    }

    @AfterClass
    public static void cleanup() throws IOException {
        CLOSER.close();
    }

    public CursorFactoryProjectionTest(String name, CursorFactory projectionsCursorFactory, TimeBoundaryInspector projectionsTimeBoundaryInspector, CursorFactory rollupProjectionsCursorFactory, TimeBoundaryInspector rollupProjectionsTimeBoundaryInspector, boolean segmentSortedByTime, boolean autoSchema, boolean writeNullColumns) {
        this.projectionsCursorFactory = projectionsCursorFactory;
        this.projectionsTimeBoundaryInspector = projectionsTimeBoundaryInspector;
        this.rollupProjectionsCursorFactory = rollupProjectionsCursorFactory;
        this.rollupProjectionsTimeBoundaryInspector = rollupProjectionsTimeBoundaryInspector;
        this.segmentSortedByTime = segmentSortedByTime;
        this.autoSchema = autoSchema;
        this.nonBlockingPool = (NonBlockingPool)this.closer.closeLater(new CloseableStupidPool("GroupByQueryEngine-bufferPool", () -> ByteBuffer.allocate(50000)));
        this.resourcesReservationPool = new GroupByResourcesReservationPool((BlockingPool)this.closer.closeLater(new CloseableDefaultBlockingPool(() -> ByteBuffer.allocate(50000), 5)), new GroupByQueryConfig());
        this.groupingEngine = new GroupingEngine(new DruidProcessingConfig(), GroupByQueryConfig::new, this.resourcesReservationPool, TestHelper.makeJsonMapper(), TestHelper.makeSmileMapper(), (query, future) -> {}, new GroupByStatsProvider());
        this.timeseriesEngine = new TimeseriesQueryEngine(this.nonBlockingPool);
    }

    @Test
    public void testProjectionSelectionTwoDims() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("b").addOrderByColumn("a", OrderByColumnSpec.Direction.DESCENDING).addOrderByColumn("b", OrderByColumnSpec.Direction.DESCENDING).setLimit(10).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("ab");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 6);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{"b", "bb"}, new Object[]{"b", "aa"}, new Object[]{"a", "dd"}, new Object[]{"a", "cc"}, new Object[]{"a", "bb"}, new Object[]{"a", "aa"}));
    }

    @Test
    public void testProjectionSelectionTwoDimsVirtual() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("v0").setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(\"b\", 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("a", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC), new OrderByColumnSpec("v0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(10))).setContext(Map.of("useProjection", "abfoo")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("abfoo");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 6);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{"a", "ddfoo"}, new Object[]{"a", "ccfoo"}, new Object[]{"a", "bbfoo"}, new Object[]{"a", "aafoo"}, new Object[]{"b", "bbfoo"}, new Object[]{"b", "aafoo"}));
    }

    @Test
    public void testProjectionSelectionTwoDimsCount() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("b").addOrderByColumn("a", OrderByColumnSpec.Direction.DESCENDING).addOrderByColumn("b", OrderByColumnSpec.Direction.DESCENDING).setLimit(10).addAggregator((AggregatorFactory)new CountAggregatorFactory("count")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(null);
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorNoProjection(buildSpec, queryMetrics);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{"b", "bb", 1L}, new Object[]{"b", "aa", 2L}, new Object[]{"a", "dd", 1L}, new Object[]{"a", "cc", 1L}, new Object[]{"a", "bb", 1L}, new Object[]{"a", "aa", 2L}));
    }

    @Test
    public void testProjectionSelectionTwoDimsCountForce() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("b").addAggregator((AggregatorFactory)new CountAggregatorFactory("count")).setContext(Map.of("forceProjections", true)).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        Throwable t = Assert.assertThrows(DruidException.class, () -> this.projectionsCursorFactory.makeCursorHolder(buildSpec));
        Assert.assertEquals((Object)"Force projections specified, but none satisfy query", (Object)t.getMessage());
    }

    @Test
    public void testProjectionSkipContext() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongLastAggregatorFactory("c_last", "c", null)).setContext(Map.of("noProjections", true)).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(null);
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorNoProjection(buildSpec, queryMetrics);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 7L, Pair.of((Object)UTC_01H31M.getMillis(), (Object)2L)}, new Object[]{"b", 12L, Pair.of((Object)UTC_MIDNIGHT.plusMinutes(10).getMillis(), (Object)5L)}));
    }

    @Test
    public void testProjectionSingleDim() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongLastAggregatorFactory("c_last", "c", null)).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 7L, Pair.of((Object)UTC_01H31M.getMillis(), (Object)2L)}, new Object[]{"b", 12L, Pair.of((Object)UTC_MIDNIGHT.plusMinutes(10).getMillis(), (Object)5L)}));
    }

    @Test
    public void testProjectionSingleDimMissing() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("missing").addAggregator((AggregatorFactory)new DoubleSumAggregatorFactory("d_sum", "d")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("missing_column");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 1);
        this.testGroupBy(query, queryMetrics, Collections.singletonList(new Object[]{null, 20.8}));
    }

    @Test
    public void testProjectionSingleDimFilter() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)UTC_MIDNIGHT, (ReadableInstant)UTC_MIDNIGHT.plusDays(1))).addDimension("a").setDimFilter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"a", null)).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongLastAggregatorFactory("c_last", "c", null)).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 2);
        this.testGroupBy(query, queryMetrics, Collections.singletonList(new Object[]{"a", 7L, Pair.of((Object)UTC_01H31M.getMillis(), (Object)2L)}));
    }

    @Test
    public void testProjectionSingleDimFilteredAgg() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)UTC_MIDNIGHT, (ReadableInstant)UTC_MIDNIGHT.plusDays(1))).addDimension("a").addAggregator((AggregatorFactory)new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"), (DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"a", null))).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 7L}, new Object[]{"b", null}));
    }

    @Test
    public void testProjectionSingleDimFilteredAggLessMatchy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)UTC_MIDNIGHT, (ReadableInstant)UTC_MIDNIGHT.plusDays(1))).addDimension("a").addAggregator((AggregatorFactory)new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"), (DimFilter)new EqualityFilter("b", ColumnType.STRING, (Object)"bb", null))).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("ab_hourly_cd_sum");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 7);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 1L}, new Object[]{"b", 5L}));
    }

    @Test
    public void testProjectionSingleDimFilteredAggNoMatchy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)UTC_MIDNIGHT, (ReadableInstant)UTC_MIDNIGHT.plusDays(1))).addDimension("a").addAggregator((AggregatorFactory)new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"), (DimFilter)new OrDimFilter(List.of(new EqualityFilter("b", ColumnType.STRING, (Object)"bb", null), new NullFilter("e", null))))).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(null);
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 8);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 2L}, new Object[]{"b", 5L}));
    }

    @Test
    public void testProjectionSingleDimFilterWithPartialIntervalAligned() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)UTC_MIDNIGHT, (ReadableInstant)UTC_MIDNIGHT.plusHours(1))).addDimension("a").setDimFilter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"a", null)).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongLastAggregatorFactory("c_last", "c", null)).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 1);
        this.testGroupBy(query, queryMetrics, Collections.singletonList(new Object[]{"a", 4L, Pair.of((Object)UTC_MIDNIGHT.plusMinutes(4).getMillis(), (Object)2L)}));
    }

    @Test
    public void testProjectionSingleDimFilterWithPartialIntervalUnaligned() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)UTC_MIDNIGHT, (ReadableInstant)UTC_MIDNIGHT.plusHours(1).minusMinutes(1))).addDimension("a").setDimFilter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"a", null)).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongLastAggregatorFactory("c_last", "c", null)).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(null);
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, Collections.singletonList(new Object[]{"a", 4L, Pair.of((Object)UTC_MIDNIGHT.plusMinutes(4).getMillis(), (Object)2L)}));
    }

    @Test
    public void testProjectionSingleDimCount() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new CountAggregatorFactory("cnt")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 7L, 5L}, new Object[]{"b", 12L, 3L}));
    }

    @Test
    public void testProjectionSingleDimMultipleSameAggs() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum_2", "c")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 7L, 7L}, new Object[]{"b", 12L, 12L}));
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testQueryGranularityFinerThanProjectionGranularity() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testQueryGranularityFitsProjectionGranularity() {
        GroupByQuery.Builder queryBuilder = GroupByQuery.builder().setDataSource("test").setInterval(Intervals.ETERNITY).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"));
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        if (this.segmentSortedByTime) {
            queryBuilder.addDimension("a").setGranularity(Granularities.HOUR);
        } else {
            queryBuilder.setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"__gran", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"a")}).setVirtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")});
        }
        GroupByQuery query = queryBuilder.build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{UTC_MIDNIGHT.getMillis(), "a", 4L}, new Object[]{UTC_MIDNIGHT.getMillis(), "b", 12L}, new Object[]{UTC_01H.getMillis(), "a", 3L}));
    }

    @Test
    public void testQueryGranularityFitsProjectionGranularityNotTimeOrdered() {
        GroupByQuery.Builder queryBuilder = GroupByQuery.builder().setDataSource("test").setInterval(Intervals.ETERNITY).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"));
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(this.segmentSortedByTime ? null : "b_hourly_c_sum_non_time_ordered");
        if (this.segmentSortedByTime) {
            queryBuilder.addDimension("b").setGranularity(Granularities.HOUR);
        } else {
            queryBuilder.setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"__gran", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"b")}).setVirtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")});
        }
        GroupByQuery query = queryBuilder.build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, this.segmentSortedByTime ? 8 : 5);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{UTC_MIDNIGHT.getMillis(), "aa", 8L}, new Object[]{UTC_MIDNIGHT.getMillis(), "bb", 6L}, new Object[]{UTC_MIDNIGHT.getMillis(), "cc", 2L}, new Object[]{UTC_01H.getMillis(), "aa", 1L}, new Object[]{UTC_01H.getMillis(), "dd", 2L}));
    }

    @Test
    public void testQueryGranularityFitsProjectionGranularityWithTimeZone() {
        GroupByQuery.Builder queryBuilder = GroupByQuery.builder().setDataSource("test").setInterval(Intervals.ETERNITY).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"));
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        if (this.segmentSortedByTime) {
            queryBuilder.addDimension("a").setGranularity((Granularity)new PeriodGranularity(new Period((Object)"PT1H"), null, DateTimes.inferTzFromString((String)"America/Los_Angeles")));
        } else {
            queryBuilder.setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"__gran", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"a")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("__gran", "timestamp_floor(__time,'PT1H',null,'America/Los_Angeles')", ColumnType.LONG, new ExprMacroTable(List.of(new TimestampFloorExprMacro())))});
        }
        GroupByQuery query = queryBuilder.build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{UTC_MIDNIGHT.getMillis(), "a", 4L}, new Object[]{UTC_MIDNIGHT.getMillis(), "b", 12L}, new Object[]{UTC_01H.getMillis(), "a", 3L}));
    }

    @Test
    public void testQueryGranularityDoesNotFitProjectionGranularityWithTimeZone() {
        GroupByQuery.Builder queryBuilder = GroupByQuery.builder().setDataSource("test").setInterval(Intervals.ETERNITY).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"));
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(null);
        if (this.segmentSortedByTime) {
            queryBuilder.addDimension("a").setGranularity((Granularity)new PeriodGranularity(new Period((Object)"PT1H"), null, DateTimes.inferTzFromString((String)"Asia/Kolkata")));
        } else {
            queryBuilder.setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"__gran", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"a")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("__gran", "timestamp_floor(__time,'PT1H',null,'Asia/Kolkata')", ColumnType.LONG, new ExprMacroTable(List.of(new TimestampFloorExprMacro())))});
        }
        GroupByQuery query = queryBuilder.build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 8);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{UTC_MIDNIGHT.minusMinutes(30).getMillis(), "a", 4L}, new Object[]{UTC_MIDNIGHT.minusMinutes(30).getMillis(), "b", 12L}, new Object[]{UTC_01H.minusMinutes(30).getMillis(), "a", 1L}, new Object[]{UTC_01H31M.minusMinutes(1).getMillis(), "a", 2L}));
    }

    @Test
    public void testQueryGranularityLargerProjectionGranularity() {
        GroupByQuery.Builder queryBuilder = GroupByQuery.builder().setDataSource("test").setInterval(Intervals.ETERNITY).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c"));
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count_latest");
        if (this.segmentSortedByTime) {
            queryBuilder.addDimension("a").setGranularity(Granularities.DAY);
        } else {
            queryBuilder.setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"__gran", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"a")}).setVirtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"__gran")});
        }
        GroupByQuery query = queryBuilder.build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{UTC_MIDNIGHT.getMillis(), "a", 7L}, new Object[]{UTC_MIDNIGHT.getMillis(), "b", 12L}));
    }

    @Test
    public void testProjectionSelectionMissingAggregatorButHasAggregatorInput() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("b").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new FloatSumAggregatorFactory("e_sum", "e")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(null);
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorNoProjection(buildSpec, queryMetrics);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"aa", 9L, Float.valueOf(8.8f)}, new Object[]{"bb", 6L, Float.valueOf(6.6f)}, new Object[]{"cc", 2L, Float.valueOf(2.2f)}, new Object[]{"dd", 2L, Float.valueOf(2.2f)}));
    }

    @Test
    public void testProjectionSelectionMissingAggregatorAndAggregatorInput() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new DoubleSumAggregatorFactory("d_sum", "d")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("ab_hourly_cd_sum");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 7);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 7L, 7.6000000000000005}, new Object[]{"b", 12L, 13.2}));
    }

    @Test
    public void testProjectionSelectionMissingColumnOnBaseTableToo() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("z").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new DoubleSumAggregatorFactory("d_sum", "d")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("ab_hourly_cd_sum");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 7);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", null, 7L, 7.6000000000000005}, new Object[]{"b", null, 12L, 13.2}));
    }

    @Test
    public void testTimeseriesQueryAllGranularityCanMatchNonTimeDimProjection() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context(Map.of("useProjection", "b_c_sum")).build();
        ExpectedProjectionTimeseries queryMetrics = new ExpectedProjectionTimeseries("b_c_sum");
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 4);
        this.testTimeseries(query, queryMetrics, Collections.singletonList(new Object[]{UTC_MIDNIGHT, 19L}));
    }

    @Test
    public void testTimeseriesQueryAllGranularitiesAlwaysRuns() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context(Map.of("noProjections", true)).build();
        ExpectedProjectionTimeseries queryMetrics = new ExpectedProjectionTimeseries(null);
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorNoProjection(buildSpec, queryMetrics);
        this.testTimeseries(query, queryMetrics, Collections.singletonList(new Object[]{UTC_MIDNIGHT, 19L}));
    }

    @Test
    public void testTimeseriesQueryOrderByNotCompatibleWithProjection() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.DAY).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context(Map.of("useProjection", "b_c_sum")).build();
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, null);
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> this.projectionsCursorFactory.makeCursorHolder(buildSpec));
        Assert.assertEquals((Object)DruidException.Category.INVALID_INPUT, (Object)e.getCategory());
        Assert.assertEquals((Object)"Projection[b_c_sum] specified, but does not satisfy query", (Object)e.getMessage());
    }

    @Test
    public void testTimeseriesQueryGranularityFitsProjectionGranularity() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).build();
        ExpectedProjectionTimeseries queryMetrics = new ExpectedProjectionTimeseries("a_hourly_c_sum_with_count_latest");
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testTimeseries(query, queryMetrics, List.of(new Object[]{UTC_MIDNIGHT, 16L}, new Object[]{UTC_01H, 3L}));
    }

    @Test
    public void testTimeseriesQueryGranularityAllFitsProjectionGranularityWithSegmentGranularity() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context(Map.of("useProjection", "c_sum_daily")).build();
        ExpectedProjectionTimeseries queryMetrics = new ExpectedProjectionTimeseries("c_sum_daily");
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 1);
        this.testTimeseries(query, queryMetrics, Collections.singletonList(new Object[]{UTC_MIDNIGHT, 19L}));
    }

    @Test
    public void testTimeseriesQueryGranularityAllFitsProjectionGranularityWithNoGrouping() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context(Map.of("useProjection", "c_sum")).build();
        ExpectedProjectionTimeseries queryMetrics = new ExpectedProjectionTimeseries("c_sum");
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 1);
        this.testTimeseries(query, queryMetrics, Collections.singletonList(new Object[]{UTC_MIDNIGHT, 19L}));
    }

    @Test
    public void testTimeseriesQueryGranularityFinerThanProjectionGranularity() {
        Assume.assumeTrue((boolean)this.segmentSortedByTime);
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.MINUTE).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context(Map.of("skipEmptyBuckets", true)).build();
        ExpectedProjectionTimeseries queryMetrics = new ExpectedProjectionTimeseries(null);
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorNoProjection(buildSpec, queryMetrics);
        this.testTimeseries(query, queryMetrics, List.of(new Object[]{UTC_MIDNIGHT, 1L}, new Object[]{UTC_MIDNIGHT.plusMinutes(2), 1L}, new Object[]{UTC_MIDNIGHT.plusMinutes(4), 2L}, new Object[]{UTC_MIDNIGHT.plusMinutes(6), 3L}, new Object[]{UTC_MIDNIGHT.plusMinutes(8), 4L}, new Object[]{UTC_MIDNIGHT.plusMinutes(10), 5L}, new Object[]{UTC_01H, 1L}, new Object[]{UTC_01H31M, 2L}));
    }

    @Test
    public void testProjectionSingleDimRollupTable() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "sum_c")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_with_count");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(this.rollupProjectionsCursorFactory, buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, true, false, List.of(new Object[]{"a", 7L}, new Object[]{"b", 12L}));
    }

    @Test
    public void testProjectionSingleDimVirtualColumnRollupTable() {
        ExpressionVirtualColumn vc = new ExpressionVirtualColumn("v0", "concat(a, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE);
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("v0").setVirtualColumns(new VirtualColumn[]{vc}).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "sum_c")).addAggregator((AggregatorFactory)new LongMaxAggregatorFactory("c_c", "max_c")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("afoo");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(this.rollupProjectionsCursorFactory, buildSpec, queryMetrics, 2);
        this.testGroupBy(query, queryMetrics, true, false, List.of(new Object[]{"afoo", 7L, 2L}, new Object[]{"bfoo", 12L, 5L}));
    }

    @Test
    public void testProjectionJson() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("f", "$.x", "v0", ColumnType.STRING)}).addDimension("v0").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("json");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 6);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 7L}, new Object[]{"b", 12L}));
    }

    @Test
    public void testProjectionFilter() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").setDimFilter((DimFilter)new EqualityFilter("b", ColumnType.STRING, (Object)"aa", null)).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("c_sum", "c")).addAggregator((AggregatorFactory)new DoubleSumAggregatorFactory("d_sum", "d")).setContext(Map.of("useProjection", "a_filter_b_aaonly_hourly_cd_sum")).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_filter_b_aaonly_hourly_cd_sum");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 3);
        this.testGroupBy(query, queryMetrics, List.of(new Object[]{"a", 2L, 2.1}, new Object[]{"b", 7L, 7.7}));
    }

    @Test
    public void testProjectionSelectionTwoVirtual() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("v0").addDimension((DimensionSpec)DefaultDimensionSpec.of((String)"v1", (ColumnType)ColumnType.LONG)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(a, \"b\")", ColumnType.STRING, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("v1", "d + e", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_concat_b_d_plus_f_sum_c");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 8);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{"aaa", null}, new Object[]{"aaa", 2L}, new Object[]{"abb", 2L}, new Object[]{"acc", 4L}, new Object[]{"add", 4L}, new Object[]{"baa", 6L}, new Object[]{"baa", 8L}, new Object[]{"bbb", 11L}));
    }

    @Test
    public void testProjectionFilteredProjectionMatch() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimFilter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"a", null)).addDimension("a").build();
        boolean isRealtime = this.projectionsCursorFactory instanceof IncrementalIndexCursorFactory;
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(isRealtime ? "abfoo" : "a_hourly_c_sum_filter_a_to_a");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, isRealtime ? 4 : 2);
        this.testGroupBy(query, queryMetrics, (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}));
    }

    @Test
    public void testProjectionFilteredNoFilteredProjectionMatch() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimFilter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"b", null)).addDimension("a").build();
        boolean isRealtime = this.projectionsCursorFactory instanceof IncrementalIndexCursorFactory;
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy(isRealtime ? "abfoo" : "a_hourly_c_sum_with_count_latest");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, isRealtime ? 2 : 1);
        this.testGroupBy(query, queryMetrics, (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}));
    }

    @Test
    public void testProjectionFilteredToEmpty() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimFilter((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"nomatch", null)).setContext(Map.of("useProjection", "a_hourly_c_sum_filter_a_to_empty")).addDimension("a").build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("a_hourly_c_sum_filter_a_to_empty");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 0);
        this.testGroupBy(query, queryMetrics, List.of());
    }

    @Test
    public void testProjectionFilteredToEmptyTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.ALL).filters((DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"nomatch", null)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).context(Map.of("useProjection", "a_hourly_c_sum_filter_a_to_empty")).build();
        ExpectedProjectionTimeseries queryMetrics = new ExpectedProjectionTimeseries("a_hourly_c_sum_filter_a_to_empty");
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 0);
        boolean isRealtime = this.projectionsCursorFactory instanceof IncrementalIndexCursorFactory;
        List<Object[]> expectedResults = Collections.singletonList(new Object[]{UTC_MIDNIGHT, null});
        List expectedRealtimeResults = List.of();
        Sequence resultRows = this.timeseriesEngine.process(query, this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, (TimeseriesQueryMetrics)queryMetrics);
        queryMetrics.assertProjection();
        List results = resultRows.toList();
        this.assertTimeseriesResults(query.getResultRowSignature(RowSignature.Finalization.YES), isRealtime ? expectedRealtimeResults : expectedResults, results);
        Assertions.assertEquals((Object)UTC_MIDNIGHT, (Object)this.projectionsTimeBoundaryInspector.getMinTime());
        if (isRealtime || this.segmentSortedByTime) {
            Assertions.assertEquals((Object)UTC_01H31M, (Object)this.projectionsTimeBoundaryInspector.getMaxTime());
        } else {
            Assertions.assertEquals((Object)UTC_01H31M.plusMillis(1), (Object)this.projectionsTimeBoundaryInspector.getMaxTime());
        }
        Assume.assumeTrue((boolean)this.segmentSortedByTime);
        Sequence resultRowsNoProjection = this.timeseriesEngine.process(query.withOverriddenContext(Map.of("noProjections", true)), this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, (TimeseriesQueryMetrics)queryMetrics);
        List resultsNoProjection = resultRowsNoProjection.toList();
        this.assertTimeseriesResults(query.getResultRowSignature(RowSignature.Finalization.YES), expectedResults, resultsNoProjection);
    }

    @Test
    public void testProjectionGroupOnTime() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension((DimensionSpec)new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)).addDimension("v0").setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(a, 'aaa')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("time_and_a");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 8);
        this.testGroupBy(query, queryMetrics, false, true, List.of(new Object[]{UTC_MIDNIGHT.getMillis(), "aaaa"}, new Object[]{UTC_MIDNIGHT.plusMinutes(2).getMillis(), "aaaa"}, new Object[]{UTC_MIDNIGHT.plusMinutes(4).getMillis(), "aaaa"}, new Object[]{UTC_MIDNIGHT.plusMinutes(6).getMillis(), "baaa"}, new Object[]{UTC_MIDNIGHT.plusMinutes(8).getMillis(), "baaa"}, new Object[]{UTC_MIDNIGHT.plusMinutes(10).getMillis(), "baaa"}, new Object[]{UTC_01H.getMillis(), "aaaa"}, new Object[]{UTC_01H31M.getMillis(), "aaaa"}));
    }

    @Test
    public void testProjectionGroupFilteredOnVirtualColumn() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "c + d", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE)}).setDimFilter((DimFilter)new TypedInFilter("v0", ColumnType.DOUBLE, List.of(Double.valueOf(2.1), Double.valueOf(4.2)), null, null)).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("c", "c")}).build();
        ExpectedProjectionGroupBy queryMetrics = new ExpectedProjectionGroupBy("filtered_c_plus_d");
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, (QueryMetrics)queryMetrics);
        this.assertCursorProjection(buildSpec, queryMetrics, 2);
        this.testGroupBy(query, queryMetrics, (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    private void testGroupBy(GroupByQuery query, ExpectedProjectionGroupBy queryMetrics, List<Object[]> expectedResults) {
        this.testGroupBy(query, queryMetrics, false, false, expectedResults);
    }

    private void testGroupBy(GroupByQuery query, ExpectedProjectionGroupBy queryMetrics, boolean rollup, boolean withMerge, List<Object[]> expectedResults) {
        this.testGroupByQuery(query, queryMetrics, rollup, withMerge, expectedResults);
        GroupByQuery queryNoProjections = query.withOverriddenContext(Map.of("noProjections", true));
        this.testGroupByQuery(queryNoProjections, new ExpectedProjectionGroupBy(null), rollup, withMerge, expectedResults);
    }

    private void testGroupByQuery(GroupByQuery query, ExpectedProjectionGroupBy queryMetrics, boolean rollup, boolean withMerge, List<Object[]> expectedResults) {
        GroupByQuery finalQuery = withMerge ? query.withOverriddenContext(Map.of("queryResourceId", String.valueOf(query.hashCode()))) : query;
        QueryRunner runner = (unused1, unused2) -> this.groupingEngine.process(finalQuery, rollup ? this.rollupProjectionsCursorFactory : this.projectionsCursorFactory, rollup ? this.rollupProjectionsTimeBoundaryInspector : this.projectionsTimeBoundaryInspector, this.nonBlockingPool, (GroupByQueryMetrics)queryMetrics);
        if (withMerge) {
            this.resourcesReservationPool.reserve(new QueryResourceId(String.valueOf(query.hashCode())), finalQuery, true, new GroupByStatsProvider.PerQueryStats());
            runner = this.groupingEngine.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, List.of(runner));
        }
        List results = runner.run(QueryPlus.wrap((Query)finalQuery)).toList();
        queryMetrics.assertProjection();
        this.assertGroupByResults(expectedResults, results);
    }

    private void testTimeseries(TimeseriesQuery query, ExpectedProjectionTimeseries queryMetrics, List<Object[]> expectedResults) {
        this.testTimeseries(this.projectionsCursorFactory, this.projectionsTimeBoundaryInspector, query, queryMetrics, expectedResults);
    }

    private void testTimeseries(CursorFactory cursorFactory, TimeBoundaryInspector timeBoundaryInspector, TimeseriesQuery query, ExpectedProjectionTimeseries queryMetrics, List<Object[]> expectedResults) {
        Sequence resultRows = this.timeseriesEngine.process(query, cursorFactory, timeBoundaryInspector, (TimeseriesQueryMetrics)queryMetrics);
        queryMetrics.assertProjection();
        List results = resultRows.toList();
        this.assertTimeseriesResults(query.getResultRowSignature(RowSignature.Finalization.YES), expectedResults, results);
        Assume.assumeTrue((boolean)this.segmentSortedByTime);
        Sequence resultRowsNoProjection = this.timeseriesEngine.process(query.withOverriddenContext(Map.of("noProjections", true)), cursorFactory, timeBoundaryInspector, (TimeseriesQueryMetrics)queryMetrics);
        List resultsNoProjection = resultRowsNoProjection.toList();
        this.assertTimeseriesResults(query.getResultRowSignature(RowSignature.Finalization.YES), expectedResults, resultsNoProjection);
    }

    private void assertGroupByResults(List<Object[]> expected, List<ResultRow> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Object[] actualArray = actual.stream().map(ResultRow::getArray).map(Arrays::toString).toArray();
        Assertions.assertEquals((Object)Arrays.toString(expected.stream().map(Arrays::toString).toArray()), (Object)Arrays.toString(actualArray));
    }

    private void assertTimeseriesResults(RowSignature querySignature, List<Object[]> expected, List<Result<TimeseriesResultValue>> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertArrayEquals((Object[])expected.get(i), (Object[])CursorFactoryProjectionTest.getResultArray(actual.get(i), querySignature));
        }
    }

    private void assertCursorNoProjection(CursorBuildSpec buildSpec, ExpectedProjectionQueryMetrics<?> queryMetrics) {
        this.assertCursorProjection(buildSpec, queryMetrics, 8);
    }

    private void assertCursorProjection(CursorBuildSpec buildSpec, ExpectedProjectionQueryMetrics<?> queryMetrics, int expectedRowCount) {
        this.assertCursorProjection(this.projectionsCursorFactory, buildSpec, queryMetrics, expectedRowCount);
    }

    private void assertCursorProjection(CursorFactory cursorFactory, CursorBuildSpec buildSpec, ExpectedProjectionQueryMetrics<?> queryMetrics, int expectedRowCount) {
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);){
            queryMetrics.assertProjection();
            Cursor cursor = cursorHolder.asCursor();
            int rowCount = 0;
            if (cursor != null) {
                while (!cursor.isDone()) {
                    ++rowCount;
                    cursor.advance();
                }
            }
            Assert.assertEquals((long)expectedRowCount, (long)rowCount);
        }
    }

    private static AutoTypeColumnSchema toAutoColumn(DimensionSchema x) {
        if (PROJECTION_TIME_COLUMNS.contains(x.getName())) {
            return new AutoTypeColumnSchema(x.getName(), ColumnType.LONG, null);
        }
        return AutoTypeColumnSchema.of((String)x.getName());
    }

    private static IndexBuilder makeBuilder(DimensionsSpec dimensionsSpec, boolean autoSchema, boolean writeNullColumns) {
        File tmp = FileUtils.createTempDir();
        CLOSER.register(tmp::delete);
        return IndexBuilder.create().tmpDir(tmp).schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withRollup(false).withMinTimestamp(UTC_MIDNIGHT.getMillis()).withProjections(autoSchema ? AUTO_PROJECTIONS : PROJECTIONS).build()).writeNullColumns(writeNullColumns).rows(ROWS);
    }

    private static IndexBuilder makeRollupBuilder(DimensionsSpec dimensionsSpec, AggregatorFactory[] aggs, boolean autoSchema) {
        File tmp = FileUtils.createTempDir();
        CLOSER.register(tmp::delete);
        return IndexBuilder.create().tmpDir(tmp).schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withMetrics(aggs).withRollup(true).withMinTimestamp(UTC_MIDNIGHT.getMillis()).withProjections(autoSchema ? AUTO_ROLLUP_PROJECTIONS : ROLLUP_PROJECTIONS).build()).writeNullColumns(true).rows(ROLLUP_ROWS);
    }

    private static Object[] getResultArray(Result<TimeseriesResultValue> result, RowSignature rowSignature) {
        Object[] rowArray = new Object[rowSignature.size()];
        for (int i = 0; i < rowSignature.size(); ++i) {
            rowArray[i] = i == 0 ? result.getTimestamp() : ((TimeseriesResultValue)result.getValue()).getMetric(rowSignature.getColumnName(i));
        }
        return rowArray;
    }

    private static class ExpectedProjectionGroupBy
    extends ExpectedProjectionQueryMetrics<GroupByQuery>
    implements GroupByQueryMetrics {
        private ExpectedProjectionGroupBy(@Nullable String expectedProjection) {
            super(expectedProjection);
        }

        public void numDimensions(GroupByQuery query) {
        }

        public void numMetrics(GroupByQuery query) {
        }

        public void numComplexMetrics(GroupByQuery query) {
        }

        public void granularity(GroupByQuery query) {
        }
    }

    private static class ExpectedProjectionQueryMetrics<T extends Query<?>>
    extends DefaultQueryMetrics<T> {
        @Nullable
        private final String expectedProjection;
        @Nullable
        private String capturedProjection;

        private ExpectedProjectionQueryMetrics(@Nullable String expectedProjection) {
            this.expectedProjection = expectedProjection;
        }

        public void projection(String projection) {
            this.capturedProjection = projection;
        }

        void assertProjection() {
            Assertions.assertEquals((Object)this.expectedProjection, (Object)this.capturedProjection);
            this.capturedProjection = null;
        }
    }

    private static class ExpectedProjectionTimeseries
    extends ExpectedProjectionQueryMetrics<TimeseriesQuery>
    implements TimeseriesQueryMetrics {
        private ExpectedProjectionTimeseries(@Nullable String expectedProjection) {
            super(expectedProjection);
        }

        public void limit(TimeseriesQuery query) {
        }

        public void numMetrics(TimeseriesQuery query) {
        }

        public void numComplexMetrics(TimeseriesQuery query) {
        }

        public void granularity(TimeseriesQuery query) {
        }
    }
}

