/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.allocation.SingleMemoryAllocatorFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class ScanQueryQueryToolChestTest {
    private static final List<Object[]> ARRAY_RESULTS_1;
    private static final List<Object[]> ARRAY_RESULTS_2;
    private static final List<Object[]> ARRAY_RESULTS_3;
    private final ScanQueryQueryToolChest toolChest = ScanQueryQueryToolChestTest.makeTestScanQueryToolChest();

    public static ScanQueryQueryToolChest makeTestScanQueryToolChest() {
        return new ScanQueryQueryToolChest(DefaultGenericQueryMetricsFactory.instance());
    }

    @Test
    public void test_resultArraySignature_columnsNotSpecified() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).build();
        Assert.assertEquals((Object)RowSignature.empty(), (Object)this.toolChest.resultArraySignature(scanQuery));
    }

    @Test
    public void test_resultArraySignature_columnsNotSpecifiedLegacyMode() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).build();
        Assert.assertEquals((Object)RowSignature.empty(), (Object)this.toolChest.resultArraySignature(scanQuery));
    }

    @Test
    public void test_resultArraySignature_columnsSpecified() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar"}).build();
        Assert.assertEquals((Object)RowSignature.builder().add("foo", null).add("bar", null).build(), (Object)this.toolChest.resultArraySignature(scanQuery));
    }

    @Test
    public void test_resultsAsArrays_columnsNotSpecifiedListResults() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[0], (Object)new Object[0]), (Sequence<Object[]>)this.toolChest.resultsAsArrays(scanQuery, ScanQueryQueryToolChestTest.makeResults1(ScanQuery.ResultFormat.RESULT_FORMAT_LIST)));
    }

    @Test
    public void test_resultsAsArrays_columnsNotSpecifiedCompactedListResults() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[0], (Object)new Object[0]), (Sequence<Object[]>)this.toolChest.resultsAsArrays(scanQuery, ScanQueryQueryToolChestTest.makeResults1(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)));
    }

    @Test
    public void test_resultsAsArrays_columnsSpecifiedListResults() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        QueryToolChestTestHelper.assertArrayResultsEquals(ARRAY_RESULTS_1, (Sequence<Object[]>)this.toolChest.resultsAsArrays(scanQuery, ScanQueryQueryToolChestTest.makeResults1(ScanQuery.ResultFormat.RESULT_FORMAT_LIST)));
    }

    @Test
    public void test_resultsAsArrays_columnsSpecifiedCompactedListResults() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        QueryToolChestTestHelper.assertArrayResultsEquals(ARRAY_RESULTS_1, (Sequence<Object[]>)this.toolChest.resultsAsArrays(scanQuery, ScanQueryQueryToolChestTest.makeResults1(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)));
    }

    @Test
    public void test_resultsAsFrames_batchingWorksAsExpectedWithDistinctColumnTypes() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar", "foo2", "bar2", "foo3", "bar3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        List frames = ((Sequence)this.toolChest.resultsAsFrames(scanQuery, Sequences.concat((Sequence[])new Sequence[]{ScanQueryQueryToolChestTest.makeResults1(ScanQuery.ResultFormat.RESULT_FORMAT_LIST), ScanQueryQueryToolChestTest.results2(), ScanQueryQueryToolChestTest.results3()}), (MemoryAllocatorFactory)new SingleMemoryAllocatorFactory((MemoryAllocator)HeapMemoryAllocator.unlimited()), true).get()).toList();
        Assert.assertEquals((long)3L, (long)frames.size());
        RowSignature resultRowSignature = RowSignature.builder().add("foo", null).add("bar", null).add("foo2", null).add("bar2", null).add("foo3", null).add("bar3", null).build();
        Sequence rows = new FrameBasedInlineDataSource(frames, resultRowSignature).getRowsAsSequence();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{null, StructuredData.wrap((Object)3.2), null, null, null, null}, (Object)new Object[]{StructuredData.wrap((Object)"x"), StructuredData.wrap((Object)"y"), null, null, null, null}, (Object)new Object[]{null, null, "str1", 3.2, null, null}, (Object)new Object[]{null, null, "str2", 3.3, null, null}, (Object)new Object[]{null, null, null, null, 3.4, "str3"}, (Object)new Object[]{null, null, null, null, 3.5, "str4"}), (Sequence<Object[]>)rows);
    }

    @Test
    public void test_resultsAsFrames_batchingWorksAsExpectedWithMixedColumnTypes() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar", "foo2", "bar2", "foo3", "bar3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        List frames = ((Sequence)this.toolChest.resultsAsFrames(scanQuery, Sequences.concat((Sequence[])new Sequence[]{ScanQueryQueryToolChestTest.results2(), ScanQueryQueryToolChestTest.makeResults1(ScanQuery.ResultFormat.RESULT_FORMAT_LIST), ScanQueryQueryToolChestTest.makeResults1(ScanQuery.ResultFormat.RESULT_FORMAT_LIST), ScanQueryQueryToolChestTest.results3(), ScanQueryQueryToolChestTest.results2(), ScanQueryQueryToolChestTest.results2(), ScanQueryQueryToolChestTest.results3()}), (MemoryAllocatorFactory)new SingleMemoryAllocatorFactory((MemoryAllocator)HeapMemoryAllocator.unlimited()), true).get()).toList();
        Assert.assertEquals((long)5L, (long)frames.size());
        RowSignature resultRowSignature = RowSignature.builder().add("foo", null).add("bar", null).add("foo2", null).add("bar2", null).add("foo3", null).add("bar3", null).build();
        Sequence rows = new FrameBasedInlineDataSource(frames, resultRowSignature).getRowsAsSequence();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, "str1", 3.2, null, null}, (Object)new Object[]{null, null, "str2", 3.3, null, null}, (Object)new Object[]{null, StructuredData.wrap((Object)3.2), null, null, null, null}, (Object)new Object[]{StructuredData.wrap((Object)"x"), StructuredData.wrap((Object)"y"), null, null, null, null}, (Object)new Object[]{null, StructuredData.wrap((Object)3.2), null, null, null, null}, (Object)new Object[]{StructuredData.wrap((Object)"x"), StructuredData.wrap((Object)"y"), null, null, null, null}, (Object)new Object[]{null, null, null, null, 3.4, "str3"}, (Object)new Object[]{null, null, null, null, 3.5, "str4"}, (Object)new Object[]{null, null, "str1", 3.2, null, null}, (Object)new Object[]{null, null, "str2", 3.3, null, null}, (Object)new Object[]{null, null, "str1", 3.2, null, null}, (Object)new Object[]{null, null, "str2", 3.3, null, null}, (Object[])new Object[][]{{null, null, null, null, 3.4, "str3"}, {null, null, null, null, 3.5, "str4"}}), (Sequence<Object[]>)rows);
    }

    @Test
    public void test_resultsAsFrames_batchingWorksAsExpectedWithSameColumnTypes() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar", "foo2", "bar2", "foo3", "bar3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        List frames = ((Sequence)this.toolChest.resultsAsFrames(scanQuery, Sequences.concat((Sequence[])new Sequence[]{ScanQueryQueryToolChestTest.results2(), ScanQueryQueryToolChestTest.results2()}), (MemoryAllocatorFactory)new SingleMemoryAllocatorFactory((MemoryAllocator)HeapMemoryAllocator.unlimited()), true).get()).toList();
        Assert.assertEquals((long)1L, (long)frames.size());
        RowSignature resultRowSignature = RowSignature.builder().add("foo", null).add("bar", null).add("foo2", null).add("bar2", null).add("foo3", null).add("bar3", null).build();
        Sequence rows = new FrameBasedInlineDataSource(frames, resultRowSignature).getRowsAsSequence();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, "str1", 3.2, null, null}, (Object)new Object[]{null, null, "str2", 3.3, null, null}, (Object)new Object[]{null, null, "str1", 3.2, null, null}, (Object)new Object[]{null, null, "str2", 3.3, null, null}), (Sequence<Object[]>)rows);
    }

    private static Sequence<ScanResultValue> makeResults1(ScanQuery.ResultFormat resultFormat) {
        ArrayList rows = new ArrayList();
        switch (resultFormat) {
            case RESULT_FORMAT_LIST: {
                ARRAY_RESULTS_1.forEach(arr -> {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("foo", arr[0]);
                    m.put("bar", arr[1]);
                    rows.add(m);
                });
                break;
            }
            case RESULT_FORMAT_COMPACTED_LIST: {
                ARRAY_RESULTS_1.forEach(arr -> rows.add(Arrays.asList(arr)));
                break;
            }
            default: {
                throw new ISE("Cannot generate resultFormat '%s'", new Object[]{resultFormat});
            }
        }
        return Sequences.simple((Iterable)ImmutableList.of((Object)new ScanResultValue(null, (List)ImmutableList.of((Object)"foo", (Object)"bar"), rows)));
    }

    private static Sequence<ScanResultValue> results2() {
        ArrayList rows = new ArrayList();
        ARRAY_RESULTS_2.forEach(arr -> {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("foo2", arr[0]);
            m.put("bar2", arr[1]);
            rows.add(m);
        });
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("foo2", ColumnType.STRING);
        rowSignatureBuilder.add("bar2", ColumnType.DOUBLE);
        return Sequences.simple((Iterable)ImmutableList.of((Object)new ScanResultValue(null, (List)ImmutableList.of((Object)"foo2", (Object)"bar2"), rows, rowSignatureBuilder.build())));
    }

    private static Sequence<ScanResultValue> results3() {
        ArrayList rows = new ArrayList();
        ARRAY_RESULTS_3.forEach(arr -> {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("foo3", arr[0]);
            m.put("bar3", arr[1]);
            rows.add(m);
        });
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("foo3", ColumnType.DOUBLE);
        rowSignatureBuilder.add("bar3", ColumnType.STRING);
        return Sequences.simple((Iterable)ImmutableList.of((Object)new ScanResultValue(null, (List)ImmutableList.of((Object)"foo3", (Object)"bar3"), rows, rowSignatureBuilder.build())));
    }

    @Test
    public void testCacheStrategy() {
        ScanQuery query = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).batchSize(4096).offset(10L).limit(100L).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(query, null);
        Assert.assertNotNull((Object)strategy);
        Assert.assertTrue((boolean)strategy.isCacheable((Query)query, true, false));
        Assert.assertFalse((boolean)strategy.isCacheable((Query)query, false, true));
        Assert.assertTrue((boolean)strategy.isCacheable((Query)query, true, true));
        byte[] cacheKey = strategy.computeCacheKey((Query)query);
        Assert.assertNotNull((Object)cacheKey);
        Assert.assertTrue((cacheKey.length > 0 ? 1 : 0) != 0);
        byte[] resultLevelCacheKey = strategy.computeResultLevelCacheKey((Query)query);
        Assert.assertNotNull((Object)resultLevelCacheKey);
        Assert.assertTrue((resultLevelCacheKey.length > 0 ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])cacheKey, (byte[])resultLevelCacheKey);
        ScanResultValue testResult = new ScanResultValue("test_segment", (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"dim1", (Object)"value1", (Object)"dim2", (Object)"value2"), (Object)ImmutableMap.of((Object)"dim1", (Object)"value3", (Object)"dim2", (Object)"value4")));
        ScanResultValue cachedValue = (ScanResultValue)strategy.prepareForCache(false).apply((Object)testResult);
        ScanResultValue fromCache = (ScanResultValue)strategy.pullFromCache(false).apply((Object)cachedValue);
        Assert.assertEquals((Object)testResult, (Object)fromCache);
    }

    @Test
    public void testCacheDisabledForBySegmentQueries() {
        ScanQuery query = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).batchSize(4096).offset(10L).limit(100L).context((Map)ImmutableMap.of((Object)"bySegment", (Object)true)).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(query, null);
        Assert.assertNotNull((Object)strategy);
        Assert.assertFalse((boolean)strategy.isCacheable((Query)query, true, false));
        Assert.assertFalse((boolean)strategy.isCacheable((Query)query, false, true));
    }

    @Test
    public void testCacheKeyDifferentQueries() {
        ScanQuery query1 = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        ScanQuery query2 = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        ScanQuery query3 = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(query1, null);
        byte[] cacheKey1 = strategy.computeCacheKey((Query)query1);
        byte[] cacheKey2 = strategy.computeCacheKey((Query)query2);
        byte[] cacheKey3 = strategy.computeCacheKey((Query)query3);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey3));
        Assert.assertFalse((boolean)Arrays.equals(cacheKey2, cacheKey3));
    }

    @Test
    public void testCacheKeyWithFilters() {
        ScanQuery queryWithFilter = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).filters((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"test", null)).build();
        ScanQuery queryWithoutFilter = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(queryWithFilter, null);
        byte[] cacheKeyWithFilter = strategy.computeCacheKey((Query)queryWithFilter);
        byte[] cacheKeyWithoutFilter = strategy.computeCacheKey((Query)queryWithoutFilter);
        Assert.assertFalse((boolean)Arrays.equals(cacheKeyWithFilter, cacheKeyWithoutFilter));
    }

    @Test
    public void testCacheKeyWithVirtualColumns() {
        ScanQuery queryWithVirtual = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "virtual_col"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("virtual_col", "dim1 + '_suffix'", ColumnType.STRING, ExprMacroTable.nil())}).build();
        ScanQuery queryWithoutVirtual = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(queryWithVirtual, null);
        byte[] cacheKeyWithVirtual = strategy.computeCacheKey((Query)queryWithVirtual);
        byte[] cacheKeyWithoutVirtual = strategy.computeCacheKey((Query)queryWithoutVirtual);
        Assert.assertFalse((boolean)Arrays.equals(cacheKeyWithVirtual, cacheKeyWithoutVirtual));
    }

    @Test
    public void testCacheKeyWithOrderBy() {
        ScanQuery queryWithOrderBy = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).orderBy(List.of(OrderBy.descending((String)"dim1"))).build();
        ScanQuery queryWithoutOrderBy = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        ScanQuery queryWithDifferentOrderBy = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).orderBy(List.of(OrderBy.ascending((String)"dim1"))).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(queryWithOrderBy, null);
        byte[] cacheKeyWithOrderBy = strategy.computeCacheKey((Query)queryWithOrderBy);
        byte[] cacheKeyWithoutOrderBy = strategy.computeCacheKey((Query)queryWithoutOrderBy);
        byte[] cacheKeyWithDifferentOrderBy = strategy.computeCacheKey((Query)queryWithDifferentOrderBy);
        Assert.assertFalse((boolean)Arrays.equals(cacheKeyWithOrderBy, cacheKeyWithoutOrderBy));
        Assert.assertFalse((boolean)Arrays.equals(cacheKeyWithOrderBy, cacheKeyWithDifferentOrderBy));
    }

    @Test
    public void testCacheKeyWithOffsetAndLimit() {
        ScanQuery queryWithOffsetLimit = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).offset(10L).limit(100L).build();
        ScanQuery queryWithoutOffsetLimit = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(queryWithOffsetLimit, null);
        byte[] cacheKeyWithOffsetLimit = strategy.computeCacheKey((Query)queryWithOffsetLimit);
        byte[] cacheKeyWithoutOffsetLimit = strategy.computeCacheKey((Query)queryWithoutOffsetLimit);
        Assert.assertFalse((boolean)Arrays.equals(cacheKeyWithOffsetLimit, cacheKeyWithoutOffsetLimit));
    }

    @Test
    public void testCacheKeyWithDifferentResultFormat() {
        ScanQuery queryWithCompactedList = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).offset(10L).limit(100L).build();
        ScanQuery queryWithResultFormatList = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).offset(10L).limit(100L).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(queryWithCompactedList, null);
        byte[] cacheKeyWithCompactedList = strategy.computeCacheKey((Query)queryWithCompactedList);
        byte[] cacheKeyWithResultFormatList = strategy.computeCacheKey((Query)queryWithResultFormatList);
        Assert.assertFalse((boolean)Arrays.equals(cacheKeyWithCompactedList, cacheKeyWithResultFormatList));
    }

    @Test
    public void testCacheKeyWithDifferentTimeOrder() {
        ScanQuery queryWithOrderDesc = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"__time", "dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).order(Order.DESCENDING).build();
        ScanQuery queryWithOrderAsc = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"__time", "dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).order(Order.ASCENDING).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(queryWithOrderDesc, null);
        byte[] cacheKeyWithOrderDesc = strategy.computeCacheKey((Query)queryWithOrderDesc);
        byte[] cacheKeyWithOrderAsc = strategy.computeCacheKey((Query)queryWithOrderAsc);
        Assert.assertFalse((boolean)Arrays.equals(cacheKeyWithOrderDesc, cacheKeyWithOrderAsc));
    }

    @Test
    public void testCacheKeyWithDifferentColumnTypes() {
        ScanQuery query1 = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"__time", "dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columnTypes(List.of(ColumnType.LONG, ColumnType.STRING, ColumnType.STRING)).build();
        ScanQuery query2 = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2025-01-01/2025-01-02")))).columns(new String[]{"__time", "dim1", "dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columnTypes(List.of(ColumnType.LONG, ColumnType.STRING, ColumnType.STRING_ARRAY)).build();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(query1, null);
        byte[] cacheKeyQuery1 = strategy.computeCacheKey((Query)query1);
        byte[] cacheKeyQuery2 = strategy.computeCacheKey((Query)query2);
        Assert.assertFalse((boolean)Arrays.equals(cacheKeyQuery1, cacheKeyQuery2));
    }

    static {
        ComplexMetrics.registerSerde((String)"json", (ComplexMetricSerde)NestedDataComplexTypeSerde.INSTANCE);
        ARRAY_RESULTS_1 = ImmutableList.of((Object)new Object[]{null, 3.2}, (Object)new Object[]{"x", "y"});
        ARRAY_RESULTS_2 = ImmutableList.of((Object)new Object[]{"str1", 3.2}, (Object)new Object[]{"str2", 3.3});
        ARRAY_RESULTS_3 = ImmutableList.of((Object)new Object[]{3.4, "str3"}, (Object)new Object[]{3.5, "str4"});
    }
}

