/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.segment.join.JoinType;
import org.junit.Assert;
import org.junit.Test;

public class PreJoinableClauseTest {
    private final PreJoinableClause clause = this.makePreJoinableClause();

    private PreJoinableClause makePreJoinableClause() {
        JoinDataSource join = JoinDataSource.create((DataSource)new TableDataSource("bar"), (DataSource)new TableDataSource("foo"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        return new PreJoinableClause(join);
    }

    @Test
    public void test_getPrefix() {
        Assert.assertEquals((Object)"j.", (Object)this.clause.getPrefix());
    }

    @Test
    public void test_getJoinType() {
        Assert.assertEquals((Object)JoinType.LEFT, (Object)this.clause.getJoinType());
    }

    @Test
    public void test_getCondition() {
        Assert.assertEquals((Object)"x == \"j.x\"", (Object)this.clause.getCondition().getOriginalExpression());
    }

    @Test
    public void test_getDataSource() {
        Assert.assertEquals((Object)new TableDataSource("foo"), (Object)this.clause.getDataSource());
    }

    @Test
    public void test_maybeUnwrapRestrictedDataSource() {
        Assert.assertEquals((Object)new TableDataSource("foo"), (Object)this.clause.maybeUnwrapRestrictedDataSource());
        RestrictedDataSource left = RestrictedDataSource.create((DataSource)new TableDataSource("bar"), (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("col", null)));
        RestrictedDataSource restrictedDataSource1 = RestrictedDataSource.create((DataSource)new TableDataSource("foo"), (Policy)NoRestrictionPolicy.instance());
        RestrictedDataSource restrictedDataSource2 = RestrictedDataSource.create((DataSource)new TableDataSource("foo"), (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("col", null)));
        JoinDataSource join1CanbeUnwrapped = JoinDataSource.create((DataSource)left, (DataSource)restrictedDataSource1, (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSource join2NotSupported = JoinDataSource.create((DataSource)left, (DataSource)restrictedDataSource2, (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        Assert.assertEquals((Object)new TableDataSource("foo"), (Object)new PreJoinableClause(join1CanbeUnwrapped).maybeUnwrapRestrictedDataSource());
        QueryUnsupportedException e = (QueryUnsupportedException)Assert.assertThrows(QueryUnsupportedException.class, () -> new PreJoinableClause(join2NotSupported).maybeUnwrapRestrictedDataSource());
        Assert.assertEquals((Object)"Restricted data source [foo] with policy [RowFilterPolicy{rowFilter=col IS NULL}] is not supported", (Object)e.getMessage());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(PreJoinableClause.class).usingGetClass().withNonnullFields(new String[]{"prefix", "dataSource", "joinType", "condition"}).verify();
    }
}

