/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.metadata.AggregatorMergeStrategy;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.timeline.LogicalSegment;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class SegmentMetadataQueryQueryToolChestTest {
    private static final DataSource TEST_DATASOURCE = new TableDataSource("dummy");
    private static final Interval INTERVAL_2020 = Intervals.of((String)"2020-01-01/2020-01-02");
    private static final Interval INTERVAL_2021 = Intervals.of((String)"2021-01-01/2021-01-02");
    private static final SegmentId TEST_SEGMENT_ID1 = SegmentId.of((String)TEST_DATASOURCE.toString(), (Interval)INTERVAL_2020, (String)"test", (int)0);
    private static final SegmentId TEST_SEGMENT_ID2 = SegmentId.of((String)TEST_DATASOURCE.toString(), (Interval)INTERVAL_2021, (String)"test", (int)0);
    private static final AggregateProjectionMetadata.Schema PROJECTION_CHANNEL_ADDED_HOURLY = AggregateProjectionMetadata.schemaBuilder((String)"name1-does-not-matter").timeColumnName("__virtualGranularity").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__virtualGranularity")}).groupAndOrder(new String[]{"__virtualGranularity", "channel"}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("channel_sum", "channel")}).build();
    private static final AggregateProjectionMetadata.Schema PROJECTION_CHANNEL_ADDED_DAILY = AggregateProjectionMetadata.schemaBuilder((String)"name2-does-not-matter").timeColumnName("__virtualGranularity").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"__virtualGranularity")}).groupAndOrder(new String[]{"__virtualGranularity", "channel"}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("channel_sum", "channel")}).build();

    @Test
    public void testCacheStrategy() throws Exception {
        SegmentMetadataQuery query = new SegmentMetadataQuery(TEST_DATASOURCE, (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, AggregatorMergeStrategy.STRICT);
        CacheStrategy strategy = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).getCacheStrategy(query);
        byte[] expectedKey = new byte[]{4, 9, 1, 10, 0, 0, 0, 3, 0, 2, 4};
        byte[] actualKey = strategy.computeCacheKey((Query)query);
        Assert.assertArrayEquals((byte[])expectedKey, (byte[])actualKey);
        SegmentAnalysis result = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).interval(Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")).column("placement", new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.name(), true, false, 10881L, Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null)).size(71982).numRows(100).build();
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        SegmentAnalysis fromCacheValue = (SegmentAnalysis)objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        SegmentAnalysis fromCacheResult = (SegmentAnalysis)strategy.pullFromSegmentLevelCache().apply((Object)fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testMergeAggregators(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("baz", (AggregatorFactory)new DoubleSumAggregatorFactory("baz", "baz")).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis expected = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new DoubleSumAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expected, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, aggregatorMergeStrategy));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testMergeAggregatorsWithIntervals(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).interval(TEST_SEGMENT_ID1.getInterval()).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("baz", (AggregatorFactory)new DoubleSumAggregatorFactory("baz", "baz")).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).interval(TEST_SEGMENT_ID2.getInterval()).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis expected = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").interval(TEST_SEGMENT_ID1.getInterval()).interval(TEST_SEGMENT_ID2.getInterval()).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new DoubleSumAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expected, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, aggregatorMergeStrategy));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testMergeAggregatorsOneNullStrict(AggregatorMergeStrategy aggregatorMergeStrategy) {
        Assume.assumeTrue((aggregatorMergeStrategy == AggregatorMergeStrategy.STRICT ? 1 : 0) != 0);
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis expectedNullAggregators = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").build();
        Assert.assertEquals((Object)expectedNullAggregators, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, aggregatorMergeStrategy));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testMergeAggregatorsOneNullNotStrict(AggregatorMergeStrategy aggregatorMergeStrategy) {
        Assume.assumeTrue((aggregatorMergeStrategy != AggregatorMergeStrategy.STRICT ? 1 : 0) != 0);
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis expected = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        Assert.assertEquals((Object)expected, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, aggregatorMergeStrategy));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testMergeAggregatorsAllNull(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).build();
        SegmentAnalysis expected = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").build();
        Assert.assertEquals((Object)expected, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, aggregatorMergeStrategy));
    }

    @Test
    public void testMergeAggregatorsConflict() {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleMaxAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        SegmentAnalysis expectedStrict = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").build();
        Assert.assertEquals((Object)expectedStrict, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, AggregatorMergeStrategy.STRICT));
        SegmentAnalysis expectedLenient = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", null).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)));
        Assert.assertEquals((Object)expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)));
        Assert.assertEquals((Object)expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), analysis1));
        SegmentAnalysis expectedEarliest = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedEarliest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)expectedEarliest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2)));
        SegmentAnalysis expectedLatest = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleMaxAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedLatest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
        Assert.assertEquals((Object)expectedLatest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2)));
    }

    @Test
    public void testMergeAggregatorsConflictWithDifferentOrder() {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleMaxAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").build(), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        SegmentAnalysis expectedLenient = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", null).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)));
        SegmentAnalysis expectedEarliest = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleMaxAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedEarliest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)expectedEarliest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2)));
        SegmentAnalysis expectedLatest = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedLatest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
        Assert.assertEquals((Object)expectedLatest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2)));
    }

    @Test
    public void testMergeAggregatorsConflictWithEqualSegmentIntervalsAndDifferentPartitions() {
        Interval interval = Intervals.of((String)"2023-01-01/2023-01-02");
        SegmentId segmentId1 = SegmentId.of((String)TEST_DATASOURCE.toString(), (Interval)interval, (String)"test", (int)1);
        SegmentId segmentId2 = SegmentId.of((String)TEST_DATASOURCE.toString(), (Interval)interval, (String)"test", (int)2);
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(segmentId1).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(segmentId2).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleMaxAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)new SegmentAnalysis.Builder("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2").build(), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        SegmentAnalysis expectedLenient = new SegmentAnalysis.Builder("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", null).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)));
        SegmentAnalysis expectedEarliest = new SegmentAnalysis.Builder("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedEarliest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)expectedEarliest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2)));
        SegmentAnalysis expectedLatest = new SegmentAnalysis.Builder("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleMaxAggregatorFactory("bar", "bar")).aggregator("baz", (AggregatorFactory)new LongMaxAggregatorFactory("baz", "baz")).build();
        Assert.assertEquals((Object)expectedLatest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
        Assert.assertEquals((Object)expectedLatest, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2)));
    }

    @Test
    public void testFilterSegments() {
        SegmentMetadataQueryConfig config = new SegmentMetadataQueryConfig();
        SegmentMetadataQueryQueryToolChest toolChest = new SegmentMetadataQueryQueryToolChest(config);
        List filteredSegments = toolChest.filterSegments(Druids.newSegmentMetadataQueryBuilder().dataSource("foo").merge(true).build(), ImmutableList.of((Object)"2000-01-01/P1D", (Object)"2000-01-04/P1D", (Object)"2000-01-09/P1D", (Object)"2000-01-09/P1D").stream().map(interval -> new LogicalSegment(){
            final /* synthetic */ String val$interval;
            {
                this.val$interval = string;
            }

            public Interval getInterval() {
                return Intervals.of((String)this.val$interval);
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)this.val$interval);
            }
        }).collect(Collectors.toList()));
        Assert.assertEquals((Object)Period.weeks((int)1), (Object)config.getDefaultHistory());
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2000-01-04/P1D"), (Object)Intervals.of((String)"2000-01-09/P1D"), (Object)Intervals.of((String)"2000-01-09/P1D")), filteredSegments.stream().map(LogicalSegment::getInterval).collect(Collectors.toList()));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testMergeRollup(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).rollup(false).build();
        SegmentAnalysis analysis3 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).rollup(false).build();
        SegmentAnalysis analysis4 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).rollup(true).build();
        SegmentAnalysis analysis5 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).rollup(true).build();
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, aggregatorMergeStrategy).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis4, aggregatorMergeStrategy).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis2, analysis4, aggregatorMergeStrategy).isRollup());
        Assert.assertFalse((boolean)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis2, analysis3, aggregatorMergeStrategy).isRollup());
        Assert.assertTrue((boolean)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis4, analysis5, aggregatorMergeStrategy).isRollup());
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testInvalidMergeAggregatorsWithNullOrEmptyDatasource(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).build();
        MatcherAssert.assertThat((Object)((DruidException)Assert.assertThrows(DruidException.class, () -> SegmentMetadataQueryQueryToolChest.mergeAnalyses(null, (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)aggregatorMergeStrategy))), (Matcher)DruidExceptionMatcher.defensive().expectMessageIs("SegementMetadata queries require at least one datasource."));
        MatcherAssert.assertThat((Object)((DruidException)Assert.assertThrows(DruidException.class, () -> SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)ImmutableSet.of(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)aggregatorMergeStrategy))), (Matcher)DruidExceptionMatcher.defensive().expectMessageIs("SegementMetadata queries require at least one datasource."));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testMergeWithUnionDatasource(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        SegmentAnalysis expectedMergedAnalysis = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").aggregator("foo", (AggregatorFactory)new LongSumAggregatorFactory("foo", "foo")).aggregator("bar", (AggregatorFactory)new DoubleSumAggregatorFactory("bar", "bar")).build();
        UnionDataSource dataSource1 = new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("dummy")));
        UnionDataSource dataSource2 = new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("dummy"), (Object)new TableDataSource("foo"), (Object)new TableDataSource("bar")));
        Assert.assertEquals((Object)expectedMergedAnalysis, (Object)SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)dataSource1.getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)aggregatorMergeStrategy)));
        Assert.assertEquals((Object)expectedMergedAnalysis, (Object)SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)dataSource2.getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)aggregatorMergeStrategy)));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testMergeWithNullAnalyses(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).rollup(false).build();
        Assert.assertEquals((Object)analysis1, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, null, aggregatorMergeStrategy));
        Assert.assertEquals((Object)analysis2, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(null, analysis2, aggregatorMergeStrategy));
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), null, null, (AggregatorMergeStrategy)aggregatorMergeStrategy));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testProjections(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).projection("channel_sum", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 100)).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).projection("channel_sum", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 200)).build();
        SegmentAnalysis expected = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").projection("channel_sum", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 300)).build();
        Assert.assertEquals((Object)expected, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, aggregatorMergeStrategy));
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testProjectionsWithNull(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).projection("channel_sum", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 100)).build();
        SegmentAnalysis analysis1NullProjection = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).projection("channel_sum", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 200)).build();
        SegmentAnalysis analysis2NullProjection = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).build();
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1NullProjection, analysis2, aggregatorMergeStrategy).getProjections());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2NullProjection, aggregatorMergeStrategy).getProjections());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1NullProjection, analysis2NullProjection, aggregatorMergeStrategy).getProjections());
    }

    @EnumSource(value=AggregatorMergeStrategy.class)
    @ParameterizedTest(name="{index}: with AggregatorMergeStrategy {0}")
    public void testProjectionsWithConflict(AggregatorMergeStrategy aggregatorMergeStrategy) {
        SegmentAnalysis analysis1 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID1).projection("channel_sum", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 100)).projection("channel_sum_1", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 100)).projection("conflict_projection", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 100)).build();
        SegmentAnalysis analysis2 = new SegmentAnalysis.Builder(TEST_SEGMENT_ID2).projection("channel_sum", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 200)).projection("channel_sum_2", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_DAILY, 200)).projection("conflict_projection", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_DAILY, 200)).build();
        SegmentAnalysis expectedStrict = new SegmentAnalysis.Builder("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged").projection("channel_sum", new AggregateProjectionMetadata(PROJECTION_CHANNEL_ADDED_HOURLY, 300)).build();
        Assert.assertEquals((Object)expectedStrict, (Object)SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, aggregatorMergeStrategy));
    }

    private static SegmentAnalysis mergeWithStrategy(SegmentAnalysis analysis1, SegmentAnalysis analysis2, AggregatorMergeStrategy strategy) {
        return SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)strategy));
    }

    private static SegmentAnalysis mergeStrict(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, AggregatorMergeStrategy.STRICT);
    }

    private static SegmentAnalysis mergeLenient(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, AggregatorMergeStrategy.LENIENT);
    }

    private static SegmentAnalysis mergeEarliest(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, AggregatorMergeStrategy.EARLIEST);
    }

    private static SegmentAnalysis mergeLatest(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChestTest.mergeWithStrategy(analysis1, analysis2, AggregatorMergeStrategy.LATEST);
    }
}

