/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.query.lookup.LookupConfig;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LookupConfigTest {
    ObjectMapper mapper = TestHelper.makeJsonMapper();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSerDesr() throws IOException {
        LookupConfig lookupConfig = new LookupConfig(this.temporaryFolder.newFile().getAbsolutePath());
        Assert.assertEquals((Object)lookupConfig, (Object)this.mapper.readerFor(LookupConfig.class).readValue(this.mapper.writeValueAsString((Object)lookupConfig)));
    }

    @Test
    public void testSerdeWithNonDefaults() throws Exception {
        String json = "{\n  \"enableLookupSyncOnStartup\": false,\n  \"snapshotWorkingDir\": \"/tmp\",\n  \"numLookupLoadingThreads\": 4,\n  \"coordinatorFetchRetries\": 4,\n  \"lookupStartRetries\": 4,\n  \"coordinatorRetryDelay\": 100 \n}\n";
        LookupConfig config = (LookupConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(json, LookupConfig.class)), LookupConfig.class);
        Assert.assertEquals((Object)"/tmp", (Object)config.getSnapshotWorkingDir());
        Assert.assertEquals((Object)false, (Object)config.getEnableLookupSyncOnStartup());
        Assert.assertEquals((long)4L, (long)config.getNumLookupLoadingThreads());
        Assert.assertEquals((long)4L, (long)config.getCoordinatorFetchRetries());
        Assert.assertEquals((long)4L, (long)config.getLookupStartRetries());
        Assert.assertEquals((long)100L, (long)config.getCoordinatorRetryDelay());
    }
}

