/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import java.math.BigDecimal;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.groupby.having.HavingSpecMetricComparator;
import org.junit.Assert;
import org.junit.Test;

public class HavingSpecMetricComparatorTest {
    @Test
    public void testLongRegex() {
        Assert.assertTrue((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("1").matches());
        Assert.assertTrue((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("12").matches());
        Assert.assertFalse((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("1.").matches());
        Assert.assertFalse((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("1.2").matches());
        Assert.assertFalse((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("1.23").matches());
        Assert.assertFalse((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("1E5").matches());
        Assert.assertFalse((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("1.23E5").matches());
        Assert.assertFalse((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("").matches());
        Assert.assertFalse((boolean)HavingSpecMetricComparator.LONG_PAT.matcher("xyz").matches());
    }

    @Test
    public void testCompareDoubleToLongWithNanReturns1() {
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)1L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)-1L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)0L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)1L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)-1L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NaN, (long)0L));
    }

    @Test
    public void testCompareDoubleToLongWithInfinityReturns1() {
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)1L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)-1L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)0L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)1L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)-1L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.POSITIVE_INFINITY, (long)0L));
    }

    @Test
    public void testCompareDoubleToLongWithInfinityReturnsNegative1() {
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)1L));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)-1L));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)0L));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)1L));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)-1L));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)Double.NEGATIVE_INFINITY, (long)0L));
    }

    @Test
    public void testCompareDoubleToLongWithNumbers() {
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)1.000001, (long)1L));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)0.999999, (long)1L));
        Assert.assertEquals((long)0L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)10.0, (long)10L));
        Assert.assertEquals((long)0L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)0.0, (long)0L));
        Assert.assertEquals((long)0L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)-0.0, (long)0L));
        Assert.assertEquals((long)1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)9.223372036854776E18, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)HavingSpecMetricComparator.compareDoubleToLong((double)-9.223372036854776E18, (long)Long.MIN_VALUE));
    }

    @Test
    public void testNullValue() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> HavingSpecMetricComparator.compare((String)"metric", null, null, (Object)10));
        Assert.assertEquals((Object)DruidException.Category.DEFENSIVE, (Object)e.getCategory());
    }

    @Test
    public void testNullMetricValue() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> HavingSpecMetricComparator.compare((String)"metric", (Number)10, null, null));
        Assert.assertEquals((Object)DruidException.Category.DEFENSIVE, (Object)e.getCategory());
    }

    @Test
    public void testUnsupportedNumberTypeLongValue() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> HavingSpecMetricComparator.compare((String)"metric", (Number)BigDecimal.valueOf(10L), null, (Object)10));
        Assert.assertEquals((Object)DruidException.Category.DEFENSIVE, (Object)e.getCategory());
    }

    @Test
    public void testUnsupportedNumberTypeDoubleValue() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> HavingSpecMetricComparator.compare((String)"metric", (Number)BigDecimal.valueOf(10L), null, (Object)10.0));
        Assert.assertEquals((Object)DruidException.Category.DEFENSIVE, (Object)e.getCategory());
    }
}

