/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class GroupByQueryTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market", ColumnType.STRING_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(100))).build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Query serdeQuery = (Query)JSON_MAPPER.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testGetRequiredColumns() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v", "\"other\"", ColumnType.STRING, ExprMacroTable.nil())}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), DefaultDimensionSpec.of((String)"v")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(100))).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"quality", (Object)"other", (Object)"index"), (Object)query.getRequiredColumns());
    }

    @Test
    public void testRowOrderingMixTypes() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("dummy").setGranularity(Granularities.ALL).setInterval("2000/2001").addDimension((DimensionSpec)new DefaultDimensionSpec("foo", "foo", ColumnType.LONG)).addDimension((DimensionSpec)new DefaultDimensionSpec("bar", "bar", ColumnType.FLOAT)).addDimension((DimensionSpec)new DefaultDimensionSpec("baz", "baz", ColumnType.STRING)).addDimension((DimensionSpec)new DefaultDimensionSpec("bat", "bat", ColumnType.STRING_ARRAY)).build();
        Ordering rowOrdering = query.getRowOrdering(false);
        int compare = rowOrdering.compare((Object)ResultRow.of((Object[])new Object[]{1, Float.valueOf(1.0f), "a", new Object[]{"1", "2"}}), (Object)ResultRow.of((Object[])new Object[]{1L, 1.0, "b", new Object[]{"3"}}));
        Assert.assertEquals((long)-1L, (long)compare);
    }

    @Test
    public void testSegmentLookUpForNestedQueries() {
        MultipleIntervalSegmentSpec innerQuerySegmentSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-11-07/2011-11-08")));
        MultipleIntervalSegmentSpec outerQuerySegmentSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-11-04/2011-11-08")));
        List<CountAggregatorFactory> aggs = Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT);
        GroupByQuery innerQuery = GroupByQuery.builder().setDataSource("blah").setInterval((QuerySegmentSpec)innerQuerySegmentSpec).setGranularity(Granularities.DAY).setAggregatorSpecs(aggs).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)innerQuery).setInterval((QuerySegmentSpec)outerQuerySegmentSpec).setAggregatorSpecs(aggs).setGranularity(Granularities.DAY).build();
        ExecutionVertex ev = ExecutionVertex.of((Query)query);
        Assert.assertEquals((Object)innerQuerySegmentSpec, (Object)ev.getEffectiveQuerySegmentSpec());
    }

    @Test
    public void testAsCursorBuildSpecAllGranularity() {
        VirtualColumns virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(placement, 'foo')", ColumnType.STRING, ExprMacroTable.nil())});
        LongSumAggregatorFactory longSum = new LongSumAggregatorFactory("idx", "index");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market", ColumnType.STRING_ARRAY), new DefaultDimensionSpec("v0", "v0", ColumnType.STRING)}).setVirtualColumns(virtualColumns).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, longSum}).setGranularity(Granularities.ALL).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(100))).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        Assert.assertEquals(QueryRunnerTestHelper.FIRST_TO_THIRD.getIntervals().get(0), (Object)buildSpec.getInterval());
        Assert.assertEquals((Object)ImmutableList.of((Object)"quality", (Object)"market", (Object)"v0"), (Object)buildSpec.getGroupingColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)QueryRunnerTestHelper.ROWS_COUNT, (Object)longSum), (Object)buildSpec.getAggregators());
        Assert.assertEquals((Object)virtualColumns, (Object)buildSpec.getVirtualColumns());
        Assert.assertEquals(List.of(), (Object)buildSpec.getPreferredOrdering());
    }

    @Test
    public void testAsCursorBuildSpecDayGranularity() {
        VirtualColumns virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(placement, 'foo')", ColumnType.STRING, ExprMacroTable.nil())});
        LongSumAggregatorFactory longSum = new LongSumAggregatorFactory("idx", "index");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market", ColumnType.STRING_ARRAY), new DefaultDimensionSpec("v0", "v0", ColumnType.STRING)}).setVirtualColumns(virtualColumns).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, longSum}).setGranularity(Granularities.DAY).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(100))).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        Assert.assertEquals(QueryRunnerTestHelper.FIRST_TO_THIRD.getIntervals().get(0), (Object)buildSpec.getInterval());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__virtualGranularity", (Object)"quality", (Object)"market", (Object)"v0"), (Object)buildSpec.getGroupingColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)QueryRunnerTestHelper.ROWS_COUNT, (Object)longSum), (Object)buildSpec.getAggregators());
        Assert.assertEquals((Object)VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)query.getGranularity(), (String)"__virtualGranularity"), virtualColumns.getVirtualColumns()[0]}), (Object)buildSpec.getVirtualColumns());
        Assert.assertEquals((Object)Cursors.ascendingTimeOrder(), (Object)buildSpec.getPreferredOrdering());
    }

    @Test
    public void testAsCursorBuildSpecDayGranularityNameConflict() {
        VirtualColumns virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("__virtualGranularity", "concat(placement, 'foo')", ColumnType.STRING, ExprMacroTable.nil())});
        LongSumAggregatorFactory longSum = new LongSumAggregatorFactory("idx", "index");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market", ColumnType.STRING_ARRAY), new DefaultDimensionSpec("v0", "v0", ColumnType.STRING)}).setVirtualColumns(virtualColumns).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, longSum}).setGranularity(Granularities.DAY).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(100))).build();
        CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null);
        Assert.assertEquals(QueryRunnerTestHelper.FIRST_TO_THIRD.getIntervals().get(0), (Object)buildSpec.getInterval());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__virtualGranularity0", (Object)"quality", (Object)"market", (Object)"v0"), (Object)buildSpec.getGroupingColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)QueryRunnerTestHelper.ROWS_COUNT, (Object)longSum), (Object)buildSpec.getAggregators());
        Assert.assertEquals((Object)VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)query.getGranularity(), (String)"__virtualGranularity0"), virtualColumns.getVirtualColumns()[0]}), (Object)buildSpec.getVirtualColumns());
        Assert.assertEquals((Object)Cursors.ascendingTimeOrder(), (Object)buildSpec.getPreferredOrdering());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(GroupByQuery.class).usingGetClass().suppress(new Warning[]{Warning.NULL_FIELDS, Warning.NONFINAL_FIELDS}).withIgnoredFields(new String[]{"canDoLimitPushDown", "forceLimitPushDown", "postProcessingFn", "resultRowSignature", "universalTimestamp", "groupingColumns"}).verify();
    }
}

