/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ComplexDimensionGroupByQueryTest {
    private final QueryContexts.Vectorize vectorize;
    private final AggregationTestHelper helper;
    private final List<Segment> segments;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    public ComplexDimensionGroupByQueryTest(GroupByQueryConfig config, String vectorize) {
        this.vectorize = QueryContexts.Vectorize.fromString((String)vectorize);
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.emptyList(), config, this.tempFolder);
        Sequence rows = Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "abc")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "abc")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "def")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "abc")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "ghi")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "def")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "abc")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "pqr")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "xyz")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "foo")}, (Object)new Object[]{new SerializablePairLongString(Long.valueOf(1L), "bar")}));
        RowSignature rowSignature = RowSignature.builder().add("pair", ColumnType.ofComplex((String)"serializablePairLongString")).build();
        this.segments = Collections.singletonList(new RowBasedSegment(rows, columnName -> {
            int columnNumber = rowSignature.indexOf(columnName);
            return row -> columnNumber >= 0 ? row[columnNumber] : null;
        }, rowSignature));
    }

    @Parameterized.Parameters(name="config = {0}, vectorize = {1}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            for (String vectorize : new String[]{"false", "force"}) {
                constructors.add(new Object[]{config, vectorize});
            }
        }
        return constructors;
    }

    public Map<String, Object> getContext() {
        return ImmutableMap.of((Object)"vectorize", (Object)this.vectorize.toString(), (Object)"vectorizeVirtualColumns", (Object)"true");
    }

    @Test
    public void testGroupByOnPairClass() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("pair", "pair", ColumnType.ofComplex((String)"serializablePairLongString"))}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        if (this.vectorize == QueryContexts.Vectorize.FORCE) {
            Assert.assertThrows(RuntimeException.class, () -> this.helper.runQueryOnSegmentsObjs(this.segments, groupQuery).toList());
        } else {
            List resultRows = this.helper.runQueryOnSegmentsObjs(this.segments, groupQuery).toList();
            Assert.assertArrayEquals((Object[])new ResultRow[]{ResultRow.of((Object[])new Object[]{new SerializablePairLongString(Long.valueOf(1L), "abc"), 4L}), ResultRow.of((Object[])new Object[]{new SerializablePairLongString(Long.valueOf(1L), "bar"), 1L}), ResultRow.of((Object[])new Object[]{new SerializablePairLongString(Long.valueOf(1L), "def"), 2L}), ResultRow.of((Object[])new Object[]{new SerializablePairLongString(Long.valueOf(1L), "foo"), 1L}), ResultRow.of((Object[])new Object[]{new SerializablePairLongString(Long.valueOf(1L), "ghi"), 1L}), ResultRow.of((Object[])new Object[]{new SerializablePairLongString(Long.valueOf(1L), "pqr"), 1L}), ResultRow.of((Object[])new Object[]{new SerializablePairLongString(Long.valueOf(1L), "xyz"), 1L})}, (Object[])resultRows.toArray());
        }
    }
}

