/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.lookup.ImmutableLookupMap;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.Utf8ValueSetIndexes;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class InDimFilterTest
extends InitializedNullHandlingTest {
    private ObjectMapper mapper = new DefaultObjectMapper();
    private final String serializedFilter = "{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"]}";
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);

    @Test
    public void testDeserialization() throws IOException {
        InDimFilter actualInDimFilter = (InDimFilter)this.mapper.readerFor(DimFilter.class).readValue("{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"]}");
        InDimFilter expectedInDimFilter = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        Assert.assertEquals((Object)expectedInDimFilter, (Object)actualInDimFilter);
    }

    @Test
    public void testSerialization() throws IOException {
        InDimFilter dimInFilter = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        String actualSerializedFilter = this.mapper.writeValueAsString((Object)dimInFilter);
        Assert.assertEquals((Object)"{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"]}", (Object)actualSerializedFilter);
    }

    @Test
    public void testGetValuesWithValuesSetOfNonEmptyStringsUseTheGivenSet() {
        InDimFilter.ValuesSet values = new InDimFilter.ValuesSet();
        values.addAll(Arrays.asList("v1", "v2", "v3"));
        InDimFilter filter = new InDimFilter("dim", (Set)values);
        Assert.assertSame((Object)values, (Object)filter.getValues());
    }

    @Test
    public void testGetValuesWithValuesSetIncludingEmptyString() {
        InDimFilter.ValuesSet values = InDimFilter.ValuesSet.copyOf((Collection)ImmutableSet.of((Object)"v1", (Object)"", (Object)"v3"));
        InDimFilter filter = new InDimFilter("dim", (Set)values);
        Assert.assertSame((Object)values, (Object)filter.getValues());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"v1", "", "v3"}), (Object)filter.getValues());
    }

    @Test
    public void testGetCacheKeyReturningSameKeyForValuesOfDifferentOrders() {
        InDimFilter dimFilter1 = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v1", (Object)"v2"), null);
        InDimFilter dimFilter2 = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v2", (Object)"v1"), null);
        Assert.assertArrayEquals((byte[])dimFilter1.getCacheKey(), (byte[])dimFilter2.getCacheKey());
    }

    @Test
    public void testGetCacheKeyForNullVsEmptyString() {
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList(null, "abc"), null);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Arrays.asList("", "abc"), null);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyReturningSameKeyForSetsOfDifferentTypesAndComparators() {
        TreeSet<String> reverseOrderSet = new TreeSet<String>(Ordering.natural().reversed());
        InDimFilter dimFilter1 = new InDimFilter("dim", (Set)Sets.newTreeSet(Arrays.asList("v1", "v2")));
        InDimFilter dimFilter2 = new InDimFilter("dim", (Set)Sets.newHashSet((Object[])new String[]{"v2", "v1"}));
        InDimFilter dimFilter3 = new InDimFilter("dim", (Set)ImmutableSortedSet.copyOf(Arrays.asList("v2", "v1")));
        reverseOrderSet.addAll(Arrays.asList("v1", "v2"));
        InDimFilter dimFilter4 = new InDimFilter("dim", reverseOrderSet);
        Assert.assertArrayEquals((byte[])dimFilter1.getCacheKey(), (byte[])dimFilter2.getCacheKey());
        Assert.assertArrayEquals((byte[])dimFilter1.getCacheKey(), (byte[])dimFilter3.getCacheKey());
        Assert.assertArrayEquals((byte[])dimFilter1.getCacheKey(), (byte[])dimFilter4.getCacheKey());
    }

    @Test
    public void testGetCacheKeyDifferentKeysForListOfStringsAndSingleStringOfLists() {
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Collections.singletonList("good,bad"), null);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyDifferentKeysForNullAndFourZeroChars() {
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList(null, "abc"), null);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Arrays.asList("\u0000\u0000\u0000\u0000", "abc"), null);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyDifferentKeysWhenStringBoundariesMove() {
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList("bar", "foo"), null);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Arrays.asList("barf", "oo"), null);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyDifferentKeysForListOfStringsAndSingleStringOfListsWithExtractFn() {
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        InDimFilter inDimFilter1 = new InDimFilter("dimTest", Arrays.asList("good", "bad"), (ExtractionFn)regexFn);
        InDimFilter inDimFilter2 = new InDimFilter("dimTest", Collections.singletonList("good,bad"), (ExtractionFn)regexFn);
        Assert.assertFalse((boolean)Arrays.equals(inDimFilter1.getCacheKey(), inDimFilter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyNullValue() throws IOException {
        InDimFilter inDimFilter = (InDimFilter)this.mapper.readValue("{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[null]}", InDimFilter.class);
        Assert.assertNotNull((Object)inDimFilter.getCacheKey());
    }

    @Test
    public void testGetCacheKeyReturningDifferentKeysWithAndWithoutNull() {
        InDimFilter filter1 = new InDimFilter("dim", Arrays.asList("val", null), null);
        InDimFilter filter2 = new InDimFilter("dim", Collections.singletonList("val"), null);
        Assert.assertFalse((boolean)Arrays.equals(filter1.getCacheKey(), filter2.getCacheKey()));
    }

    @Test
    public void testGetCacheKeyReturningCachedCacheKey() {
        InDimFilter filter = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v1", (Object)"v2"), null);
        Assert.assertSame((Object)filter.getCacheKey(), (Object)filter.getCacheKey());
    }

    @Test
    public void testGetDimensionRangeSetValuesOfDifferentOrdersReturningSameResult() {
        InDimFilter dimFilter1 = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v1", (Object)"v2", (Object)"v3"), null);
        InDimFilter dimFilter2 = new InDimFilter("dim", (Collection)ImmutableList.of((Object)"v3", (Object)"v2", (Object)"v1"), null);
        Assert.assertEquals((Object)dimFilter1.getDimensionRangeSet("dim"), (Object)dimFilter2.getDimensionRangeSet("dim"));
    }

    @Test
    public void testOptimizeSingleValueInToSelector() {
        InDimFilter filter = new InDimFilter("dim", Collections.singleton("v1"), null);
        Assert.assertEquals((Object)new SelectorDimFilter("dim", "v1", null), (Object)filter.optimize(false));
        Assert.assertEquals((Object)new SelectorDimFilter("dim", "v1", null), (Object)filter.optimize(true));
    }

    @Test
    public void testOptimizeLookup_simple() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("abc", "def");
        lookupMap.put("foo", "bar");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, false, null, null, Boolean.valueOf(true));
        Assert.assertEquals((String)"reverse lookup bar", (Object)Sets.newHashSet((Object[])new String[]{"foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup bar (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup baz", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup baz (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup [def, bar, baz]", (Object)Sets.newHashSet((Object[])new String[]{"abc", "foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup [def, bar, baz] (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertNull((String)"reverse lookup null", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup null (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup empty string", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup empty string (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testOptimizeLookup_replaceMissingValueWith() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("abc", "def");
        lookupMap.put("foo", "bar");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, false, "baz", null, Boolean.valueOf(true));
        Assert.assertEquals((String)"reverse lookup bar", (Object)Sets.newHashSet((Object[])new String[]{"foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup bar (includeUnknown)", (Object)Sets.newHashSet((Object[])new String[]{"foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertNull((String)"reverse lookup baz", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup baz (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertNull((String)"reverse lookup [def, bar, baz]", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup [def, bar, baz] (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup null", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup null (includeUnknown)", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup empty string", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup empty string (includeUnknown)", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testOptimizeLookup_replaceMissingValue_containingNull() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("nv", null);
        lookupMap.put("abc", "def");
        lookupMap.put("foo", "bar");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, false, "bar", null, Boolean.valueOf(true));
        Assert.assertNull((String)"reverse lookup bar", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup bar (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup baz", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup baz (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertNull((String)"reverse lookup [def, bar, baz]", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup [def, bar, baz] (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup null", Collections.singleton("nv"), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup null (includeUnknown)", Collections.singleton("nv"), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup empty string", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup empty string (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testOptimizeLookup_replaceMissingValue_containingEmptyString() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("emptystring", "");
        lookupMap.put("abc", "def");
        lookupMap.put("foo", "bar");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, false, "bar", null, Boolean.valueOf(true));
        Assert.assertNull((String)"reverse lookup bar", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup bar (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup baz", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup baz (includeUnknown)", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertNull((String)"reverse lookup [def, bar, baz]", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup [def, bar, baz] (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup null", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup null (includeUnknown)", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup empty string", Collections.singleton("emptystring"), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup empty string (includeUnknown)", Collections.singleton("emptystring"), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testOptimizeLookup_containingEmptyString() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("emptystring", "");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, false, null, null, Boolean.valueOf(true));
        Assert.assertEquals((String)"reverse lookup empty string", Collections.singleton("emptystring"), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup empty string (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertNull((String)"reverse lookup null", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup null (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testOptimizeLookup_emptyStringKey() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("", "bar");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, false, null, null, Boolean.valueOf(true));
        Assert.assertEquals((String)"reverse lookup bar", Collections.singleton(""), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup bar (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertNull((String)"reverse lookup null", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup null (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testOptimizeLookup_retainMissingValue() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("abc", "def");
        lookupMap.put("foo", "bar");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, true, null, null, Boolean.valueOf(true));
        Assert.assertEquals((String)"reverse lookup bar", (Object)Sets.newHashSet((Object[])new String[]{"bar", "foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup bar (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup baz", Collections.singleton("baz"), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup baz (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup [def, bar, baz]", (Object)Sets.newHashSet((Object[])new String[]{"abc", "bar", "baz", "def", "foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup [def, bar, baz] (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup null", Collections.singleton(null), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup null (includeUnknown)", Collections.singleton(null), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup empty string", Collections.singleton(""), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup empty string (includeUnknown)", null, (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testOptimizeLookup_injective() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("abc", "def");
        lookupMap.put("foo", "bar");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(true, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, false, null, null, Boolean.valueOf(true));
        Assert.assertEquals((String)"reverse lookup bar", (Object)Sets.newHashSet((Object[])new String[]{"foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup bar (includeUnknown)", (Object)Sets.newHashSet((Object[])new String[]{"foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("bar"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup baz", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup baz (includeUnknown)", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup [def, bar, baz]", (Object)Sets.newHashSet((Object[])new String[]{"abc", "foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup [def, bar, baz] (includeUnknown)", (Object)Sets.newHashSet((Object[])new String[]{"abc", "foo"}), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Arrays.asList("def", "bar", "baz"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup null", Collections.singleton(null), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup null (includeUnknown)", Collections.singleton(null), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup empty string", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertEquals((String)"reverse lookup empty string (includeUnknown)", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testOptimizeLookup_nullKey() {
        HashMap<Object, String> lookupMap = new HashMap<Object, String>();
        lookupMap.put(null, "nv");
        LookupExtractor lookup = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        LookupExtractionFn extractionFn = new LookupExtractionFn(lookup, false, null, null, Boolean.valueOf(true));
        Assert.assertEquals((String)"reverse lookup nv", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("nv"), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup nv (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton("nv"), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertNull((String)"reverse lookup null", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup null (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(null), (ExtractionFn)extractionFn), (boolean)true));
        Assert.assertEquals((String)"reverse lookup empty string", Collections.emptySet(), (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)false));
        Assert.assertNull((String)"reverse lookup empty string (includeUnknown)", (Object)InDimFilter.optimizeLookup((InDimFilter)new InDimFilter("dim", Collections.singleton(""), (ExtractionFn)extractionFn), (boolean)true));
    }

    @Test
    public void testContainsNullWhenValuesSetIsTreeSet() {
        TreeSet<String> values = new TreeSet<String>();
        values.add("foo");
        values.add("bar");
        InDimFilter filter = new InDimFilter("dim", values, null);
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("dim", null);
        RowBasedColumnSelectorFactory columnSelectorFactory = RowBasedColumnSelectorFactory.create((RowAdapter)RowAdapters.standardRow(), () -> new MapBasedRow(0L, row), (ColumnInspector)RowSignature.builder().add("dim", ColumnType.STRING).build(), (boolean)true, (boolean)false);
        ValueMatcher matcher = filter.toFilter().makeMatcher((ColumnSelectorFactory)columnSelectorFactory);
        Assert.assertFalse((boolean)matcher.matches(false));
        row.put("dim", "foo");
        Assert.assertTrue((boolean)matcher.matches(false));
        row.put("dim", "fox");
        Assert.assertFalse((boolean)matcher.matches(false));
    }

    @Test
    public void testUsesUtf8SetIndex() {
        Filter inFilter = new InDimFilter("dim0", (Set)ImmutableSet.of((Object)"v1", (Object)"v2")).toFilter();
        ColumnIndexSelector indexSelector = (ColumnIndexSelector)Mockito.mock(ColumnIndexSelector.class);
        ColumnIndexSupplier indexSupplier = (ColumnIndexSupplier)Mockito.mock(ColumnIndexSupplier.class);
        Utf8ValueSetIndexes valueIndexes = (Utf8ValueSetIndexes)Mockito.mock(Utf8ValueSetIndexes.class);
        BitmapColumnIndex bitmapColumnIndex = (BitmapColumnIndex)Mockito.mock(BitmapColumnIndex.class);
        InDimFilter.ValuesSet expectedValuesSet = new InDimFilter.ValuesSet();
        expectedValuesSet.addAll(Arrays.asList("v1", "v2"));
        Mockito.when((Object)indexSelector.getIndexSupplier("dim0")).thenReturn((Object)indexSupplier);
        Mockito.when((Object)((Utf8ValueSetIndexes)indexSupplier.as(Utf8ValueSetIndexes.class))).thenReturn((Object)valueIndexes);
        Mockito.when((Object)valueIndexes.forSortedValuesUtf8(expectedValuesSet.toUtf8())).thenReturn((Object)bitmapColumnIndex);
        BitmapColumnIndex retVal = inFilter.getBitmapColumnIndex(indexSelector);
        Assert.assertSame((String)"inFilter returns the intended bitmapColumnIndex", (Object)bitmapColumnIndex, (Object)retVal);
    }

    @Test
    public void testUsesStringSetIndex() {
        Filter inFilter = new InDimFilter("dim0", (Set)ImmutableSet.of((Object)"v1", (Object)"v2")).toFilter();
        ColumnIndexSelector indexSelector = (ColumnIndexSelector)Mockito.mock(ColumnIndexSelector.class);
        ColumnIndexSupplier indexSupplier = (ColumnIndexSupplier)Mockito.mock(ColumnIndexSupplier.class);
        StringValueSetIndexes valueIndex = (StringValueSetIndexes)Mockito.mock(StringValueSetIndexes.class);
        BitmapColumnIndex bitmapColumnIndex = (BitmapColumnIndex)Mockito.mock(BitmapColumnIndex.class);
        InDimFilter.ValuesSet expectedValuesSet = new InDimFilter.ValuesSet();
        expectedValuesSet.addAll(Arrays.asList("v1", "v2"));
        Mockito.when((Object)indexSelector.getIndexSupplier("dim0")).thenReturn((Object)indexSupplier);
        Mockito.when((Object)((Utf8ValueSetIndexes)indexSupplier.as(Utf8ValueSetIndexes.class))).thenReturn(null);
        Mockito.when((Object)((StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class))).thenReturn((Object)valueIndex);
        Mockito.when((Object)valueIndex.forSortedValues((SortedSet)expectedValuesSet)).thenReturn((Object)bitmapColumnIndex);
        BitmapColumnIndex retVal = inFilter.getBitmapColumnIndex(indexSelector);
        Assert.assertSame((String)"inFilter returns the intended bitmapColumnIndex", (Object)bitmapColumnIndex, (Object)retVal);
    }
}

