/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.junit.Assert;
import org.junit.Test;

public class RegexDimExtractionFnTest {
    private static final String[] PATHS = new String[]{"/druid/prod/historical", "/druid/prod/broker", "/druid/prod/coordinator", "/druid/demo/historical", "/druid/demo/broker", "/druid/demo/coordinator", "/dash/aloe", "/dash/baloo"};
    private static final String[] TEST_STRINGS = new String[]{"apple", "awesome", "asylum", "business", "be", "cool"};

    @Test
    public void testPathExtraction() {
        String regex = "/([^/]+)/";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(false), null);
        LinkedHashSet<String> extracted = new LinkedHashSet<String>();
        for (String path : PATHS) {
            extracted.add(extractionFn.apply(path));
        }
        LinkedHashSet expected = Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"druid", (Object)"dash"));
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testDeeperPathExtraction() {
        String regex = "^/([^/]+/[^/]+)(/|$)";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(false), null);
        LinkedHashSet<String> extracted = new LinkedHashSet<String>();
        for (String path : PATHS) {
            extracted.add(extractionFn.apply(path));
        }
        LinkedHashSet expected = Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"druid/prod", (Object)"druid/demo", (Object)"dash/aloe", (Object)"dash/baloo"));
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testIndexZero() {
        String regex = "/([^/]{4})/";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Integer.valueOf(0), Boolean.valueOf(true), null);
        LinkedHashSet<String> extracted = new LinkedHashSet<String>();
        for (String path : PATHS) {
            extracted.add(extractionFn.apply(path));
        }
        LinkedHashSet expected = Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"/prod/", (Object)"/demo/", (Object)"/dash/"));
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testIndexTwo() {
        String regex = "^/([^/]+)/([^/]+)";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Integer.valueOf(2), Boolean.valueOf(true), null);
        LinkedHashSet<String> extracted = new LinkedHashSet<String>();
        for (String path : PATHS) {
            extracted.add(extractionFn.apply(path));
        }
        LinkedHashSet expected = Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"prod", (Object)"demo", (Object)"aloe", (Object)"baloo"));
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testStringExtraction() {
        String regex = "(.)";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(false), null);
        LinkedHashSet<String> extracted = new LinkedHashSet<String>();
        for (String testString : TEST_STRINGS) {
            extracted.add(extractionFn.apply(testString));
        }
        LinkedHashSet expected = Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testNullAndEmpty() {
        String regex = "(.*)/.*/.*";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(false), null);
        Assert.assertEquals((Object)"", (Object)extractionFn.apply(""));
        Assert.assertNull((Object)extractionFn.apply(null));
        Assert.assertEquals((Object)"", (Object)extractionFn.apply("/a/b"));
    }

    @Test
    public void testMissingValueReplacementWhenPatternDoesNotMatchNull() {
        String regex = "(bob)";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(true), "NO MATCH");
        Assert.assertEquals((Object)"NO MATCH", (Object)extractionFn.apply(""));
        Assert.assertEquals((Object)"NO MATCH", (Object)extractionFn.apply(null));
        Assert.assertEquals((Object)"NO MATCH", (Object)extractionFn.apply("abc"));
        Assert.assertEquals((Object)"bob", (Object)extractionFn.apply("bob"));
    }

    @Test
    public void testMissingValueReplacementWhenPatternMatchesNull() {
        String regex = "^()$";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(true), "NO MATCH");
        Assert.assertEquals((Object)"", (Object)extractionFn.apply(""));
        Assert.assertEquals((Object)"NO MATCH", (Object)extractionFn.apply(null));
        Assert.assertEquals((Object)"NO MATCH", (Object)extractionFn.apply("abc"));
    }

    @Test
    public void testMissingValueReplacementToEmpty() {
        String regex = "(bob)";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(true), "");
        Assert.assertEquals((Object)"", (Object)extractionFn.apply(null));
        Assert.assertEquals((Object)"", (Object)extractionFn.apply(""));
        Assert.assertEquals((Object)"", (Object)extractionFn.apply("abc"));
        Assert.assertEquals((Object)"", (Object)extractionFn.apply("123"));
        Assert.assertEquals((Object)"bob", (Object)extractionFn.apply("bobby"));
    }

    @Test
    public void testMissingValueReplacement() {
        String regex = "(a\\w*)";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(true), "foobar");
        LinkedHashSet<String> extracted = new LinkedHashSet<String>();
        for (String testString : TEST_STRINGS) {
            extracted.add(extractionFn.apply(testString));
        }
        LinkedHashSet expected = Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"apple", (Object)"awesome", (Object)"asylum", (Object)"foobar"));
        Assert.assertEquals((Object)expected, extracted);
        byte[] cacheKey = extractionFn.getCacheKey();
        byte[] expectedCacheKey = new byte[]{1, 40, 97, 92, 119, 42, 41, -1, 0, 0, 0, 1, 102, 111, 111, 98, 97, 114, -1, 1};
        Assert.assertArrayEquals((byte[])expectedCacheKey, (byte[])cacheKey);
        RegexDimExtractionFn nullExtractionFn = new RegexDimExtractionFn(regex, Boolean.valueOf(true), null);
        LinkedHashSet<String> extracted2 = new LinkedHashSet<String>();
        for (String testString : TEST_STRINGS) {
            extracted2.add(nullExtractionFn.apply(testString));
        }
        LinkedHashSet expected2 = Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"apple", (Object)"awesome", (Object)"asylum"));
        expected2.add(null);
        Assert.assertEquals((Object)expected2, extracted2);
        cacheKey = nullExtractionFn.getCacheKey();
        expectedCacheKey = new byte[]{1, 40, 97, 92, 119, 42, 41, -1, 0, 0, 0, 1, -1, 1};
        Assert.assertArrayEquals((byte[])expectedCacheKey, (byte[])cacheKey);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"regex\", \"expr\" : \".(...)?\" , \"replaceMissingValue\": true, \"replaceMissingValueWith\":\"foobar\"}";
        RegexDimExtractionFn extractionFn = (RegexDimExtractionFn)objectMapper.readValue("{ \"type\" : \"regex\", \"expr\" : \".(...)?\" , \"replaceMissingValue\": true, \"replaceMissingValueWith\":\"foobar\"}", ExtractionFn.class);
        Assert.assertEquals((Object)".(...)?", (Object)extractionFn.getExpr());
        Assert.assertTrue((boolean)extractionFn.isReplaceMissingValue());
        Assert.assertEquals((Object)"foobar", (Object)extractionFn.getReplaceMissingValueWith());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }
}

