/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.IPv4AddressStringifyExprMacro;
import org.apache.druid.query.expression.MacroTestBase;
import org.junit.Assert;
import org.junit.Test;

public class IPv4AddressStringifyExprMacroTest
extends MacroTestBase {
    private static final Expr VALID = ExprEval.of((long)3232235521L).toExpr();
    private static final String EXPECTED = "192.168.0.1";

    public IPv4AddressStringifyExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new IPv4AddressStringifyExprMacro());
    }

    @Test
    public void testTooFewArgs() {
        this.expectException(IllegalArgumentException.class, "requires 1 argument");
        this.apply(Collections.emptyList());
    }

    @Test
    public void testTooManyArgs() {
        this.expectException(IllegalArgumentException.class, "requires 1 argument");
        this.apply(Arrays.asList(VALID, VALID));
    }

    @Test
    public void testNullLongArg() {
        Expr nullNumeric = ExprEval.ofLong(null).toExpr();
        Assert.assertNull((Object)this.eval(nullNumeric));
    }

    @Test
    public void testInvalidArgType() {
        Expr longArray = ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).toExpr();
        Assert.assertNull((Object)this.eval(longArray));
    }

    @Test
    public void testInvalidLongArgTooSmall() {
        Expr tooSmall = ExprEval.ofLong((Number)-1L).toExpr();
        Assert.assertNull((Object)this.eval(tooSmall));
    }

    @Test
    public void testValidLongArgLowest() {
        Expr tooSmall = ExprEval.ofLong((Number)0L).toExpr();
        Assert.assertEquals((Object)"0.0.0.0", (Object)this.eval(tooSmall));
    }

    @Test
    public void testValidLongArg() {
        Assert.assertEquals((Object)EXPECTED, (Object)this.eval(VALID));
    }

    @Test
    public void testValidLongArgHighest() {
        Expr tooSmall = ExprEval.ofLong((Number)0xFFFFFFFFL).toExpr();
        Assert.assertEquals((Object)"255.255.255.255", (Object)this.eval(tooSmall));
    }

    @Test
    public void testInvalidLongArgTooLarge() {
        Expr tooLarge = ExprEval.ofLong((Number)0x100000000L).toExpr();
        Assert.assertNull((Object)this.eval(tooLarge));
    }

    @Test
    public void testNullStringArg() {
        Expr nullString = ExprEval.ofString(null).toExpr();
        Assert.assertNull((Object)this.eval(nullString));
    }

    @Test
    public void testInvalidStringArgNotIPAddress() {
        Expr notIpAddress = ExprEval.ofString((String)"druid.apache.org").toExpr();
        Assert.assertNull((Object)this.eval(notIpAddress));
    }

    @Test
    public void testInvalidStringArgIPv6Compatible() {
        Expr ipv6Compatible = ExprEval.ofString((String)"::192.168.0.1").toExpr();
        Assert.assertNull((Object)this.eval(ipv6Compatible));
    }

    @Test
    public void testValidStringArgIPv6Mapped() {
        Expr ipv6Mapped = ExprEval.ofString((String)"::ffff:192.168.0.1").toExpr();
        Assert.assertNull((Object)this.eval(ipv6Mapped));
    }

    @Test
    public void testValidStringArgIPv4() {
        Assert.assertEquals((Object)EXPECTED, (Object)this.eval(VALID));
    }

    @Test
    public void testValidStringArgUnsignedInt() {
        Expr unsignedInt = ExprEval.ofString((String)"3232235521").toExpr();
        Assert.assertNull((Object)this.eval(unsignedInt));
    }

    private Object eval(Expr arg) {
        Expr expr = this.apply(Collections.singletonList(arg));
        ExprEval eval = expr.eval(InputBindings.nilBindings());
        return eval.value();
    }
}

