/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongStringComplexMetricSerde;
import org.apache.druid.query.aggregation.SingleObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.cell.RandomStringUtils;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongStringComplexMetricSerdeTest {
    private static final SerializablePairLongStringComplexMetricSerde LEGACY_SERDE = new SerializablePairLongStringComplexMetricSerde();
    private static final SerializablePairLongStringComplexMetricSerde COMPRESSED_SERDE = new SerializablePairLongStringComplexMetricSerde(true);
    private final Random random = new Random(0L);
    private final RandomStringUtils randomStringUtils = new RandomStringUtils(this.random);

    @Test
    public void testSingle() throws Exception {
        this.assertExpected((List<SerializablePairLongString>)ImmutableList.of((Object)new SerializablePairLongString(Long.valueOf(100L), "fuu")), 33, 77);
    }

    @Test
    public void testLargeString() throws Exception {
        this.assertExpected((List<SerializablePairLongString>)ImmutableList.of((Object)new SerializablePairLongString(Long.valueOf(100L), this.randomStringUtils.randomAlphanumeric(0x200000))), 2097182, 2103139);
    }

    @Test
    public void testCompressable() throws Exception {
        int i;
        int numStrings = 10;
        ArrayList<SerializablePairLongString> valueList = new ArrayList<SerializablePairLongString>();
        ArrayList<String> stringList = new ArrayList<String>();
        for (i = 0; i < numStrings; ++i) {
            stringList.add(this.randomStringUtils.randomAlphanumeric(1024));
        }
        for (i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongString(Long.valueOf(Integer.MAX_VALUE + (long)i), (String)stringList.get(i % numStrings)));
        }
        this.assertExpected(valueList, 10440010, 1746198);
    }

    @Test
    public void testHighlyCompressable() throws Exception {
        ArrayList<SerializablePairLongString> valueList = new ArrayList<SerializablePairLongString>();
        String stringValue = this.randomStringUtils.randomAlphanumeric(1024);
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongString(Long.valueOf(Integer.MAX_VALUE + (long)i), stringValue));
        }
        this.assertExpected(valueList, 10440010, 289645);
    }

    @Test
    public void testRandom() throws Exception {
        ArrayList<SerializablePairLongString> valueList = new ArrayList<SerializablePairLongString>();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongString(Long.valueOf(this.random.nextLong()), this.randomStringUtils.randomAlphanumeric(1024)));
        }
        this.assertExpected(valueList, 10440010, 10429009);
    }

    @Test
    public void testNullString() throws Exception {
        this.assertExpected((List<SerializablePairLongString>)ImmutableList.of((Object)new SerializablePairLongString(Long.valueOf(100L), null)), 30, 74);
    }

    @Test
    public void testEmpty() throws Exception {
        this.assertExpected(Collections.emptyList(), 10, 57);
    }

    @Test
    public void testSingleNull() throws Exception {
        this.assertExpected(Arrays.asList(new SerializablePairLongString[]{null}), 18, 58);
    }

    @Test
    public void testMultipleNull() throws Exception {
        this.assertExpected(Arrays.asList(null, null, null, null), 42, 59);
    }

    private ByteBuffer assertExpected(List<SerializablePairLongString> expected, int expectedLegacySize, int expectedCompressedSize) throws IOException {
        OnHeapMemorySegmentWriteOutMedium writeOutMedium = new OnHeapMemorySegmentWriteOutMedium();
        ByteBuffer legacyBuffer = SerializablePairLongStringComplexMetricSerdeTest.serializeAllValuesToByteBuffer(expected, LEGACY_SERDE.getSerializer((SegmentWriteOutMedium)writeOutMedium, "not-used", IndexSpec.getDefault()), expectedLegacySize).asReadOnlyBuffer();
        ByteBuffer compressedBuffer = SerializablePairLongStringComplexMetricSerdeTest.serializeAllValuesToByteBuffer(expected, COMPRESSED_SERDE.getSerializer((SegmentWriteOutMedium)writeOutMedium, "not-used", IndexSpec.getDefault()), expectedCompressedSize).asReadOnlyBuffer();
        try (ComplexColumn legacyCol = this.createComplexColumn(legacyBuffer);
             ComplexColumn compressedCol = this.createComplexColumn(compressedBuffer);){
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertEquals((Object)expected.get(i), (Object)legacyCol.getRowValue(i));
                Assert.assertEquals((Object)expected.get(i), (Object)compressedCol.getRowValue(i));
            }
        }
        return compressedBuffer;
    }

    private ComplexColumn createComplexColumn(ByteBuffer byteBuffer) {
        ColumnBuilder builder = new ColumnBuilder();
        int serializedSize = byteBuffer.remaining();
        LEGACY_SERDE.deserializeColumn(byteBuffer, builder);
        builder.setType(ValueType.COMPLEX);
        BaseColumnHolder columnHolder = builder.build();
        ComplexColumn col = (ComplexColumn)columnHolder.getColumn();
        if (col instanceof SerializablePairLongStringComplexColumn) {
            Assert.assertEquals((long)serializedSize, (long)col.getLength());
        }
        Assert.assertEquals((Object)"serializablePairLongString", (Object)col.getTypeName());
        Assert.assertEquals(SerializablePairLongString.class, (Object)col.getClazz());
        return col;
    }

    private static ByteBuffer serializeAllValuesToByteBuffer(List<SerializablePairLongString> values, GenericColumnSerializer serializer, int expectedSize) throws IOException {
        serializer.open();
        final AtomicReference<Object> reference = new AtomicReference<Object>(null);
        SingleObjectColumnValueSelector<SerializablePairLongString> valueSelector = new SingleObjectColumnValueSelector<SerializablePairLongString>(SerializablePairLongString.class){

            @Nullable
            public SerializablePairLongString getObject() {
                return (SerializablePairLongString)reference.get();
            }
        };
        for (SerializablePairLongString selector : values) {
            reference.set(selector);
            serializer.serialize((ColumnValueSelector)valueSelector);
        }
        return SerializablePairLongStringComplexMetricSerdeTest.serializeToByteBuffer((GenericColumnSerializer<SerializablePairLongString>)serializer, expectedSize);
    }

    private static ByteBuffer serializeToByteBuffer(GenericColumnSerializer<SerializablePairLongString> serializer, int expectedSize) throws IOException {
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        serializer.writeTo((WritableByteChannel)channel, null);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)channel.size()).order(ByteOrder.nativeOrder());
        channel.readFully(0L, byteBuffer);
        byteBuffer.flip();
        if (expectedSize > -1) {
            Assert.assertEquals((long)expectedSize, (long)serializer.getSerializedSize());
        }
        Assert.assertEquals((long)serializer.getSerializedSize(), (long)byteBuffer.limit());
        return byteBuffer;
    }
}

