/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.SerializablePairLongLongComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongLongComplexMetricSerde;
import org.apache.druid.query.aggregation.SingleObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongLongComplexMetricSerdeTest {
    private static final SerializablePairLongLongComplexMetricSerde COMPRESSED_SERDE = new SerializablePairLongLongComplexMetricSerde();
    private final Random random = new Random(0L);

    @Test
    public void testSingle() throws Exception {
        this.assertExpected((List<SerializablePairLongLong>)ImmutableList.of((Object)new SerializablePairLongLong(Long.valueOf(100L), Long.valueOf(10L))), 78);
    }

    @Test
    public void testLargeRHS() throws Exception {
        this.assertExpected((List<SerializablePairLongLong>)ImmutableList.of((Object)new SerializablePairLongLong(Long.valueOf(100L), Long.valueOf(this.random.nextLong()))), 78);
    }

    @Test
    public void testCompressable() throws Exception {
        int i;
        int numLongs = 10;
        ArrayList<SerializablePairLongLong> valueList = new ArrayList<SerializablePairLongLong>();
        ArrayList<Long> longList = new ArrayList<Long>();
        for (i = 0; i < numLongs; ++i) {
            longList.add(this.random.nextLong());
        }
        for (i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongLong(Long.valueOf(Integer.MAX_VALUE + (long)i), (Long)longList.get(i % numLongs)));
        }
        this.assertExpected(valueList, 80509);
    }

    @Test
    public void testHighlyCompressable() throws Exception {
        ArrayList<SerializablePairLongLong> valueList = new ArrayList<SerializablePairLongLong>();
        Long longValue = this.random.nextLong();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongLong(Long.valueOf(Integer.MAX_VALUE + (long)i), longValue));
        }
        this.assertExpected(valueList, 80274);
    }

    @Test
    public void testRandom() throws Exception {
        ArrayList<SerializablePairLongLong> valueList = new ArrayList<SerializablePairLongLong>();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongLong(Long.valueOf(this.random.nextLong()), Long.valueOf(this.random.nextLong())));
        }
        this.assertExpected(valueList, 210967);
    }

    @Test
    public void testNullRHS() throws Exception {
        this.assertExpected((List<SerializablePairLongLong>)ImmutableList.of((Object)new SerializablePairLongLong(Long.valueOf(100L), null)), 71);
    }

    @Test
    public void testEmpty() throws Exception {
        this.assertExpected(Collections.emptyList(), 57);
    }

    @Test
    public void testSingleNull() throws Exception {
        this.assertExpected(Arrays.asList(new SerializablePairLongLong[]{null}), 58);
    }

    @Test
    public void testMultipleNull() throws Exception {
        this.assertExpected(Arrays.asList(null, null, null, null), 59);
    }

    private ByteBuffer assertExpected(List<SerializablePairLongLong> expected, int expectedCompressedSize) throws IOException {
        OnHeapMemorySegmentWriteOutMedium writeOutMedium = new OnHeapMemorySegmentWriteOutMedium();
        ByteBuffer compressedBuffer = SerializablePairLongLongComplexMetricSerdeTest.serializeAllValuesToByteBuffer(expected, COMPRESSED_SERDE.getSerializer((SegmentWriteOutMedium)writeOutMedium, "not-used", IndexSpec.getDefault()), expectedCompressedSize).asReadOnlyBuffer();
        try (ComplexColumn compressedCol = this.createComplexColumn(compressedBuffer);){
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertEquals((Object)expected.get(i), (Object)compressedCol.getRowValue(i));
            }
        }
        return compressedBuffer;
    }

    private ComplexColumn createComplexColumn(ByteBuffer byteBuffer) {
        ColumnBuilder builder = new ColumnBuilder();
        int serializedSize = byteBuffer.remaining();
        COMPRESSED_SERDE.deserializeColumn(byteBuffer, builder);
        builder.setType(ValueType.COMPLEX);
        BaseColumnHolder columnHolder = builder.build();
        ComplexColumn col = (ComplexColumn)columnHolder.getColumn();
        if (col instanceof SerializablePairLongLongComplexColumn) {
            Assert.assertEquals((long)serializedSize, (long)col.getLength());
        }
        Assert.assertEquals((Object)"serializablePairLongLong", (Object)col.getTypeName());
        Assert.assertEquals(SerializablePairLongLong.class, (Object)col.getClazz());
        return col;
    }

    private static ByteBuffer serializeAllValuesToByteBuffer(List<SerializablePairLongLong> values, GenericColumnSerializer serializer, int expectedSize) throws IOException {
        serializer.open();
        final AtomicReference<Object> reference = new AtomicReference<Object>(null);
        SingleObjectColumnValueSelector<SerializablePairLongLong> valueSelector = new SingleObjectColumnValueSelector<SerializablePairLongLong>(SerializablePairLongLong.class){

            @Nullable
            public SerializablePairLongLong getObject() {
                return (SerializablePairLongLong)reference.get();
            }
        };
        for (SerializablePairLongLong selector : values) {
            reference.set(selector);
            serializer.serialize((ColumnValueSelector)valueSelector);
        }
        return SerializablePairLongLongComplexMetricSerdeTest.serializeToByteBuffer((GenericColumnSerializer<SerializablePairLongLong>)serializer, expectedSize);
    }

    private static ByteBuffer serializeToByteBuffer(GenericColumnSerializer<SerializablePairLongLong> serializer, int expectedSize) throws IOException {
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        serializer.writeTo((WritableByteChannel)channel, null);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)channel.size()).order(ByteOrder.nativeOrder());
        channel.readFully(0L, byteBuffer);
        byteBuffer.flip();
        if (expectedSize > -1) {
            Assert.assertEquals((long)expectedSize, (long)serializer.getSerializedSize());
        }
        Assert.assertEquals((long)serializer.getSerializedSize(), (long)byteBuffer.limit());
        return byteBuffer;
    }
}

