/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.TestGroupByBuffers;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;
import org.junit.rules.TemporaryFolder;

public class AggregationTestHelper
implements Closeable {
    private final ObjectMapper mapper;
    private final IndexMerger indexMerger;
    private final IndexIO indexIO;
    private final QueryToolChest toolChest;
    private final QueryRunnerFactory factory;
    private final TemporaryFolder tempFolder;
    private final Closer resourceCloser;
    private final Map<String, Object> queryContext;

    private AggregationTestHelper(ObjectMapper mapper, IndexMerger indexMerger, IndexIO indexIO, QueryToolChest toolchest, QueryRunnerFactory factory, TemporaryFolder tempFolder, List<? extends Module> jsonModulesToRegister, Closer resourceCloser, Map<String, Object> queryContext) {
        this.mapper = mapper;
        this.indexMerger = indexMerger;
        this.indexIO = indexIO;
        this.toolChest = toolchest;
        this.factory = factory;
        this.tempFolder = tempFolder;
        this.resourceCloser = resourceCloser;
        this.queryContext = queryContext;
        for (Module module : jsonModulesToRegister) {
            mapper.registerModule(module);
        }
    }

    public static AggregationTestHelper createGroupByQueryAggregationTestHelper(List<? extends Module> jsonModulesToRegister, GroupByQueryConfig config, TemporaryFolder tempFolder) {
        Closer closer = Closer.create();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        TestGroupByBuffers groupByBuffers = (TestGroupByBuffers)closer.register((Closeable)TestGroupByBuffers.createDefault());
        for (Module module : jsonModulesToRegister) {
            mapper.registerModule(module);
        }
        GroupByQueryRunnerFactory factory = GroupByQueryRunnerTest.makeQueryRunnerFactory(mapper, config, groupByBuffers);
        IndexIO indexIO = new IndexIO(mapper, new ColumnConfig(){});
        return new AggregationTestHelper(mapper, (IndexMerger)new IndexMergerV9(mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), indexIO, factory.getToolchest(), (QueryRunnerFactory)factory, tempFolder, jsonModulesToRegister, closer, Collections.emptyMap());
    }

    public static AggregationTestHelper createTimeseriesQueryAggregationTestHelper(List<? extends Module> jsonModulesToRegister, TemporaryFolder tempFolder) {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        TimeseriesQueryQueryToolChest toolchest = new TimeseriesQueryQueryToolChest();
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(toolchest, new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        IndexIO indexIO = new IndexIO(mapper, new ColumnConfig(){});
        return new AggregationTestHelper(mapper, (IndexMerger)new IndexMergerV9(mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), indexIO, (QueryToolChest)toolchest, (QueryRunnerFactory)factory, tempFolder, jsonModulesToRegister, Closer.create(), Collections.emptyMap());
    }

    public static AggregationTestHelper createTopNQueryAggregationTestHelper(List<? extends Module> jsonModulesToRegister, TemporaryFolder tempFolder) {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        TopNQueryQueryToolChest toolchest = new TopNQueryQueryToolChest(new TopNQueryConfig());
        CloseableStupidPool<ByteBuffer> pool = new CloseableStupidPool<ByteBuffer>("TopNQueryRunnerFactory-bufferPool", new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(0xA00000);
            }
        });
        Closer resourceCloser = Closer.create();
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(pool, toolchest, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        IndexIO indexIO = new IndexIO(mapper, new ColumnConfig(){});
        return new AggregationTestHelper(mapper, (IndexMerger)new IndexMergerV9(mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), indexIO, (QueryToolChest)toolchest, (QueryRunnerFactory)factory, tempFolder, jsonModulesToRegister, resourceCloser, Collections.emptyMap());
    }

    public static AggregationTestHelper createScanQueryAggregationTestHelper(List<? extends Module> jsonModulesToRegister, TemporaryFolder tempFolder) {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        ScanQueryQueryToolChest toolchest = new ScanQueryQueryToolChest(DefaultGenericQueryMetricsFactory.instance());
        Closer resourceCloser = Closer.create();
        ScanQueryRunnerFactory factory = new ScanQueryRunnerFactory(toolchest, new ScanQueryEngine(), new ScanQueryConfig());
        IndexIO indexIO = new IndexIO(mapper, new ColumnConfig(){});
        return new AggregationTestHelper(mapper, (IndexMerger)new IndexMergerV9(mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), indexIO, (QueryToolChest)toolchest, (QueryRunnerFactory)factory, tempFolder, jsonModulesToRegister, resourceCloser, Collections.emptyMap());
    }

    public AggregationTestHelper withQueryContext(Map<String, Object> queryContext) {
        HashMap<String, Object> newContext = new HashMap<String, Object>(this.queryContext);
        newContext.putAll(queryContext);
        return new AggregationTestHelper(this.mapper, this.indexMerger, this.indexIO, this.toolChest, this.factory, this.tempFolder, Collections.emptyList(), this.resourceCloser, newContext);
    }

    public <T> Sequence<T> createIndexAndRunQueryOnSegment(File inputDataFile, String parserJson, String aggregators, long minTimestamp, Granularity gran, int maxRowCount, String queryJson) throws Exception {
        File segmentDir = this.tempFolder.newFolder();
        this.createIndex(inputDataFile, parserJson, aggregators, segmentDir, minTimestamp, gran, maxRowCount, true);
        return this.runQueryOnSegments(Collections.singletonList(segmentDir), queryJson);
    }

    public <T> Sequence<T> createIndexAndRunQueryOnSegment(File inputDataFile, String parserJson, String aggregators, long minTimestamp, Granularity gran, int maxRowCount, Query<T> query) throws Exception {
        File segmentDir = this.tempFolder.newFolder();
        this.createIndex(inputDataFile, parserJson, aggregators, segmentDir, minTimestamp, gran, maxRowCount, true);
        return this.runQueryOnSegments(Collections.singletonList(segmentDir), query);
    }

    public <T> Sequence<T> createIndexAndRunQueryOnSegment(File inputDataFile, String parserJson, String aggregators, long minTimestamp, Granularity gran, int maxRowCount, boolean rollup, String queryJson) throws Exception {
        File segmentDir = this.tempFolder.newFolder();
        this.createIndex(inputDataFile, parserJson, aggregators, segmentDir, minTimestamp, gran, maxRowCount, rollup);
        return this.runQueryOnSegments(Collections.singletonList(segmentDir), queryJson);
    }

    public <T> Sequence<T> createIndexAndRunQueryOnSegment(InputStream inputDataStream, String parserJson, String aggregators, long minTimestamp, Granularity gran, int maxRowCount, String queryJson) throws Exception {
        return this.createIndexAndRunQueryOnSegment(inputDataStream, parserJson, aggregators, minTimestamp, gran, maxRowCount, true, queryJson);
    }

    public <T> Sequence<T> createIndexAndRunQueryOnSegment(InputStream inputDataStream, String parserJson, String aggregators, long minTimestamp, Granularity gran, int maxRowCount, boolean rollup, String queryJson) throws Exception {
        File segmentDir = this.tempFolder.newFolder();
        this.createIndex(inputDataStream, parserJson, aggregators, segmentDir, minTimestamp, gran, maxRowCount, rollup);
        return this.runQueryOnSegments(Collections.singletonList(segmentDir), queryJson);
    }

    public void createIndex(File inputDataFile, String parserJson, String aggregators, File outDir, long minTimestamp, Granularity gran, int maxRowCount) throws Exception {
        this.createIndex(new FileInputStream(inputDataFile), parserJson, aggregators, outDir, minTimestamp, gran, maxRowCount, true);
    }

    public void createIndex(File inputDataFile, String parserJson, String aggregators, File outDir, long minTimestamp, Granularity gran, int maxRowCount, boolean rollup) throws Exception {
        this.createIndex(new FileInputStream(inputDataFile), parserJson, aggregators, outDir, minTimestamp, gran, maxRowCount, rollup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(InputStream inputDataStream, String parserJson, String aggregators, File outDir, long minTimestamp, Granularity gran, int maxRowCount, boolean rollup) throws Exception {
        try {
            StringInputRowParser parser = (StringInputRowParser)this.mapper.readValue(parserJson, StringInputRowParser.class);
            LineIterator iter = IOUtils.lineIterator((InputStream)inputDataStream, (String)"UTF-8");
            List aggregatorSpecs = (List)this.mapper.readValue(aggregators, (TypeReference)new TypeReference<List<AggregatorFactory>>(){});
            this.createIndex((Iterator)iter, (InputRowParser)parser, aggregatorSpecs.toArray(new AggregatorFactory[0]), outDir, minTimestamp, gran, maxRowCount, rollup);
        }
        finally {
            Closeables.close((Closeable)inputDataStream, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(Iterator rows, InputRowParser parser, AggregatorFactory[] metrics, File outDir, long minTimestamp, Granularity gran, int maxRowCount, boolean rollup) throws Exception {
        ArrayList<File> toMerge = new ArrayList<File>();
        try (IncrementalIndex index = null;){
            index = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withDimensionsSpec(parser.getParseSpec().getDimensionsSpec()).withQueryGranularity(gran).withMetrics(metrics).withRollup(rollup).build()).setMaxRowCount(maxRowCount).build();
            while (rows.hasNext()) {
                Object row = rows.next();
                if (!index.canAppendRow()) {
                    File tmp = this.tempFolder.newFolder();
                    toMerge.add(tmp);
                    this.indexMerger.persist(index, tmp, IndexSpec.getDefault(), null);
                    index.close();
                    index = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withDimensionsSpec(parser.getParseSpec().getDimensionsSpec()).withQueryGranularity(gran).withMetrics(metrics).withRollup(rollup).build()).setMaxRowCount(maxRowCount).build();
                }
                if (row instanceof String && parser instanceof StringInputRowParser) {
                    index.add(((StringInputRowParser)parser).parse((String)row));
                    continue;
                }
                index.add((InputRow)parser.parseBatch(row).get(0));
            }
            if (toMerge.size() > 0) {
                File tmp = this.tempFolder.newFolder();
                toMerge.add(tmp);
                this.indexMerger.persist(index, tmp, IndexSpec.getDefault(), null);
                ArrayList<QueryableIndex> indexes = new ArrayList<QueryableIndex>(toMerge.size());
                for (File file : toMerge) {
                    indexes.add(this.indexIO.loadIndex(file));
                }
                this.indexMerger.mergeQueryableIndex(indexes, rollup, metrics, outDir, IndexSpec.getDefault(), null, -1);
                for (QueryableIndex qi : indexes) {
                    qi.close();
                }
            } else {
                this.indexMerger.persist(index, outDir, IndexSpec.getDefault(), null);
            }
        }
    }

    public Query readQuery(String queryJson) {
        try {
            return (Query)this.mapper.readValue(queryJson, Query.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static IncrementalIndex createIncrementalIndex(Iterator rows, InputRowParser parser, List<DimensionSchema> dimensions, AggregatorFactory[] metrics, long minTimestamp, Granularity gran, int maxRowCount, boolean rollup) {
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withDimensionsSpec(new DimensionsSpec(dimensions)).withMetrics(metrics).withRollup(rollup).build()).setMaxRowCount(maxRowCount).build();
        while (rows.hasNext()) {
            Object row = rows.next();
            if (!index.canAppendRow()) {
                throw new IAE("Can't add row to index", new Object[0]);
            }
            if (row instanceof String && parser instanceof StringInputRowParser) {
                index.add(((StringInputRowParser)parser).parse((String)row));
                continue;
            }
            index.add((InputRow)parser.parseBatch(row).get(0));
        }
        return index;
    }

    public static IncrementalIndex createIncrementalIndex(Iterator rows, InputRowParser parser, AggregatorFactory[] metrics, long minTimestamp, Granularity gran, int maxRowCount, boolean rollup) {
        return AggregationTestHelper.createIncrementalIndex(rows, parser, null, metrics, minTimestamp, gran, maxRowCount, rollup);
    }

    public Segment persistIncrementalIndex(IncrementalIndex index, File outDir) throws Exception {
        if (outDir == null) {
            outDir = this.tempFolder.newFolder();
        }
        this.indexMerger.persist(index, outDir, IndexSpec.getDefault(), null);
        return new QueryableIndexSegment(this.indexIO.loadIndex(outDir), SegmentId.dummy((String)""));
    }

    public <T> Sequence<T> runQueryOnSegments(List<File> segmentDirs, String queryJson) {
        return this.runQueryOnSegments(segmentDirs, this.readQuery(queryJson).withOverriddenContext(this.queryContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Sequence<T> runQueryOnSegments(List<File> segmentDirs, Query<T> query) {
        List segments = Lists.transform(segmentDirs, (Function)new Function<File, Segment>(){

            public Segment apply(File segmentDir) {
                try {
                    return new QueryableIndexSegment(AggregationTestHelper.this.indexIO.loadIndex(segmentDir), SegmentId.dummy((String)""));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        try {
            Sequence<T> sequence = this.runQueryOnSegmentsObjs(segments, query);
            return sequence;
        }
        finally {
            for (Segment segment : segments) {
                CloseableUtils.closeAndWrapExceptions((Closeable)segment);
            }
        }
    }

    public <T> Sequence<T> runQueryOnSegmentsObjs(List<Segment> segments, Query<T> query) {
        FinalizeResultsQueryRunner baseRunner = new FinalizeResultsQueryRunner(this.toolChest.postMergeQueryDecoration(this.toolChest.mergeResults(this.toolChest.preMergeQueryDecoration(this.factory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, (Iterable)Lists.transform(segments, (Function)new Function<Segment, QueryRunner>(){

            public QueryRunner apply(Segment segment) {
                try {
                    return AggregationTestHelper.this.makeStringSerdeQueryRunner(AggregationTestHelper.this.mapper, AggregationTestHelper.this.toolChest, (QueryRunner<ResultRow>)AggregationTestHelper.this.factory.createRunner(segment));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }))), true)), this.toolChest);
        return baseRunner.run(QueryPlus.wrap(GroupByQueryRunnerTestHelper.populateResourceId(query)));
    }

    public QueryRunner<ResultRow> makeStringSerdeQueryRunner(final ObjectMapper mapper, final QueryToolChest toolChest, final QueryRunner<ResultRow> baseRunner) {
        return new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext map) {
                try {
                    Sequence resultSeq = baseRunner.run(queryPlus, ResponseContext.createEmpty());
                    Yielder yielder = resultSeq.toYielder(null, new YieldingAccumulator(){

                        public Object accumulate(Object accumulated, Object in) {
                            this.yield();
                            return in;
                        }
                    });
                    String resultStr = mapper.writer().writeValueAsString((Object)yielder);
                    List resultRows = Lists.transform((List)AggregationTestHelper.this.readQueryResultArrayFromString(resultStr, queryPlus.getQuery()), (Function)toolChest.makePreComputeManipulatorFn(queryPlus.getQuery(), MetricManipulatorFns.deserializing()));
                    if (queryPlus.getQuery() instanceof GroupByQuery) {
                        List comparable = resultRows.stream().peek(row -> {
                            GroupByQuery query = (GroupByQuery)queryPlus.getQuery();
                            GroupingEngine.convertRowTypesToOutputTypes((List)query.getDimensions(), (ResultRow)row, (int)query.getResultRowDimensionStart());
                        }).collect(Collectors.toList());
                        return Sequences.simple(comparable);
                    }
                    return Sequences.simple((Iterable)resultRows);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    private List readQueryResultArrayFromString(String str, Query query) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        ObjectMapper decoratedMapper = this.toolChest.decorateObjectMapper(this.mapper, query);
        JsonParser jp = decoratedMapper.getFactory().createParser(str);
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw new IAE("not an array [%s]", new Object[]{str});
        }
        ObjectCodec objectCodec = jp.getCodec();
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            result.add(objectCodec.readValue(jp, (ResolvedType)this.toolChest.getBaseResultType()));
        }
        return result;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public <T> T[] runRelocateVerificationTest(AggregatorFactory factory, ColumnSelectorFactory selector, Class<T> clazz) {
        Object[] results = (Object[])Array.newInstance(clazz, 2);
        BufferAggregator agg = factory.factorizeBuffered(selector);
        ByteBuffer myBuf = ByteBuffer.allocate(10040902);
        agg.init(myBuf, 0);
        agg.aggregate(myBuf, 0);
        results[0] = agg.get(myBuf, 0);
        byte[] theBytes = new byte[factory.getMaxIntermediateSizeWithNulls()];
        myBuf.get(theBytes);
        ByteBuffer newBuf = ByteBuffer.allocate(941209);
        newBuf.position(7574);
        newBuf.put(theBytes);
        newBuf.position(0);
        agg.relocate(0, 7574, myBuf, newBuf);
        results[1] = agg.get(newBuf, 7574);
        return results;
    }

    public IndexIO getIndexIO() {
        return this.indexIO;
    }

    @Override
    public void close() throws IOException {
        this.resourceCloser.close();
    }
}

