/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final TableDataSource fooDataSource = new TableDataSource("foo");
    private final TableDataSource barDataSource = new TableDataSource("bar");

    @Test
    public void test_getTableNames() {
        Assert.assertEquals(Collections.singleton("foo"), (Object)this.fooDataSource.getTableNames());
    }

    @Test
    public void test_getChildren() {
        Assert.assertEquals(Collections.emptyList(), (Object)this.fooDataSource.getChildren());
    }

    @Test
    public void test_isCacheable() {
        Assert.assertTrue((boolean)this.fooDataSource.isCacheable(true));
        Assert.assertTrue((boolean)this.fooDataSource.isCacheable(false));
    }

    @Test
    public void test_isGlobal() {
        Assert.assertFalse((boolean)this.fooDataSource.isGlobal());
    }

    @Test
    public void test_isConcrete() {
        Assert.assertTrue((boolean)this.fooDataSource.isProcessable());
    }

    @Test
    public void test_withChildren_empty() {
        Assert.assertSame((Object)this.fooDataSource, (Object)this.fooDataSource.withChildren(Collections.emptyList()));
    }

    @Test
    public void test_withChildren_nonEmpty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot accept children");
        this.fooDataSource.withChildren((List)ImmutableList.of((Object)new TableDataSource("bar")));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(TableDataSource.class).usingGetClass().withNonnullFields(new String[]{"name"}).verify();
    }

    @Test
    public void test_serde_roundTrip() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TableDataSource deserialized = (TableDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)this.fooDataSource), DataSource.class);
        Assert.assertEquals((Object)this.fooDataSource, (Object)deserialized);
        Assert.assertNotEquals((Object)this.barDataSource, (Object)deserialized);
    }

    @Test
    public void test_deserialize_fromObject() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TableDataSource deserialized = (TableDataSource)jsonMapper.readValue("{\"type\":\"table\",\"name\":\"foo\"}", DataSource.class);
        Assert.assertEquals((Object)this.fooDataSource, (Object)deserialized);
        Assert.assertNotEquals((Object)this.barDataSource, (Object)deserialized);
    }

    @Test
    public void test_deserialize_fromString() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TableDataSource deserialized = (TableDataSource)jsonMapper.readValue("\"foo\"", DataSource.class);
        Assert.assertEquals((Object)this.fooDataSource, (Object)deserialized);
        Assert.assertNotEquals((Object)this.barDataSource, (Object)deserialized);
    }

    @Test
    public void test_serialize() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        String s = jsonMapper.writeValueAsString((Object)this.fooDataSource);
        Assert.assertEquals((Object)"{\"type\":\"table\",\"name\":\"foo\"}", (Object)s);
    }
}

