/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.query.MetricsEmittingQueryProcessingPool;
import org.apache.druid.query.PrioritizedExecutorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MetricsEmittingQueryProcessingPoolTest {
    private ScheduledExecutorService timeoutService;

    @Before
    public void setUp() {
        this.timeoutService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
    }

    @Test
    public void testPrioritizedExecutorDelegate() {
        PrioritizedExecutorService service = (PrioritizedExecutorService)Mockito.mock(PrioritizedExecutorService.class);
        ScheduledExecutorService timeoutService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Mockito.when((Object)service.getQueueSize()).thenReturn((Object)10);
        Mockito.when((Object)service.getActiveTasks()).thenReturn((Object)2);
        ExecutorServiceMonitor monitor = new ExecutorServiceMonitor();
        MetricsEmittingQueryProcessingPool processingPool = new MetricsEmittingQueryProcessingPool((ListeningExecutorService)service, timeoutService, monitor);
        Assert.assertSame((Object)service, (Object)processingPool.delegate());
        StubServiceEmitter serviceEmitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("segment/scan/pending", 10);
        serviceEmitter.verifyValue("segment/scan/active", 2);
    }

    @Test
    public void testNonPrioritizedExecutorDelegate() {
        ListeningExecutorService service = (ListeningExecutorService)Mockito.mock(ListeningExecutorService.class);
        ExecutorServiceMonitor monitor = new ExecutorServiceMonitor();
        MetricsEmittingQueryProcessingPool processingPool = new MetricsEmittingQueryProcessingPool(service, this.timeoutService, monitor);
        Assert.assertSame((Object)service, (Object)processingPool.delegate());
        ServiceEmitter serviceEmitter = (ServiceEmitter)Mockito.mock(ServiceEmitter.class);
        monitor.doMonitor(serviceEmitter);
        Mockito.verifyNoInteractions((Object[])new Object[]{serviceEmitter});
    }
}

