/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.primitives.Ints;
import org.apache.druid.query.DimensionComparisonUtils;
import org.apache.druid.query.ordering.StringComparator;
import org.junit.Assert;
import org.junit.Test;

public class DimensionComparisonUtilsTest {
    @Test
    public void testArrayComparator() {
        DimensionComparisonUtils.ArrayComparator longArrayComparator = new DimensionComparisonUtils.ArrayComparator((a, b) -> {
            if (a == null) {
                return b == null ? 0 : 1;
            }
            return b == null ? -1 : -a.compareTo((Long)b);
        });
        Assert.assertEquals((long)1L, (long)longArrayComparator.compare(new Object[]{1L, 2L}, new Object[]{5L, 6L}));
        Assert.assertEquals((long)-1L, (long)longArrayComparator.compare(null, new Object[]{1L}));
        Assert.assertEquals((long)1L, (long)longArrayComparator.compare(new Object[]{1L}, null));
        Assert.assertEquals((long)1L, (long)longArrayComparator.compare(new Object[]{null}, new Object[]{1L}));
        Assert.assertEquals((long)0L, (long)longArrayComparator.compare(null, null));
        Assert.assertEquals((long)0L, (long)longArrayComparator.compare(new Object[]{1L, 2L, null, 3L}, new Object[]{1L, 2L, null, 3L}));
        Assert.assertEquals((long)1L, (long)longArrayComparator.compare(new Object[]{null}, new Object[]{1L}));
    }

    @Test
    public void testNumericArrayComparator() {
        DimensionComparisonUtils.ArrayComparatorForUnnaturalStringComparator arrayComparator = new DimensionComparisonUtils.ArrayComparatorForUnnaturalStringComparator(new StringComparator(){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public int compare(String s, String t1) {
                return Ints.compare((int)s.length(), (int)t1.length());
            }
        });
        Assert.assertEquals((long)0L, (long)arrayComparator.compare(null, null));
        Assert.assertEquals((long)0L, (long)arrayComparator.compare(new Object[]{1L, 2L, null, 3L}, new Object[]{1L, 2L, null, 3L}));
        Assert.assertEquals((long)0L, (long)arrayComparator.compare(new Object[]{1L, 2L}, new Object[]{5L, 6L}));
        Assert.assertEquals((long)-1L, (long)arrayComparator.compare(null, new Object[]{1L}));
        Assert.assertEquals((long)1L, (long)arrayComparator.compare(new Object[]{1L}, null));
        Assert.assertEquals((long)1L, (long)arrayComparator.compare(new Object[]{null}, new Object[]{1L}));
        Assert.assertEquals((long)-1L, (long)arrayComparator.compare(new Object[]{1L}, new Object[]{Float.valueOf(1.1f)}));
    }
}

