/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.junit.Assert;
import org.junit.Test;

public class MetadataStorageConnectorConfigTest {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    private MetadataStorageConnectorConfig createMetadataStorageConfig(boolean createTables, String host, int port, String connectURI, String user, String pwdString) throws IOException {
        return (MetadataStorageConnectorConfig)JSON_MAPPER.readValue("{\"createTables\": \"" + createTables + "\",\"host\": \"" + host + "\",\"port\": \"" + port + "\",\"connectURI\": \"" + connectURI + "\",\"user\": \"" + user + "\",\"password\": " + pwdString + ",\"dbcp\": {\n  \"maxConnLifetimeMillis\" : 1200000,\n  \"defaultQueryTimeout\" : \"30000\"\n}}", MetadataStorageConnectorConfig.class);
    }

    @Test
    public void testEquals() throws IOException {
        MetadataStorageConnectorConfig metadataStorageConnectorConfig = this.createMetadataStorageConfig(true, "testHost", 4000, "url", "user", "\"nothing\"");
        MetadataStorageConnectorConfig metadataStorageConnectorConfig2 = this.createMetadataStorageConfig(true, "testHost", 4000, "url", "user", "\"nothing\"");
        Assert.assertEquals((Object)metadataStorageConnectorConfig, (Object)metadataStorageConnectorConfig2);
        Assert.assertEquals((long)metadataStorageConnectorConfig.hashCode(), (long)metadataStorageConnectorConfig2.hashCode());
    }

    @Test
    public void testMetadataStorageConnectionConfigSimplePassword() throws Exception {
        this.testMetadataStorageConnectionConfig(true, "host", 1234, "connectURI", "user", "\"nothing\"", "nothing");
    }

    @Test
    public void testMetadataStorageConnectionConfigWithDefaultProviderPassword() throws Exception {
        this.testMetadataStorageConnectionConfig(true, "host", 1234, "connectURI", "user", "{\"type\":\"default\",\"password\":\"nothing\"}", "nothing");
    }

    private void testMetadataStorageConnectionConfig(boolean createTables, String host, int port, String connectURI, String user, String pwdString, String pwd) throws Exception {
        MetadataStorageConnectorConfig config = (MetadataStorageConnectorConfig)JSON_MAPPER.readValue("{\"createTables\": \"" + createTables + "\",\"host\": \"" + host + "\",\"port\": \"" + port + "\",\"connectURI\": \"" + connectURI + "\",\"user\": \"" + user + "\",\"password\": " + pwdString + "}", MetadataStorageConnectorConfig.class);
        Assert.assertEquals((Object)host, (Object)config.getHost());
        Assert.assertEquals((long)port, (long)config.getPort());
        Assert.assertEquals((Object)connectURI, (Object)config.getConnectURI());
        Assert.assertEquals((Object)user, (Object)config.getUser());
        Assert.assertEquals((Object)pwd, (Object)config.getPassword());
        Assert.assertNull((Object)config.getDbcpProperties());
    }

    @Test
    public void testDbcpProperties() throws Exception {
        this.testDbcpPropertiesFile(true, "host", 1234, "connectURI", "user", "{\"type\":\"default\",\"password\":\"nothing\"}", "nothing");
    }

    private void testDbcpPropertiesFile(boolean createTables, String host, int port, String connectURI, String user, String pwdString, String pwd) throws Exception {
        MetadataStorageConnectorConfig config = (MetadataStorageConnectorConfig)JSON_MAPPER.readValue("{\"createTables\": \"" + createTables + "\",\"host\": \"" + host + "\",\"port\": \"" + port + "\",\"connectURI\": \"" + connectURI + "\",\"user\": \"" + user + "\",\"password\": " + pwdString + ",\"dbcp\": {\n  \"maxConnLifetimeMillis\" : 1200000,\n  \"defaultQueryTimeout\" : \"30000\"\n}}", MetadataStorageConnectorConfig.class);
        Assert.assertEquals((Object)host, (Object)config.getHost());
        Assert.assertEquals((long)port, (long)config.getPort());
        Assert.assertEquals((Object)connectURI, (Object)config.getConnectURI());
        Assert.assertEquals((Object)user, (Object)config.getUser());
        Assert.assertEquals((Object)pwd, (Object)config.getPassword());
        Properties dbcpProperties = config.getDbcpProperties();
        Assert.assertEquals((Object)dbcpProperties.getProperty("maxConnLifetimeMillis"), (Object)"1200000");
        Assert.assertEquals((Object)dbcpProperties.getProperty("defaultQueryTimeout"), (Object)"30000");
    }

    @Test
    public void testCreate() {
        ImmutableMap props = ImmutableMap.of((Object)"key", (Object)"value");
        MetadataStorageConnectorConfig config = MetadataStorageConnectorConfig.create((String)"connectURI", (String)"user", (String)"pwd", (Map)props);
        Assert.assertEquals((Object)"connectURI", (Object)config.getConnectURI());
        Assert.assertEquals((Object)"user", (Object)config.getUser());
        Assert.assertEquals((Object)"pwd", (Object)config.getPassword());
        Assert.assertEquals((long)1L, (long)config.getDbcpProperties().size());
    }
}

