/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.math.expr.SettableObjectBinding;
import org.apache.druid.math.expr.SettableVectorInputBinding;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.query.expression.LookupExprMacro;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.TestMapLookupExtractorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class VectorExprResultConsistencyTest
extends InitializedNullHandlingTest {
    private static final Logger log = new Logger(VectorExprResultConsistencyTest.class);
    private static final int NUM_ITERATIONS = 10;
    private static final int VECTOR_SIZE = 4;
    private static final Map<String, String> LOOKUP = Map.of("1", "a", "12", "b", "33", "c", "111", "d", "123", "e", "124", "f");
    private static final Map<String, String> INJECTIVE_LOOKUP = new HashMap<String, String>(){

        @Override
        public String get(Object key) {
            return (String)key;
        }
    };
    private static final ExprMacroTable MACRO_TABLE;
    final Map<String, ExpressionType> types = ImmutableMap.builder().put((Object)"l1", (Object)ExpressionType.LONG).put((Object)"l2", (Object)ExpressionType.LONG).put((Object)"l3", (Object)ExpressionType.LONG).put((Object)"d1", (Object)ExpressionType.DOUBLE).put((Object)"d2", (Object)ExpressionType.DOUBLE).put((Object)"d3", (Object)ExpressionType.DOUBLE).put((Object)"s1", (Object)ExpressionType.STRING).put((Object)"s2", (Object)ExpressionType.STRING).put((Object)"s3", (Object)ExpressionType.STRING).put((Object)"boolString1", (Object)ExpressionType.STRING).put((Object)"boolString2", (Object)ExpressionType.STRING).put((Object)"boolString3", (Object)ExpressionType.STRING).build();

    @Test
    public void testConstants() {
        VectorExprResultConsistencyTest.testExpression("null", this.types);
        VectorExprResultConsistencyTest.testExpression("1", this.types);
        VectorExprResultConsistencyTest.testExpression("1.1", this.types);
        VectorExprResultConsistencyTest.testExpression("NaN", this.types);
        VectorExprResultConsistencyTest.testExpression("Infinity", this.types);
        VectorExprResultConsistencyTest.testExpression("-Infinity", this.types);
        VectorExprResultConsistencyTest.testExpression("'hello'", this.types);
        VectorExprResultConsistencyTest.testExpression("json_object('a', 1, 'b', 'abc', 'c', 3.3, 'd', array(1,2,3))", this.types);
    }

    @Test
    public void testIdentifiers() {
        ArrayList<String> columns = new ArrayList<String>(this.types.keySet());
        columns.add("unknown");
        List<String> template = List.of("%s");
        VectorExprResultConsistencyTest.testFunctions(this.types, template, columns);
    }

    @Test
    public void testCast() {
        Set<String> columns = Set.of("d1", "l1", "s1");
        Set<String> castTo = Set.of("'STRING'", "'LONG'", "'DOUBLE'", "'ARRAY<STRING>'", "'ARRAY<LONG>'", "'ARRAY<DOUBLE>'");
        Set args = Sets.cartesianProduct((Set[])new Set[]{columns, castTo});
        List<String> templates = List.of("cast(%s, %s)");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, args);
    }

    @Test
    public void testCastArraysRoundTrip() {
        VectorExprResultConsistencyTest.testExpression("cast(cast(s1, 'ARRAY<STRING>'), 'STRING')", this.types);
        VectorExprResultConsistencyTest.testExpression("cast(cast(d1, 'ARRAY<DOUBLE>'), 'DOUBLE')", this.types);
        VectorExprResultConsistencyTest.testExpression("cast(cast(d1, 'ARRAY<STRING>'), 'DOUBLE')", this.types);
        VectorExprResultConsistencyTest.testExpression("cast(cast(l1, 'ARRAY<LONG>'), 'LONG')", this.types);
        VectorExprResultConsistencyTest.testExpression("cast(cast(l1, 'ARRAY<STRING>'), 'LONG')", this.types);
    }

    @Test
    public void testUnaryOperators() {
        List<String> functions = List.of("-");
        List<String> templates = List.of("%sd1", "%sl1");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testBinaryMathOperators() {
        Set<String> columns = Set.of("d1", "d2", "l1", "l2", "1", "1.0", "nonexistent", "null", "s1");
        Set<String> columns2 = Set.of("d1", "d2", "l1", "l2", "1", "1.0");
        Set templateInputs = Sets.cartesianProduct((Set[])new Set[]{columns, columns2});
        ArrayList<String> templates = new ArrayList<String>();
        for (List template : templateInputs) {
            templates.add(StringUtils.format((String)"%s %s %s", (Object[])new Object[]{template.get(0), "%s", template.get(1)}));
        }
        List<String> args = List.of("+", "-", "*", "/", "^", "%");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, args);
    }

    @Test
    public void testBinaryComparisonOperators() {
        Set<String> columns = Set.of("d1", "d2", "l1", "l2", "1", "1.0", "s1", "s2", "nonexistent", "null");
        Set<String> columns2 = Set.of("d1", "d2", "l1", "l2", "1", "1.0", "s1", "s2", "null");
        Set templateInputs = Sets.cartesianProduct((Set[])new Set[]{columns, columns2});
        ArrayList<String> templates = new ArrayList<String>();
        for (List template : templateInputs) {
            templates.add(StringUtils.format((String)"%s %s %s", (Object[])new Object[]{template.get(0), "%s", template.get(1)}));
        }
        List<String> args = List.of(">", ">=", "<", "<=", "==", "!=");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, args);
    }

    @Test
    public void testUnaryLogicOperators() {
        List<String> functions = List.of("!");
        List<String> templates = List.of("%sd1", "%sl1", "%sboolString1");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testBinaryLogicOperators() {
        List<String> functions = List.of("&&", "||");
        List<String> templates = List.of("d1 %s d2", "l1 %s l2", "boolString1 %s boolString2", "(d1 == d2) %s (l1 == l2)");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testBinaryOperatorTrees() {
        Set<String> columns = Set.of("d1", "l1", "1", "1.0", "nonexistent", "null");
        Set<String> columns2 = Set.of("d2", "l2", "2", "2.0");
        Set templateInputs = Sets.cartesianProduct((Set[])new Set[]{columns, columns2, columns2});
        ArrayList<String> templates = new ArrayList<String>();
        for (List template : templateInputs) {
            templates.add(StringUtils.format((String)"(%s %s %s) %s %s", (Object[])new Object[]{template.get(0), "%s", template.get(1), "%s", template.get(2)}));
        }
        Set<String> ops = Set.of("+", "-", "*", "/");
        Set args = Sets.cartesianProduct((Set[])new Set[]{ops, ops});
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, args);
    }

    @Test
    public void testUnivariateFunctions() {
        List<String> functions = List.of("parse_long", "isNull", "notNull");
        List<String> templates = List.of("%s(s1)", "%s(l1)", "%s(d1)", "%s(nonexistent)", "%s(null)");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testLike() {
        VectorExprResultConsistencyTest.testExpression("like(s1, '1%')", this.types);
        VectorExprResultConsistencyTest.testExpression("like(s1, '%1')", this.types);
        VectorExprResultConsistencyTest.testExpression("like(s1, '%1%')", this.types);
    }

    @Test
    public void testUnivariateMathFunctions() {
        List<String> functions = List.of("abs", "acos", "asin", "atan", "cbrt", "ceil", "cos", "cosh", "cot", "exp", "expm1", "floor", "getExponent", "log", "log10", "log1p", "nextUp", "rint", "signum", "sin", "sinh", "sqrt", "tan", "tanh", "toDegrees", "toRadians", "ulp", "bitwiseComplement", "bitwiseConvertDoubleToLongBits", "bitwiseConvertLongBitsToDouble");
        List<String> templates = List.of("%s(l1)", "%s(d1)", "%s(pi())", "%s(null)", "%s(missing)");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testBivariateMathFunctions() {
        List<String> functions = List.of("atan2", "copySign", "div", "hypot", "remainder", "max", "min", "nextAfter", "scalb", "pow", "safe_divide", "bitwiseAnd", "bitwiseOr", "bitwiseXor", "bitwiseShiftLeft", "bitwiseShiftRight");
        List<String> templates = List.of("%s(d1, d2)", "%s(d1, l1)", "%s(l1, d1)", "%s(l1, l2)", "%s(nonexistent, l1)", "%s(nonexistent, d1)");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testSymmetricalBivariateFunctions() {
        List<String> functions = List.of("nvl", "coalesce");
        List<String> templates = List.of("%s(d1, d2)", "%s(l1, l2)", "%s(s1, s2)", "%s(nonexistent, l1)", "%s(nonexistent, d1)", "%s(nonexistent, s1)", "%s(nonexistent, nonexistent2)");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testIfFunction() {
        VectorExprResultConsistencyTest.testExpression("if(l1, l1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(l1, s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(l1, d1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(d1, l1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(d1, s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(d1, d1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(boolString1, s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(boolString1, l1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(boolString1, d1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("if(l1 % 2 == 0, -1, l2 / (l1 % 2))", this.types);
        Assertions.assertFalse((boolean)Parser.parse((String)"if(s1, l1, d2)", (ExprMacroTable)MACRO_TABLE).canVectorize(InputBindings.inspectorFromTypeMap(this.types)));
        Assertions.assertFalse((boolean)Parser.parse((String)"if(s1, d1, s2)", (ExprMacroTable)MACRO_TABLE).canVectorize(InputBindings.inspectorFromTypeMap(this.types)));
    }

    @Test
    public void testCaseSearchedFunction() {
        VectorExprResultConsistencyTest.testExpression("case_searched(boolString1, s1, boolString2, s2, s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_searched(boolString1, s1, boolString2, s2, boolString3, s3, s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_searched(boolString1, l1, boolString2, l2, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_searched(boolString1, l1, boolString2, l2, boolString3, l3, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_searched(boolString1, d1, boolString2, d2, d1)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_searched(boolString1, d1, boolString2, d2, boolString3, d3, d1)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_searched(l1 % 2 == 0, -1, l1 % 2 == 1, l2 / (l1 % 2))", this.types);
        Assertions.assertFalse((boolean)Parser.parse((String)"case_searched(boolString1, d1, boolString2, d2, l1)", (ExprMacroTable)MACRO_TABLE).canVectorize(InputBindings.inspectorFromTypeMap(this.types)));
        Assertions.assertFalse((boolean)Parser.parse((String)"case_searched(boolString1, d1, boolString2, l1, d1)", (ExprMacroTable)MACRO_TABLE).canVectorize(InputBindings.inspectorFromTypeMap(this.types)));
    }

    @Test
    public void testCaseSimpleFunction() {
        VectorExprResultConsistencyTest.testExpression("case_simple(s1, s2, s2, s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_simple(s1, s2, s2, s1, s2, s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_simple(s1, s2, l1, s1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_simple(s1, s2, d1, s1, d2, d1)", this.types);
        VectorExprResultConsistencyTest.testExpression("case_simple(s1, l1, d1, d1, d2, d1)", this.types);
        Assertions.assertFalse((boolean)Parser.parse((String)"case_simple(s1, d1, s1, l1, d1)", (ExprMacroTable)MACRO_TABLE).canVectorize(InputBindings.inspectorFromTypeMap(this.types)));
    }

    @Test
    public void testCoalesceFunction() {
        List<String> functions = List.of("coalesce");
        List<String> templates = List.of("%s(nonexistent, d1, d2, d3)", "%s(nonexistent, d1, nonexistent2, d2, nonexistent3, d3)", "%s(nonexistent, nonexistent2, l1, l2, nonexistent, l3)", "%s(nonexistent, s1, nonexistent2, s2)");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, functions);
        Assertions.assertFalse((boolean)Parser.parse((String)"coalesce(s1, d1, s1, l1, d1)", (ExprMacroTable)MACRO_TABLE).canVectorize(InputBindings.inspectorFromTypeMap(this.types)));
    }

    @Test
    public void testStringFns() {
        VectorExprResultConsistencyTest.testExpression("s1 + s2", this.types);
        VectorExprResultConsistencyTest.testExpression("s1 + '-' + s2", this.types);
        VectorExprResultConsistencyTest.testExpression("concat(s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("concat(s1,'-',s2,'-',l1,'-',d1)", this.types);
    }

    @Test
    public void testStringFunctions() {
        VectorExprResultConsistencyTest.testExpression("format('%s-%d-%.2f', s1, l1, d1)", this.types);
        VectorExprResultConsistencyTest.testExpression("format('%s %s', s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("regexp_extract(s1, '[0-9]+')", this.types);
        VectorExprResultConsistencyTest.testExpression("regexp_extract(s1, '([a-z]+)', 1)", this.types);
        VectorExprResultConsistencyTest.testExpression("regexp_like(s1, '[0-9]+')", this.types);
        VectorExprResultConsistencyTest.testExpression("regexp_like(s1, '^test.*')", this.types);
        VectorExprResultConsistencyTest.testExpression("regexp_replace(s1, '[0-9]+', 'NUM')", this.types);
        VectorExprResultConsistencyTest.testExpression("contains_string(s1, '1')", this.types);
        VectorExprResultConsistencyTest.testExpression("icontains_string(s1, '1')", this.types);
        VectorExprResultConsistencyTest.testExpression("replace(s1, 'test', 'TEST')", this.types);
        VectorExprResultConsistencyTest.testExpression("replace(s1, s2, s3)", this.types);
        VectorExprResultConsistencyTest.testExpression("substring(s1, 0, 3)", this.types);
        VectorExprResultConsistencyTest.testExpression("substring(s1, l1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("right(s1, 3)", this.types);
        VectorExprResultConsistencyTest.testExpression("right(s1, l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("left(s1, 3)", this.types);
        VectorExprResultConsistencyTest.testExpression("left(s1, l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("strlen(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("strpos(s1, 'test')", this.types);
        VectorExprResultConsistencyTest.testExpression("strpos(s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("strpos(s1, s2, l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("trim(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("trim(s1, 'abc')", this.types);
        VectorExprResultConsistencyTest.testExpression("ltrim(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("ltrim(s1, 'abc')", this.types);
        VectorExprResultConsistencyTest.testExpression("rtrim(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("rtrim(s1, 'abc')", this.types);
        VectorExprResultConsistencyTest.testExpression("lower(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("upper(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("reverse(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("repeat(s1, 3)", this.types);
        VectorExprResultConsistencyTest.testExpression("repeat(s1, l1 % 10)", this.types);
        VectorExprResultConsistencyTest.testExpression("lpad(s1, 10, 'x')", this.types);
        VectorExprResultConsistencyTest.testExpression("lpad(s1, l1 % 10, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("rpad(s1, 10, 'x')", this.types);
        VectorExprResultConsistencyTest.testExpression("rpad(s1, l1 % 10, s2)", this.types);
    }

    @Test
    public void testLookup() {
        ArrayList<String> columns = new ArrayList<String>(this.types.keySet());
        columns.add("unknown");
        List<String> templates = List.of("lookup(%s, 'test-lookup')", "lookup(%s, 'test-lookup', 'missing')", "lookup(%s, 'test-lookup-injective')", "lookup(%s, 'test-lookup-injective', 'missing')", "lookup(%s, 'nonexistent-lookup')", "lookup(%s, 'nonexistent-lookup', 'missing')");
        VectorExprResultConsistencyTest.testFunctions(this.types, templates, columns);
    }

    @Test
    public void testArrayFunctions() {
        VectorExprResultConsistencyTest.testExpression("array(s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("array(l1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("array(d1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("array(l1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("array(s1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_length(array(s1, s2))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_length(array(l1, l2, l3))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_offset(array(s1, s2), 0)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_offset(array(l1, l2), l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_ordinal(array(s1, s2), 1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_ordinal(array(l1, l2), l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_contains(array(s1, s2), s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_contains(array(l1, l2), l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_contains(array(s1, s2), array(s1))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_overlap(array(s1, s2), array(s2, s3))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_overlap(array(l1, l2), array(l2, l3))", this.types);
        VectorExprResultConsistencyTest.testExpression("scalar_in_array(s1, array(s1, s2))", this.types);
        VectorExprResultConsistencyTest.testExpression("scalar_in_array(s1, array('1', '2'))", this.types);
        VectorExprResultConsistencyTest.testExpression("scalar_in_array(s1, array(1, 2))", this.types);
        VectorExprResultConsistencyTest.testExpression("scalar_in_array(l1, array(l1, l2))", this.types);
        VectorExprResultConsistencyTest.testExpression("scalar_in_array(l1, array('1', '2'))", this.types);
        VectorExprResultConsistencyTest.testExpression("scalar_in_array(l1, array(1, 2))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_offset_of(array(s1, s2), s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_offset_of(array(l1, l2), l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_ordinal_of(array(s1, s2), s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_ordinal_of(array(l1, l2), l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_prepend(s1, array(s2, s3))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_prepend(l1, array(l2, l3))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_append(array(s1, s2), s3)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_append(array(l1, l2), l3)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_concat(array(s1, s2), array(s2, s3))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_concat(array(l1, l2), array(l2, l3))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_set_add(array(s1, s2), s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_set_add(array(l1, l2), l3)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_set_add_all(array(s1, s2), array(s2, s3))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_set_add_all(array(l1, l2), array(l2, l3))", this.types);
        VectorExprResultConsistencyTest.testExpression("array_slice(array(s1, s2, s3), 1, 2)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_slice(array(l1, l2, l3), 1, 2)", this.types);
        VectorExprResultConsistencyTest.testExpression("array_to_string(array(s1, s2), ',')", this.types);
        VectorExprResultConsistencyTest.testExpression("array_to_string(array(l1, l2), s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("string_to_array(s1, ',')", this.types);
        VectorExprResultConsistencyTest.testExpression("string_to_array(s1, s2)", this.types);
    }

    @Test
    public void testArrayHigherOrderFunctions() {
        VectorExprResultConsistencyTest.testExpression("map((x) -> x + 1, array(l1, l2))", this.types);
        VectorExprResultConsistencyTest.testExpression("map((x) -> x * 2.0, array(d1, d2))", this.types);
        VectorExprResultConsistencyTest.testExpression("map((x) -> concat(x, '_mapped'), array(s1, s2))", this.types);
        VectorExprResultConsistencyTest.testExpression("cartesian_map((x, y) -> x + y, array(l1, l2), array(d1, d2))", this.types);
        VectorExprResultConsistencyTest.testExpression("cartesian_map((x, y) -> concat(x, cast(y, 'STRING')), array(s1, s2), array(l1, l2))", this.types);
        VectorExprResultConsistencyTest.testExpression("fold((x, acc) -> x + acc, array(l1, l2), 0)", this.types);
        VectorExprResultConsistencyTest.testExpression("fold((x, acc) -> x + acc, array(d1, d2), 0.0)", this.types);
        VectorExprResultConsistencyTest.testExpression("fold((x, acc) -> concat(acc, x), array(s1, s2), '')", this.types);
        VectorExprResultConsistencyTest.testExpression("cartesian_fold((x, y, acc) -> acc + x + y, array(l1, l2), array(d1, d2), 0)", this.types);
        VectorExprResultConsistencyTest.testExpression("filter((x) -> x > 0, array(l1, l2))", this.types);
        VectorExprResultConsistencyTest.testExpression("filter((x) -> x > 0.0, array(d1, d2))", this.types);
        VectorExprResultConsistencyTest.testExpression("filter((x) -> strlen(x) > 0, array(s1, s2))", this.types);
        VectorExprResultConsistencyTest.testExpression("any((x) -> x > 0, array(l1, l2))", this.types);
        VectorExprResultConsistencyTest.testExpression("any((x) -> x > 0.0, array(d1, d2))", this.types);
        VectorExprResultConsistencyTest.testExpression("any((x) -> strlen(x) > 0, array(s1, s2))", this.types);
        VectorExprResultConsistencyTest.testExpression("all((x) -> x != null, array(l1, l2))", this.types);
        VectorExprResultConsistencyTest.testExpression("all((x) -> x != null, array(d1, d2))", this.types);
        VectorExprResultConsistencyTest.testExpression("all((x) -> x != null, array(s1, s2))", this.types);
    }

    @Test
    public void testReduceFns() {
        VectorExprResultConsistencyTest.testExpression("greatest(s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("greatest(l1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("greatest(l1, nonexistent)", this.types);
        VectorExprResultConsistencyTest.testExpression("greatest(d1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("greatest(l1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("greatest(s1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("least(s1, s2)", this.types);
        VectorExprResultConsistencyTest.testExpression("least(l1, l2)", this.types);
        VectorExprResultConsistencyTest.testExpression("least(l1, nonexistent)", this.types);
        VectorExprResultConsistencyTest.testExpression("least(d1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("least(l1, d2)", this.types);
        VectorExprResultConsistencyTest.testExpression("least(s1, l2)", this.types);
    }

    @Test
    public void testJsonFns() {
        VectorExprResultConsistencyTest.testExpression("json_object('k1', s1, 'k2', l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("json_value(json_object('k1', s1, 'k2', l1), '$.k2', 'STRING')", this.types);
        VectorExprResultConsistencyTest.testExpression("json_query(json_object('k1', s1, 'k2', l1), '$.k1')", this.types);
        VectorExprResultConsistencyTest.testExpression("json_query_array(json_object('arr', array(s1, s2)), '$.arr')", this.types);
        VectorExprResultConsistencyTest.testExpression("parse_json(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("try_parse_json(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("to_json_string(json_object('k1', s1))", this.types);
        VectorExprResultConsistencyTest.testExpression("json_keys(json_object('k1', s1, 'k2', l1), '$')", this.types);
        VectorExprResultConsistencyTest.testExpression("json_paths(json_object('k1', s1, 'k2', l1))", this.types);
        VectorExprResultConsistencyTest.testExpression("json_merge(json_object('k1', s1), json_object('k2', l1))", this.types);
    }

    @Test
    public void testTimeFunctions() {
        VectorExprResultConsistencyTest.testExpression("timestamp_ceil(l1, 'P1D')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_ceil(l1, 'PT1H')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_floor(l1, 'P1D')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_floor(l1, 'PT1H')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'MILLENNIUM')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'CENTURY')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'YEAR')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'MONTH')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'DAY')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'HOUR')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'MINUTE')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'SECOND')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'MILLISECOND')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_extract(l1, 'EPOCH')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_shift(l1, 'P1M', 1)", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp(s1, 'yyyy-MM-dd')", this.types);
        VectorExprResultConsistencyTest.testExpression("unix_timestamp(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("unix_timestamp(s1, 'yyyy-MM-dd')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_parse(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_parse(s1, 'yyyy-MM-dd')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_parse(s1, 'yyyy-MM-dd', 'UTC')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_format(l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_format(l1, 'yyyy-MM-dd')", this.types);
        VectorExprResultConsistencyTest.testExpression("timestamp_format(l1, 'yyyy-MM-dd', 'UTC')", this.types);
    }

    @Test
    public void testIpAddressFunctions() {
        VectorExprResultConsistencyTest.testExpression("ipv4_match('192.168.1.1', '192.168.0.0/16')", this.types);
        VectorExprResultConsistencyTest.testExpression("ipv4_match(s1, '192.168.0.0/16')", this.types);
        VectorExprResultConsistencyTest.testExpression("ipv4_parse('192.168.1.1')", this.types);
        VectorExprResultConsistencyTest.testExpression("ipv4_parse(s1)", this.types);
        VectorExprResultConsistencyTest.testExpression("ipv4_stringify(3232235777)", this.types);
        VectorExprResultConsistencyTest.testExpression("ipv4_stringify(l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("ipv6_match('2001:db8::1', '2001:db8::/32')", this.types);
        VectorExprResultConsistencyTest.testExpression("ipv6_match(s1, '2001:db8::/32')", this.types);
    }

    @Test
    public void testOtherFunctions() {
        VectorExprResultConsistencyTest.testExpression("human_readable_binary_byte_format(l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("human_readable_binary_byte_format(l1, 3)", this.types);
        VectorExprResultConsistencyTest.testExpression("human_readable_decimal_byte_format(l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("human_readable_decimal_byte_format(l1, 3)", this.types);
        VectorExprResultConsistencyTest.testExpression("human_readable_decimal_format(l1)", this.types);
        VectorExprResultConsistencyTest.testExpression("human_readable_decimal_format(l1, 3)", this.types);
        VectorExprResultConsistencyTest.testExpression("pi()", this.types);
    }

    static void testFunctions(Map<String, ExpressionType> types, List<String> templates, List<String> args) {
        for (String template : templates) {
            for (String arg : args) {
                String expr = StringUtils.format((String)template, (Object[])new Object[]{arg});
                VectorExprResultConsistencyTest.testExpression(expr, types);
            }
        }
    }

    static void testFunctions(Map<String, ExpressionType> types, List<String> templates, Set<List<String>> argsArrays) {
        for (String template : templates) {
            for (List<String> args : argsArrays) {
                String expr = StringUtils.format((String)template, (Object[])args.toArray());
                VectorExprResultConsistencyTest.testExpression(expr, types);
            }
        }
    }

    public static void testExpression(String expr, Map<String, ExpressionType> types) {
        VectorExprResultConsistencyTest.testExpression(expr, types, MACRO_TABLE);
    }

    public static void testExpression(String expr, Map<String, ExpressionType> types, ExprMacroTable macroTable) {
        log.debug("running expression [%s]", new Object[]{expr});
        Expr parsed = Parser.parse((String)expr, (ExprMacroTable)macroTable);
        VectorExprResultConsistencyTest.testExpressionRandomizedBindings(expr, parsed, types, 10);
        VectorExprResultConsistencyTest.testExpressionSequentialBindings(expr, parsed, types, 10);
    }

    public static void testExpressionSequentialBindings(String expr, Expr parsed, Map<String, ExpressionType> types, int numIterations) {
        for (int iter = 0; iter < numIterations; ++iter) {
            VectorExprResultConsistencyTest.assertEvalsMatch(expr, parsed, VectorExprResultConsistencyTest.makeSequentialBinding(4, types, -2 + iter * 4));
        }
    }

    public static void testExpressionRandomizedBindings(String expr, Expr parsed, Map<String, ExpressionType> types, int numIterations) {
        for (int iterations = 0; iterations < numIterations; ++iterations) {
            VectorExprResultConsistencyTest.assertEvalsMatch(expr, parsed, VectorExprResultConsistencyTest.makeRandomizedBindings(4, types));
        }
    }

    public static void assertEvalsMatch(String exprString, Expr expr, NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> bindings) {
        Assert.assertTrue((String)StringUtils.format((String)"Cannot vectorize[%s]", (Object[])new Object[]{expr}), (boolean)expr.canVectorize((Expr.InputBindingInspector)bindings.rhs));
        ExpressionType outputType = expr.getOutputType((Expr.InputBindingInspector)bindings.rhs);
        Either<String, Object[]> vectorEval = VectorExprResultConsistencyTest.evalVector(expr, (Expr.VectorInputBinding)bindings.rhs, outputType);
        Either<String, Object[]> nonVectorEval = VectorExprResultConsistencyTest.evalNonVector(expr, (Expr.ObjectBinding[])bindings.lhs, outputType);
        Assert.assertEquals((String)StringUtils.format((String)"Errors do not match for expr[%s], bindings[%s]", (Object[])new Object[]{exprString, bindings.lhs}), (Object)(nonVectorEval.isError() ? nonVectorEval.error() : ""), (Object)(vectorEval.isError() ? vectorEval.error() : ""));
        if (vectorEval.isValue() && nonVectorEval.isValue()) {
            for (int i = 0; i < 4; ++i) {
                String message = StringUtils.format((String)"Values do not match for row[%s] for expression[%s], bindings[%s]", (Object[])new Object[]{i, exprString, ((Expr.ObjectBinding[])bindings.lhs)[i]});
                if (outputType != null && outputType.isArray()) {
                    Assert.assertArrayEquals((String)message, (Object[])((Object[])((Object[])nonVectorEval.valueOrThrow())[i]), (Object[])((Object[])((Object[])vectorEval.valueOrThrow())[i]));
                    continue;
                }
                Assert.assertEquals((String)message, (Object)((Object[])nonVectorEval.valueOrThrow())[i], (Object)((Object[])vectorEval.valueOrThrow())[i]);
            }
        }
    }

    public static NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> makeRandomizedBindings(int vectorSize, Map<String, ExpressionType> types) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        return VectorExprResultConsistencyTest.populateBindings(vectorSize, types, () -> r.nextLong(Integer.MIN_VALUE, Integer.MAX_VALUE), () -> r.nextDouble() * (double)(r.nextBoolean() ? 10 : -10), () -> r.nextDouble(0.0, 1.0) > 0.9, () -> String.valueOf(r.nextInt()));
    }

    public static NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> makeSequentialBinding(int vectorSize, Map<String, ExpressionType> types, final int start) {
        return VectorExprResultConsistencyTest.populateBindings(vectorSize, types, new LongSupplier(){
            int counter;
            {
                this.counter = start;
            }

            @Override
            public long getAsLong() {
                return this.counter++;
            }
        }, new DoubleSupplier(){
            int counter;
            {
                this.counter = start;
            }

            @Override
            public double getAsDouble() {
                return this.counter++;
            }
        }, () -> ThreadLocalRandom.current().nextBoolean(), new Supplier<String>(){
            int counter;
            {
                this.counter = start;
            }

            @Override
            public String get() {
                return String.valueOf(this.counter++);
            }
        });
    }

    static NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> populateBindings(int vectorSize, Map<String, ExpressionType> types, LongSupplier longsFn, DoubleSupplier doublesFn, BooleanSupplier nullsFn, Supplier<String> stringFn) {
        SettableVectorInputBinding vectorBinding = new SettableVectorInputBinding(vectorSize);
        SettableObjectBinding[] objectBindings = new SettableObjectBinding[vectorSize];
        Expr.InputBindingInspector inspector = InputBindings.inspectorFromTypeMap(types);
        for (Map.Entry<String, ExpressionType> entry : types.entrySet()) {
            boolean[] nulls = new boolean[vectorSize];
            switch ((ExprType)entry.getValue().getType()) {
                case LONG: {
                    long[] longs = new long[vectorSize];
                    for (int i = 0; i < vectorSize; ++i) {
                        nulls[i] = nullsFn.getAsBoolean();
                        long l = longs[i] = nulls[i] ? 0L : longsFn.getAsLong();
                        if (objectBindings[i] == null) {
                            objectBindings[i] = new SettableObjectBinding().withInspector(inspector);
                        }
                        objectBindings[i].withBinding(entry.getKey(), nulls[i] ? null : Long.valueOf(longs[i]));
                    }
                    vectorBinding.addLong(entry.getKey(), longs, nulls);
                    break;
                }
                case DOUBLE: {
                    double[] doubles = new double[vectorSize];
                    for (int i = 0; i < vectorSize; ++i) {
                        nulls[i] = nullsFn.getAsBoolean();
                        double d = doubles[i] = nulls[i] ? 0.0 : doublesFn.getAsDouble();
                        if (objectBindings[i] == null) {
                            objectBindings[i] = new SettableObjectBinding().withInspector(inspector);
                        }
                        objectBindings[i].withBinding(entry.getKey(), nulls[i] ? null : Double.valueOf(doubles[i]));
                    }
                    vectorBinding.addDouble(entry.getKey(), doubles, nulls);
                    break;
                }
                case STRING: {
                    Object[] strings = new String[vectorSize];
                    for (int i = 0; i < vectorSize; ++i) {
                        nulls[i] = nullsFn.getAsBoolean();
                        if (!nulls[i] && entry.getKey().startsWith("boolString")) {
                            strings[i] = String.valueOf(nullsFn.getAsBoolean());
                        } else {
                            Object object = strings[i] = nulls[i] ? null : String.valueOf(stringFn.get());
                        }
                        if (objectBindings[i] == null) {
                            objectBindings[i] = new SettableObjectBinding().withInspector(inspector);
                        }
                        objectBindings[i].withBinding(entry.getKey(), nulls[i] ? null : strings[i]);
                    }
                    vectorBinding.addString(entry.getKey(), strings);
                }
            }
        }
        return new NonnullPair((Object)objectBindings, (Object)vectorBinding);
    }

    private static Either<String, Object[]> evalVector(Expr expr, Expr.VectorInputBinding bindings, @Nullable ExpressionType outputType) {
        ExprEvalVector vectorEval;
        ExprVectorProcessor processor = expr.asVectorProcessor((Expr.VectorInputBindingInspector)bindings);
        try {
            vectorEval = processor.evalVector(bindings);
        }
        catch (ArithmeticException e) {
            return Either.error((Object)e.getClass().getName());
        }
        catch (Exception e) {
            return Either.error((Object)e.toString());
        }
        Object[] vectorVals = vectorEval.getObjectVector();
        if (outputType != null) {
            Assert.assertEquals((String)"vector eval type", (Object)outputType, (Object)vectorEval.getType());
        }
        return Either.value((Object)vectorVals);
    }

    private static Either<String, Object[]> evalNonVector(Expr expr, Expr.ObjectBinding[] bindings, @Nullable ExpressionType outputType) {
        Object[] exprValues = new Object[4];
        for (int i = 0; i < 4; ++i) {
            ExprEval eval;
            try {
                eval = expr.eval(bindings[i]);
            }
            catch (ArithmeticException e) {
                return Either.error((Object)e.getClass().getName());
            }
            catch (Exception e) {
                return Either.error((Object)e.toString());
            }
            if (outputType != null && eval.value() != null) {
                Assert.assertEquals((String)"nonvector eval type", (Object)eval.type(), (Object)outputType);
            }
            exprValues[i] = eval.value();
        }
        return Either.value((Object)exprValues);
    }

    static {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DruidGuiceExtensions(), new ExpressionModule(), binder -> {
            LookupExtractorFactoryContainerProvider lookupProvider = new LookupExtractorFactoryContainerProvider(){

                public Set<String> getAllLookupNames() {
                    return Set.of("test-lookup", "test-lookup-injective");
                }

                public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
                    if ("test-lookup".equals(lookupName)) {
                        return Optional.of(new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)new TestMapLookupExtractorFactory(LOOKUP, false)));
                    }
                    if ("test-lookup-injective".equals(lookupName)) {
                        return Optional.of(new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)new TestMapLookupExtractorFactory(INJECTIVE_LOOKUP, true)));
                    }
                    return Optional.empty();
                }

                public String getCanonicalLookupName(String lookupName) {
                    return "";
                }
            };
            ExpressionModule.addExprMacro((Binder)binder, LookupExprMacro.class);
            binder.bind(Key.get(ObjectMapper.class, Json.class)).toInstance((Object)new DefaultObjectMapper());
            binder.bind(LookupExtractorFactoryContainerProvider.class).toInstance((Object)lookupProvider);
        }});
        MACRO_TABLE = (ExprMacroTable)injector.getInstance(ExprMacroTable.class);
    }
}

