/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.MetricsVerifier;

public class StubServiceEmitter
extends ServiceEmitter
implements MetricsVerifier {
    private final Queue<Event> events = new ConcurrentLinkedDeque<Event>();
    private final Queue<AlertEvent> alertEvents = new ConcurrentLinkedDeque<AlertEvent>();
    private final ConcurrentHashMap<String, Queue<ServiceMetricEvent>> metricEvents = new ConcurrentHashMap();

    public StubServiceEmitter() {
        super("testing", "localhost", null);
    }

    public StubServiceEmitter(String service, String host) {
        super(service, host, null);
    }

    public void emit(Event event) {
        if (event instanceof ServiceMetricEvent) {
            ServiceMetricEvent metricEvent = (ServiceMetricEvent)event;
            this.metricEvents.computeIfAbsent(metricEvent.getMetric(), name -> new ConcurrentLinkedDeque()).add(metricEvent);
        } else if (event instanceof AlertEvent) {
            this.alertEvents.add((AlertEvent)event);
        }
        this.events.add(event);
    }

    public List<Event> getEvents() {
        return new ArrayList<Event>(this.events);
    }

    public int getNumEmittedEvents() {
        return this.events.size();
    }

    public List<ServiceMetricEvent> getMetricEvents(String metricName) {
        Queue<ServiceMetricEvent> metricEventQueue = this.metricEvents.get(metricName);
        return metricEventQueue == null ? List.of() : List.copyOf(metricEventQueue);
    }

    public List<AlertEvent> getAlerts() {
        return new ArrayList<AlertEvent>(this.alertEvents);
    }

    @Override
    public List<Number> getMetricValues(String metricName, Map<String, Object> dimensionFilters) {
        ArrayList<Number> values = new ArrayList<Number>();
        Queue events = this.metricEvents.getOrDefault(metricName, new ArrayDeque());
        Map<Object, Object> filters = dimensionFilters == null ? Collections.emptyMap() : dimensionFilters;
        for (ServiceMetricEvent event : events) {
            Map userDims = event.getUserDims();
            boolean match = filters.keySet().stream().map(d -> filters.get(d).equals(userDims.get(d))).reduce((a, b) -> a != false && b != false).orElse(true);
            if (!match) continue;
            values.add(event.getValue());
        }
        return values;
    }

    public void start() {
    }

    public void flush() {
        this.events.clear();
        this.alertEvents.clear();
        this.metricEvents.clear();
    }

    public void close() {
    }
}

