/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.OshiSysMonitor;
import org.apache.druid.java.util.metrics.OshiSysMonitorConfig;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.Util;

public class OshiSysMonitorTest {
    private SystemInfo si;
    private HardwareAbstractionLayer hal;
    private OperatingSystem os;

    @Before
    public void setUp() {
        this.si = (SystemInfo)Mockito.mock(SystemInfo.class);
        this.hal = (HardwareAbstractionLayer)Mockito.mock(HardwareAbstractionLayer.class);
        this.os = (OperatingSystem)Mockito.mock(OperatingSystem.class);
        Mockito.when((Object)this.si.getHardware()).thenReturn((Object)this.hal);
        Mockito.when((Object)this.si.getOperatingSystem()).thenReturn((Object)this.os);
    }

    @Test
    public void testDoMonitor() {
        ServiceEmitter serviceEmitter = (ServiceEmitter)Mockito.mock(ServiceEmitter.class);
        OshiSysMonitor sysMonitorOshi = this.createMonitor(new SystemInfo());
        serviceEmitter.start();
        sysMonitorOshi.monitor(serviceEmitter);
        Assert.assertTrue((boolean)sysMonitorOshi.doMonitor(serviceEmitter));
    }

    @Test
    public void testDefaultFeedSysMonitorOshi() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        OshiSysMonitor m = this.createMonitor(new SystemInfo());
        m.start();
        m.monitor((ServiceEmitter)emitter);
        Util.sleep((long)2000L);
        m.monitor((ServiceEmitter)emitter);
        m.stop();
        this.checkEvents(emitter.getEvents(), "metrics");
    }

    @Test
    public void testMemStats() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        GlobalMemory mem = (GlobalMemory)Mockito.mock(GlobalMemory.class);
        Mockito.when((Object)mem.getTotal()).thenReturn((Object)64L);
        Mockito.when((Object)mem.getAvailable()).thenReturn((Object)16L);
        Mockito.when((Object)this.hal.getMemory()).thenReturn((Object)mem);
        OshiSysMonitor m = this.createMonitor(this.si);
        m.start();
        m.monitorMemStats((ServiceEmitter)emitter);
        m.stop();
        Assert.assertEquals((long)3L, (long)emitter.getNumEmittedEvents());
        emitter.verifyEmitted("sys/mem/max", 1);
        emitter.verifyEmitted("sys/mem/used", 1);
        emitter.verifyEmitted("sys/mem/free", 1);
        emitter.verifyValue("sys/mem/max", 64L);
        emitter.verifyValue("sys/mem/used", 48L);
        emitter.verifyValue("sys/mem/free", 16L);
    }

    @Test
    public void testMemStatsSkipOthers() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        GlobalMemory mem = (GlobalMemory)Mockito.mock(GlobalMemory.class);
        Mockito.when((Object)mem.getTotal()).thenReturn((Object)64L);
        Mockito.when((Object)mem.getAvailable()).thenReturn((Object)16L);
        Mockito.when((Object)this.hal.getMemory()).thenReturn((Object)mem);
        OshiSysMonitor m = this.createMonitor(this.si, (List<String>)ImmutableList.of((Object)"mem"));
        m.start();
        m.doMonitor((ServiceEmitter)emitter);
        m.stop();
        Assert.assertEquals((long)3L, (long)emitter.getNumEmittedEvents());
        emitter.verifyEmitted("sys/mem/max", 1);
        emitter.verifyEmitted("sys/mem/used", 1);
        emitter.verifyEmitted("sys/mem/free", 1);
        emitter.verifyEmitted("sys/swap/pageIn", 0);
        emitter.verifyEmitted("sys/fs/max", 0);
    }

    @Test
    public void testSwapStats() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        GlobalMemory mem = (GlobalMemory)Mockito.mock(GlobalMemory.class);
        VirtualMemory swap = (VirtualMemory)Mockito.mock(VirtualMemory.class);
        Mockito.when((Object)swap.getSwapPagesIn()).thenReturn((Object)300L);
        Mockito.when((Object)swap.getSwapPagesOut()).thenReturn((Object)200L);
        Mockito.when((Object)swap.getSwapTotal()).thenReturn((Object)1000L);
        Mockito.when((Object)swap.getSwapUsed()).thenReturn((Object)700L);
        Mockito.when((Object)mem.getVirtualMemory()).thenReturn((Object)swap);
        Mockito.when((Object)this.hal.getMemory()).thenReturn((Object)mem);
        OshiSysMonitor m = this.createMonitor(this.si);
        m.start();
        m.monitorSwapStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)4L, (long)emitter.getNumEmittedEvents());
        emitter.verifyEmitted("sys/swap/pageIn", 1);
        emitter.verifyEmitted("sys/swap/pageOut", 1);
        emitter.verifyEmitted("sys/swap/max", 1);
        emitter.verifyEmitted("sys/swap/free", 1);
        emitter.verifyValue("sys/swap/pageIn", 300L);
        emitter.verifyValue("sys/swap/pageOut", 200L);
        emitter.verifyValue("sys/swap/max", 1000L);
        emitter.verifyValue("sys/swap/free", 300L);
        Mockito.when((Object)swap.getSwapPagesIn()).thenReturn((Object)400L);
        Mockito.when((Object)swap.getSwapPagesOut()).thenReturn((Object)250L);
        Mockito.when((Object)swap.getSwapUsed()).thenReturn((Object)500L);
        emitter.flush();
        m.monitorSwapStats((ServiceEmitter)emitter);
        emitter.verifyValue("sys/swap/pageIn", 100L);
        emitter.verifyValue("sys/swap/pageOut", 50L);
        emitter.verifyValue("sys/swap/max", 1000L);
        emitter.verifyValue("sys/swap/free", 500L);
        m.stop();
    }

    @Test
    public void testFsStats() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        OSFileStore fs1 = (OSFileStore)Mockito.mock(OSFileStore.class);
        OSFileStore fs2 = (OSFileStore)Mockito.mock(OSFileStore.class);
        Mockito.when((Object)fs1.getTotalSpace()).thenReturn((Object)300L);
        Mockito.when((Object)fs1.getUsableSpace()).thenReturn((Object)200L);
        Mockito.when((Object)fs1.getTotalInodes()).thenReturn((Object)1000L);
        Mockito.when((Object)fs1.getFreeInodes()).thenReturn((Object)700L);
        Mockito.when((Object)fs1.getVolume()).thenReturn((Object)"/dev/disk1");
        Mockito.when((Object)fs1.getMount()).thenReturn((Object)"/System/Volumes/boot1");
        Mockito.when((Object)fs2.getTotalSpace()).thenReturn((Object)400L);
        Mockito.when((Object)fs2.getUsableSpace()).thenReturn((Object)320L);
        Mockito.when((Object)fs2.getTotalInodes()).thenReturn((Object)800L);
        Mockito.when((Object)fs2.getFreeInodes()).thenReturn((Object)600L);
        Mockito.when((Object)fs2.getVolume()).thenReturn((Object)"/dev/disk2");
        Mockito.when((Object)fs2.getMount()).thenReturn((Object)"/System/Volumes/boot2");
        ImmutableList osFileStores = ImmutableList.of((Object)fs1, (Object)fs2);
        Mockito.when((Object)fileSystem.getFileStores(true)).thenReturn((Object)osFileStores);
        Mockito.when((Object)this.os.getFileSystem()).thenReturn((Object)fileSystem);
        OshiSysMonitor m = this.createMonitor(this.si);
        m.start();
        m.monitorFsStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)8L, (long)emitter.getNumEmittedEvents());
        emitter.verifyEmitted("sys/fs/max", 2);
        emitter.verifyEmitted("sys/fs/used", 2);
        emitter.verifyEmitted("sys/fs/files/count", 2);
        emitter.verifyEmitted("sys/fs/files/free", 2);
        ImmutableMap userDims1 = ImmutableMap.of((Object)"fsDevName", (Object)"/dev/disk1", (Object)"fsDirName", (Object)"/System/Volumes/boot1");
        List<Number> metricValues1 = emitter.getMetricValues("sys/fs/max", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)300L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/fs/used", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)100L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/fs/files/count", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)1000L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/fs/files/free", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)700L, (Object)metricValues1.get(0));
        ImmutableMap userDims2 = ImmutableMap.of((Object)"fsDevName", (Object)"/dev/disk2", (Object)"fsDirName", (Object)"/System/Volumes/boot2");
        List<Number> metricValues2 = emitter.getMetricValues("sys/fs/max", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)400L, (Object)metricValues2.get(0));
        metricValues2 = emitter.getMetricValues("sys/fs/used", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)80L, (Object)metricValues2.get(0));
        metricValues2 = emitter.getMetricValues("sys/fs/files/count", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)800L, (Object)metricValues2.get(0));
        metricValues2 = emitter.getMetricValues("sys/fs/files/free", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)600L, (Object)metricValues2.get(0));
        m.stop();
    }

    @Test
    public void testDiskStats() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        HWDiskStore disk1 = (HWDiskStore)Mockito.mock(HWDiskStore.class);
        HWDiskStore disk2 = (HWDiskStore)Mockito.mock(HWDiskStore.class);
        Mockito.when((Object)disk1.getReadBytes()).thenReturn((Object)300L);
        Mockito.when((Object)disk1.getReads()).thenReturn((Object)200L);
        Mockito.when((Object)disk1.getWriteBytes()).thenReturn((Object)400L);
        Mockito.when((Object)disk1.getWrites()).thenReturn((Object)500L);
        Mockito.when((Object)disk1.getCurrentQueueLength()).thenReturn((Object)100L);
        Mockito.when((Object)disk1.getTransferTime()).thenReturn((Object)150L);
        Mockito.when((Object)disk1.getName()).thenReturn((Object)"disk1");
        Mockito.when((Object)disk2.getReadBytes()).thenReturn((Object)2000L);
        Mockito.when((Object)disk2.getReads()).thenReturn((Object)3000L);
        Mockito.when((Object)disk2.getWriteBytes()).thenReturn((Object)1000L);
        Mockito.when((Object)disk2.getWrites()).thenReturn((Object)4000L);
        Mockito.when((Object)disk2.getCurrentQueueLength()).thenReturn((Object)750L);
        Mockito.when((Object)disk2.getTransferTime()).thenReturn((Object)800L);
        Mockito.when((Object)disk2.getName()).thenReturn((Object)"disk2");
        ImmutableList hwDiskStores = ImmutableList.of((Object)disk1, (Object)disk2);
        Mockito.when((Object)this.hal.getDiskStores()).thenReturn((Object)hwDiskStores);
        OshiSysMonitor m = this.createMonitor(this.si);
        m.start();
        m.monitorDiskStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)0L, (long)emitter.getNumEmittedEvents());
        Mockito.when((Object)disk1.getReadBytes()).thenReturn((Object)400L);
        Mockito.when((Object)disk1.getReads()).thenReturn((Object)220L);
        Mockito.when((Object)disk1.getWriteBytes()).thenReturn((Object)600L);
        Mockito.when((Object)disk1.getWrites()).thenReturn((Object)580L);
        Mockito.when((Object)disk1.getCurrentQueueLength()).thenReturn((Object)300L);
        Mockito.when((Object)disk1.getTransferTime()).thenReturn((Object)250L);
        Mockito.when((Object)disk2.getReadBytes()).thenReturn((Object)4500L);
        Mockito.when((Object)disk2.getReads()).thenReturn((Object)3500L);
        Mockito.when((Object)disk2.getWriteBytes()).thenReturn((Object)2300L);
        Mockito.when((Object)disk2.getWrites()).thenReturn((Object)5000L);
        Mockito.when((Object)disk2.getCurrentQueueLength()).thenReturn((Object)900L);
        Mockito.when((Object)disk2.getTransferTime()).thenReturn((Object)1100L);
        m.monitorDiskStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)12L, (long)emitter.getNumEmittedEvents());
        ImmutableMap userDims1 = ImmutableMap.of((Object)"diskName", (Object)"disk1");
        List<Number> metricValues1 = emitter.getMetricValues("sys/disk/read/size", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)100L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/disk/read/count", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)20L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/disk/write/size", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)200L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/disk/write/count", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)80L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/disk/queue", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)200L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/disk/transferTime", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)100L, (Object)metricValues1.get(0));
        ImmutableMap userDims2 = ImmutableMap.of((Object)"diskName", (Object)"disk2");
        List<Number> metricValues2 = emitter.getMetricValues("sys/disk/read/size", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)2500L, (Object)metricValues2.get(0));
        metricValues2 = emitter.getMetricValues("sys/disk/read/count", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)500L, (Object)metricValues2.get(0));
        metricValues2 = emitter.getMetricValues("sys/disk/write/size", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)1300L, (Object)metricValues2.get(0));
        metricValues2 = emitter.getMetricValues("sys/disk/write/count", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)1000L, (Object)metricValues2.get(0));
        metricValues2 = emitter.getMetricValues("sys/disk/queue", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)150L, (Object)metricValues2.get(0));
        metricValues2 = emitter.getMetricValues("sys/disk/transferTime", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues2.size());
        Assert.assertEquals((Object)300L, (Object)metricValues2.get(0));
        m.stop();
    }

    @Test
    public void testNetStats() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        NetworkIF net1 = (NetworkIF)Mockito.mock(NetworkIF.class);
        Mockito.when((Object)net1.getBytesRecv()).thenReturn((Object)300L);
        Mockito.when((Object)net1.getPacketsRecv()).thenReturn((Object)200L);
        Mockito.when((Object)net1.getInErrors()).thenReturn((Object)400L);
        Mockito.when((Object)net1.getInDrops()).thenReturn((Object)500L);
        Mockito.when((Object)net1.getBytesSent()).thenReturn((Object)100L);
        Mockito.when((Object)net1.getPacketsSent()).thenReturn((Object)150L);
        Mockito.when((Object)net1.getOutErrors()).thenReturn((Object)200L);
        Mockito.when((Object)net1.getCollisions()).thenReturn((Object)20L);
        Mockito.when((Object)net1.getName()).thenReturn((Object)"Wifi");
        Mockito.when((Object)net1.getIPv4addr()).thenReturn((Object)new String[]{"123.456.7.8", "0.0.0.0", "192.1.2.3"});
        Mockito.when((Object)net1.getMacaddr()).thenReturn((Object)"ha:rd:wa:re:add");
        ImmutableList networkIFS = ImmutableList.of((Object)net1);
        Mockito.when((Object)this.hal.getNetworkIFs()).thenReturn((Object)networkIFS);
        OshiSysMonitor m = this.createMonitor(this.si);
        m.start();
        m.monitorNetStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)0L, (long)emitter.getNumEmittedEvents());
        Mockito.when((Object)net1.getBytesRecv()).thenReturn((Object)400L);
        Mockito.when((Object)net1.getPacketsRecv()).thenReturn((Object)220L);
        Mockito.when((Object)net1.getInErrors()).thenReturn((Object)600L);
        Mockito.when((Object)net1.getInDrops()).thenReturn((Object)580L);
        Mockito.when((Object)net1.getBytesSent()).thenReturn((Object)300L);
        Mockito.when((Object)net1.getPacketsSent()).thenReturn((Object)250L);
        Mockito.when((Object)net1.getOutErrors()).thenReturn((Object)330L);
        Mockito.when((Object)net1.getCollisions()).thenReturn((Object)240L);
        m.monitorNetStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)16L, (long)emitter.getNumEmittedEvents());
        ImmutableMap userDims1 = ImmutableMap.of((Object)"netName", (Object)"Wifi", (Object)"netAddress", (Object)"123.456.7.8", (Object)"netHwaddr", (Object)"ha:rd:wa:re:add");
        ImmutableMap userDims2 = ImmutableMap.of((Object)"netName", (Object)"Wifi", (Object)"netAddress", (Object)"192.1.2.3", (Object)"netHwaddr", (Object)"ha:rd:wa:re:add");
        List<Number> metricValues1 = emitter.getMetricValues("sys/net/read/size", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)100L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/read/packets", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)20L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/read/errors", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)200L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/read/dropped", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)80L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/write/size", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)200L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/write/packets", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)100L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/write/errors", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)130L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/write/collisions", (Map<String, Object>)userDims1);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)220L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/read/size", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)100L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/read/packets", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)20L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/read/errors", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)200L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/read/dropped", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)80L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/write/size", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)200L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/write/packets", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)100L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/write/errors", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)130L, (Object)metricValues1.get(0));
        metricValues1 = emitter.getMetricValues("sys/net/write/collisions", (Map<String, Object>)userDims2);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)220L, (Object)metricValues1.get(0));
        m.stop();
    }

    @Test
    public void testCpuStats() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        CentralProcessor processor = (CentralProcessor)Mockito.mock(CentralProcessor.class);
        long[][] procTicks = new long[][]{{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}, {2L, 4L, 6L, 8L, 10L, 12L, 14L, 16L}};
        Mockito.when((Object)processor.getProcessorCpuLoadTicks()).thenReturn((Object)procTicks);
        Mockito.when((Object)this.hal.getProcessor()).thenReturn((Object)processor);
        OshiSysMonitor m = this.createMonitor(this.si);
        m.start();
        m.monitorCpuStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)0L, (long)emitter.getNumEmittedEvents());
        long[][] procTicks2 = new long[][]{{4L, 5L, 6L, 8L, 9L, 7L, 10L, 12L}, {5L, 8L, 8L, 10L, 15L, 14L, 18L, 22L}};
        Mockito.when((Object)processor.getProcessorCpuLoadTicks()).thenReturn((Object)procTicks2);
        m.monitorCpuStats((ServiceEmitter)emitter);
        m.stop();
        Assert.assertEquals((long)16L, (long)emitter.getNumEmittedEvents());
        HashMap<String, Object> userDims = new HashMap<String, Object>();
        userDims.put("cpuName", "0");
        userDims.put("cpuTime", "user");
        List<Number> metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)12L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "nice");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)12L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "sys");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)12L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "idle");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)16L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "wait");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)16L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "irq");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)4L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "softIrq");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)12L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "stolen");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)16L, (Object)metricValues1.get(0));
        userDims.replace("cpuName", "1");
        userDims.replace("cpuTime", "user");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)10L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "nice");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)14L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "sys");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)7L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "idle");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)7L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "wait");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)17L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "irq");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)7L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "softIrq");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)14L, (Object)metricValues1.get(0));
        userDims.replace("cpuTime", "stolen");
        metricValues1 = emitter.getMetricValues("sys/cpu", userDims);
        Assert.assertEquals((long)1L, (long)metricValues1.size());
        Assert.assertEquals((Object)21L, (Object)metricValues1.get(0));
    }

    @Test
    public void testSysStats() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        Mockito.when((Object)this.os.getSystemUptime()).thenReturn((Object)4000L);
        CentralProcessor processor = (CentralProcessor)Mockito.mock(CentralProcessor.class);
        double[] la = new double[]{2.31, 4.31, 5.31};
        Mockito.when((Object)processor.getSystemLoadAverage(3)).thenReturn((Object)la);
        Mockito.when((Object)this.hal.getProcessor()).thenReturn((Object)processor);
        OshiSysMonitor m = this.createMonitor(this.si);
        m.start();
        m.monitorSysStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)4L, (long)emitter.getNumEmittedEvents());
        m.stop();
        emitter.verifyEmitted("sys/uptime", 1);
        emitter.verifyEmitted("sys/la/1", 1);
        emitter.verifyEmitted("sys/la/5", 1);
        emitter.verifyEmitted("sys/la/15", 1);
        emitter.verifyValue("sys/uptime", 4000L);
        emitter.verifyValue("sys/la/1", 2.31);
        emitter.verifyValue("sys/la/5", 4.31);
        emitter.verifyValue("sys/la/15", 5.31);
    }

    @Test
    public void testTcpStats() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        InternetProtocolStats.TcpStats tcpv4 = (InternetProtocolStats.TcpStats)Mockito.mock(InternetProtocolStats.TcpStats.class);
        InternetProtocolStats ipstats = (InternetProtocolStats)Mockito.mock(InternetProtocolStats.class);
        Mockito.when((Object)tcpv4.getConnectionsActive()).thenReturn((Object)10L);
        Mockito.when((Object)tcpv4.getConnectionsPassive()).thenReturn((Object)20L);
        Mockito.when((Object)tcpv4.getConnectionFailures()).thenReturn((Object)5L);
        Mockito.when((Object)tcpv4.getConnectionsReset()).thenReturn((Object)7L);
        Mockito.when((Object)tcpv4.getSegmentsReceived()).thenReturn((Object)200L);
        Mockito.when((Object)tcpv4.getInErrors()).thenReturn((Object)3L);
        Mockito.when((Object)tcpv4.getSegmentsSent()).thenReturn((Object)300L);
        Mockito.when((Object)tcpv4.getOutResets()).thenReturn((Object)4L);
        Mockito.when((Object)tcpv4.getSegmentsRetransmitted()).thenReturn((Object)8L);
        Mockito.when((Object)ipstats.getTCPv4Stats()).thenReturn((Object)tcpv4);
        Mockito.when((Object)this.os.getInternetProtocolStats()).thenReturn((Object)ipstats);
        OshiSysMonitor m = this.createMonitor(this.si);
        m.start();
        m.monitorTcpStats((ServiceEmitter)emitter);
        Assert.assertEquals((long)0L, (long)emitter.getNumEmittedEvents());
        Mockito.when((Object)tcpv4.getConnectionsActive()).thenReturn((Object)20L);
        Mockito.when((Object)tcpv4.getConnectionsPassive()).thenReturn((Object)25L);
        Mockito.when((Object)tcpv4.getConnectionFailures()).thenReturn((Object)8L);
        Mockito.when((Object)tcpv4.getConnectionsReset()).thenReturn((Object)14L);
        Mockito.when((Object)tcpv4.getSegmentsReceived()).thenReturn((Object)350L);
        Mockito.when((Object)tcpv4.getInErrors()).thenReturn((Object)4L);
        Mockito.when((Object)tcpv4.getSegmentsSent()).thenReturn((Object)500L);
        Mockito.when((Object)tcpv4.getOutResets()).thenReturn((Object)7L);
        Mockito.when((Object)tcpv4.getSegmentsRetransmitted()).thenReturn((Object)8L);
        m.monitorTcpStats((ServiceEmitter)emitter);
        m.stop();
        Assert.assertEquals((long)9L, (long)emitter.getNumEmittedEvents());
        emitter.verifyValue("sys/tcpv4/activeOpens", 10L);
        emitter.verifyValue("sys/tcpv4/passiveOpens", 5L);
        emitter.verifyValue("sys/tcpv4/attemptFails", 3L);
        emitter.verifyValue("sys/tcpv4/estabResets", 7L);
        emitter.verifyValue("sys/tcpv4/in/segs", 150L);
        emitter.verifyValue("sys/tcpv4/in/errs", 1L);
        emitter.verifyValue("sys/tcpv4/out/segs", 200L);
        emitter.verifyValue("sys/tcpv4/out/rsts", 3L);
        emitter.verifyValue("sys/tcpv4/retrans/segs", 0L);
    }

    private void checkEvents(List<Event> events, String expectedFeed) {
        Assert.assertFalse((String)"no events emitted", (boolean)events.isEmpty());
        for (Event e : events) {
            if (expectedFeed.equals(e.getFeed())) continue;
            String message = StringUtils.format((String)"\"feed\" in event: %s", (Object[])new Object[]{e.toMap().toString()});
            Assert.assertEquals((String)message, (Object)expectedFeed, (Object)e.getFeed());
        }
    }

    private OshiSysMonitor createMonitor(SystemInfo si) {
        return this.createMonitor(si, (List<String>)ImmutableList.of());
    }

    private OshiSysMonitor createMonitor(SystemInfo si, List<String> categories) {
        return new OshiSysMonitor((Map)ImmutableMap.of(), new OshiSysMonitorConfig(categories), si);
    }

    private static enum STATS {
        MEM,
        SWAP,
        FS,
        DISK,
        NET,
        CPU,
        SYS,
        TCP;

    }
}

