/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.CgroupV2CpuMonitor;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupV2Discoverer;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class CgroupV2CpuMonitorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private File statFile;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws IOException {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupV2Discoverer(this.procDir.toPath());
        TestUtils.setUpCgroupsV2(this.procDir, this.cgroupDir);
        this.statFile = new File(this.cgroupDir, "cpu.stat");
        TestUtils.copyOrReplaceResource("/cgroupv2/cpu.stat", this.statFile);
    }

    @Test
    public void testMonitor() throws IOException, InterruptedException {
        CgroupV2CpuMonitor monitor = new CgroupV2CpuMonitor(this.discoverer);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        Assert.assertEquals((long)0L, (long)emitter.getNumEmittedEvents());
        emitter.flush();
        TestUtils.copyOrReplaceResource("/cgroupv2/cpu.stat-2", this.statFile);
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        Assert.assertTrue((boolean)emitter.getEvents().stream().map(e -> e.toMap().get((Object)"metric")).collect(Collectors.toList()).containsAll((Collection<?>)ImmutableSet.of((Object)"cgroup/cpu/usage/total/percentage", (Object)"cgroup/cpu/usage/user/percentage", (Object)"cgroup/cpu/usage/sys/percentage")));
    }
}

