/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.service;

import com.google.common.collect.ImmutableMap;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.service.SegmentMetadataEvent;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class SegmentMetadataEventTest {
    @Test
    public void testBasicEvent() {
        SegmentMetadataEvent event = new SegmentMetadataEvent("dummy_datasource", DateTimes.of((String)"2001-01-01T00:00:00.000Z"), DateTimes.of((String)"2001-01-02T00:00:00.000Z"), DateTimes.of((String)"2001-01-03T00:00:00.000Z"), "dummy_version", true);
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"segment_metadata").put((Object)"dataSource", (Object)"dummy_datasource").put((Object)"createdTime", (Object)DateTimes.of((String)"2001-01-01T00:00:00.000Z")).put((Object)"startTime", (Object)DateTimes.of((String)"2001-01-02T00:00:00.000Z")).put((Object)"endTime", (Object)DateTimes.of((String)"2001-01-03T00:00:00.000Z")).put((Object)"version", (Object)"dummy_version").put((Object)"isCompacted", (Object)true).build(), (Object)event.toMap());
    }

    @Test
    public void testCreate() {
        DataSegment segment = DataSegment.builder().dataSource("wiki").interval(Intervals.of((String)"2023/2024")).shardSpec((ShardSpec)new NumberedShardSpec(1, 1)).version("v1").size(100L).build();
        DateTime eventTime = DateTimes.nowUtc();
        SegmentMetadataEvent event = SegmentMetadataEvent.create((DataSegment)segment, (DateTime)eventTime);
        Assert.assertEquals((Object)EventMap.builder().put("feed", (Object)"segment_metadata").put("dataSource", (Object)segment.getDataSource()).put("createdTime", (Object)eventTime).put("startTime", (Object)segment.getInterval().getStart()).put("endTime", (Object)segment.getInterval().getEnd()).put("version", (Object)segment.getVersion()).put("isCompacted", (Object)false).build(), (Object)event.toMap());
    }
}

