/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.logger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class LoggerTest {
    private final Logger log = new Logger(LoggerTest.class);

    @Test
    public void testLogWithCrazyMessages() {
        String message = "this % might %d kill %*.s the %s parser";
        this.log.warn("this % might %d kill %*.s the %s parser", new Object[0]);
    }

    @Test
    public void testLegacyLogging() {
        Throwable throwable = new Throwable();
        this.log.error("foo", throwable);
        this.log.warn("foo", throwable);
    }

    @Test
    public void testErrorExceptions() {
        this.log.noStackTrace().error((Throwable)new RuntimeException("beep"), "Feel the hatred of %d years", new Object[]{10000});
        this.log.noStackTrace().error((Throwable)new RuntimeException("beep"), "", new Object[0]);
        this.log.error((Throwable)new RuntimeException("beep"), "An exception", new Object[0]);
    }

    @Test
    public void testLogNoSegments() {
        ArrayList<String> messages = new ArrayList<String>();
        Logger.LogFunction logger = this.getLogToListFunction(messages);
        Logger.logSegments((Logger.LogFunction)logger, Collections.emptyList(), (String)"None segments");
        Logger.logSegmentIds((Logger.LogFunction)logger, Stream.empty(), (String)"None segments");
        Assert.assertEquals((long)0L, (long)messages.size());
    }

    @Test
    public void testLogSegments() {
        ArrayList<String> messages = new ArrayList<String>();
        List segments = this.makeDataSegments(2).collect(Collectors.toList());
        Logger.LogFunction logger = this.getLogToListFunction(messages);
        Logger.logSegments((Logger.LogFunction)logger, segments, (String)"Test segments");
        Assert.assertEquals((long)1L, (long)messages.size());
        String expected = "Test segments: [someDataSource_2012-01-01T00:00:00.000Z_2012-01-03T00:00:00.000Z_2020-02-02T00:00:00.000Z, someDataSource_2012-01-02T00:00:00.000Z_2012-01-04T00:00:00.000Z_2020-02-02T00:00:00.000Z]";
        Assert.assertEquals((Object)"Test segments: [someDataSource_2012-01-01T00:00:00.000Z_2012-01-03T00:00:00.000Z_2020-02-02T00:00:00.000Z, someDataSource_2012-01-02T00:00:00.000Z_2012-01-04T00:00:00.000Z_2020-02-02T00:00:00.000Z]", messages.get(0));
    }

    @Test
    public void testLogSegmentIds() {
        ArrayList<String> messages = new ArrayList<String>();
        Stream<SegmentId> segments = this.makeDataSegments(2).map(DataSegment::getId);
        Logger.LogFunction logger = this.getLogToListFunction(messages);
        Logger.logSegmentIds((Logger.LogFunction)logger, segments, (String)"Test segments");
        Assert.assertEquals((long)1L, (long)messages.size());
        String expected = "Test segments: [someDataSource_2012-01-01T00:00:00.000Z_2012-01-03T00:00:00.000Z_2020-02-02T00:00:00.000Z, someDataSource_2012-01-02T00:00:00.000Z_2012-01-04T00:00:00.000Z_2020-02-02T00:00:00.000Z]";
        Assert.assertEquals((Object)"Test segments: [someDataSource_2012-01-01T00:00:00.000Z_2012-01-03T00:00:00.000Z_2020-02-02T00:00:00.000Z, someDataSource_2012-01-02T00:00:00.000Z_2012-01-04T00:00:00.000Z_2020-02-02T00:00:00.000Z]", messages.get(0));
    }

    @Test
    public void testLogSegmentsMany() {
        int numSegments = 100000;
        MutableInt msgCount = new MutableInt();
        Stream<SegmentId> segments = this.makeDataSegments(100000).map(DataSegment::getId);
        Logger.LogFunction logger = (msg, format) -> {
            String message = StringUtils.format((String)msg, (Object[])format);
            Assert.assertTrue((boolean)message.startsWith("Many segments: ["));
            Assert.assertTrue((boolean)message.endsWith("]"));
            msgCount.increment();
        };
        Logger.logSegmentIds((Logger.LogFunction)logger, segments, (String)"Many segments");
        int expected = (int)Math.ceil(1562.5);
        Assert.assertEquals((long)expected, (long)msgCount.intValue());
    }

    @Test
    public void testGetName() {
        String expected = "org.apache.druid.java.util.common.logger.LoggerTest";
        Assert.assertEquals((Object)expected, (Object)this.log.getName());
    }

    private Logger.LogFunction getLogToListFunction(List<String> messages) {
        return (msg, format) -> messages.add(StringUtils.format((String)msg, (Object[])format));
    }

    private Stream<DataSegment> makeDataSegments(int numSegments) {
        DateTime start = DateTimes.of((String)"2012-01-01");
        DateTime end = DateTimes.of((String)"2012-01-02");
        String version = DateTimes.of((String)"2020-02-02").toString();
        return IntStream.range(0, numSegments).mapToObj(segmentNum -> DataSegment.builder().dataSource("someDataSource").interval(new Interval((ReadableInstant)start.plusDays(segmentNum), (ReadableInstant)end.plusDays(segmentNum + 1))).version(version).size(1L).build());
    }
}

