/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.apache.druid.java.util.common.guava.Accumulators;
import org.apache.druid.java.util.common.guava.ExplodingSequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class YieldingSequenceBaseTest {
    @Test
    public void testAccumulate() {
        ExplodingSequence sequence = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)3)), false, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2, (Object)3), (Object)sequence.accumulate(new ArrayList(), Accumulators.list()));
        Assert.assertEquals((String)"Closes resources", (long)1L, (long)sequence.getCloseCount());
    }

    @Test
    public void testExceptionDuringGet() {
        ExplodingSequence sequence = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)3)), true, false);
        try {
            sequence.accumulate(new ArrayList(), Accumulators.list());
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"get")));
        }
        Assert.assertEquals((String)"Closes resources", (long)1L, (long)sequence.getCloseCount());
    }

    @Test
    public void testExceptionDuringClose() {
        ExplodingSequence sequence = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)3)), false, true);
        try {
            sequence.accumulate(new ArrayList(), Accumulators.list());
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"close"))));
        }
        Assert.assertEquals((String)"Closes resources", (long)1L, (long)sequence.getCloseCount());
    }

    @Test
    public void testExceptionDuringGetAndClose() {
        ExplodingSequence sequence = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)3)), true, true);
        try {
            sequence.accumulate(new ArrayList(), Accumulators.list());
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"get")));
        }
        Assert.assertEquals((String)"Closes resources", (long)1L, (long)sequence.getCloseCount());
    }
}

