/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;

public class TestSequence<T>
implements Sequence<T> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Sequence<T> base;

    public static <T> TestSequence<T> create(Iterable<T> iterable) {
        return new TestSequence<T>(iterable);
    }

    public static <T> TestSequence<T> create(T ... vals) {
        return TestSequence.create(Arrays.asList(vals));
    }

    public TestSequence(Iterable<T> iterable) {
        this.base = Sequences.withBaggage((Sequence)Sequences.simple(iterable), (Closeable)new Closeable(){

            @Override
            public void close() {
                TestSequence.this.closed.set(true);
            }
        });
    }

    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
        return (OutType)this.base.accumulate(initValue, accumulator);
    }

    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        return this.base.toYielder(initValue, accumulator);
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

