/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.junit.Assert;

public class SequenceTestHelper {
    public static void testAll(Sequence<Integer> seq, List<Integer> nums) throws IOException {
        SequenceTestHelper.testAll("", seq, nums);
    }

    public static void testAll(String prefix, Sequence<Integer> seq, List<Integer> nums) throws IOException {
        SequenceTestHelper.testAccumulation(prefix, seq, nums);
        SequenceTestHelper.testYield(prefix, seq, nums);
    }

    public static void testYield(String prefix, Sequence<Integer> seq, List<Integer> nums) throws IOException {
        SequenceTestHelper.testYield(prefix, 3, seq, nums);
        SequenceTestHelper.testYield(prefix, 1, seq, nums);
    }

    public static void testYield(final String prefix, final int numToTake, Sequence<Integer> seq, final List<Integer> nums) throws IOException {
        Iterator<Integer> numsIter = nums.iterator();
        Yielder yielder = seq.toYielder((Object)0, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){
            final Iterator<Integer> valsIter;
            int count;
            {
                this.valsIter = nums.iterator();
                this.count = 0;
            }

            public Integer accumulate(Integer accumulated, Integer in) {
                if (++this.count >= numToTake) {
                    this.count = 0;
                    this.yield();
                }
                Assert.assertEquals((String)prefix, (Object)this.valsIter.next(), (Object)in);
                return accumulated + in;
            }
        });
        int expectedSum = 0;
        while (numsIter.hasNext()) {
            int i;
            for (i = 0; i < numToTake && numsIter.hasNext(); ++i) {
                expectedSum += numsIter.next().intValue();
            }
            if (i < numToTake) continue;
            Assert.assertFalse((String)prefix, (boolean)yielder.isDone());
            Assert.assertEquals((String)prefix, (long)expectedSum, (long)((Integer)yielder.get()).intValue());
            expectedSum = 0;
            yielder = yielder.next((Object)0);
        }
        Assert.assertEquals((long)expectedSum, (long)((Integer)yielder.get()).intValue());
        Assert.assertTrue((String)prefix, (boolean)yielder.isDone());
        yielder.close();
    }

    public static void testAccumulation(final String prefix, Sequence<Integer> seq, final List<Integer> nums) {
        int expectedSum = 0;
        for (Integer num : nums) {
            expectedSum += num.intValue();
        }
        int sum = (Integer)seq.accumulate((Object)0, (Accumulator)new Accumulator<Integer, Integer>(){
            final Iterator<Integer> valsIter;
            {
                this.valsIter = nums.iterator();
            }

            public Integer accumulate(Integer accumulated, Integer in) {
                Assert.assertEquals((String)prefix, (Object)this.valsIter.next(), (Object)in);
                return accumulated + in;
            }
        });
        Assert.assertEquals((String)prefix, (long)expectedSum, (long)sum);
    }

    public static void testClosed(AtomicInteger closedCounter, Sequence<Integer> seq) {
        boolean exceptionThrown = false;
        try {
            seq.accumulate((Object)1, (accumulated, in) -> accumulated + 1);
        }
        catch (UnsupportedOperationException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        Assert.assertEquals((long)1L, (long)closedCounter.get());
        exceptionThrown = false;
        Yielder yielder = null;
        try {
            yielder = seq.toYielder((Object)1, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){

                public Integer accumulate(Integer accumulated, Integer in) {
                    return accumulated + 1;
                }
            });
        }
        catch (UnsupportedOperationException e) {
            exceptionThrown = true;
        }
        Assert.assertNull(yielder);
        Assert.assertTrue((boolean)exceptionThrown);
        Assert.assertEquals((long)2L, (long)closedCounter.get());
        exceptionThrown = false;
        try {
            seq.forEach(i -> {});
        }
        catch (UnsupportedOperationException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        Assert.assertEquals((long)3L, (long)closedCounter.get());
    }
}

