/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class PeriodGranularityTest {
    PeriodGranularity UTC_PT1H = new PeriodGranularity(new Period((Object)"PT1H"), null, DateTimeZone.UTC);
    PeriodGranularity UTC_PT30M = new PeriodGranularity(new Period((Object)"PT30M"), null, DateTimeZone.UTC);
    DateTimeZone PACIFIC_TZ = DateTimes.inferTzFromString((String)"America/Los_Angeles");
    DateTimeZone INDIAN_TZ = DateTimes.inferTzFromString((String)"Asia/Kolkata");

    @Test
    public void testCanBeMappedTo_sameTimeZone() {
        Assertions.assertTrue((boolean)this.UTC_PT30M.canBeMappedTo(this.UTC_PT1H));
        PeriodGranularity pacificPT2H = new PeriodGranularity(new Period((Object)"PT2H"), null, this.PACIFIC_TZ);
        Assertions.assertFalse((boolean)pacificPT2H.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT20M"), null, this.PACIFIC_TZ)));
        Assertions.assertTrue((boolean)pacificPT2H.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT6H"), null, this.PACIFIC_TZ)));
        PeriodGranularity pacificP1D = new PeriodGranularity(new Period((Object)"P1D"), null, this.PACIFIC_TZ);
        Assertions.assertFalse((boolean)pacificP1D.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT1H"), null, this.PACIFIC_TZ)));
        Assertions.assertTrue((boolean)pacificP1D.canBeMappedTo(new PeriodGranularity(new Period((Object)"P1M"), null, this.PACIFIC_TZ)));
        PeriodGranularity pacificP2D = new PeriodGranularity(new Period((Object)"P2D"), null, this.PACIFIC_TZ);
        Assertions.assertFalse((boolean)pacificP2D.canBeMappedTo(new PeriodGranularity(new Period((Object)"P1W"), null, this.PACIFIC_TZ)));
        Assertions.assertTrue((boolean)pacificP2D.canBeMappedTo(new PeriodGranularity(new Period((Object)"P2W"), null, this.PACIFIC_TZ)));
        PeriodGranularity pacificPT1W2D = new PeriodGranularity(new Period((Object)"P1W").withDays(2), null, this.PACIFIC_TZ);
        Assertions.assertFalse((boolean)pacificPT1W2D.canBeMappedTo(new PeriodGranularity(new Period((Object)"P2M"), null, this.PACIFIC_TZ)));
        Assertions.assertFalse((boolean)pacificPT1W2D.canBeMappedTo(new PeriodGranularity(new Period((Object)"P2Y"), null, this.PACIFIC_TZ)));
        Assertions.assertTrue((boolean)pacificPT1W2D.canBeMappedTo(pacificPT1W2D));
        Assertions.assertTrue((boolean)pacificPT1W2D.canBeMappedTo(new PeriodGranularity(new Period((Object)"P2W").withDays(4), null, this.PACIFIC_TZ)));
        Assertions.assertTrue((boolean)pacificP1D.canBeMappedTo(pacificPT1W2D));
        Assertions.assertTrue((boolean)pacificPT2H.canBeMappedTo(new PeriodGranularity(new Period((Object)"P1D").withHours(2), null, this.PACIFIC_TZ)));
    }

    @Test
    public void testCanBeMappedTo_sameHourlyAlignWithUtc() {
        Assertions.assertTrue((boolean)this.UTC_PT1H.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT1H"), null, this.PACIFIC_TZ)));
        Assertions.assertTrue((boolean)this.UTC_PT1H.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT3H"), null, this.PACIFIC_TZ)));
    }

    @Test
    public void testCanBeMappedTo_same30MinutesAlignWithUtc() {
        Assertions.assertFalse((boolean)this.UTC_PT1H.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT2H"), null, this.INDIAN_TZ)));
        Assertions.assertFalse((boolean)new PeriodGranularity(new Period((Object)"PT1H"), null, this.PACIFIC_TZ).canBeMappedTo(new PeriodGranularity(new Period((Object)"PT1H"), null, this.INDIAN_TZ)));
        Assertions.assertTrue((boolean)new PeriodGranularity(new Period((Object)"PT30M"), null, this.PACIFIC_TZ).canBeMappedTo(new PeriodGranularity(new Period((Object)"PT1H"), null, this.INDIAN_TZ)));
        Assertions.assertTrue((boolean)this.UTC_PT30M.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT30M"), null, this.PACIFIC_TZ)));
    }

    @Test
    public void testCanBeMappedTo_withOrigin() {
        Assertions.assertFalse((boolean)new PeriodGranularity(new Period((Object)"PT1H"), DateTimes.nowUtc(), DateTimeZone.UTC).canBeMappedTo(new PeriodGranularity(new Period((Object)"PT2H"), null, DateTimeZone.UTC)));
        Assertions.assertFalse((boolean)this.UTC_PT1H.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT1H"), DateTimes.nowUtc(), DateTimeZone.UTC)));
    }

    @Test
    public void testCanBeMappedTo_differentTimeZone() {
        PeriodGranularity pacificPT1H = new PeriodGranularity(new Period((Object)"PT1H"), null, this.PACIFIC_TZ);
        Assertions.assertTrue((boolean)pacificPT1H.canBeMappedTo(this.UTC_PT1H));
        Assertions.assertTrue((boolean)pacificPT1H.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT3H"), null, DateTimes.inferTzFromString((String)"America/New_York"))));
        Assertions.assertTrue((boolean)pacificPT1H.canBeMappedTo(new PeriodGranularity(new Period((Object)"P1M"), null, DateTimeZone.UTC)));
        Assertions.assertFalse((boolean)pacificPT1H.canBeMappedTo(new PeriodGranularity(new Period((Object)"PT1H"), null, this.INDIAN_TZ)));
        Assertions.assertFalse((boolean)pacificPT1H.canBeMappedTo(new PeriodGranularity(new Period((Object)"P1D"), null, this.INDIAN_TZ)));
        Assertions.assertFalse((boolean)new PeriodGranularity(new Period((Object)"P1D"), null, this.PACIFIC_TZ).canBeMappedTo(new PeriodGranularity(new Period((Object)"P1D"), null, DateTimeZone.UTC)));
    }
}

