/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.util.Arrays;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class IntervalsTest {
    @Test
    public void testFindOverlappingInterval() {
        Interval[] sortedIntervals = new Interval[]{Intervals.of((String)"2019/2020"), Intervals.of((String)"2021/2022"), Intervals.of((String)"2021-04-01/2021-05-01"), Intervals.of((String)"2022/2023")};
        Arrays.sort(sortedIntervals, Comparators.intervalsByStartThenEnd());
        Assert.assertNull((Object)Intervals.findOverlappingInterval((Interval)Intervals.of((String)"2018/2019"), (Interval[])sortedIntervals));
        Assert.assertNull((Object)Intervals.findOverlappingInterval((Interval)Intervals.of((String)"2023/2024"), (Interval[])sortedIntervals));
        Assert.assertEquals((Object)Intervals.of((String)"2021/2022"), (Object)Intervals.findOverlappingInterval((Interval)Intervals.of((String)"2021/2022"), (Interval[])sortedIntervals));
        Assert.assertEquals((Object)Intervals.of((String)"2022/2023"), (Object)Intervals.findOverlappingInterval((Interval)Intervals.of((String)"2022-01-01/2022-01-02"), (Interval[])sortedIntervals));
        Assert.assertEquals((Object)Intervals.of((String)"2021/2022"), (Object)Intervals.findOverlappingInterval((Interval)Intervals.of((String)"2021-06-01/2021-07-01"), (Interval[])sortedIntervals));
        Assert.assertEquals((Object)Intervals.of((String)"2021/2022"), (Object)Intervals.findOverlappingInterval((Interval)Intervals.of((String)"2021-03-01/2021-04-01"), (Interval[])sortedIntervals));
        Assert.assertNull((Object)Intervals.findOverlappingInterval((Interval)Intervals.of((String)"2020-01-02/2020-03-03"), (Interval[])sortedIntervals));
    }

    @Test
    public void testValidIntervalStrings() {
        String[] intervalStringRepresentations;
        for (String s : intervalStringRepresentations = new String[]{"2022-01-01T00:00:00.000Z/2022-01-02T00:00:00.000Z", "2021-03-14T12:34:56.789Z/2021-03-15T12:34:56.789Z", "2022-01-01T00:00:00.000+05:30/2022-01-01T01:00:00.000+05:30", "2022-01-01T07:00:00.000-07:00/2022-01-01T08:00:00.000-07:00", "2022-01-01T00:00:00.000+0530/2022-01-01T01:00:00.000+0530", "2022-01-01T00:00:00Z/2022-01-02T00:00:00Z", "2022-01-01/2022-01-02", "2022-01-01T00:00:00.000Z/P1D", "2022-01-01T12:00:00Z/PT6H", "2022-01-01T00:00:00Z/P2DT3H4M5S", "P1D/2022-01-02T00:00:00.000Z", "PT6H/2022-01-01T18:00:00Z", "P2DT3H4M5S/2022-01-03T03:04:05Z"}) {
            Interval expected = Intervals.of((String)s);
            Interval actual = Intervals.fromString((String)s);
            Assert.assertEquals((String)("Mismatch for: " + s), (Object)expected, (Object)actual);
        }
    }

    @Test
    public void testInvalidInterval() {
        DruidExceptionMatcher.invalidInput().assertThrowsAndMatches(() -> Intervals.of((String)"invalid string"));
    }
}

