/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.util.TimeZone;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DateTimesTest {
    @Test
    public void testCommonDateTimePattern() {
        DateTime dt1 = DateTimes.nowUtc();
        DateTime dt2 = new DateTime(System.currentTimeMillis(), DateTimes.inferTzFromString((String)"IST"));
        DateTime dt3 = new DateTime(System.currentTimeMillis(), DateTimeZone.forOffsetHoursMinutes((int)1, (int)30));
        for (DateTime dt : new DateTime[]{dt1, dt2, dt3}) {
            Assert.assertTrue((boolean)DateTimes.COMMON_DATE_TIME_PATTERN.matcher(dt.toString()).matches());
        }
    }

    @Test
    public void testinferTzFromStringWithKnownTzId() {
        Assert.assertEquals((Object)DateTimeZone.UTC, (Object)DateTimes.inferTzFromString((String)"UTC"));
    }

    @Test
    public void testinferTzFromStringWithOffset() {
        Assert.assertEquals((Object)DateTimeZone.forOffsetHoursMinutes((int)10, (int)30), (Object)DateTimes.inferTzFromString((String)"+1030"));
    }

    @Test
    public void testinferTzFromStringWithJavaTimeZone() {
        Assert.assertEquals((Object)DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("ACT")), (Object)DateTimes.inferTzFromString((String)"ACT"));
    }

    @Test
    public void testinferTzFromStringWithJavaTimeZoneAndNoFallback() {
        Assert.assertEquals((Object)DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("ACT")), (Object)DateTimes.inferTzFromString((String)"ACT", (boolean)false));
    }

    @Test
    public void testinferTzFromStringWithUnknownTimeZoneShouldReturnUTC() {
        Assert.assertEquals((Object)DateTimeZone.UTC, (Object)DateTimes.inferTzFromString((String)"America/Unknown"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testinferTzFromStringWithUnknownTimeZoneAndNoFallbackShouldThrowException() {
        Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)DateTimes.inferTzFromString((String)"America/Unknown", (boolean)false));
    }

    @Test
    public void testStringToDateTimeConversion() {
        String seconds = "2018-01-30T06:00:00";
        DateTime dt2 = DateTimes.of((String)seconds);
        Assert.assertEquals((Object)"2018-01-30T06:00:00.000Z", (Object)dt2.toString());
        String milis = "1517292000000";
        DateTime dt1 = DateTimes.of((String)milis);
        Assert.assertEquals((Object)"2018-01-30T06:00:00.000Z", (Object)dt1.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStringToDateTimeConverstion_RethrowInitialException() {
        String invalid = "51729200AZ";
        DateTimes.of((String)invalid);
    }

    @Test
    public void testCanCompareAsString() {
        Assert.assertTrue((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.EPOCH));
        Assert.assertTrue((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.of((String)"0000-01-01")));
        Assert.assertEquals((Object)"0000-01-01T00:00:00.000Z", (Object)DateTimes.COMPARE_DATE_AS_STRING_MIN.toString());
        Assert.assertEquals((Object)"9999-12-31T23:59:59.999Z", (Object)DateTimes.COMPARE_DATE_AS_STRING_MAX.toString());
        Assert.assertTrue((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.of((String)"9999")));
        Assert.assertTrue((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.of((String)"2000")));
        Assert.assertFalse((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.MIN));
        Assert.assertFalse((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.MAX));
        Assert.assertFalse((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.of((String)"-1-01-01T00:00:00")));
        Assert.assertFalse((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.of((String)"10000-01-01")));
        Assert.assertFalse((boolean)DateTimes.canCompareAsString((DateTime)DateTimes.of((String)"2000").withZone(DateTimes.inferTzFromString((String)"America/Los_Angeles"))));
    }

    @Test
    public void testEarlierOf() {
        Assert.assertNull((Object)DateTimes.earlierOf(null, null));
        DateTime jan14 = DateTimes.of((String)"2013-01-14");
        Assert.assertEquals((Object)jan14, (Object)DateTimes.earlierOf(null, (DateTime)jan14));
        Assert.assertEquals((Object)jan14, (Object)DateTimes.earlierOf((DateTime)jan14, null));
        Assert.assertEquals((Object)jan14, (Object)DateTimes.earlierOf((DateTime)jan14, (DateTime)jan14));
        DateTime jan15 = DateTimes.of((String)"2013-01-15");
        Assert.assertEquals((Object)jan14, (Object)DateTimes.earlierOf((DateTime)jan15, (DateTime)jan14));
        Assert.assertEquals((Object)jan14, (Object)DateTimes.earlierOf((DateTime)jan14, (DateTime)jan15));
    }

    @Test
    public void testLaterOf() {
        Assert.assertNull((Object)DateTimes.laterOf(null, null));
        DateTime jan14 = DateTimes.of((String)"2013-01-14");
        Assert.assertEquals((Object)jan14, (Object)DateTimes.laterOf(null, (DateTime)jan14));
        Assert.assertEquals((Object)jan14, (Object)DateTimes.laterOf((DateTime)jan14, null));
        Assert.assertEquals((Object)jan14, (Object)DateTimes.laterOf((DateTime)jan14, (DateTime)jan14));
        DateTime jan15 = DateTimes.of((String)"2013-01-15");
        Assert.assertEquals((Object)jan15, (Object)DateTimes.laterOf((DateTime)jan15, (DateTime)jan14));
        Assert.assertEquals((Object)jan15, (Object)DateTimes.laterOf((DateTime)jan14, (DateTime)jan15));
    }
}

