/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.granularity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.druid.indexer.granularity.ArbitraryGranularitySpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ArbitraryGranularityTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testDefaultQueryGranularity() {
        ArbitraryGranularitySpec spec = new ArbitraryGranularitySpec(null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-02-01T00Z/2012-03-01T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        Assert.assertNotNull((Object)spec.getQueryGranularity());
    }

    @Test
    public void testSimple() {
        ArbitraryGranularitySpec spec = new ArbitraryGranularitySpec(Granularities.NONE, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-02-01T00Z/2012-03-01T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        Assert.assertTrue((boolean)spec.isRollup());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-02-01T00Z/2012-03-01T00Z")}), (Object)Lists.newArrayList((Iterable)spec.sortedBucketIntervals()));
        Assert.assertEquals((Object)Optional.of((Object)Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-01T00Z")));
        Assert.assertEquals((Object)Optional.of((Object)Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-08T00Z")));
        Assert.assertEquals((String)"2012-01-03T00Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-03T00Z")));
        Assert.assertEquals((String)"2012-01-03T01Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-03T01Z")));
        Assert.assertEquals((String)"2012-01-04T01Z", (Object)Optional.absent(), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-04T01Z")));
        Assert.assertEquals((String)"2012-01-07T23:59:59.999Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-07T23:59:59.999Z")));
        Assert.assertEquals((String)"2012-01-08T01Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-08T01Z")));
        Assert.assertEquals((String)"2012-01-04T00Z", (Object)Optional.absent(), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-04T00Z")));
        Assert.assertEquals((String)"2012-01-05T00Z", (Object)Optional.absent(), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-05T00Z")));
    }

    @Test
    public void testOverlapViolation() {
        ArrayList intervals = Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-02T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")});
        boolean thrown = false;
        try {
            ArbitraryGranularitySpec arbitraryGranularitySpec = new ArbitraryGranularitySpec(Granularities.NONE, (List)intervals);
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        Assert.assertTrue((String)"Exception thrown", (boolean)thrown);
    }

    @Test
    public void testRollupSetting() {
        ArrayList intervals = Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-02-01T00Z/2012-03-01T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")});
        ArbitraryGranularitySpec spec = new ArbitraryGranularitySpec(Granularities.NONE, Boolean.valueOf(false), (List)intervals);
        Assert.assertFalse((boolean)spec.isRollup());
    }

    @Test
    public void testOverlapViolationSameStartInstant() {
        ArrayList intervals = Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-05T00Z")});
        boolean thrown = false;
        try {
            ArbitraryGranularitySpec arbitraryGranularitySpec = new ArbitraryGranularitySpec(Granularities.NONE, (List)intervals);
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        Assert.assertTrue((String)"Exception thrown", (boolean)thrown);
    }

    @Test
    public void testJson() {
        ArbitraryGranularitySpec spec = new ArbitraryGranularitySpec(Granularities.NONE, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-02-01T00Z/2012-03-01T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        try {
            GranularitySpec rtSpec = (GranularitySpec)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)spec), GranularitySpec.class);
            Assert.assertEquals((String)"Round-trip", (Object)ImmutableList.copyOf((Iterable)spec.sortedBucketIntervals()), (Object)ImmutableList.copyOf((Iterable)rtSpec.sortedBucketIntervals()));
            Assert.assertEquals((String)"Round-trip", (Object)ImmutableList.copyOf((Collection)spec.inputIntervals()), (Object)ImmutableList.copyOf((Collection)rtSpec.inputIntervals()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testNullInputIntervals() {
        ArbitraryGranularitySpec spec = new ArbitraryGranularitySpec(Granularities.NONE, null);
        Assert.assertFalse((boolean)spec.sortedBucketIntervals().iterator().hasNext());
    }
}

