/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.tasklogs.NoopTaskLogs;
import org.apache.druid.tasklogs.TaskLogs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BindersTest {
    @Test
    public void test_bindTaskLogs() {
        Properties props = new Properties();
        props.setProperty("druid.indexer.logs.type", "noop");
        Injector injector = Guice.createInjector((Module[])new Module[]{binder -> {
            binder.bind(Properties.class).toInstance((Object)props);
            PolyBind.createChoice((Binder)binder, (String)"druid.indexer.logs.type", (Key)Key.get(TaskLogs.class), null);
            PolyBind.createChoiceWithDefault((Binder)binder, (String)"druid.indexer.logs.defaultType", (Key)Key.get(TaskLogs.class, (Annotation)Names.named((String)"switching.defaultType")), (String)"noop");
            Binders.bindTaskLogs((Binder)binder, (String)"noop", NoopTaskLogs.class);
        }});
        TaskLogs taskLogs = (TaskLogs)injector.getInstance(TaskLogs.class);
        Assertions.assertInstanceOf(NoopTaskLogs.class, (Object)taskLogs);
        TaskLogs defaultTypeTaskLogs = (TaskLogs)injector.getInstance(Key.get(TaskLogs.class, (Annotation)Names.named((String)"switching.defaultType")));
        Assertions.assertInstanceOf(NoopTaskLogs.class, (Object)defaultTypeTaskLogs);
    }
}

