/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.field.LongFieldWriter;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.frame.write.InvalidFieldException;
import org.apache.druid.frame.write.RowBasedFrameWriter;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class RowBasedFrameWriterTest
extends InitializedNullHandlingTest {
    @Test
    public void test_addSelection_singleLargeRow() {
        Frame frame;
        RowSignature signature = RowSignature.builder().add("n", ColumnType.LONG).add("s", ColumnType.STRING).build();
        byte[] largeUtf8 = new byte[990000];
        Arrays.fill(largeUtf8, (byte)70);
        String largeString = StringUtils.fromUtf8((byte[])largeUtf8);
        MapBasedRow largeRow = new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"n", (Object)3L, (Object)"s", (Object)largeString));
        FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.latestRowBased(), (MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(1000000), (RowSignature)signature, (List)ImmutableList.of(), (boolean)false);
        RowBasedColumnSelectorFactory columnSelectorFactory = RowBasedColumnSelectorFactory.create((RowAdapter)RowAdapters.standardRow(), () -> RowBasedFrameWriterTest.lambda$test_addSelection_singleLargeRow$0((Row)largeRow), (ColumnInspector)signature, (boolean)false, (boolean)false);
        try (FrameWriter frameWriter = frameWriterFactory.newFrameWriter((ColumnSelectorFactory)columnSelectorFactory);){
            Assert.assertTrue((boolean)frameWriter.addSelection());
            frame = Frame.wrap((byte[])frameWriter.toByteArray());
        }
        FrameTestUtil.assertRowsEqual((Sequence<List<Object>>)Sequences.simple(Collections.singletonList(ImmutableList.of((Object)3L, (Object)largeString))), FrameTestUtil.readRowsFromCursorFactory(FrameReader.create((RowSignature)signature).makeCursorFactory(frame)));
    }

    @Test
    public void test_addSelection_withException() {
        String colName = "colName";
        String errorMsg = "Frame writer exception";
        RowSignature signature = RowSignature.builder().add(colName, ColumnType.LONG).build();
        RuntimeException realException = new RuntimeException(errorMsg);
        LongFieldWriter fieldWriter = (LongFieldWriter)EasyMock.mock(LongFieldWriter.class);
        EasyMock.expect((Object)fieldWriter.writeTo((WritableMemory)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong())).andThrow((Throwable)realException);
        EasyMock.replay((Object[])new Object[]{fieldWriter});
        RowBasedFrameWriter rowBasedFrameWriter = new RowBasedFrameWriter(FrameType.latestRowBased(), signature, Collections.emptyList(), (List)ImmutableList.of((Object)fieldWriter), null, null, AppendableMemory.create((MemoryAllocator)HeapMemoryAllocator.unlimited()), AppendableMemory.create((MemoryAllocator)HeapMemoryAllocator.unlimited()));
        InvalidFieldException expectedException = new InvalidFieldException.Builder().column(colName).errorMsg(errorMsg).build();
        InvalidFieldException actualException = (InvalidFieldException)Assert.assertThrows(InvalidFieldException.class, () -> ((RowBasedFrameWriter)rowBasedFrameWriter).addSelection());
        Assert.assertEquals((Object)expectedException, (Object)actualException);
        Assert.assertEquals((Object)realException, (Object)actualException.getCause());
    }

    private static /* synthetic */ Row lambda$test_addSelection_singleLargeRow$0(Row largeRow) {
        return largeRow;
    }
}

