/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.druid.query.extraction.UpperExtractionFn;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class FrameCursorFactoryTest {

    @RunWith(value=Parameterized.class)
    public static class CursorTests
    extends InitializedNullHandlingTest {
        private static final int VECTOR_SIZE = 7;
        private final FrameType frameType;
        private final Interval interval;
        private CursorFactory queryableCursorFactory;
        private FrameSegment frameSegment;
        private CursorFactory frameCursorFactory;
        private final QueryContext queryContext = QueryContext.of((Map)ImmutableMap.of((Object)"vectorSize", (Object)7));

        public CursorTests(FrameType frameType, Interval interval) {
            this.frameType = frameType;
            this.interval = interval;
        }

        @Parameterized.Parameters(name="frameType = {0}, interval = {1}")
        public static Iterable<Object[]> constructorFeeder() {
            ArrayList<Object[]> constructors = new ArrayList<Object[]>();
            List<Interval> intervals = List.of(TestIndex.getMMappedTestIndex().getDataInterval(), Intervals.ETERNITY, Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-02T00:00:00.000Z"), Intervals.of((String)"3001/3002"));
            for (FrameType frameType : FrameType.values()) {
                for (Interval interval : intervals) {
                    constructors.add(new Object[]{frameType, interval});
                }
            }
            return constructors;
        }

        @Before
        public void setUp() {
            this.queryableCursorFactory = new QueryableIndexCursorFactory(TestIndex.getMMappedTestIndex());
            this.frameSegment = FrameTestUtil.cursorFactoryToFrameSegment(this.queryableCursorFactory, this.frameType);
            this.frameCursorFactory = Objects.requireNonNull((CursorFactory)this.frameSegment.as(CursorFactory.class));
        }

        @After
        public void tearDown() {
            if (this.frameSegment != null) {
                this.frameSegment.close();
            }
        }

        @Test
        public void test_fullScan() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_fullScan_preferAscTime() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setPreferredOrdering(Cursors.ascendingTimeOrder()).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_fullScan_preferDescTime() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setPreferredOrdering(Cursors.descendingTimeOrder()).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_selectorFilter_stringColumn() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setFilter(new SelectorDimFilter("quality", "automotive", null).toFilter()).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_selectorFilter_numericColumn() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setFilter(new SelectorDimFilter("qualityLong", "1400", null).toFilter()).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_selectorFilter_expr() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setFilter(new SelectorDimFilter("quality", "automotive", null).toFilter()).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("expr", "qualityLong + 1", ColumnType.LONG, ExprMacroTable.nil())})).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_selectorFilter_extractionFn() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setFilter(new SelectorDimFilter("quality", "automotive", (ExtractionFn)new UpperExtractionFn(null)).toFilter()).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_selectorFilter_timeExtractionFn() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setFilter(new SelectorDimFilter("__time", "Friday", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false)).toFilter()).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_virtualColumn_cannotVectorize() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("expr", "if(isnull(quality),'yes',0)", ColumnType.STRING, ExprMacroTable.nil())})).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, false);
        }

        @Test
        public void test_aggregator_canVectorize() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setAggregators(List.of(new DoubleSumAggregatorFactory("qualitySum", "qualityLong"))).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, this.frameType.isColumnar());
        }

        @Test
        public void test_aggregator_cannotVectorize() {
            CursorBuildSpec cursorSpec = CursorBuildSpec.builder().setInterval(this.interval).setAggregators(List.of(new DoubleSumAggregatorFactory("qualitySum", "quality"))).setQueryContext(this.queryContext).build();
            this.verifyCursorFactory(cursorSpec, false);
        }

        private void verifyCursorFactory(CursorBuildSpec cursorSpec, boolean expectedCanVectorize) {
            Assert.assertEquals((String)"expected interval (if this assertion fails, the test is likely written incorrectly)", (Object)this.interval, (Object)cursorSpec.getInterval());
            CursorBuildSpec queryableCursorSpec = CursorBuildSpec.builder((CursorBuildSpec)cursorSpec).setPreferredOrdering(Collections.emptyList()).build();
            try (CursorHolder queryableCursorHolder = this.queryableCursorFactory.makeCursorHolder(queryableCursorSpec);
                 CursorHolder frameCursorHolder = this.frameCursorFactory.makeCursorHolder(cursorSpec);){
                Assert.assertEquals((String)"ordering", Collections.emptyList(), (Object)frameCursorHolder.getOrdering());
                Assert.assertEquals((String)"canVectorize", (Object)expectedCanVectorize, (Object)frameCursorHolder.canVectorize());
                CursorTests.verifyCursors(queryableCursorHolder, frameCursorHolder, this.frameCursorFactory.getRowSignature());
                if (expectedCanVectorize) {
                    CursorTests.verifyVectorCursors(queryableCursorHolder, frameCursorHolder, this.frameCursorFactory.getRowSignature());
                }
            }
        }

        private static void verifyCursors(CursorHolder queryableCursorHolder, CursorHolder frameCursorHolder, RowSignature signature) {
            Sequence<List<Object>> queryableRows = FrameTestUtil.readRowsFromCursor(CursorTests.advanceAndReset(queryableCursorHolder.asCursor()), signature);
            Sequence<List<Object>> frameRows = FrameTestUtil.readRowsFromCursor(CursorTests.advanceAndReset(frameCursorHolder.asCursor()), signature);
            FrameTestUtil.assertRowsEqual(queryableRows, frameRows);
        }

        private static void verifyVectorCursors(CursorHolder queryableCursorHolder, CursorHolder frameCursorHolder, RowSignature signature) {
            Sequence queryableRows = FrameTestUtil.readRowsFromVectorCursor(CursorTests.advanceAndReset(queryableCursorHolder.asVectorCursor()), signature).withBaggage((Closeable)queryableCursorHolder);
            Sequence frameRows = FrameTestUtil.readRowsFromVectorCursor(CursorTests.advanceAndReset(frameCursorHolder.asVectorCursor()), signature).withBaggage((Closeable)frameCursorHolder);
            FrameTestUtil.assertRowsEqual((Sequence<List<Object>>)queryableRows, (Sequence<List<Object>>)frameRows);
        }

        private static Cursor advanceAndReset(Cursor cursor) {
            for (int i = 0; i < 3 && !cursor.isDone(); ++i) {
                cursor.advance();
            }
            cursor.reset();
            return cursor;
        }

        private static VectorCursor advanceAndReset(VectorCursor cursor) {
            for (int i = 0; i < 3 && !cursor.isDone(); ++i) {
                cursor.advance();
            }
            cursor.reset();
            return cursor;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class BasicTests
    extends InitializedNullHandlingTest {
        private final FrameType frameType;
        private CursorFactory queryableCursorFactory;
        private FrameSegment frameSegment;
        private CursorFactory frameCursorFactory;

        public BasicTests(FrameType frameType) {
            this.frameType = frameType;
        }

        @Parameterized.Parameters(name="frameType = {0}")
        public static Iterable<Object[]> constructorFeeder() {
            ArrayList<Object[]> constructors = new ArrayList<Object[]>();
            for (FrameType frameType : FrameType.values()) {
                constructors.add(new Object[]{frameType});
            }
            return constructors;
        }

        @Before
        public void setUp() {
            this.queryableCursorFactory = new QueryableIndexCursorFactory(TestIndex.getMMappedTestIndex());
            this.frameSegment = FrameTestUtil.cursorFactoryToFrameSegment(this.queryableCursorFactory, this.frameType);
            this.frameCursorFactory = Objects.requireNonNull((CursorFactory)this.frameSegment.as(CursorFactory.class));
        }

        @After
        public void tearDown() {
            if (this.frameSegment != null) {
                this.frameSegment.close();
            }
        }

        @Test
        public void test_getRowSignature() {
            Assert.assertEquals((Object)this.queryableCursorFactory.getRowSignature(), (Object)this.frameCursorFactory.getRowSignature());
        }

        @Test
        public void test_getColumnCapabilities_typeOfKnownColumns() {
            for (String columnName : this.frameCursorFactory.getRowSignature().getColumnNames()) {
                ColumnCapabilities expectedCapabilities = this.queryableCursorFactory.getColumnCapabilities(columnName);
                ColumnCapabilities actualCapabilities = this.frameCursorFactory.getColumnCapabilities(columnName);
                Assert.assertEquals((String)StringUtils.format((String)"column [%s] type", (Object[])new Object[]{columnName}), (Object)expectedCapabilities.toColumnType(), (Object)actualCapabilities.toColumnType());
                if (this.frameType == FrameType.latestColumnar()) {
                    Assert.assertEquals((String)StringUtils.format((String)"column [%s] hasMultipleValues", (Object[])new Object[]{columnName}), (Object)expectedCapabilities.hasMultipleValues(), (Object)actualCapabilities.hasMultipleValues());
                    continue;
                }
                Assert.assertEquals((String)StringUtils.format((String)"column [%s] hasMultipleValues", (Object[])new Object[]{columnName}), (Object)(expectedCapabilities.getType() == ValueType.STRING ? ColumnCapabilities.Capable.UNKNOWN : ColumnCapabilities.Capable.FALSE), (Object)actualCapabilities.hasMultipleValues());
            }
        }

        @Test
        public void test_getColumnCapabilities_unknownColumn() {
            Assert.assertNull((Object)this.frameCursorFactory.getColumnCapabilities("nonexistent"));
        }
    }
}

