/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.frame.processor.SuperSorterProgressSnapshot;
import org.apache.druid.frame.processor.SuperSorterProgressTracker;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SuperSorterProgressSnapshotTest {
    private SuperSorterProgressTracker superSorterProgressTracker;
    private final ImmutableMap<Integer, Long> LEVEL_TO_TOTAL_MERGERS_COMMON_MAP = ImmutableMap.builder().put((Object)0, (Object)16L).put((Object)1, (Object)8L).put((Object)2, (Object)4L).put((Object)3, (Object)2L).put((Object)4, (Object)1L).build();
    private final ImmutableMap<Integer, Long> LEVEL_TO_MERGED_BATCHES_COMMON_MAP = ImmutableMap.builder().put((Object)0, (Object)10L).put((Object)1, (Object)2L).put((Object)2, (Object)3L).put((Object)3, (Object)1L).put((Object)4, (Object)12L).build();
    private final int TOTAL_LEVELS = 5;

    @Before
    public void setup() {
        this.superSorterProgressTracker = new SuperSorterProgressTracker();
        this.superSorterProgressTracker.setTotalMergersForLevel(0, 16L);
        this.superSorterProgressTracker.setTotalMergersForLevel(1, 8L);
        this.superSorterProgressTracker.setTotalMergersForLevel(2, 4L);
        this.superSorterProgressTracker.setTotalMergersForLevel(3, 2L);
        this.superSorterProgressTracker.setTotalMergersForLevel(4, 1L);
        this.superSorterProgressTracker.addMergedBatchesForLevel(0, 5L);
        this.superSorterProgressTracker.addMergedBatchesForLevel(0, 5L);
        this.superSorterProgressTracker.addMergedBatchesForLevel(1, 2L);
        this.superSorterProgressTracker.addMergedBatchesForLevel(2, 3L);
        this.superSorterProgressTracker.addMergedBatchesForLevel(3, 1L);
        this.superSorterProgressTracker.addMergedBatchesForLevel(4, 12L);
    }

    @Test
    public void testSnapshotWhenTotalMergingLevelsUnset() {
        SuperSorterProgressSnapshot snapshot = this.superSorterProgressTracker.snapshot();
        Assert.assertNull((Object)snapshot.getProgressDigest());
        Assert.assertEquals((long)-1L, (long)snapshot.getTotalMergingLevels());
        Assert.assertEquals(this.LEVEL_TO_TOTAL_MERGERS_COMMON_MAP, (Object)snapshot.getLevelToTotalBatches());
        Assert.assertEquals(this.LEVEL_TO_MERGED_BATCHES_COMMON_MAP, (Object)snapshot.getLevelToMergedBatches());
        Assert.assertEquals((Object)false, (Object)snapshot.isTriviallyComplete());
    }

    @Test
    public void testSnapshotWhenTotalMergingLevelsSetButOutputPartitionsCountUnknown() {
        this.superSorterProgressTracker.setTotalMergingLevels(5);
        SuperSorterProgressSnapshot snapshot = this.superSorterProgressTracker.snapshot();
        Assert.assertNotNull((Object)snapshot.getProgressDigest());
        Assert.assertEquals((double)0.425, (double)snapshot.getProgressDigest(), (double)1.0E-6);
        Assert.assertEquals((long)5L, (long)snapshot.getTotalMergingLevels());
        HashMap<Integer, Long> levelToTotalMergersModifiedMap = new HashMap<Integer, Long>((Map<Integer, Long>)this.LEVEL_TO_TOTAL_MERGERS_COMMON_MAP);
        levelToTotalMergersModifiedMap.put(4, -1L);
        Assert.assertEquals(levelToTotalMergersModifiedMap, (Object)snapshot.getLevelToTotalBatches());
        Assert.assertEquals(this.LEVEL_TO_MERGED_BATCHES_COMMON_MAP, (Object)snapshot.getLevelToMergedBatches());
        Assert.assertEquals((Object)false, (Object)snapshot.isTriviallyComplete());
    }

    @Test
    public void testSnapshotWhenTotalMergingLevelsAndOutputPartitionsCountKnown() {
        this.superSorterProgressTracker.setTotalMergingLevels(5);
        this.superSorterProgressTracker.setTotalMergersForUltimateLevel(25L);
        SuperSorterProgressSnapshot snapshot = this.superSorterProgressTracker.snapshot();
        Assert.assertNotNull((Object)snapshot.getProgressDigest());
        Assert.assertEquals((double)0.521, (double)snapshot.getProgressDigest(), (double)1.0E-6);
        Assert.assertEquals((long)5L, (long)snapshot.getTotalMergingLevels());
        HashMap<Integer, Long> levelToTotalMergersModifiedMap = new HashMap<Integer, Long>((Map<Integer, Long>)this.LEVEL_TO_TOTAL_MERGERS_COMMON_MAP);
        levelToTotalMergersModifiedMap.put(4, 25L);
        Assert.assertEquals(levelToTotalMergersModifiedMap, (Object)snapshot.getLevelToTotalBatches());
        Assert.assertEquals(this.LEVEL_TO_MERGED_BATCHES_COMMON_MAP, (Object)snapshot.getLevelToMergedBatches());
        Assert.assertEquals((Object)false, (Object)snapshot.isTriviallyComplete());
    }

    @Test
    public void testSnapshotWhenTrackerIsTriviallyComplete() {
        this.superSorterProgressTracker.setTotalMergingLevels(5);
        this.superSorterProgressTracker.setTotalMergersForUltimateLevel(25L);
        this.superSorterProgressTracker.markTriviallyComplete();
        SuperSorterProgressSnapshot snapshot = this.superSorterProgressTracker.snapshot();
        Assert.assertNotNull((Object)snapshot.getProgressDigest());
        Assert.assertEquals((double)1.0, (double)snapshot.getProgressDigest(), (double)0.0);
        Assert.assertEquals((Object)true, (Object)snapshot.isTriviallyComplete());
    }

    @Test
    public void testSerde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        SuperSorterProgressSnapshot snapshot = new SuperSorterProgressSnapshot(1, (Map)ImmutableMap.of((Object)1, (Object)2L), (Map)ImmutableMap.of((Object)1, (Object)3L), 8L, false);
        String jsonString = jsonMapper.writeValueAsString((Object)snapshot);
        Assert.assertEquals((Object)snapshot, (Object)jsonMapper.readValue(jsonString, SuperSorterProgressSnapshot.class));
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(SuperSorterProgressSnapshot.class).usingGetClass().verify();
    }
}

