/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.LinesInputFormat;
import org.apache.druid.segment.TestHelper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinesInputFormatTest {
    private ObjectMapper mapper;

    @Before
    public void setUp() throws Exception {
        this.mapper = TestHelper.makeJsonMapper();
    }

    @Test
    public void testSerde() throws IOException {
        LinesInputFormat expected = new LinesInputFormat();
        byte[] json = this.mapper.writeValueAsBytes((Object)expected);
        Map map = (Map)this.mapper.readValue(json, Map.class);
        Assert.assertEquals((Object)"lines", map.get("type"));
        InputFormat fromJson = (InputFormat)this.mapper.readValue(json, InputFormat.class);
        MatcherAssert.assertThat((Object)fromJson, (Matcher)Matchers.instanceOf(LinesInputFormat.class));
    }

    @Test
    public void test_getWeightedSize_withoutCompression() {
        LinesInputFormat format = new LinesInputFormat();
        long unweightedSize = 100L;
        Assert.assertEquals((long)100L, (long)format.getWeightedSize("file.txt", 100L));
    }

    @Test
    public void test_getWeightedSize_withGzCompression() {
        LinesInputFormat format = new LinesInputFormat();
        long unweightedSize = 100L;
        Assert.assertEquals((long)400L, (long)format.getWeightedSize("file.txt.gz", 100L));
    }
}

