/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AggregateProjectionSpecTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    AggregateProjectionSpecTest() {
    }

    @Test
    void testSerde() throws JsonProcessingException {
        AggregateProjectionSpec spec = new AggregateProjectionSpec("some_projection", (DimFilter)new EqualityFilter("a", ColumnType.STRING, (Object)"a", null), VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"time")}), Arrays.asList(new StringDimensionSchema("a"), new LongDimensionSchema("b"), new LongDimensionSchema("time"), new FloatDimensionSchema("c"), new DoubleDimensionSchema("d")), new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("e", "e")});
        Assertions.assertEquals((Object)spec, (Object)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)spec), AggregateProjectionSpec.class));
    }

    @Test
    void testComputeOrdering_noOrdering() {
        AggregateProjectionSpec spec = new AggregateProjectionSpec("some_projection", null, VirtualColumns.EMPTY, List.of(), new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("e", "e")});
        Assertions.assertTrue((boolean)spec.getOrdering().isEmpty());
    }

    @Test
    void testComputeOrdering_granularity() {
        AggregateProjectionSpec spec = new AggregateProjectionSpec("some_projection", null, VirtualColumns.EMPTY, List.of(new LongDimensionSchema("__time")), new AggregatorFactory[0]);
        Assertions.assertEquals((Object)"__time", (Object)spec.toMetadataSchema().getTimeColumnName());
        ExpressionVirtualColumn hourly = new ExpressionVirtualColumn("hourly", "timestamp_floor(__time, 'PT1H', null, null)", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn daily = new ExpressionVirtualColumn("daily", "timestamp_floor(__time, 'P1D', null, null)", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn every10MinLA = new ExpressionVirtualColumn("every10MinLA", "timestamp_floor(__time, 'PT10M', null, 'America/Los_Angeles')", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn every10Min = new ExpressionVirtualColumn("every10Min", "timestamp_floor(__time, 'PT10M', null, null)", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn every90Min = new ExpressionVirtualColumn("every90Min", "timestamp_floor(__time, 'PT1H30M', null, null)", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        Assertions.assertEquals((Object)"hourly", (Object)new AggregateProjectionSpec("some_projection", null, VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{daily, hourly, every10MinLA}), List.of(new LongDimensionSchema("daily"), new LongDimensionSchema("hourly"), new LongDimensionSchema("every10MinLA")), new AggregatorFactory[0]).toMetadataSchema().getTimeColumnName());
        Assertions.assertNull((Object)new AggregateProjectionSpec("some_projection", null, VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{every10MinLA}), List.of(new LongDimensionSchema("every10MinLA")), new AggregatorFactory[0]).toMetadataSchema().getTimeColumnName());
        Assertions.assertEquals((Object)"every90Min", (Object)new AggregateProjectionSpec("some_projection", null, VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{every90Min, every10MinLA}), List.of(new LongDimensionSchema("every90Min"), new LongDimensionSchema("every10MinLA")), new AggregatorFactory[0]).toMetadataSchema().getTimeColumnName());
        Assertions.assertEquals((Object)"every10Min", (Object)new AggregateProjectionSpec("some_projection", null, VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{daily, hourly, every10Min}), List.of(new LongDimensionSchema("daily"), new LongDimensionSchema("hourly"), new LongDimensionSchema("every10Min")), new AggregatorFactory[0]).toMetadataSchema().getTimeColumnName());
        Assertions.assertEquals((Object)"hourly", (Object)new AggregateProjectionSpec("some_projection", null, VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{daily, hourly, every10Min}), List.of(new LongDimensionSchema("daily"), new LongDimensionSchema("hourly"), new StringDimensionSchema("every10Min")), new AggregatorFactory[0]).toMetadataSchema().getTimeColumnName());
    }

    @Test
    void testMissingName() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionSpec(null, null, VirtualColumns.EMPTY, List.of(new StringDimensionSchema("string")), null));
        Assertions.assertEquals((Object)"projection name cannot be null or empty", (Object)t.getMessage());
        t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionSpec("", null, VirtualColumns.EMPTY, List.of(new StringDimensionSchema("string")), null));
        Assertions.assertEquals((Object)"projection name cannot be null or empty", (Object)t.getMessage());
    }

    @Test
    void testInvalidGrouping() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionSpec("other_projection", null, null, null, null));
        Assertions.assertEquals((Object)"projection[other_projection] groupingColumns and aggregators must not both be null or empty", (Object)t.getMessage());
        t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionSpec("other_projection", null, null, Collections.emptyList(), null));
        Assertions.assertEquals((Object)"projection[other_projection] groupingColumns and aggregators must not both be null or empty", (Object)t.getMessage());
    }

    @Test
    void testInvalidTimeColumnType() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> new AggregateProjectionSpec("projection", null, VirtualColumns.EMPTY, List.of(new StringDimensionSchema("__time")), null));
        Assertions.assertEquals((Object)"Encountered grouping column[__time] with incorrect type[STRING]. Type must be 'long'.", (Object)t.getMessage());
    }

    @Test
    void testEqualsAndHashcode() {
        EqualsVerifier.forClass(AggregateProjectionSpec.class).usingGetClass().withPrefabValues(DimensionSchema.class, (Object)new StringDimensionSchema("a"), (Object)new DoubleDimensionSchema("d")).withIgnoredFields(new String[]{"timeColumnName"}).verify();
    }
}

