/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.druid.data.input.BytesCountingInputEntity;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.FileEntity;
import org.apache.druid.data.input.impl.InputStatsImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BytesCountingInputEntityTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private InputStats inputStats;

    @Before
    public void setup() {
        this.inputStats = new InputStatsImpl();
    }

    @Test
    public void testFetch() throws IOException {
        int fileSize = 200;
        File sourceFile = this.folder.newFile("testWithFileEntity");
        this.writeBytesToFile(sourceFile, 200);
        BytesCountingInputEntity inputEntity = new BytesCountingInputEntity((InputEntity)new FileEntity(sourceFile), this.inputStats);
        inputEntity.fetch(this.folder.newFolder(), new byte[50]);
        Assert.assertEquals((long)200L, (long)this.inputStats.getProcessedBytes());
    }

    @Test
    public void testFetchFromPartiallyReadFile() throws IOException {
        int fileSize = 200;
        File sourceFile = this.folder.newFile("testWithFileEntity");
        this.writeBytesToFile(sourceFile, 200);
        int bufferSize = 50;
        byte[] intermediateBuffer = new byte[50];
        BytesCountingInputEntity inputEntity = new BytesCountingInputEntity((InputEntity)new FileEntity(sourceFile), this.inputStats);
        inputEntity.open().read(intermediateBuffer);
        Assert.assertEquals((long)50L, (long)this.inputStats.getProcessedBytes());
        inputEntity.fetch(this.folder.newFolder(), intermediateBuffer);
        Assert.assertEquals((long)250L, (long)this.inputStats.getProcessedBytes());
    }

    @Test
    public void testFetchFromDirectory() throws IOException {
        File sourceDir = this.folder.newFolder("testWithDirectory");
        int fileSize1 = 100;
        File sourceFile1 = new File(sourceDir, "file1");
        this.writeBytesToFile(sourceFile1, 100);
        int fileSize2 = 200;
        File sourceFile2 = new File(sourceDir, "file2");
        this.writeBytesToFile(sourceFile2, 200);
        BytesCountingInputEntity inputEntity = new BytesCountingInputEntity((InputEntity)new FileEntity(sourceDir), this.inputStats);
        inputEntity.fetch(this.folder.newFolder(), new byte[1000]);
        Assert.assertEquals((long)300L, (long)this.inputStats.getProcessedBytes());
    }

    @Test
    public void testOpen() throws IOException {
        int entitySize = 100;
        BytesCountingInputEntity inputEntity = new BytesCountingInputEntity((InputEntity)new ByteEntity(new byte[100]), this.inputStats);
        inputEntity.open().read(new byte[200]);
        Assert.assertEquals((long)100L, (long)this.inputStats.getProcessedBytes());
    }

    @Test
    public void testOpenWithSmallBuffer() throws IOException {
        int entitySize = 100;
        int bufferSize = 50;
        BytesCountingInputEntity inputEntity = new BytesCountingInputEntity((InputEntity)new ByteEntity(new byte[100]), this.inputStats);
        inputEntity.open().read(new byte[50]);
        Assert.assertEquals((long)50L, (long)this.inputStats.getProcessedBytes());
    }

    private void writeBytesToFile(File sourceFile, int numBytes) throws IOException {
        if (!sourceFile.exists()) {
            sourceFile.createNewFile();
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(sourceFile), StandardCharsets.UTF_8);
        char[] chars = new char[numBytes];
        Arrays.fill(chars, ' ');
        outputStreamWriter.write(chars);
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }
}

