/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.concurrent.LifecycleLock;
import org.junit.Assert;
import org.junit.Test;

public class LifecycleLockTest {
    @Test
    public void testOnlyOneCanStart() throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            this.testOnlyOneCanStartRun();
        }
    }

    private void testOnlyOneCanStartRun() throws InterruptedException {
        final LifecycleLock lifecycleLock = new LifecycleLock();
        final CountDownLatch startLatch = new CountDownLatch(1);
        int numThreads = 100;
        final CountDownLatch finishLatch = new CountDownLatch(numThreads);
        final AtomicInteger successful = new AtomicInteger(0);
        for (int i = 0; i < numThreads; ++i) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                        if (lifecycleLock.canStart()) {
                            successful.incrementAndGet();
                        }
                        finishLatch.countDown();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }.start();
        }
        startLatch.countDown();
        finishLatch.await();
        Assert.assertEquals((long)1L, (long)successful.get());
    }

    @Test
    public void testOnlyOneCanStop() throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            this.testOnlyOneCanStopRun();
        }
    }

    private void testOnlyOneCanStopRun() throws InterruptedException {
        final LifecycleLock lifecycleLock = new LifecycleLock();
        Assert.assertTrue((boolean)lifecycleLock.canStart());
        lifecycleLock.started();
        lifecycleLock.exitStart();
        final CountDownLatch startLatch = new CountDownLatch(1);
        int numThreads = 100;
        final CountDownLatch finishLatch = new CountDownLatch(numThreads);
        final AtomicInteger successful = new AtomicInteger(0);
        for (int i = 0; i < numThreads; ++i) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                        if (lifecycleLock.canStop()) {
                            successful.incrementAndGet();
                        }
                        finishLatch.countDown();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }.start();
        }
        startLatch.countDown();
        finishLatch.await();
        Assert.assertEquals((long)1L, (long)successful.get());
    }

    @Test
    public void testNoStartAfterStop() {
        LifecycleLock lifecycleLock = new LifecycleLock();
        Assert.assertTrue((boolean)lifecycleLock.canStart());
        lifecycleLock.started();
        lifecycleLock.exitStart();
        Assert.assertTrue((boolean)lifecycleLock.canStop());
        Assert.assertFalse((boolean)lifecycleLock.canStart());
    }

    @Test
    public void testNotStarted() {
        LifecycleLock lifecycleLock = new LifecycleLock();
        Assert.assertTrue((boolean)lifecycleLock.canStart());
        lifecycleLock.exitStart();
        Assert.assertFalse((boolean)lifecycleLock.awaitStarted());
        Assert.assertFalse((boolean)lifecycleLock.canStop());
    }

    @Test
    public void testRestart() {
        LifecycleLock lifecycleLock = new LifecycleLock();
        Assert.assertTrue((boolean)lifecycleLock.canStart());
        lifecycleLock.started();
        lifecycleLock.exitStart();
        Assert.assertTrue((boolean)lifecycleLock.canStop());
        lifecycleLock.exitStopAndReset();
        Assert.assertTrue((boolean)lifecycleLock.canStart());
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testDoubleStarted() {
        LifecycleLock lifecycleLock = new LifecycleLock();
        lifecycleLock.canStart();
        lifecycleLock.started();
        lifecycleLock.started();
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testDoubleExitStart() {
        LifecycleLock lifecycleLock = new LifecycleLock();
        lifecycleLock.canStart();
        lifecycleLock.started();
        lifecycleLock.exitStart();
        lifecycleLock.exitStart();
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testCanStopNotExitedStart() {
        LifecycleLock lifecycleLock = new LifecycleLock();
        lifecycleLock.canStart();
        lifecycleLock.started();
        lifecycleLock.canStop();
    }
}

