/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.exception;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.exception.PersonaBasedErrorTransformStrategy;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PersonaBasedErrorTransformStrategyTest {
    private PersonaBasedErrorTransformStrategy target;

    @Before
    public void setUp() throws Exception {
        this.target = new PersonaBasedErrorTransformStrategy();
    }

    @Test
    public void testUserPersonaRemainsUnchanged() {
        DruidException druidException = DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.FORBIDDEN).build("Permission exception", new Object[0]);
        Assert.assertEquals(Optional.empty(), (Object)this.target.maybeTransform(druidException, Optional.empty()));
    }

    @Test
    public void testDeveloperPersonaIsTransformed() {
        DruidException druidException = DruidException.defensive().build("Test Defensive exception", new Object[0]);
        DruidExceptionMatcher druidExceptionMatcher = new DruidExceptionMatcher(DruidException.Persona.USER, druidException.getCategory(), druidException.getErrorCode()).expectMessageContains("Could not process the query, please contact your administrator with Error ID");
        druidExceptionMatcher.matches(this.target.maybeTransform(druidException, Optional.of("the-error")).get());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(PersonaBasedErrorTransformStrategy.class).usingGetClass().verify();
    }
}

